/*
 * Decompiled with CFR 0.152.
 */
package JabpLite;

import JabpLite.Account;
import JabpLite.AccountStore;
import JabpLite.Category;
import JabpLite.CategoryStore;
import JabpLite.CategoryView;
import JabpLite.Currency;
import JabpLite.CurrencyForm;
import JabpLite.CurrencyStore;
import JabpLite.Investment;
import JabpLite.InvestmentStore;
import JabpLite.InvestmentView;
import JabpLite.JabpLite;
import JabpLite.NameId;
import JabpLite.StandingOrderView;
import JabpLite.Transaction;
import JabpLite.TransactionStore;
import JabpLite.Utilities;
import JabpLite.ViewForm;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStoreException;

public class CurrencyView
extends Canvas
implements CommandListener,
Runnable {
    Currency ccy;
    Currency ccy1;
    Currency oldCcy;
    Currency previousCcy;
    CurrencyForm ccyf;
    Form debug;
    CurrencyStore ccys;
    Alert alert;
    Display display;
    Font font;
    JabpLite parent;
    ViewForm vl;
    String oldName = "";
    String msg = "";
    int width;
    int height;
    int actionKey;
    int upKey;
    int downKey;
    int leftKey;
    int rightKey;
    int currentX;
    int currentY;
    int oldX;
    int oldY;
    int numItems;
    int numItemsPage;
    int fontHeight;
    int fontWidth;
    int currentPos;
    int oldPos;
    int oldId;
    int startPos;
    int numberWidth;
    int currencyWidth;
    int ratePosition;
    int runMode;

    public CurrencyView(JabpLite jabpLite, Display display) {
        this.parent = jabpLite;
        this.display = display;
        this.addCommand(this.parent.exitCommand);
        this.addCommand(this.parent.newCommand);
        this.addCommand(this.parent.editCommand);
        this.addCommand(this.parent.deleteCommand);
        this.addCommand(this.parent.mainCommand);
        this.addCommand(this.parent.viewCommand);
        this.addCommand(this.parent.cancelCommand);
        this.setCommandListener(this);
        this.alert = new Alert("");
        this.alert.setType(AlertType.CONFIRMATION);
        this.alert.setTimeout(1500);
        this.width = this.getWidth();
        this.height = this.getHeight() - this.parent.heightAdjustment;
        int n = 8;
        if (this.parent.mediumSize) {
            n = 0;
        }
        this.font = Font.getFont((int)0, (int)0, (int)n);
        this.fontHeight = this.font.getHeight();
        this.numberWidth = this.font.stringWidth("999999.99");
        this.setPositions();
        this.numItemsPage = this.height / this.fontHeight - 2;
        this.actionKey = this.getKeyCode(8);
        this.upKey = this.getKeyCode(1);
        this.downKey = this.getKeyCode(6);
        this.leftKey = this.getKeyCode(2);
        this.rightKey = this.getKeyCode(5);
        this.ccys = new CurrencyStore(this.parent);
        this.numItems = this.ccys.getNumCurrencies();
        this.currentX = 0;
        this.currentY = this.fontHeight;
        this.currentPos = 0;
    }

    public void paint(Graphics graphics) {
        this.height = this.getHeight() - this.parent.heightAdjustment;
        this.numItemsPage = this.height / this.fontHeight - 2;
        graphics.setFont(this.font);
        this.showHeader(graphics);
        this.showPage(graphics);
        this.showFooter(graphics);
    }

    void showPage(Graphics graphics) {
        graphics.setColor(this.parent.colorBackground);
        graphics.fillRect(0, this.fontHeight, this.width, this.height - this.fontHeight * 2);
        graphics.setColor(0);
        if (this.numItems == 0) {
            return;
        }
        for (int i = 0; i < this.numItemsPage && i + this.startPos <= this.numItems - 1; ++i) {
            if (i == this.currentPos) {
                graphics.setColor(this.parent.colorCursor);
                graphics.fillRect(0, this.fontHeight * i + this.fontHeight, this.width, this.fontHeight);
                graphics.setColor(0);
            }
            this.ccy = this.ccys.getCurrencyFromIndex(i + this.startPos);
            this.buildLine(graphics, this.ccy, this.fontHeight * i + this.fontHeight);
        }
        this.ccy = this.ccys.getCurrencyFromIndex(this.startPos + this.currentPos);
    }

    void showHeader(Graphics graphics) {
        graphics.setColor(this.parent.colorHeading);
        graphics.fillRect(0, 0, this.width, this.fontHeight);
        graphics.setColor(0);
        if (this.msg.equals("")) {
            graphics.drawString("\u0412\u0430\u043b\u044e\u0442\u044b", this.parent.widthAdjustment, this.parent.fontAdjustment, 20);
            graphics.drawString("\u041a\u043e\u044d\u0444.", this.ratePosition + this.numberWidth - this.font.stringWidth("\u041a\u043e\u044d\u0444."), this.parent.fontAdjustment, 20);
        } else {
            graphics.drawString(this.msg, this.parent.widthAdjustment, this.parent.fontAdjustment, 20);
        }
    }

    void showFooter(Graphics graphics) {
        graphics.setColor(this.parent.colorHeading);
        graphics.fillRect(0, this.height - this.fontHeight, this.width, this.fontHeight);
        graphics.setColor(0);
    }

    void drawUp() {
        if (this.startPos + this.currentPos > 0) {
            this.oldY = this.currentY;
            this.currentY -= this.fontHeight;
            --this.currentPos;
            this.previousCcy = new Currency();
            this.previousCcy.clone(this.ccy);
            this.ccy = this.ccys.getCurrencyFromIndex(this.startPos + this.currentPos);
            if (this.currentY < this.fontHeight) {
                this.currentY = this.fontHeight;
                --this.startPos;
                if (this.startPos < 0) {
                    this.startPos = 0;
                }
                ++this.currentPos;
            }
            this.repaint();
            return;
        }
    }

    void drawDown() {
        if (this.startPos + this.currentPos < this.numItems - 1) {
            this.oldY = this.currentY;
            this.currentY += this.fontHeight;
            ++this.currentPos;
            this.previousCcy = new Currency();
            this.previousCcy.clone(this.ccy);
            this.ccy = this.ccys.getCurrencyFromIndex(this.startPos + this.currentPos);
            if (this.currentY + this.fontHeight * 2 > this.height) {
                this.currentY -= this.fontHeight;
                ++this.startPos;
                --this.currentPos;
                if (this.startPos > this.numItems - 1) {
                    this.startPos = this.numItems - 1 - this.currentPos;
                }
            }
            this.repaint();
            return;
        }
    }

    void buildLine(Graphics graphics, Currency currency, int n) {
        int n2 = currency.code.length();
        for (int i = 0; i < n2; ++i) {
            int n3 = n2 - i;
            if (this.font.stringWidth(currency.code.substring(0, n3)) > this.currencyWidth) continue;
            graphics.drawString(currency.code.substring(0, n3), this.parent.widthAdjustment, n + this.parent.fontAdjustment, 20);
            break;
        }
        String string = Utilities.rateToString(currency.rate, false);
        graphics.drawString(string, this.ratePosition + this.numberWidth - this.font.stringWidth(string), n + this.parent.fontAdjustment, 20);
    }

    void setPositions() {
        this.currencyWidth = this.width - this.numberWidth - this.parent.widthAdjustment * 2 - 10;
        this.ratePosition = this.currencyWidth + this.parent.widthAdjustment + 10;
    }

    Currency showCurrency() {
        this.oldCcy = new Currency();
        this.oldCcy.clone(this.ccy);
        return this.ccy;
    }

    int newCurrency(Currency currency) {
        this.ccy1 = currency;
        this.ccy1.id = this.ccys.saveNewCurrency(this.ccy1);
        if (this.ccy == null) {
            this.ccy = this.ccy1;
        }
        ++this.numItems;
        this.repaint();
        return this.ccy1.id;
    }

    void editCurrency(Currency currency) {
        this.ccy1 = currency;
        this.ccys.saveExistingCurrency(this.ccy1);
        if (!this.ccy1.code.equals(this.oldCcy.code)) {
            this.runMode = 1;
            this.display.callSerially((Runnable)this);
        } else {
            this.msg = "";
        }
        if (this.ccy1.rate != this.oldCcy.rate) {
            this.runMode = 2;
            this.display.callSerially((Runnable)this);
        } else {
            this.msg = "";
        }
        this.repaint();
    }

    void deleteCurrency(Currency currency) {
        this.ccy1 = currency;
        this.ccys.deleteCurrency(this.ccy1);
        this.ccys.deleteIndex(this.startPos + this.currentPos);
        --this.numItems;
        if (this.numItems > 0 && this.startPos + this.currentPos > this.numItems - 1) {
            if (this.currentPos > 0) {
                this.currentY -= this.fontHeight;
                --this.currentPos;
            } else {
                --this.startPos;
            }
        }
        this.repaint();
    }

    void updateCurrencyName() {
        this.ccys.deleteIndex(this.startPos + this.currentPos);
        this.ccys.addIndex(this.ccy1);
        AccountStore accountStore = new AccountStore(this.parent);
        RecordEnumeration recordEnumeration = accountStore.getAccounts();
        try {
            while (recordEnumeration.hasNextElement()) {
                int n = recordEnumeration.nextRecordId();
                Account account = accountStore.getAccount(n);
                if (!account.currency.equals(this.oldCcy.code)) continue;
                account.currency = this.ccy1.code;
                accountStore.saveExistingAccount(account);
            }
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " ccyv5");
        }
        recordEnumeration.destroy();
        recordEnumeration = null;
        accountStore.closeAccountStore();
        accountStore = null;
        InvestmentStore investmentStore = new InvestmentStore(this.parent);
        recordEnumeration = investmentStore.getInvestments();
        try {
            while (recordEnumeration.hasNextElement()) {
                int n = recordEnumeration.nextRecordId();
                Investment investment = investmentStore.getInvestment(n);
                if (!investment.currency.equals(this.oldCcy.code)) continue;
                investment.currency = this.ccy1.code;
                investmentStore.saveExistingInvestment(investment);
            }
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " ccyv5a");
        }
        recordEnumeration = null;
        investmentStore.closeInvestmentStore();
        investmentStore = null;
        this.msg = "";
        this.repaint();
    }

    void updateCurrencyTransactions() {
        AccountStore accountStore = new AccountStore(this.parent);
        RecordEnumeration recordEnumeration = accountStore.getAccounts();
        try {
            while (recordEnumeration.hasNextElement()) {
                int n = recordEnumeration.nextRecordId();
                Account account = accountStore.getAccount(n);
                if (!account.currency.equals(this.ccy1.code)) continue;
                CategoryStore categoryStore = new CategoryStore(this.parent);
                Category category = categoryStore.getCategoryFromName("FX \u0420\u0435\u0433\u0443\u043b\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435");
                TransactionStore transactionStore = new TransactionStore(this.parent, account);
                Transaction transaction = new Transaction();
                transaction.account = account.name;
                transaction.description = "FX \u0420\u0435\u0433\u0443\u043b\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435";
                long l = account.current;
                long l2 = this.oldCcy.rate;
                long l3 = this.ccy1.rate;
                long l4 = l * l2 / l3;
                transaction.amount = (int)l4 - account.current;
                transaction.category = category.name;
                transaction.reconciled = true;
                transaction.id = transactionStore.saveNewTransaction(transaction);
                transactionStore.closeTransactionStore();
                transactionStore = null;
                if (this.parent.tv != null && this.parent.tv.a.name.equals(account.name)) {
                    ++this.parent.tv.numItems;
                }
                this.parent.av.totalToday -= account.today;
                this.parent.av.totalReconciled -= account.reconciled;
                account.updateBalance(transaction, null);
                this.parent.av.totalToday += account.today;
                this.parent.av.totalReconciled += account.reconciled;
                accountStore.saveExistingAccount(account);
                category = categoryStore.getCategoryFromName(category.name);
                if (this.parent.cv != null) {
                    this.parent.cv.totalCurrent -= category.current;
                }
                category.updateBalance(transaction, null);
                if (this.parent.cv != null) {
                    this.parent.cv.totalCurrent += category.current;
                }
                categoryStore.saveExistingCategory(category);
                categoryStore.closeCategoryStore();
                categoryStore = null;
                category = null;
            }
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " ccyv5b");
        }
        recordEnumeration.destroy();
        recordEnumeration = null;
        accountStore.closeAccountStore();
        accountStore = null;
    }

    protected void showNotify() {
        this.repaint();
    }

    public void run() {
        if (this.runMode == 1) {
            this.updateCurrencyName();
        }
        if (this.runMode == 2) {
            this.updateCurrencyTransactions();
        }
    }

    protected void keyPressed(int n) {
        if (n == this.leftKey || n == -3) {
            if (this.startPos == 0) {
                this.currentPos = 0;
                this.currentY = this.fontHeight;
            } else {
                this.startPos -= this.numItemsPage;
                if (this.startPos < 0) {
                    this.startPos = 0;
                }
            }
            this.repaint();
            return;
        }
        if (n == this.rightKey || n == -4) {
            this.startPos += this.numItemsPage;
            if (this.startPos + this.currentPos > this.numItems - 1) {
                this.currentPos = Math.min(this.numItems, this.numItemsPage) - 1;
                this.startPos = this.numItems - 1 - this.currentPos;
                this.currentY = this.currentPos * this.fontHeight + this.fontHeight;
            }
            this.repaint();
            return;
        }
        if (n == this.actionKey) {
            // empty if block
        }
        if (n == this.upKey) {
            this.drawUp();
            return;
        }
        if (n == this.downKey) {
            this.drawDown();
            return;
        }
        if (n == 48) {
            int n2 = this.startPos + this.currentPos;
            this.debug = new Form("\u0417\u0430\u043f\u0438\u0441\u044c \u0421\u0432\u043e\u0439\u0441\u0442\u0432");
            this.debug.append("\u041f\u043e\u0437\u0438\u0446\u0438\u044f" + n2 + "\u0438\u0437" + this.numItems + "\n");
            short s = (short)n2;
            int n3 = ((NameId)this.ccys.ht.get((Object)new Short((short)s))).id;
            this.debug.append("\u0417\u0430\u043f\u0438\u0441\u044c ID" + n3 + "\n");
            this.debug.append("\u0417\u0430\u043f\u0438\u0441\u044c \u0414\u043b\u0438\u043d\u044b" + this.ccys.getRecordSize(n3) + "\n");
            this.debug.append("\u0420\u0430\u0437\u043c\u0435\u0440 \u0417\u0430\u043f\u0438\u0441\u0438 \u0418\u0441\u0442\u043e\u0440\u0438\u0438" + this.ccys.getSize() + "\n");
            this.debug.addCommand(this.parent.okCommand);
            this.debug.setCommandListener((CommandListener)this);
            this.display.setCurrent((Displayable)this.debug);
        }
    }

    protected void pointerPressed(int n, int n2) {
        if (n2 < this.fontHeight) {
            this.keyPressed(this.leftKey);
            return;
        }
        if (n2 > this.height - this.fontHeight) {
            this.keyPressed(this.rightKey);
            return;
        }
        int n3 = (n2 - this.fontHeight) / this.fontHeight;
        while (n3 > this.currentPos) {
            this.drawDown();
        }
        while (n3 < this.currentPos) {
            this.drawUp();
        }
        this.repaint();
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.parent.exitCommand) {
            this.parent.destroyApp(true);
            return;
        }
        if (displayable == this) {
            if (command == this.parent.newCommand) {
                this.ccyf = new CurrencyForm(this.parent, new Currency(), "\u041d\u043e\u0432\u044b\u0439");
                this.ccyf.addCommand(this.parent.createCommand);
                this.ccyf.addCommand(this.parent.cancelCommand);
                this.ccyf.addCommand(this.parent.exitCommand);
                this.ccyf.setCommandListener(this);
                this.display.setCurrent((Displayable)this.ccyf);
            }
            if (command == this.parent.editCommand) {
                if (this.numItems == 0) {
                    this.alert.setString("\u041d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430 \u0412\u0430\u043b\u044e\u0442\u0430");
                    this.display.setCurrent(this.alert, (Displayable)this);
                    return;
                }
                this.msg = "\u041e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435 \u0412\u0430\u043b\u044e\u0442\u044b";
                this.repaint();
                this.ccyf = new CurrencyForm(this.parent, this.showCurrency(), "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c");
                this.ccyf.addCommand(this.parent.updateCommand);
                this.ccyf.addCommand(this.parent.cancelCommand);
                this.ccyf.addCommand(this.parent.exitCommand);
                this.ccyf.setCommandListener(this);
                this.display.setCurrent((Displayable)this.ccyf);
            }
            if (command == this.parent.deleteCommand) {
                if (this.numItems == 0) {
                    this.alert.setString("\u041d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430 \u0412\u0430\u043b\u044e\u0442\u0430");
                    this.display.setCurrent(this.alert, (Displayable)this);
                    return;
                }
                this.ccyf = new CurrencyForm(this.parent, this.showCurrency(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c");
                this.ccyf.addCommand(this.parent.deleteCommand);
                this.ccyf.addCommand(this.parent.cancelCommand);
                this.ccyf.addCommand(this.parent.exitCommand);
                this.ccyf.setCommandListener(this);
                this.display.setCurrent((Displayable)this.ccyf);
            }
            if (command == this.parent.mainCommand) {
                this.display.setCurrent((Displayable)this.parent.av);
            }
            if (command == this.parent.viewCommand) {
                this.vl = new ViewForm();
                this.vl.addCommand(this.parent.okCommand);
                this.vl.addCommand(this.parent.cancelCommand);
                this.vl.addCommand(this.parent.exitCommand);
                this.vl.setCommandListener(this);
                this.display.setCurrent((Displayable)this.vl);
            }
        }
        if (displayable == this.ccyf) {
            if (command == this.parent.deleteCommand) {
                this.ccyf = null;
                AccountStore accountStore = new AccountStore(this.parent);
                RecordEnumeration recordEnumeration = accountStore.getAccounts();
                try {
                    while (recordEnumeration.hasNextElement()) {
                        int n = recordEnumeration.nextRecordId();
                        Account account = accountStore.getAccount(n);
                        if (!account.currency.equals(this.ccy.code)) continue;
                        this.alert.setString("\u041d\u0435 \u043c\u043e\u0433\u0443 \u0443\u0434\u0430\u043b\u0438\u0442\u044c, \u0435\u0441\u0442\u044c \u0423\u0447\u0435\u0442\u043d.\u0417\u0430\u043f\u0438\u0441\u0438");
                        this.display.setCurrent(this.alert, (Displayable)this);
                        recordEnumeration.destroy();
                        recordEnumeration = null;
                        accountStore.closeAccountStore();
                        accountStore = null;
                        return;
                    }
                }
                catch (RecordStoreException recordStoreException) {
                    System.err.println((Object)((Object)recordStoreException) + " ccyv9");
                }
                recordEnumeration.destroy();
                recordEnumeration = null;
                accountStore.closeAccountStore();
                accountStore = null;
                InvestmentStore investmentStore = new InvestmentStore(this.parent);
                recordEnumeration = investmentStore.getInvestments();
                try {
                    while (recordEnumeration.hasNextElement()) {
                        int n = recordEnumeration.nextRecordId();
                        Investment investment = investmentStore.getInvestment(n);
                        if (!investment.currency.equals(this.ccy.code)) continue;
                        this.alert.setString("\u041d\u0435 \u043c\u043e\u0433\u0443 \u0443\u0434\u0430\u043b\u0438\u0442\u044c, \u0435\u0441\u0442\u044c \u0438\u043d\u0432\u0435\u0441\u0442\u0438\u0446\u0438\u0438");
                        this.display.setCurrent(this.alert, (Displayable)this);
                        recordEnumeration.destroy();
                        recordEnumeration = null;
                        investmentStore.closeInvestmentStore();
                        investmentStore = null;
                        return;
                    }
                }
                catch (RecordStoreException recordStoreException) {
                    System.err.println((Object)((Object)recordStoreException) + " ccyv9a");
                }
                recordEnumeration.destroy();
                recordEnumeration = null;
                investmentStore.closeInvestmentStore();
                investmentStore = null;
                if (this.ccy.code.equals(this.parent.homeCurrency)) {
                    this.alert.setString("\u041d\u0435 \u043c\u043e\u0433\u0443 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0434\u043e\u043c\u0430\u0448\u043d\u044e\u044e \u0412\u0430\u043b\u044e\u0442\u0443");
                    this.display.setCurrent(this.alert, (Displayable)this);
                    return;
                }
                this.deleteCurrency(this.ccy);
                this.display.setCurrent((Displayable)this);
            }
            if (command == this.parent.createCommand) {
                this.ccy1 = this.ccyf.update();
                if (this.ccy1.code.equals("")) {
                    this.alert.setString("\u041f\u0443\u0441\u0442\u043e\u0439 \u041a\u043e\u0434 \u0412\u0430\u043b\u044e\u0442\u044b");
                    this.display.setCurrent(this.alert, (Displayable)this.ccyf);
                    return;
                }
                if (this.ccys.lookUpId(this.ccy1) != 0) {
                    this.alert.setString(this.ccy1.code + " \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442 ");
                    this.display.setCurrent(this.alert, (Displayable)this.ccyf);
                    return;
                }
                this.display.setCurrent((Displayable)this);
                this.newCurrency(this.ccy1);
                this.ccyf = null;
            }
            if (command == this.parent.updateCommand) {
                boolean bl = false;
                if (this.ccy.code.equals(this.parent.homeCurrency)) {
                    bl = true;
                }
                this.ccy1 = this.ccyf.update();
                if (this.ccy1.code.equals("")) {
                    this.alert.setString("\u041f\u0443\u0441\u0442\u043e\u0439 \u041a\u043e\u0434 \u0412\u0430\u043b\u044e\u0442\u044b");
                    this.display.setCurrent(this.alert, (Displayable)this.ccyf);
                    return;
                }
                int n = this.ccy1.id;
                if (!this.ccy1.code.equals(this.oldCcy.code) && this.ccys.lookUpId(this.ccy1) != 0) {
                    this.alert.setString(this.ccy1.code + " \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442 ");
                    this.display.setCurrent(this.alert, (Displayable)this.ccyf);
                    return;
                }
                this.ccy1.id = n;
                if (bl && this.ccy1.rate != 100000) {
                    this.alert.setString("\u041a\u043e\u044d\u0444. \u0434\u043e\u043c\u0430\u0448\u043d\u0435\u0439 \u0432\u0430\u043b\u044e\u0442\u044b \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c 1.00");
                    this.display.setCurrent(this.alert, (Displayable)this.ccyf);
                    return;
                }
                this.ccyf = null;
                this.display.setCurrent((Displayable)this);
                this.editCurrency(this.ccy1);
                if (bl) {
                    this.parent.homeCurrency = this.ccy1.code;
                }
            }
            if (command == this.parent.cancelCommand) {
                this.msg = "";
                this.ccyf = null;
                this.alert.setString("\u041e\u0442\u043c\u0435\u043d\u0435\u043d\u043e");
                this.display.setCurrent(this.alert, (Displayable)this);
            }
        }
        if (displayable == this.vl) {
            if (command == this.parent.cancelCommand) {
                this.msg = "";
                this.vl = null;
                this.alert.setString("\u041e\u0442\u043c\u0435\u043d\u0435\u043d\u043e");
                this.display.setCurrent(this.alert, (Displayable)this);
            }
            if (command == this.parent.okCommand) {
                if (this.vl.update() == 0) {
                    this.display.setCurrent((Displayable)this.parent.av);
                }
                if (this.vl.update() == 1) {
                    if (this.parent.tv == null) {
                        this.alert.setString("\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u0430 \u0423\u0447\u0435\u0442\u043d.\u0417\u0430\u043f\u0438\u0441\u044c");
                        this.display.setCurrent(this.alert, (Displayable)this);
                    } else {
                        this.display.setCurrent((Displayable)this.parent.tv);
                    }
                }
                if (this.vl.update() == 2) {
                    if (this.parent.cv == null) {
                        this.parent.cv = new CategoryView(this.parent, this.display);
                    }
                    this.display.setCurrent((Displayable)this.parent.cv);
                }
                if (this.vl.update() == 3) {
                    if (this.parent.sov == null) {
                        this.parent.sov = new StandingOrderView(this.parent, this.display);
                    }
                    this.display.setCurrent((Displayable)this.parent.sov);
                }
                if (this.vl.update() == 4) {
                    if (this.parent.iv == null) {
                        this.parent.iv = new InvestmentView(this.parent, this.display);
                    }
                    this.display.setCurrent((Displayable)this.parent.iv);
                }
                if (this.vl.update() == 5) {
                    this.display.setCurrent((Displayable)this);
                }
            }
        }
        if (displayable == this.debug) {
            this.debug = null;
            this.display.setCurrent((Displayable)this);
        }
    }
}

