/*
 * Decompiled with CFR 0.152.
 */
package JabpLite;

import JabpLite.Currency;
import JabpLite.CurrencyStore;
import JabpLite.Investment;
import JabpLite.JabpLite;
import JabpLite.Utilities;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.DateField;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.TextField;

public class InvestmentForm
extends Form {
    Investment inv;
    JabpLite parent;
    DateField df;
    ChoiceGroup cgCurrency;
    TextField tfName;
    TextField tfDescription;
    TextField tfHolding;
    TextField tfPrice;

    public InvestmentForm(JabpLite jabpLite, Investment investment, String string) {
        super(string + "\u0418\u043d\u0432\u0435\u0441\u0442\u0438\u0446\u0438\u044f");
        this.parent = jabpLite;
        this.inv = investment;
        this.tfName = new TextField("\u0418\u043c\u044f", this.inv.name, 30, 0);
        this.append((Item)this.tfName);
        this.tfDescription = new TextField("\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435", this.inv.description, 64, 0);
        this.append((Item)this.tfDescription);
        int n = 2;
        if (!this.parent.numericEntry) {
            n = 0;
        }
        this.tfHolding = new TextField("\u041f\u0440\u043e\u0432\u0435\u0434\u0435\u043d\u0438\u0435", "", 20, n);
        String string2 = "";
        if (this.inv.holding != 0) {
            string2 = Utilities.holdingToString(Math.abs(this.inv.holding));
        }
        this.tfHolding.setString(string2);
        this.append((Item)this.tfHolding);
        this.tfPrice = new TextField("\u0426\u0435\u043d\u0430", "", 20, n);
        string2 = "";
        if (this.inv.price != 0) {
            string2 = Utilities.numberToString(Math.abs(this.inv.price), this.parent.numericEntry);
        }
        this.tfPrice.setString(string2);
        this.append((Item)this.tfPrice);
        this.df = new DateField("\u0414\u0430\u0442\u0430", 1);
        this.df.setDate(this.inv.priceDate);
        this.append((Item)this.df);
        this.cgCurrency = new ChoiceGroup("\u0412\u0430\u043b\u044e\u0442\u0430", 1);
        CurrencyStore currencyStore = new CurrencyStore(this.parent);
        int n2 = currencyStore.getNumCurrencies();
        for (int i = 0; i < n2; ++i) {
            Currency currency = currencyStore.getCurrencyFromIndex(i);
            this.cgCurrency.append(currency.code, null);
            if (this.inv.currency.equals("")) {
                if (!currency.code.equals(this.parent.homeCurrency)) continue;
                this.cgCurrency.setSelectedIndex(i, true);
                continue;
            }
            if (!currency.code.equals(this.inv.currency)) continue;
            this.cgCurrency.setSelectedIndex(i, true);
        }
        this.append((Item)this.cgCurrency);
        currencyStore.closeCurrencyStore();
        currencyStore = null;
    }

    Investment update() {
        this.inv.name = this.tfName.getString();
        this.inv.description = this.tfDescription.getString();
        int n = this.inv.holding;
        this.inv.holding = Utilities.holdingToNumber(this.tfHolding.getString(), n);
        n = this.inv.price;
        this.inv.price = Utilities.stringToNumber(this.tfPrice.getString(), n, this.parent.numericEntry);
        this.inv.priceDate = this.df.getDate();
        this.inv.currency = this.cgCurrency.getString(this.cgCurrency.getSelectedIndex());
        return this.inv;
    }
}

