/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic;

import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.MainCanvas;
import sk.inlogic.X;
import sk.inlogic.graphics.GFont;
import sk.inlogic.text.ResourceBundle;

public class Resources {
    private static String graphicsBaseDir = "/";
    private static String graphicsDisplayDir = "/";
    public static final int IMG_SPLASH = 0;
    public static final int IMG_INLOGIC_LOGO = 1;
    public static final int IMG_BG_1 = 2;
    public static final int IMG_BG_2 = 3;
    public static final int IMG_BG_3 = 4;
    public static final int IMG_SELECTOR = 5;
    public static final int IMG_ROTATE = 6;
    public static final int IMG_ABOUT = 7;
    public static final int IMG_BACK = 8;
    public static final int IMG_EXIT = 9;
    public static final int IMG_INSTRUCTIONS = 10;
    public static final int IMG_LOCKED = 11;
    public static final int IMG_NO = 12;
    public static final int IMG_YES = 13;
    public static final int IMG_PACK_SMALL = 14;
    public static final int IMG_PLAY = 15;
    public static final int IMG_RESTART = 16;
    public static final int IMG_LANG_EN = 17;
    public static final int IMG_LANG_DE = 18;
    public static final int IMG_LANG_FR = 19;
    public static final int IMG_LANG_IT = 20;
    public static final int IMG_LANG_ES = 21;
    public static final int IMG_LANG_PT = 22;
    public static final int IMG_LANG_RU = 23;
    public static final int IMG_LANG_SK = 24;
    public static final int IMG_STAR = 25;
    public static final int IMG_POINTER_DOT = 26;
    public static final int IMG_BEE_SAD = 27;
    public static final int IMG_BEE_HAPPY = 28;
    public static final int IMG_STAR_GRAY = 29;
    public static final int IMG_STICK = 30;
    public static final int IMG_STICK1 = 31;
    public static final int IMG_RESULT_BAR_EMPTY = 32;
    public static final int IMG_RESULT_BAR_FULL = 33;
    public static final int IMG_POWER_BAR = 34;
    public static final int IMG_POWER_BAR_BG = 35;
    public static final int IMG_RETURN_TO_MENU = 36;
    public static final int IMG_PACK_BIG = 37;
    public static final int IMG_RED_BUTTON = 38;
    public static final int IMG_WIN = 39;
    public static final int IMG_MENU_BG = 40;
    public static final int IMG_MENU_ABOUT = 41;
    public static final int IMG_TUT_BALLOONS = 42;
    public static final int TOTAL_IMGS = 43;
    public static Image[] resImgs = new Image[43];
    public static int[] resImgsW = new int[43];
    public static int[] resImgsH = new int[43];
    public static final int SPR_ARROW = 0;
    public static final int SPR_BOMB = 1;
    public static final int SPR_WOOD = 2;
    public static final int SPR_FREEZE = 3;
    public static final int SPR_BALON_1 = 4;
    public static final int SPR_BALON_2 = 5;
    public static final int SPR_BOD = 6;
    public static final int SPR_ICE = 7;
    public static final int SPR_HONEY = 8;
    public static final int SPR_ROCK = 9;
    public static final int SPR_TRIPLE_SHOT = 10;
    public static final int SPR_ARROWS = 11;
    public static final int SPR_WINDOW_SKIN = 12;
    public static final int SPR_SOUNDS = 13;
    public static final int SPR_WINDOW_SKIN_HIGHLIGHTED = 14;
    public static final int SPR_BEE = 15;
    public static final int SPR_SMOKE = 16;
    public static final int SPR_STONE_PARTICLES = 17;
    public static final int SPR_WOOD_PARTICLES = 18;
    public static final int SPR_SMOKE_BOMB = 19;
    public static final int SPR_LOADING_DOTS = 20;
    public static final int SPR_123 = 21;
    public static final int SPR_GAME_ARROWS = 22;
    public static final int SPR_ARROWS_H = 23;
    public static final int TOTAL_SPRS = 24;
    public static Sprite[] resSprs = new Sprite[24];
    public static int[] resSprsW = new int[24];
    public static int[] resSprsH = new int[24];
    public static final int GFONT_MAIN = 0;
    public static final int TOTAL_GFONTS = 1;
    public static GFont[] resGFonts = new GFont[1];
    public static final int TEXT_MAIN = 0;
    public static final int TOTAL_TEXTS = 1;
    public static ResourceBundle[] resTexts = new ResourceBundle[1];
    public static final int TEXT_MAIN_INSTRUCTIONS = 2;
    public static final int TEXT_MAIN_ENABLE_MUSIC = 4;
    public static final int TEXT_MAIN_YES = 5;
    public static final int TEXT_MAIN_NO = 6;
    public static final int TEXT_REALY_QUIT = 3;
    public static final int TEXT_WIN = 7;
    public static final int TEXT_1_STAR = 8;
    public static final int TEXT_2_STAR = 9;
    public static final int TEXT_3_STAR = 10;
    public static final int TEXT_PERFECT_RES = 11;
    public static final int TEXT_CONTROLS_KEYS = 14;
    public static final int TEXT_CONTROLS_TOUCH = 15;
    public static final int TEXT_MENU_DESCRIPTION = 16;
    public static final int TEXT_BB_FK_LEFT = 12;
    public static final int TEXT_BB_FK_RIGHT = 13;
    public static final int TEXT_TUTORIAL_1_KEYS = 17;
    public static final int TEXT_TUTORIAL_1_TOUCH = 18;
    public static final int TEXT_TUTORIAL_2_BOUNCE = 19;
    public static final int TEXT_TUTORIAL_3_WOOD = 20;
    public static final int TEXT_TUTORIAL_4_ROCK = 21;
    public static final int TEXT_TUTORIAL_5_BOMB = 22;
    public static final int TEXT_TUTORIAL_6_ARROW = 23;
    public static final int TEXT_TUTORIAL_7_MULTIPLAYER = 24;
    public static final int TEXT_TUTORIAL_8_HONEY_COMB = 25;
    public static final int TEXT_TUTORIAL_9_SNOWFLAKE = 26;
    public static final int TEXT_QUIT = 27;
    public static final int TEXT_RESULT_1 = 28;
    public static final int TEXT_RESULT_2 = 29;
    private static String langDir = "/";

    public static void refreshLoading() {
        if (MainCanvas.loading) {
            X.mainCanvas.repaintLoading();
        }
    }

    public static Image createImage(String imgName) {
        Image image = null;
        System.out.println("imgName2: " + imgName);
        try {
            image = Image.createImage((String)imgName);
        }
        catch (Exception e) {
            System.out.println("Creating Image error [\"" + imgName + "\"]: " + e);
        }
        return image;
    }

    public static Sprite createSprite(Image image, int slicesX, int slicesY) {
        Sprite sprite = null;
        try {
            int sprWidth = image.getWidth() / slicesX;
            int sprHeight = image.getHeight() / slicesY;
            sprite = new Sprite(image, sprWidth, sprHeight);
        }
        catch (Exception e) {
            sprite = null;
        }
        return sprite;
    }

    public static void loadImage(int imgIdx) {
        String imgName = null;
        switch (imgIdx) {
            case 41: {
                imgName = "ui_info";
                break;
            }
            case 0: {
                imgName = "splash";
                break;
            }
            case 42: {
                imgName = "i_balon";
                break;
            }
            case 40: {
                imgName = "splash2";
                break;
            }
            case 1: {
                imgName = "l";
                break;
            }
            case 2: {
                imgName = "bg1";
                break;
            }
            case 3: {
                imgName = "bg2";
                break;
            }
            case 4: {
                imgName = "bg3";
                break;
            }
            case 5: {
                imgName = "mi_selector";
                break;
            }
            case 6: {
                imgName = "rot";
                break;
            }
            case 7: {
                imgName = "ui_about";
                break;
            }
            case 8: {
                imgName = "ui_back";
                break;
            }
            case 9: {
                imgName = "ui_exit";
                break;
            }
            case 10: {
                imgName = "ui_instructions";
                break;
            }
            case 11: {
                imgName = "ui_locked";
                break;
            }
            case 12: {
                imgName = "ui_no";
                break;
            }
            case 13: {
                imgName = "ui_yes";
                break;
            }
            case 14: {
                imgName = "ui_pack_small";
                break;
            }
            case 15: {
                imgName = "ui_play";
                break;
            }
            case 16: {
                imgName = "ui_restart";
                break;
            }
            case 17: {
                imgName = "lang_en";
                break;
            }
            case 18: {
                imgName = "lang_de";
                break;
            }
            case 19: {
                imgName = "lang_fr";
                break;
            }
            case 20: {
                imgName = "lang_it";
                break;
            }
            case 21: {
                imgName = "lang_es";
                break;
            }
            case 22: {
                imgName = "lang_pt";
                break;
            }
            case 23: {
                imgName = "lang_ru";
                break;
            }
            case 24: {
                imgName = "lang_sk";
                break;
            }
            case 25: {
                imgName = "star_light";
                break;
            }
            case 26: {
                imgName = "pointer_dot";
                break;
            }
            case 27: {
                imgName = "bee_lose";
                break;
            }
            case 28: {
                imgName = "bee_stars";
                break;
            }
            case 29: {
                imgName = "star_gray";
                break;
            }
            case 32: {
                imgName = "result_bar_empty";
                break;
            }
            case 33: {
                imgName = "result_bar_full";
                break;
            }
            case 34: {
                imgName = "power_bar";
                break;
            }
            case 35: {
                imgName = "power_bar_bg";
                break;
            }
            case 36: {
                imgName = "ui_back_to_menu";
                break;
            }
            case 37: {
                imgName = "ui_pack_big";
                break;
            }
            case 38: {
                imgName = "red_button";
                break;
            }
            case 39: {
                imgName = "win";
            }
        }
        if (imgName != null && resImgs[imgIdx] == null) {
            Resources.resImgs[imgIdx] = Resources.createImage(graphicsBaseDir + imgName + ".png");
            Resources.resImgsW[imgIdx] = resImgs[imgIdx].getWidth();
            Resources.resImgsH[imgIdx] = resImgs[imgIdx].getHeight();
        }
    }

    public static void freeImage(int imgIdx) {
        Resources.resImgs[imgIdx] = null;
        Resources.resImgsW[imgIdx] = -1;
        Resources.resImgsH[imgIdx] = -1;
        System.gc();
    }

    public static void loadImages(int[] imgsIdx) {
        for (int i = 0; i < imgsIdx.length; ++i) {
            Resources.loadImage(imgsIdx[i]);
            Resources.refreshLoading();
        }
    }

    public static void freeImages(int[] imgsIdx) {
        for (int i = 0; i < imgsIdx.length; ++i) {
            Resources.resImgs[imgsIdx[i]] = null;
            Resources.resImgsW[imgsIdx[i]] = -1;
            Resources.resImgsH[imgsIdx[i]] = -1;
        }
        System.gc();
    }

    public static void loadSprite(int sprIdx) {
        String sprName = null;
        int slicesX = 1;
        int slicesY = 1;
        switch (sprIdx) {
            case 0: {
                sprName = "i_siska";
                slicesX = 3;
                slicesY = 1;
                break;
            }
            case 1: {
                sprName = "i_bomb";
                slicesX = 2;
                slicesY = 1;
                break;
            }
            case 2: {
                sprName = "i_drevo";
                slicesX = 2;
                slicesY = 1;
                break;
            }
            case 3: {
                sprName = "i_vlocka";
                slicesX = 2;
                slicesY = 1;
                break;
            }
            case 4: {
                sprName = "i_balon";
                slicesX = 6;
                slicesY = 1;
                break;
            }
            case 5: {
                sprName = "i_balon";
                slicesX = 6;
                slicesY = 1;
                break;
            }
            case 6: {
                sprName = "i_bodliak";
                slicesX = 2;
                slicesY = 1;
                break;
            }
            case 7: {
                sprName = "i_lad";
                slicesX = 1;
                slicesY = 1;
                break;
            }
            case 8: {
                sprName = "i_med";
                slicesX = 3;
                slicesY = 1;
                break;
            }
            case 9: {
                sprName = "i_skala";
                slicesX = 3;
                slicesY = 1;
                break;
            }
            case 10: {
                sprName = "i_trojl";
                slicesX = 2;
                slicesY = 1;
                break;
            }
            case 12: {
                sprName = "ui_window_skin";
                slicesX = 3;
                slicesY = 3;
                break;
            }
            case 11: {
                sprName = "ui_arrows";
                slicesX = 2;
                slicesY = 1;
                break;
            }
            case 23: {
                sprName = "ui_arrows_v";
                slicesX = 1;
                slicesY = 2;
                break;
            }
            case 13: {
                sprName = "ui_sound_on_off";
                slicesX = 2;
                slicesY = 1;
                break;
            }
            case 14: {
                sprName = "ui_window_skin_highlighted";
                slicesX = 3;
                slicesY = 3;
                break;
            }
            case 15: {
                sprName = "bee";
                slicesX = 18;
                slicesY = 1;
                break;
            }
            case 16: {
                sprName = "dym";
                slicesX = 5;
                slicesY = 1;
                break;
            }
            case 17: {
                sprName = "stone_particles";
                slicesX = 6;
                slicesY = 1;
                break;
            }
            case 18: {
                sprName = "wood_particles";
                slicesX = 6;
                slicesY = 1;
                break;
            }
            case 19: {
                sprName = "dym_2";
                slicesX = 5;
                slicesY = 1;
                break;
            }
            case 20: {
                sprName = "loading_dots";
                slicesX = 2;
                slicesY = 1;
                break;
            }
            case 21: {
                sprName = "123";
                slicesX = 3;
                slicesY = 1;
                break;
            }
            case 22: {
                sprName = "ui_game_arrows";
                slicesX = 2;
                slicesY = 1;
            }
        }
        if (sprName != null && resSprs[sprIdx] == null) {
            Image tmpImg = Resources.createImage(graphicsBaseDir + sprName + ".png");
            Resources.resSprs[sprIdx] = Resources.createSprite(tmpImg, slicesX, slicesY);
            Resources.resSprsW[sprIdx] = resSprs[sprIdx].getWidth();
            Resources.resSprsH[sprIdx] = resSprs[sprIdx].getHeight();
            tmpImg = null;
        }
    }

    public static void freeSprite(int sprIdx) {
        Resources.resSprs[sprIdx] = null;
        System.gc();
    }

    public static void loadSprites(int[] sprsIdx) {
        for (int i = 0; i < sprsIdx.length; ++i) {
            Resources.loadSprite(sprsIdx[i]);
            Resources.refreshLoading();
        }
        System.gc();
    }

    public static void freeSprites(int[] sprsIdx) {
        for (int i = 0; i < sprsIdx.length; ++i) {
            Resources.resSprs[sprsIdx[i]] = null;
        }
        System.gc();
    }

    private static GFont createGFontInstr(Image gFontImg) {
        char[] fontChars = null;
        char[] fontChars1 = new char[]{'A', 'B', '\u00c6', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00c1', '\u00c0', '\u00c4', '\u00c5', '\u00c2', '\u00c3', '\u00c7', '\u010c', '\u010e', '\u00c9', '\u00c8', '\u00cb', '\u00ca', '\u00cd', '\u00cc', '\u00cf', '\u00ce', '\u013d', '\u00d1', '\u0147', '\u00d3', '\u00d2', '\u00d6', '\u00d4', '\u00d5', '\u00d9', '\u00da', '\u00dc', '\u00dd', '\u016e', '\u0154', '\u0158', '\u0160', '\u015a', '\u0164', '\u017d', '$', '\u00a3', '\u00a5', '#', '&', '*', '@', '\\', '\u20ac', '\u00ae', '\u00a9', '\u2122', '[', '(', '{', '}', ')', ']', '|', '%', '\u00b0', '<', '>', '+', '=', '.', ',', ':', ';', '\'', '`', '\u201c', '!', '?', '-', '_', '\u00f7', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '\u00df', '\u00d0', '\u00bf', '\u00a1', '/'};
        char[] fontChars2 = new char[]{'A', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00c1', 'A', '\u00c4', 'A', '\u00c2', 'A', '\u00c7', '\u010c', '\u010e', '\u00c9', 'E', '\u00cb', 'E', '\u00cd', 'I', 'I', '\u00ce', '\u013d', 'N', '\u0147', '\u00d3', 'O', '\u00d6', '\u00d4', 'O', 'U', '\u00da', '\u00dc', 'U', '\u00dd', '\u016e', '\u0154', '\u0158', '\u0160', '\u015a', '\u0164', '\u017d', '$', 'L', 'Y', '#', '&', '*', '@', '/', '\u20ac', '\u00ae', '\u00a9', '\u2122', '[', '(', '{', '}', ')', ']', '|', '%', '\u00b0', '<', '>', '+', '=', '.', ',', ':', ';', '\'', '`', '\u201c', '!', '?', '-', '_', '\u00f7', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '\u00df', '?', '\u00bf', '\u00a1'};
        short[] fontCharsWidth = null;
        int spaceBetweenChars = 0;
        switch (gFontImg.getHeight()) {
            case 12: {
                fontChars = fontChars2;
                fontCharsWidth = new short[]{7, 9, 7, 7, 7, 6, 6, 7, 7, 4, 6, 7, 6, 7, 7, 7, 7, 7, 7, 7, 6, 7, 7, 10, 7, 8, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 6, 6, 8, 7, 5, 5, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8, 7, 7, 7, 7, 7, 6, 7, 7, 7, 8, 9, 9, 9, 10, 7, 9, 11, 10, 9, 5, 5, 6, 6, 5, 5, 4, 8, 7, 7, 7, 8, 6, 4, 4, 4, 4, 4, 5, 7, 4, 8, 6, 8, 8, 7, 5, 7, 7, 8, 7, 7, 7, 7, 7, 7, 8, 7, 4};
                break;
            }
            case 15: {
                fontChars = fontChars1;
                fontCharsWidth = new short[]{8, 8, 13, 7, 7, 8, 6, 7, 7, 3, 2, 7, 3, 12, 7, 8, 8, 8, 5, 6, 5, 8, 7, 11, 8, 6, 8, 7, 8, 8, 8, 7, 8, 6, 7, 11, 7, 8, 8, 8, 4, 4, 6, 4, 6, 7, 8, 8, 8, 8, 8, 8, 7, 7, 7, 8, 7, 6, 5, 6, 7, 6, 7, 8, 8, 9, 7, 10, 5, 10, 6, 7, 6, 9, 10, 3, 3, 4, 4, 3, 3, 1, 11, 3, 7, 6, 7, 7, 4, 3, 3, 4, 4, 5, 6, 4, 7, 5, 5, 3, 8, 5, 7, 7, 9, 8, 7, 8, 8, 7, 8, 9, 7, 3, 6};
                break;
            }
            case 14: {
                fontChars = fontChars1;
                fontCharsWidth = new short[]{9, 8, 13, 7, 9, 7, 8, 8, 9, 5, 6, 9, 4, 12, 9, 8, 9, 9, 7, 7, 8, 8, 8, 10, 8, 9, 7, 9, 8, 9, 8, 8, 8, 7, 7, 11, 7, 7, 7, 7, 4, 5, 5, 5, 7, 9, 8, 7, 7, 7, 7, 7, 8, 7, 7, 9, 7, 7, 7, 7, 6, 9, 7, 7, 8, 9, 9, 10, 6, 9, 5, 9, 5, 9, 8, 7, 5, 5, 5, 5, 7, 3, 9, 4, 5, 5, 8, 7, 4, 4, 4, 4, 4, 4, 6, 5, 7, 6, 8, 6, 8, 6, 7, 7, 8, 7, 7, 7, 7, 7, 8, 10, 7, 5, 5, 0, 9};
                break;
            }
            case 20: {
                fontChars = fontChars1;
                fontCharsWidth = new short[]{12, 12, 19, 10, 13, 10, 11, 12, 12, 7, 8, 13, 7, 17, 13, 10, 13, 13, 11, 10, 12, 11, 12, 15, 11, 12, 11, 12, 13, 12, 12, 13, 12, 10, 10, 15, 10, 10, 10, 10, 7, 6, 7, 7, 10, 13, 12, 11, 10, 11, 11, 10, 11, 12, 11, 12, 12, 11, 10, 9, 10, 13, 11, 10, 12, 14, 13, 14, 9, 12, 8, 13, 7, 12, 11, 10, 7, 8, 8, 7, 10, 5, 12, 6, 8, 8, 11, 8, 5, 6, 5, 5, 6, 5, 9, 7, 10, 8, 11, 10, 10, 9, 10, 11, 12, 10, 10, 10, 11, 10, 12, 14, 10, 7, 8, 0, 12};
                break;
            }
            case 31: {
                fontChars = fontChars1;
                fontCharsWidth = new short[]{18, 17, 27, 15, 19, 15, 16, 17, 19, 9, 13, 19, 9, 25, 19, 15, 18, 19, 16, 14, 18, 17, 17, 22, 16, 18, 15, 18, 18, 18, 18, 18, 18, 14, 14, 22, 14, 14, 15, 15, 10, 10, 10, 10, 14, 18, 18, 15, 15, 15, 15, 15, 17, 17, 17, 17, 17, 15, 15, 14, 14, 18, 15, 14, 17, 19, 19, 20, 13, 18, 11, 18, 9, 17, 16, 15, 10, 11, 10, 11, 15, 6, 18, 9, 12, 11, 15, 13, 8, 8, 7, 7, 8, 8, 13, 10, 15, 12, 17, 14, 15, 12, 15, 16, 17, 14, 15, 14, 15, 15, 17, 21, 15, 10, 10, 0, 18};
                break;
            }
            default: {
                fontChars = fontChars1;
                fontCharsWidth = new short[]{18, 17, 27, 15, 19, 15, 16, 17, 19, 9, 13, 19, 9, 25, 19, 15, 18, 19, 16, 14, 18, 17, 17, 22, 16, 18, 15, 18, 18, 18, 18, 18, 18, 14, 14, 22, 14, 14, 15, 15, 10, 10, 10, 10, 14, 18, 18, 15, 15, 15, 15, 15, 17, 17, 17, 17, 17, 15, 15, 14, 14, 18, 15, 14, 17, 19, 19, 20, 13, 18, 11, 18, 9, 17, 16, 15, 10, 11, 10, 11, 15, 6, 18, 9, 12, 11, 15, 13, 8, 8, 7, 7, 8, 8, 13, 10, 15, 12, 17, 14, 15, 12, 15, 16, 17, 14, 15, 14, 15, 15, 17, 21, 15, 10, 10, 0, 18};
            }
        }
        return new GFont(gFontImg, fontChars, fontCharsWidth, spaceBetweenChars, fontCharsWidth[0]);
    }

    private static GFont createGFontNums(Image gFontImg) {
        char[] fontChars = new char[]{'1', '2', '3', '4', '5', '6', '7', '8', '9', '0', 'S', 'T', 'M'};
        short[] fontCharsWidth = null;
        int spaceBetweenChars = 2;
        switch (gFontImg.getHeight()) {
            case 7: {
                spaceBetweenChars = 1;
                fontCharsWidth = new short[]{3, 5, 4, 4, 4, 5, 4, 5, 5, 5, 7, 7, 6};
                break;
            }
            case 9: {
                fontCharsWidth = new short[]{5, 7, 7, 8, 7, 7, 7, 7, 7, 6, 11, 9, 8};
                break;
            }
            case 15: {
                fontCharsWidth = new short[]{7, 9, 9, 10, 9, 10, 9, 10, 9, 9, 17, 13, 12};
                break;
            }
            case 21: {
                fontCharsWidth = new short[]{10, 13, 14, 15, 13, 14, 14, 13, 14, 14, 23, 17, 18};
                break;
            }
            case 29: {
                fontCharsWidth = new short[]{12, 17, 16, 18, 16, 18, 18, 17, 18, 17, 29, 23, 24};
                break;
            }
            default: {
                fontCharsWidth = new short[]{14, 20, 20, 22, 20, 21, 21, 21, 21, 20, 35, 27};
            }
        }
        return new GFont(gFontImg, fontChars, fontCharsWidth, spaceBetweenChars, fontCharsWidth[0]);
    }

    public static void loadGFont(int gFontIdx) {
        Image gFontImg = null;
        if (resGFonts[gFontIdx] != null) {
            return;
        }
        switch (gFontIdx) {
            case 0: {
                gFontImg = Resources.createImage(graphicsBaseDir + "font.png");
                if (gFontImg == null) break;
                Resources.resGFonts[gFontIdx] = Resources.createGFontInstr(gFontImg);
            }
        }
    }

    public static void freeGFont(int gFontIdx) {
        Resources.resGFonts[gFontIdx] = null;
        System.gc();
    }

    public static void loadGFonts(int[] gFontsIdx) {
        for (int i = 0; i < gFontsIdx.length; ++i) {
            Resources.loadGFont(gFontsIdx[i]);
        }
    }

    public static void freeGFonts(int[] gFontsIdx) {
        for (int i = 0; i < gFontsIdx.length; ++i) {
            Resources.resGFonts[gFontsIdx[i]] = null;
        }
        System.gc();
    }

    public static void initLangDirs(String langCode) {
        langDir = "/lang/" + langCode + "/";
    }

    public static void loadText(int textIdx) {
        String textPath = null;
        switch (textIdx) {
            case 0: {
                textPath = langDir + "m.csr";
            }
        }
        Resources.resTexts[textIdx] = new ResourceBundle(X.singleton, textPath);
    }

    public static void freeText(int textIdx) {
        Resources.resTexts[textIdx] = null;
        System.gc();
    }
}

