/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic;

import javax.microedition.lcdui.Graphics;
import sk.inlogic.MainCanvas;
import sk.inlogic.Resources;
import sk.inlogic.Sounds;
import sk.inlogic.graphics.Rendering2D;
import sk.inlogic.screen.IScreen;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Rectangle;
import sk.inlogic.util.Tools;

public class ScreenMainMenu
implements IScreen {
    MainCanvas mc;
    int mode;
    long modeDelay;
    private static final int ITEM_LEFT_ARROW = 0;
    private static final int ITEM_RIGHT_ARROW = 1;
    private static final int ITEM_PLAY = 2;
    private static final int ITEM_SOUNDS = 3;
    private static final int ITEM_INSTRUCTIONS = 4;
    private static final int ITEM_ABOUT = 5;
    private static final int ITEM_QUIT = 6;
    private int selectedMenuItem = 2;
    Rectangle[] menuItems = new Rectangle[7];
    Rectangle centeredItem = null;
    int menuBackgroundH = 0;
    private int holdingItemIndex = -1;
    int key = 0;
    int a = 0;
    private int x1 = 0;
    private int x2 = 0;
    boolean allMissed = true;
    boolean swippe = false;

    public ScreenMainMenu(MainCanvas _canvas) {
        this.mc = _canvas;
    }

    public void beforeShow() {
        MainCanvas.mlog("ScreenMainMenu beforeShow() - IN");
        Resources.loadImages(new int[]{40, 41, 15, 5, 7, 9, 10});
        Resources.loadSprites(new int[]{11, 13});
        this.createMenuItems();
        this.centeredItem = new Rectangle(MainCanvas.WIDTH - MainCanvas.mainTableSize >> 1, MainCanvas.HEIGHT - (MainCanvas.arrowBackgroundSize + MainCanvas.mainUIOffset), MainCanvas.mainTableSize, MainCanvas.arrowBackgroundSize);
        this.menuItems[0] = new Rectangle(this.centeredItem.x - MainCanvas.emptySpaceOnSides4 - (MainCanvas.arrowBackgroundSize >> 1), this.centeredItem.getCenterY() - (MainCanvas.arrowBackgroundSize >> 1), MainCanvas.arrowBackgroundSize, MainCanvas.arrowBackgroundSize);
        this.menuItems[1] = new Rectangle(this.centeredItem.getRight() + MainCanvas.emptySpaceOnSides4 - (MainCanvas.arrowBackgroundSize >> 1), this.centeredItem.getCenterY() - (MainCanvas.arrowBackgroundSize >> 1), MainCanvas.arrowBackgroundSize, MainCanvas.arrowBackgroundSize);
        this.selectedMenuItem = 2;
        this.holdingItemIndex = -1;
        MainCanvas.selectItemWithLoading = new Rectangle(MainCanvas.WIDTH - (MainCanvas.mainUIOffset + 3 * Resources.resImgsW[15] / 2), MainCanvas.HEIGHT - (MainCanvas.mainUIOffset + MainCanvas.arrowBackgroundSize), 3 * Resources.resImgsW[15] / 2, MainCanvas.arrowBackgroundSize);
        MainCanvas.mlog("ScreenMainMenu beforeShow() - OUT " + MainCanvas.soundManager.IsSoundOn());
        if (MainCanvas.soundManager.IsSoundOn()) {
            MainCanvas.soundManager.Stop();
            MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
        }
    }

    public void afterHide() {
        MainCanvas.mlog("ScreenMainMenu afterHide() - IN");
        Resources.freeImages(new int[]{40, 41, 15, 5, 7, 9, 10});
        Resources.freeSprites(new int[]{11, 13});
        MainCanvas.mlog("ScreenMainMenu afterHide() - OUT");
    }

    private void createMenuItems() {
        this.menuBackgroundH = Resources.resImgsH[7] + (Resources.resImgsH[7] >> 1);
        this.menuItems[2] = new Rectangle(MainCanvas.WIDTH - MainCanvas.mainTableSize >> 1, MainCanvas.HEIGHT - (MainCanvas.arrowBackgroundSize + MainCanvas.mainUIOffset), MainCanvas.mainTableSize, MainCanvas.arrowBackgroundSize);
        this.menuItems[3] = new Rectangle(MainCanvas.WIDTH + (MainCanvas.WIDTH - MainCanvas.mainTableSize >> 1), MainCanvas.HEIGHT - (MainCanvas.arrowBackgroundSize + MainCanvas.mainUIOffset), MainCanvas.mainTableSize, MainCanvas.arrowBackgroundSize);
        this.menuItems[4] = new Rectangle(2 * MainCanvas.WIDTH + (MainCanvas.WIDTH - MainCanvas.mainTableSize >> 1), MainCanvas.HEIGHT - (MainCanvas.arrowBackgroundSize + MainCanvas.mainUIOffset), MainCanvas.mainTableSize, MainCanvas.arrowBackgroundSize);
        this.menuItems[5] = new Rectangle(3 * MainCanvas.WIDTH + (MainCanvas.WIDTH - MainCanvas.mainTableSize >> 1), MainCanvas.HEIGHT - (MainCanvas.arrowBackgroundSize + MainCanvas.mainUIOffset), MainCanvas.mainTableSize, MainCanvas.arrowBackgroundSize);
        this.menuItems[6] = new Rectangle(3 * MainCanvas.WIDTH + (MainCanvas.WIDTH - MainCanvas.mainTableSize >> 1), MainCanvas.HEIGHT - (MainCanvas.arrowBackgroundSize + MainCanvas.mainUIOffset), MainCanvas.mainTableSize, MainCanvas.arrowBackgroundSize);
    }

    private void recalculate() {
        for (int i = 2; i < this.menuItems.length; ++i) {
            this.menuItems[i].x = -1000;
            if (i != this.selectedMenuItem) continue;
            this.menuItems[i].x = MainCanvas.WIDTH - this.menuItems[i].width >> 1;
        }
    }

    public void update(long lastRunLenght) {
        this.repaint();
    }

    public void paint(Graphics g) {
        Tools.setFullClip(g);
        g.drawImage(Resources.resImgs[40], 0, 0, 20);
        for (int i = 0; i < this.menuItems.length; ++i) {
            if (this.holdingItemIndex == i) {
                Rendering2D.paintImageFromSkin3HV(g, Resources.resSprs[14], this.menuItems[i]);
                continue;
            }
            Rendering2D.paintImageFromSkin3HV(g, Resources.resSprs[12], this.menuItems[i]);
        }
        g.drawImage(Resources.resImgs[15], this.menuItems[2].getCenterX() - (Resources.resImgsW[15] >> 1), this.menuItems[2].getCenterY() - (Resources.resImgsH[15] >> 1), 20);
        if (MainCanvas.soundManager.IsSoundOn()) {
            Resources.resSprs[13].setFrame(0);
        } else {
            Resources.resSprs[13].setFrame(1);
        }
        Resources.resSprs[13].setPosition(this.menuItems[3].getCenterX() - (Resources.resSprsW[13] >> 1), this.menuItems[3].getCenterY() - (Resources.resSprsH[13] >> 1));
        Resources.resSprs[13].paint(g);
        g.drawImage(Resources.resImgs[7], this.menuItems[4].getCenterX() - (Resources.resImgsW[7] >> 1), this.menuItems[4].getCenterY() - (Resources.resImgsH[7] >> 1), 20);
        g.drawImage(Resources.resImgs[41], this.menuItems[5].getCenterX() - (Resources.resImgsW[7] >> 1), this.menuItems[5].getCenterY() - (Resources.resImgsH[7] >> 1), 20);
        g.drawImage(Resources.resImgs[9], this.menuItems[6].getCenterX() - (Resources.resImgsW[9] >> 1), this.menuItems[6].getCenterY() - (Resources.resImgsH[9] >> 1), 20);
        Resources.resSprs[11].setFrame(0);
        Resources.resSprs[11].setPosition(this.menuItems[0].getCenterX() - (Resources.resSprs[11].getWidth() >> 1), this.menuItems[0].getCenterY() - (Resources.resSprs[11].getHeight() >> 1));
        Resources.resSprs[11].paint(g);
        Resources.resSprs[11].setFrame(1);
        Resources.resSprs[11].setPosition(this.menuItems[1].getCenterX() - (Resources.resSprs[11].getWidth() >> 1), this.menuItems[1].getCenterY() - (Resources.resSprs[11].getHeight() >> 1));
        Resources.resSprs[11].paint(g);
    }

    public void repaint() {
        this.mc.paint();
    }

    public void keyPressed(int keyCode) {
        this.key = keyCode;
    }

    public void keyReleased(int keyCode) {
        this.a = keyCode;
        if (Keys.isActionGeneratedByKey(5, keyCode)) {
            if (this.selectedMenuItem == 2) {
                this.mc.setActiveScreen(7, null);
            } else if (this.selectedMenuItem == 6) {
                this.mc.setActiveScreen(10, null);
            } else if (this.selectedMenuItem == 4) {
                this.mc.setActiveScreen(5, null);
            } else if (this.selectedMenuItem == 5) {
                this.mc.setActiveScreen(9, null);
            } else if (this.selectedMenuItem == 3) {
                MainCanvas.soundManager.SetSoundOn(!MainCanvas.soundManager.IsSoundOn());
                if (MainCanvas.soundManager.IsSoundOn()) {
                    MainCanvas.soundManager.Stop();
                    MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
                }
            }
        }
        if (Keys.isActionGeneratedByKey(3, keyCode)) {
            this.prevItem();
        }
        if (Keys.isActionGeneratedByKey(4, keyCode)) {
            this.nextItem();
        }
    }

    public void nextItem() {
        ++this.selectedMenuItem;
        if (this.selectedMenuItem > 6) {
            this.selectedMenuItem = 2;
        }
        this.recalculate();
    }

    public void prevItem() {
        --this.selectedMenuItem;
        if (this.selectedMenuItem < 2) {
            this.selectedMenuItem = 6;
        }
        this.recalculate();
    }

    public void pointerPressed(int x, int y) {
        this.x1 = x;
        for (int i = 0; i < this.menuItems.length; ++i) {
            if (!this.menuItems[i].contains(x, y)) continue;
            this.holdingItemIndex = i;
        }
        MainCanvas.mlog("ScreenMainMenu pointerPressed()");
        MainCanvas.mlog("\tholdingItemIndex = " + this.holdingItemIndex);
    }

    public void pointerDragged(int x, int y) {
    }

    public void pointerReleased(int x, int y) {
        this.x2 = x;
        if (!this.swippe) {
            if (this.x2 > this.x1 + 20) {
                this.nextItem();
                Keys.resetAllPressedKeysAndActions();
            } else if (this.x2 + 20 < this.x1) {
                this.prevItem();
                Keys.resetAllPressedKeysAndActions();
            } else {
                this.swippe = true;
            }
        }
        MainCanvas.mlog("ScreenMainMenu pointerReleased() - IN");
        this.allMissed = true;
        for (int i = 0; i < this.menuItems.length; ++i) {
            if (!this.menuItems[i].contains(x, y)) continue;
            if (this.holdingItemIndex != i) break;
            this.allMissed = false;
            break;
        }
        this.holdingItemIndex = -1;
        if (this.allMissed) {
            MainCanvas.mlog("\tall missed");
            return;
        }
        if (this.menuItems[2].contains(x, y)) {
            this.mc.setActiveScreen(7, null);
        } else if (this.menuItems[3].contains(x, y)) {
            MainCanvas.soundManager.SetSoundOn(!MainCanvas.soundManager.IsSoundOn());
            if (MainCanvas.soundManager.IsSoundOn()) {
                MainCanvas.soundManager.Stop();
                MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
            }
        } else if (this.menuItems[4].contains(x, y)) {
            this.mc.setActiveScreen(5, null);
        } else if (this.menuItems[5].contains(x, y)) {
            this.mc.setActiveScreen(9, null);
        } else if (this.menuItems[6].contains(x, y)) {
            this.mc.setActiveScreen(10, null);
        } else if (this.menuItems[0].contains(x, y)) {
            this.prevItem();
            MainCanvas.mlog("\tLEFT ARROW PRESSED");
        } else if (this.menuItems[1].contains(x, y)) {
            this.nextItem();
            MainCanvas.mlog("\tRIGHT ARROW PRESSED");
        }
        MainCanvas.mlog("ScreenMainMenu pointerReleased() - OUT");
        this.swippe = false;
    }

    void tr(String s) {
        System.out.println(s);
    }
}

