/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.util;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.util.ArrayInt;
import sk.inlogic.util.ArrayObject;

public class Particles {
    static final int MAX_PARTICLES = 100;
    private static int[] partX = new int[100];
    private static int[] partY = new int[100];
    private static int[] partVelX = new int[100];
    private static int[] partVelY = new int[100];
    private static int[] partAccX = new int[100];
    private static int[] partAccY = new int[100];
    private static int[] partCol = new int[100];
    private static int[] partSize = new int[100];
    private static int[] partLife = new int[100];
    private static Sprite[] partSprite = new Sprite[100];
    private static int[] partFrame = new int[100];

    public static void resetParticles() {
        ArrayInt.resetArray(partX);
        ArrayObject.resetObjectsArray(partSprite);
        System.gc();
    }

    public static int createParticle(int X2, int Y, int VelX, int VelY, int AccX, int AccY, int Size, int Col, int Life, Sprite _s, int _spriteFrame) {
        for (int i = 99; i >= 0; --i) {
            if (partX[i] != -9999999) continue;
            Particles.partSprite[i] = _s;
            Particles.partFrame[i] = _spriteFrame;
            Particles.partX[i] = X2;
            Particles.partY[i] = Y;
            Particles.partVelX[i] = VelX;
            Particles.partVelY[i] = VelY;
            Particles.partAccX[i] = AccX;
            Particles.partAccY[i] = AccY;
            Particles.partSize[i] = Size;
            Particles.partCol[i] = Col;
            Particles.partLife[i] = Life;
            return i;
        }
        return -1;
    }

    public static int createParticle(int X2, int Y, int VelX, int VelY, int AccX, int AccY, int Size, int Col, int Life) {
        for (int i = 99; i >= 0; --i) {
            if (partX[i] != -9999999) continue;
            Particles.partSprite[i] = null;
            Particles.partFrame[i] = 0;
            Particles.partX[i] = X2;
            Particles.partY[i] = Y;
            Particles.partVelX[i] = VelX;
            Particles.partVelY[i] = VelY;
            Particles.partAccX[i] = AccX;
            Particles.partAccY[i] = AccY;
            Particles.partSize[i] = Size;
            Particles.partCol[i] = Col;
            Particles.partLife[i] = Life;
            return i;
        }
        return -1;
    }

    public static void paintParticles(Graphics g, boolean onlyAbs) {
        for (int i = 99; i >= 0; --i) {
            if (partX[i] == -9999999) continue;
            if (partLife[i] <= 0) {
                Particles.partX[i] = -9999999;
                continue;
            }
            int n = i;
            partLife[n] = partLife[n] - 1;
            int n2 = i;
            partX[n2] = partX[n2] + partVelX[i] / 10;
            int n3 = i;
            partY[n3] = partY[n3] + partVelY[i] / 10;
            int n4 = i;
            partVelX[n4] = partVelX[n4] + partAccX[i];
            int n5 = i;
            partVelY[n5] = partVelY[n5] + partAccY[i];
            int tmp = partSize[i] / 2;
            int px = partX[i];
            int py = partY[i];
            if (partSprite[i] != null) {
                partSprite[i].setPosition(px + tmp, py + tmp);
                partSprite[i].setFrame(partFrame[i]);
                partSprite[i].paint(g);
                continue;
            }
            g.setColor(partCol[i]);
            g.fillRect(px - tmp, py - tmp, partSize[i], partSize[i]);
        }
    }

    public static void paintParticles(Graphics g) {
        Particles.paintParticles(g, false);
    }

    public static int activeParticles() {
        return ArrayInt.getNonNullValuesCount(partX);
    }
}

