/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic;

import javax.microedition.lcdui.Graphics;

public class Collisions {
    public static int CD_GRID_SIZE_W = 0;
    public static int CD_GRID_SIZE_H = 0;
    public static int CD_GRID_SIZE_W2 = CD_GRID_SIZE_W >> 1;
    public static int CD_GRID_SIZE_Wx2 = CD_GRID_SIZE_W << 1;
    public static int CD_GRID_SIZE_Wx4 = CD_GRID_SIZE_W << 2;
    public static int CD_GRID_SIZE_H2 = CD_GRID_SIZE_H >> 1;
    public static int CD_GRID_SIZE_Hx2 = CD_GRID_SIZE_H << 1;
    public static int CD_GRID_SIZE_Hx4 = CD_GRID_SIZE_H << 2;
    static int collisionsOnX;
    static int collisionsOnY;
    public static boolean[] collisions;
    private static int xOffset;
    private static int yOffset;
    private static int x1;
    private static int y1;

    public static final void resetCollisions() {
        collisions = null;
        System.gc();
    }

    public static final void initCollisions(int worldsCollisionOnX, int worldsCollisionOnY, int collisionSizeW, int collisionSizeH, int _xOffset, int _yOffset) {
        xOffset = _xOffset;
        yOffset = _yOffset;
        collisionsOnX = worldsCollisionOnX;
        collisionsOnY = worldsCollisionOnY;
        Collisions.resetCollisions();
        collisions = new boolean[collisionsOnX * collisionsOnY];
        CD_GRID_SIZE_W = collisionSizeW;
        CD_GRID_SIZE_H = collisionSizeH;
        CD_GRID_SIZE_W2 = CD_GRID_SIZE_W >> 1;
        CD_GRID_SIZE_Wx2 = CD_GRID_SIZE_W << 1;
        CD_GRID_SIZE_Wx4 = CD_GRID_SIZE_W << 2;
        CD_GRID_SIZE_H2 = CD_GRID_SIZE_H >> 1;
        CD_GRID_SIZE_Hx2 = CD_GRID_SIZE_H << 1;
        CD_GRID_SIZE_Hx4 = CD_GRID_SIZE_H << 2;
    }

    public static final void setCollision(int x, int y, boolean coll) {
        if (x < 0) {
            return;
        }
        if (y < 0) {
            return;
        }
        if (x >= collisionsOnX) {
            return;
        }
        if (y >= collisionsOnY) {
            return;
        }
        Collisions.collisions[y * Collisions.collisionsOnX + x] = coll;
    }

    public static final boolean getCollision(int x, int y) {
        if (x < 0) {
            return false;
        }
        if (y < 0) {
            return false;
        }
        if (x >= collisionsOnX) {
            return false;
        }
        if (y >= collisionsOnY) {
            return false;
        }
        return collisions[y * collisionsOnX + x];
    }

    public static final boolean inCollision(int x, int y) {
        x1 = (x - xOffset) / CD_GRID_SIZE_W;
        y1 = (y - yOffset) / CD_GRID_SIZE_H;
        return Collisions.getCollision(x1, y1);
    }

    public static final int getPositionOnGridX(int _x) {
        return (_x - xOffset) / CD_GRID_SIZE_W;
    }

    public static final int getPositionOnGridY(int _y) {
        return (_y - yOffset) / CD_GRID_SIZE_H;
    }

    public static final void paintCollisions(Graphics g) {
        g.setColor(65535);
        for (int x = 0; x < collisionsOnX; ++x) {
            for (int y = 0; y < collisionsOnY; ++y) {
                if (!collisions[y * collisionsOnX + x]) continue;
                g.drawRect(xOffset + x * CD_GRID_SIZE_W, yOffset + y * CD_GRID_SIZE_H, CD_GRID_SIZE_W, CD_GRID_SIZE_H);
            }
        }
    }

    public static void tr(String _s) {
        System.out.println(_s);
    }

    static {
        collisions = null;
        xOffset = 0;
        yOffset = 0;
    }
}

