/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic;

import javax.microedition.lcdui.Graphics;
import sk.inlogic.MainCanvas;
import sk.inlogic.Resources;
import sk.inlogic.graphics.Rendering2D;
import sk.inlogic.screen.IScreen;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Rectangle;
import sk.inlogic.util.Tools;

public class ScreenSelectPack
implements IScreen {
    MainCanvas mc;
    int mode;
    long modeDelay;
    private static final int ITEM_LEFT_ARROW = 0;
    private static final int ITEM_RIGHT_ARROW = 1;
    private static final int ITEM_TABLE = 2;
    private static final int ITEM_BACK = 3;
    private static final int ITEM_SELECT = 4;
    private static final int TOTAL_ITEMS = 5;
    Rectangle[] rectItems = new Rectangle[5];
    private boolean arrowLeft = false;
    private boolean arrowRight = false;
    char[] packCharArr;
    char[] starsCharArr;
    private int holdingItemIndex = -1;
    boolean allMissed = true;

    public ScreenSelectPack(MainCanvas _canvas) {
        this.mc = _canvas;
    }

    public void beforeShow() {
        Resources.loadImages(new int[]{40, 8, 37, 15, 25});
        Resources.loadSprites(new int[]{21, 11});
        Resources.loadText(0);
        this.rectItems[2] = new Rectangle(MainCanvas.WIDTH - MainCanvas.mainTableSize >> 1, MainCanvas.HEIGHT - MainCanvas.mainTableSize >> 1, MainCanvas.mainTableSize, MainCanvas.mainTableSize);
        this.rectItems[0] = new Rectangle(this.rectItems[2].x - MainCanvas.mainUIOffset - MainCanvas.arrowBackgroundSize, MainCanvas.HEIGHT - MainCanvas.arrowBackgroundSize >> 1, MainCanvas.arrowBackgroundSize, MainCanvas.arrowBackgroundSize);
        this.rectItems[1] = new Rectangle(this.rectItems[2].getRight() + MainCanvas.emptySpaceOnSides4 - (MainCanvas.arrowBackgroundSize >> 1), MainCanvas.HEIGHT - MainCanvas.arrowBackgroundSize >> 1, MainCanvas.arrowBackgroundSize, MainCanvas.arrowBackgroundSize);
        this.rectItems[4] = new Rectangle(MainCanvas.mainUIOffset, MainCanvas.HEIGHT - (MainCanvas.mainUIOffset + MainCanvas.arrowBackgroundSize), MainCanvas.arrowBackgroundSize, MainCanvas.arrowBackgroundSize);
        this.rectItems[3] = new Rectangle(MainCanvas.WIDTH - (MainCanvas.mainUIOffset + 3 * Resources.resImgsW[8] / 2), MainCanvas.HEIGHT - (MainCanvas.mainUIOffset + MainCanvas.arrowBackgroundSize), 3 * Resources.resImgsW[8] / 2, MainCanvas.arrowBackgroundSize);
        this.mc.packStars[0] = 0;
        this.mc.packStars[1] = 0;
        this.mc.packStars[2] = 0;
        for (int i = 0; i < 60; ++i) {
            if (i < 20) {
                this.mc.packStars[0] = this.mc.packStars[0] + this.mc.starsForLevel[i];
                continue;
            }
            if (i >= 20 && i < 40) {
                this.mc.packStars[1] = this.mc.packStars[1] + this.mc.starsForLevel[i];
                continue;
            }
            if (i < 40) continue;
            this.mc.packStars[2] = this.mc.packStars[2] + this.mc.starsForLevel[i];
        }
        this.mc.selectedPack = 0;
        this.packCharArr = ("" + (this.mc.selectedPack + 1)).toCharArray();
        this.starsCharArr = (this.mc.packStars[this.mc.selectedPack] + "/60").toCharArray();
    }

    public void afterHide() {
        Resources.freeImages(new int[]{40, 8, 37, 15, 25});
        Resources.freeSprites(new int[]{21, 11});
    }

    public void update(long lastRunLenght) {
        this.repaint();
    }

    public void paint(Graphics g) {
        Tools.setFullClip(g);
        this.arrowVisibility();
        g.drawImage(Resources.resImgs[40], 0, 0, 20);
        for (int i = 0; i < this.rectItems.length; ++i) {
            if (MainCanvas.touchActivated && i == 4) continue;
            if (this.holdingItemIndex == i) {
                if (i == 0 && !this.arrowLeft || i == 1 && !this.arrowRight) continue;
                Rendering2D.paintImageFromSkin3HV(g, Resources.resSprs[14], this.rectItems[i]);
                continue;
            }
            if (i == 0 && !this.arrowLeft || i == 1 && !this.arrowRight) continue;
            Rendering2D.paintImageFromSkin3HV(g, Resources.resSprs[12], this.rectItems[i]);
        }
        if (this.arrowLeft) {
            Resources.resSprs[11].setFrame(0);
            Resources.resSprs[11].setPosition(this.rectItems[0].getCenterX() - (Resources.resSprs[11].getWidth() >> 1), this.rectItems[0].getCenterY() - (Resources.resSprs[11].getHeight() >> 1));
            Resources.resSprs[11].paint(g);
        }
        if (this.arrowRight) {
            Resources.resSprs[11].setFrame(1);
            Resources.resSprs[11].setPosition(this.rectItems[1].getCenterX() - (Resources.resSprs[11].getWidth() >> 1), this.rectItems[1].getCenterY() - (Resources.resSprs[11].getHeight() >> 1));
            Resources.resSprs[11].paint(g);
        }
        if (!MainCanvas.touchActivated) {
            g.drawImage(Resources.resImgs[15], this.rectItems[4].getCenterX() - (Resources.resImgsW[8] >> 1), this.rectItems[4].getCenterY() - (Resources.resImgsH[15] >> 1), 20);
        }
        g.drawImage(Resources.resImgs[8], this.rectItems[3].getCenterX() - (Resources.resImgsW[15] >> 1), this.rectItems[3].getCenterY() - (Resources.resImgsH[8] >> 1), 20);
        g.drawImage(Resources.resImgs[37], this.rectItems[2].getCenterX() - (Resources.resImgsW[37] + Resources.resSprsW[21] >> 1), this.rectItems[2].getCenterY() - (Resources.resImgsH[37] >> 1), 0);
        Resources.resSprs[21].setFrame(this.mc.selectedPack);
        Resources.resSprs[21].setPosition(this.rectItems[2].getCenterX() - (Resources.resImgsW[37] + Resources.resSprsW[21] >> 1) + Resources.resImgsW[37], this.rectItems[2].getCenterY() - (Resources.resSprsH[21] >> 1));
        Resources.resSprs[21].paint(g);
        this.mc.mainFont.drawString(g, this.starsCharArr, MainCanvas.WIDTH2 - (this.mc.mainFont.stringWidth(this.starsCharArr) + Resources.resImgsW[25] + MainCanvas.mainUIOffset >> 1) + Resources.resImgsW[25] + MainCanvas.mainUIOffset, this.rectItems[2].getCenterY() + (Resources.resImgsH[37] >> 1) + MainCanvas.mainUIOffset + (Resources.resImgsH[25] >> 1) - (this.mc.mainFont.getHeight() >> 1), 20);
        g.drawImage(Resources.resImgs[25], MainCanvas.WIDTH2 - (this.mc.mainFont.stringWidth(this.starsCharArr) + Resources.resImgsW[25] + MainCanvas.mainUIOffset >> 1) + Resources.resImgsW[25] + MainCanvas.mainUIOffset - MainCanvas.mainUIOffset - Resources.resImgsW[25], this.rectItems[2].getCenterY() + (Resources.resImgsH[37] >> 1) + MainCanvas.mainUIOffset, 0);
    }

    public void repaint() {
        this.mc.paint();
    }

    public void arrowVisibility() {
        if (this.mc.selectedPack == 0) {
            this.arrowLeft = false;
            this.arrowRight = true;
        } else if (this.mc.selectedPack == 2) {
            this.arrowLeft = true;
            this.arrowRight = false;
        } else {
            this.arrowLeft = true;
            this.arrowRight = true;
        }
    }

    public void keyPressed(int keyCode) {
    }

    public void keyReleased(int keyCode) {
        if (Keys.isActionGeneratedByKey(3, keyCode)) {
            this.selectPrevPack();
        } else if (Keys.isActionGeneratedByKey(4, keyCode)) {
            this.selectNextPack();
        } else if (Keys.isFKRight(keyCode)) {
            this.mc.setActiveScreen(3, null);
        } else if (Keys.isFKLeft(keyCode) || Keys.isActionGeneratedByKey(5, keyCode)) {
            this.mc.setActiveScreen(8, null);
        }
    }

    public void pointerPressed(int x, int y) {
        for (int i = 0; i < this.rectItems.length; ++i) {
            if (!this.rectItems[i].contains(x, y)) continue;
            this.holdingItemIndex = i;
        }
    }

    public void pointerDragged(int x, int y) {
    }

    public void pointerReleased(int x, int y) {
        this.allMissed = true;
        for (int i = 0; i < this.rectItems.length; ++i) {
            if (!this.rectItems[i].contains(x, y)) continue;
            if (this.holdingItemIndex != i) break;
            this.allMissed = false;
            break;
        }
        this.holdingItemIndex = -1;
        if (this.allMissed) {
            this.tr("all missed");
            return;
        }
        if (this.rectItems[0].contains(x, y)) {
            this.selectPrevPack();
        }
        if (this.rectItems[1].contains(x, y)) {
            this.selectNextPack();
        }
        if (this.rectItems[2].contains(x, y)) {
            this.mc.setActiveScreen(8, null);
        }
        if (this.rectItems[3].contains(x, y)) {
            this.mc.setActiveScreen(3, null);
        }
    }

    public void selectNextPack() {
        ++this.mc.selectedPack;
        if (this.mc.selectedPack > 2) {
            this.mc.selectedPack = 2;
        }
        this.packCharArr = ("" + (this.mc.selectedPack + 1)).toCharArray();
        this.starsCharArr = (this.mc.packStars[this.mc.selectedPack] + "/60").toCharArray();
    }

    public void selectPrevPack() {
        --this.mc.selectedPack;
        if (this.mc.selectedPack < 0) {
            this.mc.selectedPack = 0;
        }
        this.packCharArr = ("" + (this.mc.selectedPack + 1)).toCharArray();
        this.starsCharArr = (this.mc.packStars[this.mc.selectedPack] + "/60").toCharArray();
    }

    void tr(String s) {
        System.out.println(s);
    }
}

