/*
 * Decompiled with CFR 0.152.
 */
package CrazyLiquid.screen;

import CrazyLiquid.main.CrazyLiquid;
import CrazyLiquid.main.Global;
import CrazyLiquid.object.Button;
import CrazyLiquid.object.Number;
import java.io.IOException;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;

public class StartScreen
extends GameCanvas
implements Runnable {
    private Image bg;
    private Number number;
    private Number number2;
    private Button btnLike;
    private Button btnNew;
    private Button btnHelp;
    private Button btnAbout;
    private Button btnExit;
    private Button btnResume;
    private long sleepTime = 0L;
    private Thread runner;
    private boolean nextScreen;

    public StartScreen() throws IOException {
        super(false);
        this.setFullScreenMode(true);
        this.initComponents();
    }

    public void Reset() throws IOException {
        this.nextScreen = false;
        this.initComponents();
        System.gc();
    }

    private void initComponents() throws IOException {
        Button.Listener buttonListener = new Button.Listener(){

            public void onClick(Button b) {
                if (b == StartScreen.this.btnNew) {
                    StartScreen.this.nextScreen = true;
                    try {
                        CrazyLiquid.getInstance().showGame();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                    catch (InterruptedException ex) {
                        ex.printStackTrace();
                    }
                }
                if (b == StartScreen.this.btnResume) {
                    StartScreen.this.nextScreen = true;
                    try {
                        CrazyLiquid.getInstance().showGame();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                    catch (InterruptedException ex) {
                        ex.printStackTrace();
                    }
                }
                if (b == StartScreen.this.btnHelp) {
                    StartScreen.this.nextScreen = true;
                    try {
                        CrazyLiquid.getInstance().showHelp();
                    }
                    catch (InterruptedException ex) {
                        ex.printStackTrace();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
                if (b == StartScreen.this.btnAbout) {
                    StartScreen.this.nextScreen = true;
                    try {
                        CrazyLiquid.getInstance().showAbout();
                    }
                    catch (InterruptedException ex) {
                        ex.printStackTrace();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
                if (b == StartScreen.this.btnLike) {
                    try {
                        CrazyLiquid.getInstance().platformRequest("http://store.ovi.mobi/content/397159/comments/add");
                    }
                    catch (ConnectionNotFoundException ex) {
                        ex.printStackTrace();
                    }
                }
                if (b == StartScreen.this.btnExit) {
                    StartScreen.this.nextScreen = true;
                    CrazyLiquid.getInstance().exitMIDlet();
                }
            }
        };
        this.bg = Image.createImage((String)"/img/BG/menubg.png");
        this.number = new Number(Image.createImage((String)"/img/sprite/numberframe.png"), Global.NUMBER_W, Global.NUMBER_H);
        this.number.X = 124;
        this.number.Y = 320;
        this.number2 = new Number(Image.createImage((String)"/img/sprite/numlevelframe.png"), Global.COMBONUMBER_W, Global.COMBONUMBER_H);
        this.number2.X = 148;
        this.number2.Y = 325;
        this.btnLike = new Button(Image.createImage((String)"/img/buttons/like.png"), Global.SMALLBTN_W, Global.SMALLBTN_H, buttonListener);
        this.btnLike.X = 89;
        this.btnLike.Y = 30;
        this.btnNew = new Button(Image.createImage((String)"/img/buttons/playnow.png"), Global.BTN_W, Global.BTN_H, buttonListener);
        this.btnNew.X = 120;
        this.btnNew.Y = 127;
        this.btnResume = new Button(Image.createImage((String)"/img/buttons/resume.png"), Global.BTN_W, Global.BTN_H, buttonListener);
        this.btnResume.X = 120;
        this.btnResume.Y = 127;
        this.btnHelp = new Button(Image.createImage((String)"/img/buttons/help.png"), Global.BTN_W, Global.BTN_H, buttonListener);
        this.btnHelp.X = 70;
        this.btnHelp.Y = 127;
        this.btnAbout = new Button(Image.createImage((String)"/img/buttons/about.png"), Global.BTN_W, Global.BTN_H, buttonListener);
        this.btnAbout.X = 20;
        this.btnAbout.Y = 127;
        this.btnExit = new Button(Image.createImage((String)"/img/buttons/quit.png"), Global.SMALLBTN_W, Global.SMALLBTN_H, buttonListener);
        this.btnExit.X = 10;
        this.btnExit.Y = 330;
    }

    public void start() throws InterruptedException {
        if (this.runner == null) {
            this.runner = new Thread(this);
        }
        if (!this.runner.isAlive()) {
            this.runner.start();
        }
    }

    public void stop() {
        this.runner = null;
    }

    public void run() {
        while (!this.nextScreen) {
            this.updateScreen(this.getGraphics());
            try {
                Thread.sleep(this.sleepTime);
            }
            catch (Exception exception) {}
        }
        this.stop();
    }

    public void updateScreen(Graphics g) {
        if (Global.isPlaying) {
            this.btnNew.isVisible = false;
            this.btnResume.isVisible = true;
        } else {
            this.btnResume.isVisible = false;
            this.btnNew.isVisible = true;
        }
        this.render(g);
        this.flushGraphics();
    }

    protected void render(Graphics g) {
        g.drawImage(this.bg, 0, 0, 0);
        this.btnLike.render(g);
        this.btnNew.render(g);
        this.btnResume.render(g);
        this.btnHelp.render(g);
        this.btnAbout.render(g);
        this.btnExit.render(g);
        if (Global.BestDrop < 100) {
            this.number.render2(Global.BestDrop, g);
        } else {
            this.number.Y = 310;
            this.number.render3(Global.BestDrop, g);
        }
        if (Global.BestLevel < 10) {
            this.number2.render1(Global.BestLevel, g);
        } else if (Global.BestLevel >= 10 && Global.BestLevel < 100) {
            this.number2.render2(Global.BestLevel, g);
        } else {
            this.number2.render3(Global.BestLevel, g);
        }
    }

    protected void pointerPressed(int x, int y) {
        this.btnLike.TouchEvent(Global.POINTER_PRESS, x, y);
        this.btnNew.TouchEvent(Global.POINTER_PRESS, x, y);
        this.btnResume.TouchEvent(Global.POINTER_PRESS, x, y);
        this.btnHelp.TouchEvent(Global.POINTER_PRESS, x, y);
        this.btnAbout.TouchEvent(Global.POINTER_PRESS, x, y);
        this.btnExit.TouchEvent(Global.POINTER_PRESS, x, y);
    }

    protected void pointerReleased(int x, int y) {
        this.btnLike.TouchEvent(Global.POINTER_RELEASE, x, y);
        this.btnNew.TouchEvent(Global.POINTER_RELEASE, x, y);
        this.btnResume.TouchEvent(Global.POINTER_RELEASE, x, y);
        this.btnHelp.TouchEvent(Global.POINTER_RELEASE, x, y);
        this.btnAbout.TouchEvent(Global.POINTER_RELEASE, x, y);
        this.btnExit.TouchEvent(Global.POINTER_RELEASE, x, y);
    }

    protected void pointerDragged(int x, int y) {
        this.btnLike.TouchEvent(Global.POINTER_DRAGGED, x, y);
        this.btnNew.TouchEvent(Global.POINTER_DRAGGED, x, y);
        this.btnResume.TouchEvent(Global.POINTER_DRAGGED, x, y);
        this.btnHelp.TouchEvent(Global.POINTER_DRAGGED, x, y);
        this.btnAbout.TouchEvent(Global.POINTER_DRAGGED, x, y);
        this.btnExit.TouchEvent(Global.POINTER_DRAGGED, x, y);
    }
}

