/*
 * Decompiled with CFR 0.152.
 */
package com.pim;

import com.pim.ImageLoader;
import com.pim.Rectangle;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Button {
    private final Image pressedImg;
    private final Image unpressedImg;
    private final Image disabledImg;
    private Rectangle boundingBox;
    private boolean pressed = false;
    private boolean enabled = true;
    private boolean selectable = false;
    private boolean selected = false;
    private final Listener listener;

    public Button(String unpressed_image_url, String pressed_image_url, String disabled_image_url, Listener listener) {
        this.listener = listener;
        this.unpressedImg = ImageLoader.loadImage(unpressed_image_url);
        this.pressedImg = ImageLoader.loadImage(pressed_image_url);
        this.disabledImg = ImageLoader.loadImage(disabled_image_url);
        this.boundingBox = new Rectangle(0, 0, this.unpressedImg.getWidth(), this.unpressedImg.getHeight());
    }

    public void paint(Graphics g) {
        if (!this.enabled) {
            g.drawImage(this.disabledImg, this.boundingBox.getX(), this.boundingBox.getY(), 20);
        } else if (this.pressed || this.selected) {
            g.drawImage(this.pressedImg, this.boundingBox.getX(), this.boundingBox.getY(), 20);
        } else {
            g.drawImage(this.unpressedImg, this.boundingBox.getX(), this.boundingBox.getY(), 20);
        }
    }

    public void setPosition(int x, int y) {
        this.boundingBox.setX(x);
        this.boundingBox.setY(y);
    }

    public void pointerPressed(int x, int y) {
        if (!this.enabled) {
            return;
        }
        this.pressed = this.contains(x, y);
    }

    public void pointerDragged(int x, int y) {
        this.pointerPressed(x, y);
    }

    public void pointerReleased(int x, int y) {
        if (!this.enabled) {
            return;
        }
        if (this.pressed && this.contains(x, y)) {
            if (this.selectable) {
                this.selected = !this.selected;
            }
            this.listener.clicked(this);
        }
        this.pressed = false;
    }

    public boolean contains(int x, int y) {
        return this.boundingBox.contains(x, y);
    }

    public int getWidth() {
        return this.boundingBox.getWidth();
    }

    public int getHeight() {
        return this.boundingBox.getHeight();
    }

    public void enable() {
        this.enabled = true;
    }

    public void disable() {
        this.enabled = false;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getX() {
        return this.boundingBox.getX();
    }

    public void setX(int x) {
        this.boundingBox.setX(x);
    }

    public int getY() {
        return this.boundingBox.getY();
    }

    public void setY(int y) {
        this.boundingBox.setY(y);
    }

    public boolean isSelectable() {
        return this.selectable;
    }

    public void setSelectable(boolean selectable) {
        this.selectable = selectable;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void select() {
        this.selectable = true;
        this.selected = true;
    }

    public void deslect() {
        this.selected = false;
    }

    protected boolean isPressed() {
        return this.pressed;
    }

    protected void setPressed(boolean pressed) {
        this.pressed = pressed;
    }

    protected Image getDisabledImage() {
        return this.disabledImg;
    }

    protected Image getPressedImage() {
        return this.pressedImg;
    }

    protected Image getUnpressedImage() {
        return this.unpressedImg;
    }

    public static interface Listener {
        public void clicked(Button var1);
    }
}

