/*
 * Decompiled with CFR 0.152.
 */
package com.pim.model;

import com.pim.model.MarbleModel;
import com.pim.model.Maze;

public class GameModel {
    private static final int POSITION_TOLERANCE = 10;
    public static final int MAZE_CORRIDOR_COUNT = 10;
    public static final float MAZE_SIDE_LENGTH = 200.0f;
    public static final float WALL_HEIGHT = 10.0f;
    public static final float DEFAULT_STEP_LENGTH_PER_AXIS = 3.0f;
    public static final float DEFAULT_STEP_LENGTH = 9.0f;
    private static GameModel _instance = null;
    private Maze _maze = new Maze(10, 200.0f, 10.0f);
    private final MarbleModel _marble = new MarbleModel();
    private boolean _goalReached = false;

    public static GameModel instance() {
        if (_instance == null) {
            _instance = new GameModel();
        }
        return _instance;
    }

    private GameModel() {
        this._marble.setPosition(0.0f, 23.0f, 0.0f);
    }

    public final Maze maze() {
        return this._maze;
    }

    public final MarbleModel marble() {
        return this._marble;
    }

    public void setGoalReached(boolean goalReached) {
        this._goalReached = goalReached;
    }

    public final boolean goalReached() {
        return this._goalReached;
    }

    public final boolean isAtEnd() {
        float[] position = this._marble.position();
        return this._maze.isAtTheEnd(position[0], position[2], 10.0f);
    }
}

