/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.core.ApplicationData;
import baltorogames.core.MathExt;
import baltorogames.core.RandSync;
import baltorogames.core.VectorF2;
import baltorogames.core_gui.UIScreen;
import baltorogames.graphic2d.TextureManager;
import baltorogames.particles.CGDynamicObj;
import baltorogames.project_gameplay.BoardListener;
import baltorogames.project_gameplay.CGAchievements;
import baltorogames.project_gameplay.CGBallCannon;
import baltorogames.project_gameplay.CGBoard;
import baltorogames.project_gameplay.CGEngineRenderer;
import baltorogames.project_gameplay.CGFallingBall;
import baltorogames.project_gameplay.CGHit;
import baltorogames.project_gameplay.CGLevelStats;
import baltorogames.project_gameplay.DeadLine;
import baltorogames.project_gameplay.LevelScenario;
import baltorogames.project_gameplay.LevelScenarioSurvivalManager;
import baltorogames.project_gameplay.MyGame;
import baltorogames.project_gameplay.SurvivalTimeBar;
import baltorogames.project_gameplay.WorldObject;
import baltorogames.project_gui.LevelLostScreen;
import baltorogames.project_gui.LevelWinScreen;
import baltorogames.project_gui.SurvivalLevelLostScreen;
import baltorogames.system.FileManager;
import java.io.DataInputStream;
import java.io.InputStream;

public class CGEngine {
    public static int m_nCurrentGalaxy = 1;
    public static int m_nCurrentLevel = 1;
    public static int m_nSurvivalLevel = -1;
    public static final int eGameMode_Story = 1;
    public static final int eGameMode_Survival = 2;
    public static final int eGameMode_Timed = 3;
    public static final int eGameMode_Zen = 4;
    public static int m_nGameMode = 2;
    public static boolean m_bGameOver;
    public static int m_nGameOverDelay;
    public static int m_nGameResult;
    public static CGBallCannon m_BallCannon;
    public static CGBoard m_Board;
    public static int m_nParams_CurrentLevelInitScore;
    public static int m_nParams_CurrentLevelInitTime;
    public static float m_fEngineScale;
    public static boolean m_bPause;
    public static WorldObject m_MenObject;
    public static WorldObject m_ChickenObject;
    public static WorldObject m_BallObject;
    protected static int m_nUpdateDeltaTime;
    public static boolean m_bEngineChangeAxis;
    public static boolean m_bWaitForHit;
    public static float m_fWaitHitDX;
    public static float m_fWaitHitDY;
    public static LevelScenarioSurvivalManager m_LevelScenarioSurvivalManager;
    public static SurvivalTimeBar m_SurvivalTimeBar;
    public static DeadLine m_DeadLine;

    public static boolean IsEndlessMode() {
        return m_nSurvivalLevel >= 0;
    }

    public static boolean IsSurvival() {
        return m_nGameMode == 2;
    }

    public static boolean IsTimed() {
        return m_nGameMode == 3;
    }

    public static boolean IsZen() {
        return m_nGameMode == 4;
    }

    public static void IncCurrentLevel() {
        if (m_nCurrentLevel < 15) {
            ++m_nCurrentLevel;
        } else {
            ++m_nCurrentGalaxy;
            m_nCurrentLevel = 1;
        }
    }

    public static void InitParams() {
    }

    public static String importString(DataInputStream dis) {
        try {
            int nL = dis.readInt();
            char[] szTextureName = new char[nL];
            for (int j = 0; j < nL; ++j) {
                char b;
                szTextureName[j] = b = (char)dis.readByte();
            }
            return new String(szTextureName);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void ReadDefaultLevelStats(int nGalaxy, int nLevel, VectorF2 out) {
        try {
            out.x = 0.0f;
            out.y = 0.0f;
            InputStream is = FileManager.OpenFile("/map_" + nGalaxy + "_1.lrs");
            if (is == null) {
                is = FileManager.OpenURLFile("/map_" + nGalaxy + "_" + nLevel + ".lrs");
            }
            if (is == null) {
                return;
            }
            DataInputStream dis0 = new DataInputStream(is);
            int nLength = 0;
            while (true) {
                int nSize = dis0.available();
                nLength += nSize;
                if (nSize == 0) break;
                dis0.skip(nSize);
            }
            is = FileManager.OpenFile("/map_" + nGalaxy + "_" + nLevel + ".lrs");
            if (is == null) {
                is = FileManager.OpenURLFile("/map_" + nGalaxy + "_" + nLevel + ".lrs");
            }
            if (is == null) {
                return;
            }
            DataInputStream dis = new DataInputStream(is);
            dis.skip(nLength - 8);
            int nV1 = dis.readInt();
            int nV2 = dis.readInt();
            out.x = nV1;
            out.y = nV2;
        }
        catch (Exception e2) {
            System.out.println("Error in ReadDefaultLevelStats method.");
            e2.printStackTrace();
            return;
        }
    }

    public static void Load1(DataInputStream dis) {
        CGEngine.Destroy();
        m_bEngineChangeAxis = false;
        try {
            int nScreenX = 480;
            int nScreenY = 800;
            float fScaleX = (float)ApplicationData.screenWidth / (float)nScreenX;
            float fScaleY = (float)ApplicationData.screenHeight / (float)nScreenY;
            m_fEngineScale = fScaleX < fScaleY ? fScaleX : fScaleY;
            m_fEngineScale = 0.255f;
            CGEngineRenderer.m_fScreenOffsetX = ((float)ApplicationData.screenWidth - m_fEngineScale * (float)nScreenX) / 2.0f;
            CGEngineRenderer.m_fScreenOffsetY = ((float)ApplicationData.screenHeight - m_fEngineScale * (float)nScreenY) / 2.0f;
            if (m_bEngineChangeAxis) {
                CGEngineRenderer.m_fScreenOffsetX = ((float)ApplicationData.screenWidth - m_fEngineScale * (float)nScreenY) / 2.0f;
                CGEngineRenderer.m_fScreenOffsetY = ((float)ApplicationData.screenHeight - m_fEngineScale * (float)nScreenX) / 2.0f;
            }
        }
        catch (Exception e) {
            return;
        }
    }

    public static void Load2(DataInputStream dis) {
        m_BallCannon = new CGBallCannon();
        m_BallCannon.SetPosition(240.0f, 700.0f);
        m_BallCannon.PrepareNew();
        m_BallCannon.ActualizeSpaceShip();
        m_bGameOver = false;
        m_bPause = false;
        if (m_nSurvivalLevel < 0) {
            m_LevelScenarioSurvivalManager = null;
            m_SurvivalTimeBar = null;
            LevelScenario ls = new LevelScenario();
            String fileName = "/map_" + m_nCurrentGalaxy + "_" + m_nCurrentLevel + ".txt";
            ls.Load(fileName);
            m_Board = new CGBoard(10, 15, new BoardListener(), ls);
        } else {
            m_LevelScenarioSurvivalManager = new LevelScenarioSurvivalManager(m_nGameMode);
            LevelScenario ls = (LevelScenario)CGEngine.m_LevelScenarioSurvivalManager.m_Vector.elementAt(RandSync.nextInt() % LevelScenarioSurvivalManager.eSize);
            ls.m_nOffset = ls.m_nRowSize - 1;
            m_Board = new CGBoard(10, 15, new BoardListener(), ls);
            m_SurvivalTimeBar = new SurvivalTimeBar();
            m_SurvivalTimeBar.Start();
        }
        CGLevelStats.Reset();
        CGHit.Reset();
        CGEngineRenderer.m_boundaries[CGEngine.m_nCurrentGalaxy - 1][0] = TextureManager.AddTexture("/gameplay/border" + m_nCurrentGalaxy + "_left.png");
        CGEngineRenderer.m_boundaries[CGEngine.m_nCurrentGalaxy - 1][1] = TextureManager.AddTexture("/gameplay/border" + m_nCurrentGalaxy + "_right.png");
        CGEngineRenderer.m_boundaries[CGEngine.m_nCurrentGalaxy - 1][2] = TextureManager.AddTexture("/gameplay/border" + m_nCurrentGalaxy + "_top.png");
        m_MenObject = ((MyGame)ApplicationData.game).m_WorldMap.FindObjectByCollisionID(1);
        if (m_MenObject != null) {
            CGEngine.m_MenObject.m_nStayOnLastFrame = 0;
            CGEngine.m_MenObject.m_nStartTime = -1;
        }
        if ((m_ChickenObject = ((MyGame)ApplicationData.game).m_WorldMap.FindObjectByCollisionID(2)) != null) {
            CGEngine.m_ChickenObject.m_nStayOnLastFrame = 0;
            CGEngine.m_ChickenObject.m_nStartTime = -1;
        }
        if ((m_BallObject = ((MyGame)ApplicationData.game).m_WorldMap.FindObjectByCollisionID(3)) != null) {
            CGEngine.m_BallObject.m_bVisible = false;
        }
        m_bWaitForHit = false;
    }

    public static int Init() {
        return 1;
    }

    public static void Destroy() {
        if (m_BallCannon != null) {
            m_BallCannon.Destroy();
        }
        m_BallCannon = null;
        m_Board = null;
    }

    public static void Update(int nDeltaTimeInMs) {
        m_nUpdateDeltaTime = nDeltaTimeInMs;
        if (m_nSurvivalLevel >= 0) {
            CGAchievements.AddSurvivalTime(nDeltaTimeInMs);
        }
        m_DeadLine.Update(nDeltaTimeInMs);
        if (nDeltaTimeInMs <= 30) {
            CGEngine.UpdateInternal(nDeltaTimeInMs);
        } else {
            int nT = 0;
            for (nT = 30; nT < nDeltaTimeInMs; nT += 30) {
                CGEngine.UpdateInternal(30);
            }
            nT = nDeltaTimeInMs % 30;
            if (nT > 0) {
                CGEngine.UpdateInternal(nT);
            }
        }
    }

    public static void UpdateInternal(int nDeltaTimeInMs) {
        if (m_bPause) {
            return;
        }
        m_Board.Update(nDeltaTimeInMs);
        if (m_BallCannon != null) {
            m_BallCannon.Update(nDeltaTimeInMs);
        }
        CGFallingBall.UpdateAll(nDeltaTimeInMs);
        CGHit.StepAll(nDeltaTimeInMs);
        if (CGEngine.m_Board.m_nTimeToCheck == -1) {
            int numRows = m_Board.getNumRows();
            if (numRows < 5) {
                m_DeadLine.SetLineType(-1);
            } else if (numRows < 7) {
                m_DeadLine.SetLineType(0);
            } else if (numRows < 8) {
                m_DeadLine.SetLineType(1);
            } else if (numRows < 9) {
                m_DeadLine.SetLineType(2);
            } else {
                m_DeadLine.SetLineType(3);
            }
        }
        CGLevelStats.m_nTimeStatsInMs += nDeltaTimeInMs;
        CGLevelStats.m_nTimeInMs -= nDeltaTimeInMs;
        if (m_bWaitForHit && m_ChickenObject != null && CGEngine.m_ChickenObject.m_nStartTime < 0) {
            CGEngine.GetBallCannon().SetTarget(m_fWaitHitDX, m_fWaitHitDY);
            if (m_MenObject != null) {
                CGEngine.m_MenObject.m_nStartTime = 0;
            }
            m_bWaitForHit = false;
        }
        if (!m_bGameOver) {
            if (!CGEngine.IsEndlessMode()) {
                int result = m_Board.checkGameIsOver();
                if (result < 0) {
                    CGEngine.EventLost(true);
                } else if (result > 0) {
                    CGEngine.EventWin();
                }
            } else if (CGEngine.IsSurvival()) {
                if (m_SurvivalTimeBar != null) {
                    m_SurvivalTimeBar.Update(nDeltaTimeInMs);
                    if (m_SurvivalTimeBar.IsOver() || m_Board.checkGameIsOver() < 0) {
                        CGEngine.EventLost(true);
                    }
                }
            } else if (CGEngine.IsTimed()) {
                if (CGLevelStats.m_nTimeInMs <= 0 || m_Board.checkGameIsOver() < 0) {
                    CGEngine.EventLost(true);
                }
            } else if (CGEngine.IsZen() && m_Board.checkGameIsOver() < 0) {
                CGEngine.EventLost(true);
            }
        } else if (m_nGameOverDelay > 0 && (m_nGameOverDelay -= nDeltaTimeInMs) <= 0) {
            m_nGameOverDelay = 0;
            if (m_nGameResult < 0) {
                if (m_nSurvivalLevel < 0) {
                    UIScreen.SetCurrentScreen(new LevelLostScreen());
                } else {
                    UIScreen.SetCurrentScreen(new SurvivalLevelLostScreen());
                }
            } else {
                UIScreen.SetCurrentScreen(new LevelWinScreen());
            }
        }
    }

    public static void Render() {
        CGEngine.RenderCannon();
        CGEngineRenderer.RenderBoundaries();
        m_Board.Render();
        CGFallingBall.RenderAll();
        CGDynamicObj.StepCurrentDynamics(m_nUpdateDeltaTime);
        CGHit.RenderAll();
    }

    public static void EventWin() {
        if (!m_bGameOver) {
            m_bGameOver = true;
            m_nGameOverDelay = 2000;
            m_nGameResult = 1;
        }
    }

    public static void EventLost(boolean bPlaySound) {
        if (!m_bGameOver) {
            m_bGameOver = true;
            m_nGameOverDelay = 2000;
            m_nGameResult = -1;
            if (bPlaySound) {
                // empty if block
            }
        }
    }

    public static float AngleFromVector(float dx, float dy) {
        if (dx == 0.0f && dy == 0.0f) {
            return -3000.0f;
        }
        float vec1_X = 0.0f;
        float vec1_Y = -1.0f;
        float fLength = dx * dx + dy * dy;
        if (fLength <= 1.0E-6f) {
            return -3000.0f;
        }
        fLength = (float)Math.sqrt(fLength);
        float vec2_X = dx / fLength;
        float vec2_Y = dy / fLength;
        float fCos = vec1_X * vec2_X + vec1_Y * vec2_Y;
        float fAngle = (float)MathExt.acos(fCos);
        fAngle *= 57.29579f;
        if (dx < 0.0f) {
            fAngle = 360.0f - fAngle;
        }
        if (fAngle < 0.0f) {
            fAngle += 360.0f;
        }
        return fAngle;
    }

    public static CGBallCannon GetBallCannon() {
        return m_BallCannon;
    }

    public static void RenderCannon() {
        CGEngineRenderer.RenderCannon();
    }

    static {
        m_nGameResult = 0;
        m_nParams_CurrentLevelInitScore = 0;
        m_nParams_CurrentLevelInitTime = 0;
        m_fEngineScale = 1.0f;
        m_bPause = false;
        m_MenObject = null;
        m_ChickenObject = null;
        m_BallObject = null;
        m_nUpdateDeltaTime = 0;
        m_bEngineChangeAxis = true;
        m_bWaitForHit = false;
        m_fWaitHitDX = 0.0f;
        m_fWaitHitDY = 0.0f;
        m_LevelScenarioSurvivalManager = null;
        m_SurvivalTimeBar = null;
        m_DeadLine = new DeadLine();
    }
}

