/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.project_gameplay.AchievementPopup;
import baltorogames.project_gameplay.CGEngine;
import baltorogames.project_gameplay.CGUserCareer;
import baltorogames.system.BGStore;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class CGAchievements {
    public static final int eAchievements_LevelComplete = 0;
    public static final int eAchievements_NoLostBall = 1;
    public static final int eAchievements_ComboX5 = 2;
    public static final int eAchievements_ComboX10 = 3;
    public static final int eAchievements_100Combos = 4;
    public static final int eAchievements_200Combos = 5;
    public static final int eAchievements_500Combos = 6;
    public static final int eAchievements_1000Combos = 7;
    public static final int eAchievements_Stage1Completed = 9;
    public static final int eAchievements_Stage2Completed = 9;
    public static final int eAchievements_Stage3Completed = 10;
    public static final int eAchievements_Survi1Hour = 11;
    public static final int eAchievements_Survi4Hour = 12;
    public static final int eAchievements_Survi8Hour = 13;
    public static final int eMaxAchievements = 14;
    protected static boolean[] arrAchievementsCompleted = new boolean[14];
    public static int m_nSurvivalTimeInMs;
    public static int m_nCombosNr;
    public static int m_nChainsNr;
    public static int m_nMaxCombo;
    public static int m_nMaxChain;
    protected static boolean m_bLoaded;

    public static void Reset() {
        for (int i = 0; i < 14; ++i) {
            CGAchievements.arrAchievementsCompleted[i] = false;
        }
        m_nSurvivalTimeInMs = 0;
        m_nCombosNr = 0;
        m_nChainsNr = 0;
        m_nMaxCombo = 0;
        m_nMaxChain = 0;
    }

    public static void completeAchievement(int nIndex) {
        if (!arrAchievementsCompleted[nIndex]) {
            CGAchievements.arrAchievementsCompleted[nIndex] = true;
            AchievementPopup.NewAchievement(nIndex);
        }
    }

    public static boolean isAchievementCompleted(int nIndex) {
        return arrAchievementsCompleted[nIndex];
    }

    public static void Load() {
        BGStore store = BGStore.openStoreToRead("Achievements");
        if (store == null) {
            System.out.println("No Achievements store!!!!!!!!!!!!!!!!!!!!!!!");
            m_bLoaded = true;
            return;
        }
        try {
            DataInputStream inputStream = store.getInStream();
            if (inputStream != null && inputStream.available() > 0) {
                for (int i = 0; i < 14; ++i) {
                    CGAchievements.arrAchievementsCompleted[i] = inputStream.readBoolean();
                }
                m_nSurvivalTimeInMs = inputStream.readInt();
                m_nCombosNr = inputStream.readInt();
                m_nChainsNr = inputStream.readInt();
                m_nMaxCombo = inputStream.readInt();
                m_nMaxChain = inputStream.readInt();
            }
            store.close();
            m_bLoaded = true;
        }
        catch (Exception e) {
            CGAchievements.Reset();
            m_bLoaded = true;
            return;
        }
    }

    public static void Save() {
        if (!m_bLoaded) {
            System.out.println("No Achievements loaded!!!!!!!!!!!!!!!!!!!!!!!");
            return;
        }
        BGStore store = BGStore.openStoreToWrite("Achievements");
        if (store == null) {
            return;
        }
        try {
            DataOutputStream outputStream = store.getOutStream();
            for (int i = 0; i < 14; ++i) {
                outputStream.writeBoolean(arrAchievementsCompleted[i]);
            }
            outputStream.writeInt(m_nSurvivalTimeInMs);
            outputStream.writeInt(m_nCombosNr);
            outputStream.writeInt(m_nChainsNr);
            outputStream.writeInt(m_nMaxCombo);
            outputStream.writeInt(m_nMaxChain);
            store.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void AddCombo() {
        if (CGEngine.m_nSurvivalLevel >= 0) {
            return;
        }
        if (++m_nCombosNr == 100) {
            CGAchievements.completeAchievement(4);
        } else if (m_nCombosNr == 200) {
            CGAchievements.completeAchievement(5);
        } else if (m_nCombosNr == 500) {
            CGAchievements.completeAchievement(6);
        } else if (m_nCombosNr == 1000) {
            CGAchievements.completeAchievement(7);
        }
    }

    public static void AddSurvivalTime(int nDeltaTimeInMs) {
        m_nSurvivalTimeInMs += nDeltaTimeInMs;
        if (!arrAchievementsCompleted[13]) {
            if (m_nSurvivalTimeInMs >= 28800000) {
                CGAchievements.completeAchievement(13);
            } else if (!arrAchievementsCompleted[12]) {
                if (m_nSurvivalTimeInMs >= 14400000) {
                    CGAchievements.completeAchievement(12);
                } else if (!arrAchievementsCompleted[11] && m_nSurvivalTimeInMs >= 3600000) {
                    CGAchievements.completeAchievement(11);
                }
            }
        }
    }

    public static void CheckBeatAllLevelsScore() {
        for (int i = 0; i < 45; ++i) {
            if (CGUserCareer.arrLevelStats[i].m_nScore >= CGUserCareer.arrLevelStats[i].m_nDefaultScore) continue;
            return;
        }
    }

    public static void CheckBeatAllLevelsTime() {
        for (int i = 0; i < 45; ++i) {
            if (CGUserCareer.arrLevelStats[i].m_nTime < CGUserCareer.arrLevelStats[i].m_nDefaultTime) continue;
            return;
        }
    }

    public static void CheckGalaxy1Completed() {
        if (CGUserCareer.IsEnvironmentAvailable(1)) {
            CGAchievements.completeAchievement(9);
        }
    }

    public static void CheckGalaxy2Completed() {
        if (CGUserCareer.IsEnvironmentAvailable(2)) {
            CGAchievements.completeAchievement(9);
        }
    }

    public static void CheckGalaxy3Completed() {
        if (CGUserCareer.IsEnvironmentCompleted(2)) {
            CGAchievements.completeAchievement(10);
        }
    }

    public static void CheckAdventureCompleted() {
    }

    public static void SetMaxCombo(int n) {
        if (CGEngine.m_nSurvivalLevel >= 0) {
            return;
        }
        if (m_nMaxCombo < n) {
            m_nMaxCombo = n;
        }
    }

    public static void SetMaxChain(int n) {
        if (CGEngine.m_nSurvivalLevel >= 0) {
            return;
        }
        if (m_nMaxChain < n) {
            m_nMaxChain = n;
        }
    }

    static {
        m_bLoaded = false;
    }
}

