/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.core;

import baltorogames.core.ApplicationData;
import baltorogames.core.MsgManager;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.project_gui.DebugConsole;
import baltorogames.system.MainCanvas;
import baltorogames.system.Platform;

public class AppCanvas
extends MainCanvas {
    public static final int[] qwerty_UP = new int[]{81, 113, 87, 119, 69, 101, 82, 114, 84, 116, 89, 121, 85, 117, 73, 105, 79, 111, 80, 112};
    public static final int[] qwerty_DOWN = new int[]{90, 122, 88, 120, 67, 99, 86, 118, 66, 98, 78, 110, 77, 109, 44, 46};
    public static final int[] qwerty_LEFT = new int[]{65, 97, 83, 115, 68, 100, 70, 102};
    public static final int[] qwerty_RIGHT = new int[]{72, 104, 74, 106, 75, 107, 76, 108};

    public AppCanvas() {
        ApplicationData.screenHeight = super.GetHeight();
        ApplicationData.screenWidth = super.GetWidth();
        Graphic2D.SetDrawContext(super.GetGraphics());
    }

    public void keyReleasedInGame(int keyCode) {
        if (keyCode == 116 || keyCode == 84) {
            this.isUpPressed = false;
            MsgManager.onKey(1, false);
        } else if (keyCode == 102 || keyCode == 70) {
            this.isLeftPressed = false;
            MsgManager.onKey(2, false);
        } else if (keyCode == 104 || keyCode == 72) {
            this.isRightPressed = false;
            MsgManager.onKey(5, false);
        } else if (keyCode == 118 || keyCode == 86) {
            this.isDownPressed = false;
            MsgManager.onKey(6, false);
        } else if (this.getGameAction(keyCode) == 8) {
            MsgManager.onKey(keyCode, false);
        }
    }

    public void keyPressedInGame(int keyCode) {
        if (keyCode == 116 || keyCode == 84) {
            this.isUpPressed = true;
            MsgManager.onKey(1, true);
        } else {
            if (keyCode == 102 || keyCode == 70) {
                this.isLeftPressed = true;
                return;
            }
            if (keyCode == 104 || keyCode == 72) {
                this.isRightPressed = true;
                return;
            }
            if (keyCode == 118 || keyCode == 86) {
                this.isDownPressed = true;
                MsgManager.onKey(6, true);
            } else if (keyCode == 103 || keyCode == 71) {
                MsgManager.onKey(8, true);
            } else if (this.getGameAction(keyCode) == 8) {
                MsgManager.onKey(8, true);
            }
        }
    }

    public void keyReleased(int keyCode) {
        if (!ApplicationData.checkIsLandscape()) {
            if (keyCode == ApplicationData.SoftButton1_Code || keyCode == ApplicationData.SoftButton2_Code) {
                MsgManager.onKey(keyCode, false);
            } else if (keyCode == Platform.KEY_KILL_ALL || keyCode == Platform.KEY_SLOW_DOWN || keyCode == Platform.KEY_TIME_WARP) {
                MsgManager.onKey(keyCode, false);
            } else {
                MsgManager.onKey(this.getGameAction(keyCode), false);
            }
        }
    }

    public void keyPressed(int keyCode) {
        if (!ApplicationData.checkIsLandscape()) {
            if (keyCode == ApplicationData.SoftButton1_Code || keyCode == ApplicationData.SoftButton2_Code) {
                MsgManager.onKey(keyCode, true);
            } else if (keyCode == Platform.KEY_KILL_ALL || keyCode == Platform.KEY_SLOW_DOWN || keyCode == Platform.KEY_TIME_WARP) {
                MsgManager.onKey(keyCode, true);
            } else {
                MsgManager.onKey(this.getGameAction(keyCode), true);
            }
            DebugConsole.trackDebugCommand(keyCode);
        }
    }

    protected void pointerPressed(int x, int y) {
        if (!ApplicationData.checkIsLandscape()) {
            MsgManager.onTouch(x, y, true);
        }
    }

    protected void pointerDragged(int x, int y) {
    }

    protected void pointerReleased(int x, int y) {
        if (!ApplicationData.checkIsLandscape()) {
            MsgManager.onTouch(x, y, false);
        }
    }
}

