/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gui;

import baltorogames.core.ApplicationData;
import baltorogames.core_gui.UIScreen;
import baltorogames.project_gui.AbortApplicationTB;
import baltorogames.project_gui.AchievementsScreen;
import baltorogames.project_gui.AskForGetMoreGames;
import baltorogames.project_gui.MainListAnimated;
import baltorogames.project_gui.NewYesNoDialogScreen;
import baltorogames.project_gui.NotInDemoVersion;
import baltorogames.project_gui.SelectGalaxy;
import baltorogames.project_gui.SelectSurvivalLevel;
import baltorogames.system.ObjectsCache;
import baltorogames.system.Options;

public class MainMenu
extends MainListAnimated {
    public static int selectedGameMode;
    boolean isBTAvailable = false;
    private int FREE_TRIAL_ID = -1;
    private int UPSELL_ID = -1;
    private int QUICK_START_ID = -10;
    private int ACHIEVEMENTS_ID = -12;
    private int ADVENTURE_ID = 0;
    private int SURVIVAL_ID = 1;
    private int TIMED_ID = 2;
    private int ZEN_ID = 3;
    private int MORE_ID = 4;
    private int QUIT_ID = 5;

    public MainMenu() {
        if (ApplicationData.demoEnabled) {
            this.append(ApplicationData.lp.getTranslatedString(Options.languageID, "ID_DEMO_VERSION"));
            this.updateIDsForDemo();
        }
        this.append(ApplicationData.lp.getTranslatedString(Options.languageID, ApplicationData.demoEnabled ? "ID_TRIAL_INFO_HEADER" : "TID_ADVENTURE"));
        if (ApplicationData.upSellEnabled) {
            this.append(ApplicationData.lp.getTranslatedString(Options.languageID, "ID_UPSELL_GAME"), true);
            this.updateIDsForUpSell();
        }
        this.append(ApplicationData.lp.getTranslatedString(Options.languageID, "TID_SURVIVAL"));
        this.append(ApplicationData.lp.getTranslatedString(Options.languageID, "TID_TIMED"));
        this.append(ApplicationData.lp.getTranslatedString(Options.languageID, "TID_ZEN"));
        this.append(ApplicationData.lp.getTranslatedString(Options.languageID, "TID_SETTINGS"));
        this.append(ApplicationData.lp.getTranslatedString(Options.languageID, "TID_QUIT"));
        if (!ApplicationData.isTouchScreen) {
            this.setSoftButtonImage(ObjectsCache.menuSbOK, ObjectsCache.menuSbOK_a, null, null);
        }
    }

    private void updateIDsForDemo() {
        this.FREE_TRIAL_ID = 0;
        ++this.QUICK_START_ID;
        ++this.MORE_ID;
        ++this.ACHIEVEMENTS_ID;
        ++this.QUIT_ID;
    }

    private void updateIDsForUpSell() {
        this.UPSELL_ID = this.QUICK_START_ID + 1;
        ++this.MORE_ID;
        ++this.ACHIEVEMENTS_ID;
        ++this.QUIT_ID;
    }

    public void onFocusBack() {
        super.onFocusBack();
        this.currentItem = 0;
    }

    public void currentItemChanged(int previousId, int currentItemId) {
    }

    public void currentItemSelected(int currentItemId) {
        if (currentItemId == this.ADVENTURE_ID) {
            if (ApplicationData.demoEnabled) {
                UIScreen.SetCurrentScreen(new NotInDemoVersion(false, 2, false, this));
            } else {
                UIScreen.SetCurrentScreen(new SelectGalaxy());
            }
        }
        if (currentItemId == this.SURVIVAL_ID) {
            UIScreen.SetCurrentScreen(new SelectSurvivalLevel(2));
        }
        if (currentItemId == this.TIMED_ID) {
            UIScreen.SetCurrentScreen(new SelectSurvivalLevel(3));
        }
        if (currentItemId == this.ZEN_ID) {
            UIScreen.SetCurrentScreen(new SelectSurvivalLevel(4));
        }
        if (currentItemId == this.MORE_ID) {
            UIScreen.SetCurrentScreen(new Options());
        }
        if (currentItemId == this.ACHIEVEMENTS_ID) {
            UIScreen.SetCurrentScreen(new AchievementsScreen());
        }
        if (currentItemId == this.QUIT_ID) {
            UIScreen.SetCurrentScreen(new AbortApplicationTB());
        }
        if (currentItemId == this.FREE_TRIAL_ID) {
            UIScreen.SetCurrentScreen(new NewYesNoDialogScreen());
        }
        if (currentItemId == this.UPSELL_ID) {
            UIScreen.SetCurrentScreen(new AskForGetMoreGames());
        }
    }

    public boolean actionSoftButton(int nID, boolean pressed) {
        if (pressed) {
            return super.actionSoftButton(nID, pressed);
        }
        if (nID >= 1000) {
            this.currentItemSelected(nID - 1000);
            return true;
        }
        return super.actionSoftButton(nID, pressed);
    }

    public boolean leftSoftButton() {
        this.currentItemSelected(this.currentItem);
        return true;
    }
}

