/*
 * Decompiled with CFR 0.152.
 */
package com;

import com.Life;
import com.Main;
import com.Resources;
import com.game.Ball;
import com.game.Brick;
import com.game.Item;
import com.game.Levels;
import com.game.Plate;
import com.menu.Highscore;
import com.menu.Menu;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.midlet.MIDlet;

public class MainGame
extends GameCanvas
implements Runnable {
    private Main midlet;
    private Menu menu;
    public int[][] SPEED = new int[][]{{2, -4}, {-2, -4}};
    public Random rand;
    public static final int BALL_SPEEDX = 2;
    public static final int BALL_SPEEDY = 4;
    public static final int BRICK_SCORE = 10;
    public static final int MAX_LIFES = 2;
    public static final int TOTAL_COLUMNS = 11;
    public Plate plate;
    public Ball ball;
    public Brick brick;
    public Item item;
    public Vector bricks;
    public Vector items;
    public Levels level;
    public int[] BrickGrid;
    public Highscore highScore;
    public Life life;
    private boolean levelUp = false;
    public int score;
    private int lifes;
    private int levelNumber;
    private int brickHit;
    private boolean lose;
    private boolean win = false;
    private boolean pause = true;
    private boolean run;
    private boolean pause_game = false;
    private int leftWall;
    private int rightWall;
    private int topWall;
    int width;
    int height;
    Thread t = null;
    public int energy = 0;
    public int count = 600;
    private int temp;

    public MainGame(Main midlet) {
        super(true);
        this.midlet = midlet;
        this.setFullScreenMode(true);
        this.width = this.getWidth();
        this.height = this.getHeight();
        this.level = new Levels();
        this.init();
    }

    protected void hideNotify() {
        this.pause_game = true;
    }

    protected void showNotify() {
    }

    public void init() {
        this.score = 0;
        if (this.level.readStream() == 0) {
            this.level.writeStream(1);
        }
        this.levelNumber = this.level.readStream();
        this.lifes = 2;
        this.brickHit = 0;
        this.plate = new Plate(Resources.plate);
        this.initPlateLoc();
        this.plate.maxLimit = this.getWidth();
        this.plate.minLimit = 0;
        this.ball = new Ball(Resources.ball);
        this.initBallLoc();
        this.leftWall = 0;
        this.rightWall = this.width;
        this.topWall = Resources.panel.getHeight();
        this.initBrickLoc();
        this.life = new Life(Resources.life);
        this.life.x = 10;
        this.life.y = this.height - (this.life.height + 10);
    }

    public void initPlateLoc() {
        this.plate.x = this.width / 2 - this.plate.width / 2;
        this.plate.y = this.height - 70;
    }

    public void initBallLoc() {
        this.ball.x = this.width / 2 - this.ball.width / 2;
        this.ball.y = this.plate.y - this.ball.height;
        this.rand = new Random();
        int r = this.rand.nextInt(2);
        this.ball.speedX = this.SPEED[r][0];
        this.ball.speedY = this.SPEED[r][1];
    }

    public void initBrickLoc() {
        this.BrickGrid = Levels.getLevel(this.levelNumber);
        this.bricks = new Vector();
        this.items = new Vector();
        int i = 0;
        while (i < this.BrickGrid.length) {
            int column = i % 11;
            int row = (i - column) / 11;
            if (this.BrickGrid[i] != 0) {
                this.brick = new Brick(Resources.bricks, this.BrickGrid[i]);
                this.brick.x = (this.width - 11 * (this.brick.width + 1)) / 2 + column * (this.brick.width + 1);
                this.brick.y = this.topWall + 50 + row * (this.brick.height + 1);
                this.bricks.addElement(this.brick);
                if (this.BrickGrid[i] != 11) {
                    this.item = new Item(Resources.items, this.BrickGrid[i]);
                }
                if (this.BrickGrid[i] == 11) {
                    int r = 11 + this.rand.nextInt(3);
                    this.item = new Item(Resources.items, r);
                }
                this.item.x = this.brick.x;
                this.item.y = this.brick.y;
                this.items.addElement(this.item);
            }
            ++i;
        }
    }

    public void start() {
        this.run = true;
        this.t = new Thread(this);
        this.t.start();
    }

    public void stop() {
        this.run = false;
    }

    public void pause() {
        this.run = false;
    }

    public void run() {
        while (this.run) {
            if (this.levelUp) {
                this.levelUp();
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException e) {
                    System.out.println("InterruptedException: " + e);
                }
                this.levelUp = false;
            }
            this.update();
            this.drawGraphics(this.getGraphics());
            this.flushGraphics();
            try {
                Thread.sleep(8L);
            }
            catch (InterruptedException e) {
                System.out.println("InterruptedException: " + e);
            }
        }
    }

    public void drawGraphics(Graphics g) {
        this.drawBackground(g);
        this.plate.draw(g);
        this.ball.draw(g);
        int i = 0;
        while (i < this.bricks.size()) {
            this.brick = (Brick)this.bricks.elementAt(i);
            if (this.brick.active) {
                this.brick.draw(g);
            }
            ++i;
        }
        i = 0;
        while (i < this.items.size()) {
            this.item = (Item)this.items.elementAt(i);
            if (this.item.active) {
                this.item.draw(g);
            }
            ++i;
        }
        this.drawLevelUp(g);
        this.drawGameover(g);
        this.drawPause(g);
        this.drawBorder(g);
    }

    public void drawGameover(Graphics g) {
        if (this.lose) {
            g.drawImage(Resources.gameover, this.width / 2, this.height / 2, 3);
        }
    }

    public void drawLevelUp(Graphics g) {
        if (this.levelUp) {
            g.drawImage(Resources.stageclear, this.width / 2, this.height / 2, 3);
        }
    }

    public void drawPause(Graphics g) {
        if (this.pause_game) {
            g.drawImage(Resources.pause, this.width / 2, this.height / 2, 3);
            this.pause();
        }
    }

    public void drawBackground(Graphics g) {
        g.drawImage(Resources.background, 0, 0, 20);
        g.drawImage(Resources.panel, 0, 0, 20);
        g.setColor(255, 255, 255);
        g.setFont(Font.getFont((int)32, (int)0, (int)8));
        g.drawString("" + this.score, 15, 15, 20);
        if (this.levelNumber == 22) {
            g.drawString("FINAL LEVEL!!! ", this.getWidth() / 2, 15, 17);
        } else {
            g.drawString("LEVEL: " + this.levelNumber, this.getWidth() / 2, 15, 17);
        }
        g.setColor(255, 255, 0);
        g.setFont(Font.getFont((int)32, (int)1, (int)8));
        g.drawString("MENU", this.getWidth() - 15, 15, 24);
    }

    public void drawBorder(Graphics g) {
        g.drawImage(Resources.border, 0, 0, 20);
        this.life.draw(g, this.lifes);
    }

    public void update() {
        if (!this.pause) {
            this.ball.update();
            this.checkBallOutside();
            this.checkWinOrLose();
            this.checkCollisions();
            this.checkEnergy();
            int i = 0;
            while (i < this.items.size()) {
                this.item = (Item)this.items.elementAt(i);
                if (this.item.active) {
                    if (this.item.y <= this.height && this.item.active) {
                        this.temp = this.item.position % 9 + 1;
                        this.item.update(this.temp);
                    } else {
                        this.item.active = false;
                        ++this.brickHit;
                    }
                }
                ++i;
            }
        }
        if (this.brickHit == this.bricks.size()) {
            ++this.levelNumber;
            this.level.writeStream(this.levelNumber);
            if (this.levelNumber > 22) {
                this.level.writeStream(1);
                this.win = true;
            } else {
                this.levelUp = true;
            }
        }
    }

    public void checkCollisions() {
        this.checkWallCollisions();
        this.checkPlateCollision();
        this.checkBrickCollisions();
        this.checkScoreCollision();
    }

    public void checkEnergy() {
        if (this.count == 0) {
            this.energy = 0;
            this.ball.image = Resources.ball;
            this.ball.width = Resources.ball.getWidth();
            this.ball.height = Resources.ball.getHeight();
            this.plate.image = Resources.plate;
            this.plate.width = Resources.plate.getWidth();
            this.plate.height = Resources.plate.getHeight();
            this.count = 600;
        }
        if (this.energy != 0) {
            switch (this.energy) {
                case 1: {
                    this.ball.image = Resources.big_ball;
                    this.ball.width = Resources.big_ball.getWidth();
                    this.ball.height = Resources.big_ball.getHeight();
                    break;
                }
                case 2: {
                    this.count = 1;
                    if (this.lifes > 5) break;
                    ++this.lifes;
                    break;
                }
                case 3: {
                    this.plate.image = Resources.big_plate;
                    this.plate.width = Resources.big_plate.getWidth();
                    this.plate.height = Resources.big_plate.getHeight();
                }
            }
            --this.count;
        }
    }

    public void checkScoreCollision() {
        int i = 0;
        while (i < this.items.size()) {
            this.item = (Item)this.items.elementAt(i);
            if (this.item.active) {
                int collision = this.item.collide(this.plate);
                if (this.item.collideHorizontal(collision)) {
                    this.item.oldY = this.item.y;
                }
                if (this.item.collideVertical(collision)) {
                    this.item.oldX = this.item.x;
                }
                if (collision != 0) {
                    this.item.active = false;
                    ++this.brickHit;
                    this.score += this.checkItem(this.item.position);
                }
            }
            ++i;
        }
    }

    private int checkItem(int input) {
        int score = 0;
        switch (input) {
            case 1: {
                score = 50;
                break;
            }
            case 2: {
                score = 60;
                break;
            }
            case 3: {
                score = 70;
                break;
            }
            case 4: {
                score = 80;
                break;
            }
            case 5: {
                score = 90;
                break;
            }
            case 6: {
                score = 100;
                break;
            }
            case 7: {
                score = 110;
                break;
            }
            case 8: {
                score = 120;
                break;
            }
            case 9: {
                score = 0;
                break;
            }
            case 10: {
                score = 200;
                break;
            }
            case 11: {
                this.energy = 1;
                break;
            }
            case 12: {
                this.energy = 2;
                break;
            }
            case 13: {
                this.energy = 3;
            }
        }
        return score;
    }

    public void checkBallOutside() {
        if (this.ball.y >= this.height) {
            this.initBallLoc();
            this.initPlateLoc();
            this.pause = true;
            if (this.lifes >= 1) {
                --this.lifes;
            } else {
                this.lose = true;
            }
        }
    }

    public void checkWinOrLose() {
        if (this.win) {
            if (this.menu == null) {
                this.menu = new Menu(this.midlet);
            }
            Display.getDisplay((MIDlet)this.midlet).setCurrent((Displayable)this.menu);
            this.lose = false;
        }
        if (this.lose) {
            this.writeHighscore(this.score);
            this.stop();
        }
    }

    private void writeHighscore(int score) {
        if (this.highScore == null) {
            this.highScore = new Highscore(this.midlet);
        }
        if (score > this.highScore.readStream()) {
            this.highScore.writeStream(score);
        }
    }

    public void checkWallCollisions() {
        if (this.ball.x + this.ball.width > this.rightWall) {
            this.ball.x = this.rightWall - this.ball.width;
            this.ball.speedX *= -1;
        }
        if (this.ball.x < this.leftWall) {
            this.ball.x = this.leftWall;
            this.ball.speedX *= -1;
        }
        if (this.ball.y < this.topWall) {
            this.ball.y = this.topWall;
            this.ball.speedY *= -1;
        }
    }

    public void checkPlateCollision() {
        int collision = this.ball.collide(this.plate);
        if (this.ball.collideHorizontal(collision) && collision != 8) {
            this.ball.oldY = this.ball.y;
            this.ball.speedY *= -1;
        }
    }

    public void checkBrickCollisions() {
        int i = 0;
        while (i < this.bricks.size()) {
            this.brick = (Brick)this.bricks.elementAt(i);
            this.item = (Item)this.items.elementAt(i);
            if (this.brick.active) {
                int collision = this.ball.collide(this.brick);
                if (this.ball.collideHorizontal(collision)) {
                    this.ball.oldY = this.ball.y;
                    this.ball.speedY = -this.ball.speedY;
                }
                if (this.ball.collideVertical(collision)) {
                    this.ball.oldX = this.ball.x;
                    this.ball.speedX = -this.ball.speedX;
                }
                if (collision != 0) {
                    if (((Brick)this.bricks.elementAt((int)i)).position == 9) {
                        ((Brick)this.bricks.elementAt((int)i)).position = 10;
                        ((Item)this.items.elementAt((int)i)).position = 10;
                    } else {
                        this.brick.active = false;
                        this.item.active = true;
                    }
                }
            }
            ++i;
        }
    }

    public void levelUp() {
        this.levelNumber = this.level.readStream();
        this.bricks.removeAllElements();
        this.pause = true;
        this.brickHit = 0;
        this.initBallLoc();
        this.initPlateLoc();
        this.initBrickLoc();
    }

    protected void pointerPressed(int x, int y) {
        if (x >= 200 && x <= this.width && y >= 0 && y <= 40) {
            this.writeHighscore(this.score);
            if (this.menu == null) {
                this.menu = new Menu(this.midlet);
            }
            Display.getDisplay((MIDlet)this.midlet).setCurrent((Displayable)this.menu);
        }
        if (this.levelUp) {
            this.levelUp();
            this.levelUp = false;
        }
    }

    protected void pointerDragged(int x, int y) {
        if (y >= this.plate.y) {
            this.plate.x = x - this.plate.width / 2;
            if (this.pause) {
                this.ball.x = x - this.ball.width / 2;
            }
        }
    }

    protected void pointerReleased(int x, int y) {
        if (this.pause) {
            this.pause = false;
        }
        if (this.lose) {
            if (this.menu == null) {
                this.menu = new Menu(this.midlet);
            }
            Display.getDisplay((MIDlet)this.midlet).setCurrent((Displayable)this.menu);
            this.lose = false;
        }
        if (this.pause_game) {
            this.pause_game = false;
            if (!this.t.isAlive()) {
                this.start();
            }
        }
    }
}

