/*
 * Decompiled with CFR 0.152.
 */
package com.bgate.core;

import com.bgate.core.Screen;
import com.bgate.utils.KeyCodeAdapter;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.GameCanvas;

public abstract class MyGame
extends GameCanvas
implements Runnable {
    Screen screen;
    Thread gameThread;
    boolean isRunning;
    public static int delay;
    public boolean connect;
    public int key;
    int keyCode;

    public MyGame() {
        super(false);
        this.setFullScreenMode(true);
        delay = 50;
        this.start();
    }

    public int getScreenWidth() {
        return this.getWidth();
    }

    public int getScreenHeight() {
        return this.getHeight();
    }

    public int getDelay() {
        return delay;
    }

    public boolean isConnect() {
        return this.connect;
    }

    public void resume() {
        this.isRunning = true;
    }

    public void pause() {
        this.isRunning = false;
    }

    public void start() {
        this.gameThread = new Thread(this);
        this.gameThread.start();
        this.isRunning = true;
    }

    public void stop() {
        this.isRunning = false;
        this.gameThread = null;
    }

    public void setScreen(Screen screen) {
        this.isRunning = false;
        this.screen.pause();
        this.screen.dispose();
        this.screen = null;
        Runtime.getRuntime().gc();
        screen.resume();
        screen.update();
        this.screen = screen;
        this.isRunning = true;
    }

    public void setStartScreen(Screen screen) {
        this.screen = screen;
    }

    public Screen getCurrentScreen() {
        return this.screen;
    }

    public Graphics getGameGraphics() {
        return this.getGraphics();
    }

    public boolean isTouchHandler() {
        return this.hasPointerEvents() && this.hasPointerMotionEvents();
    }

    public boolean isNeedShowInputForm() {
        return this.isTouchHandler() && this.getWidth() >= 320 && this.getHeight() >= 320;
    }

    public void update() {
        try {
            this.screen.update();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
    }

    public void present(Graphics g) {
        if (this.isRunning) {
            g.setColor(0);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            try {
                this.screen.present(g);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return;
            }
        }
        g.setColor(0xFF0000);
        this.flushGraphics();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int timeGc = 0;
        Graphics g = this.getGraphics();
        Thread currentThread = Thread.currentThread();
        while (currentThread == this.gameThread) {
            long timeTake;
            long startTime = System.currentTimeMillis();
            if (this.isShown()) {
                try {
                    if (this.isRunning) {
                        this.update();
                    }
                    this.present(g);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                if ((timeGc += delay) >= 5000) {
                    Runtime.getRuntime().gc();
                    timeGc = 0;
                }
            }
            if ((timeTake = System.currentTimeMillis() - startTime) < (long)delay) {
                MyGame myGame = this;
                synchronized (myGame) {
                    try {
                        this.wait((long)delay - timeTake);
                    }
                    catch (InterruptedException ex) {
                        ex.printStackTrace();
                    }
                    continue;
                }
            }
            Thread.currentThread();
            Thread.yield();
        }
    }

    protected void keyPressed(int keyCode) {
        this.key = keyCode;
        int instantkeyCode = KeyCodeAdapter.getInstance().adoptKeyCode(keyCode);
        switch (instantkeyCode) {
            case 223: {
                this.screen.leftKeyPressed();
                return;
            }
            case 224: {
                this.screen.rightKeyPressed();
                return;
            }
            case 222: {
                this.screen.downKeyPressed();
                return;
            }
            case 221: {
                this.screen.upKeyPressed();
                return;
            }
            case 225: {
                this.screen.fireKeyPressed();
                return;
            }
            case -203: {
                this.screen.fireKeyPressed();
                return;
            }
            case -201: {
                this.screen.softKeyLeftPressed();
                return;
            }
            case -202: {
                this.screen.softKeyRightPressed();
                return;
            }
        }
        this.keyCode = keyCode;
        this.screen.numberKeyPressed(keyCode);
    }

    protected void keyRepeated(int keyCode) {
        int gameAct = this.getGameAction(keyCode);
        switch (gameAct) {
            case 1: {
                this.screen.upKeytRepeated();
                return;
            }
            case 6: {
                this.screen.downKeyRepeated();
                return;
            }
            case 2: {
                this.screen.leftKeyRepeated();
                return;
            }
            case 5: {
                this.screen.rightKeyRepeated();
                return;
            }
        }
    }

    protected void keyReleased(int keyCode) {
        int gameAct = this.getGameAction(keyCode);
        switch (gameAct) {
            case 1: {
                this.screen.upKeyRealeased();
                return;
            }
            case 6: {
                this.screen.downKeyRealeased();
                return;
            }
            case 2: {
                this.screen.leftKeyRealeased();
                return;
            }
            case 5: {
                this.screen.rightKeyRealeased();
                return;
            }
        }
    }

    protected void pointerPressed(int x, int y) {
        super.pointerPressed(x, y);
        this.screen.pointerPressed(x, y);
    }

    protected void pointerReleased(int x, int y) {
        super.pointerReleased(x, y);
        this.screen.pointerReleased(x, y);
    }

    protected void pointerDragged(int x, int y) {
        super.pointerDragged(x, y);
        this.screen.pointerDragged(x, y);
    }
}

