/*
 * Decompiled with CFR 0.152.
 */
package com.bgate.utils;

import com.bgate.utils.KeyCodeAdapter;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.wireless.messaging.BinaryMessage;
import javax.wireless.messaging.Message;
import javax.wireless.messaging.MessageConnection;
import javax.wireless.messaging.MessageListener;
import javax.wireless.messaging.TextMessage;

public class BgateCanvas
extends Canvas
implements MessageListener {
    private Timer timer1;
    private TimerTask timerTask;
    public boolean isMenu = true;
    int curMenu = 0;
    int langId = 1;
    int minMenu = 0;
    int xL = 0;
    int yL = 0;
    public String[] menu;
    public String[] menuViet = new String[]{"B\u1eaeT \u0110\u1ea6U", "T\u1eaeT \u00c2M THANH", "ENGLISH", "THO\u00c1T"};
    public String[] menuEnglish = new String[]{"START GAME", "SOUND ON", "TI\u1ebeNG VI\u1ec6T", "EXIT"};
    Font fontMenu = Font.getFont((int)0, (int)1, (int)16);
    Font fontTextMenu = Font.getFont((int)0, (int)1, (int)8);
    String msgReceived = "no Message";
    MessageConnection serverConn;
    boolean sound;
    int gold = 1000;
    private int style = 1;
    byte[] text;
    public static int DELAY_DEFAULT = 100;
    private int color;
    private int mode = 0;
    Image bkImage = null;
    public static int VERTICAL = 1;
    public static int HORIZONTAL = 0;

    public BgateCanvas() {
    }

    public BgateCanvas(boolean sound) {
        this.setFullScreenMode(true);
        this.sound = sound;
        this.timer1 = new Timer();
        this.timerTask = new TimerTask(){

            public void run() {
                if (BgateCanvas.this.isShown()) {
                    BgateCanvas.this.xL = BgateCanvas.this.xL < 10 ? ++BgateCanvas.this.xL : 0;
                    BgateCanvas.this.yL = BgateCanvas.this.yL < 10 ? ++BgateCanvas.this.yL : 0;
                    BgateCanvas.this.repaint(0, 0, BgateCanvas.this.getWidth(), BgateCanvas.this.getHeight());
                }
            }
        };
        this.timer1.schedule(this.timerTask, 0L, 100L);
    }

    protected void paint(Graphics g) {
        g.setColor(0, 0, 0);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        int width = this.getWidth();
        int height = this.getHeight();
        if (width > 240) {
            width = 240;
        }
        if (height > 320) {
            height = 320;
        }
        if (this.isMenu) {
            if (this.getWidth() > 160) {
                if (this.bkImage == null) {
                    try {
                        this.bkImage = Image.createImage((String)"/menu.png");
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                g.drawRegion(this.bkImage, (240 - width) / 2, (320 - height) / 2, width, height, 0, Math.abs(this.getWidth() - Math.min(this.getWidth(), 240)) / 2, Math.abs(this.getHeight() - Math.min(this.getHeight(), 320)) / 2, 0);
                this.drawMenu(g, this.getWidth() / 2, (this.getHeight() - this.fontMenu.getHeight() * 3) / 2);
            } else {
                this.drawMenuSmall(g, this.getWidth() / 2, (this.getHeight() - this.fontMenu.getHeight() * 4) / 2);
            }
        } else {
            g.setColor(255, 255, 255);
            g.drawString(this.msgReceived, this.getWidth() / 29, this.getHeight() / 2, 0);
        }
    }

    public void drawMenuSmall(Graphics g, int x, int y) {
        int p;
        int q;
        VERTICAL = 1;
        HORIZONTAL = 0;
        int color1 = this.makeColorAsInt(0, 255, 0, 0);
        int color2 = this.makeColorAsInt(0, 255, 255, 255);
        int colorL = this.makeColorAsInt(0, 255, 255, 0);
        g.setColor(0xFFFFFF);
        g.setColor(255, 225, 0);
        for (q = 1; q <= this.getWidth() / 4 + 1; ++q) {
            for (p = 1; p <= 2; ++p) {
                if (p == 1 || q % 2 == 0) {
                    g.fillRect(q * 3 - 1 + this.getWidth() / 8, p * 3 + (this.getHeight() - 7 * this.fontMenu.getHeight()) / 2 - 4, 2, 2);
                }
                if (p != 2 && q % 2 != 0) continue;
                g.fillRect(q * 3 - 1 + this.getWidth() / 8, p * 3 + (this.getHeight() + 7 * this.fontMenu.getHeight()) / 2 - 4, 2, 2);
            }
        }
        for (q = 1; q <= 2; ++q) {
            for (p = 1; p <= 7 * this.fontMenu.getHeight() / 3 + 1; ++p) {
                if (q == 1 || p % 2 == 0) {
                    g.fillRect(q * 3 - 1 + this.getWidth() / 8, p * 3 + (this.getHeight() - 7 * this.fontMenu.getHeight()) / 2 - 4, 2, 2);
                }
                if (q != 2 && p % 2 != 0) continue;
                g.fillRect(q * 3 - 1 + this.getWidth() / 4 * 3 + this.getWidth() / 8 - 6 + 3, p * 3 + (this.getHeight() - 7 * this.fontMenu.getHeight()) / 2 - 4, 2, 2);
            }
        }
        this.menu = this.langId == 0 ? this.menuEnglish : this.menuViet;
        g.setFont(this.fontTextMenu);
        for (int i = this.minMenu; i < this.minMenu + 4; ++i) {
            if (this.curMenu == i) {
                g.setColor(0xFFFFFF);
                this.color = 0;
            } else {
                g.setColor(0xFF0000);
                this.color = -1;
            }
            if (this.getWidth() >= 160) continue;
            g.drawString(this.menu[i], x - this.fontTextMenu.stringWidth(this.menu[i]) / 2, y + (i - this.minMenu) * (this.fontMenu.getHeight() * 57 / 56), 0);
        }
    }

    public void drawMenu(Graphics g, int x, int y) {
        this.menu = this.langId == 0 ? this.menuEnglish : this.menuViet;
        g.setFont(this.fontTextMenu);
        for (int i = this.minMenu; i < this.minMenu + 4; ++i) {
            this.color = this.curMenu == i ? 10 : 1;
            this.text = new byte[this.menu[i].length()];
        }
        Runtime.getRuntime().gc();
    }

    public static void gradientBox(Graphics g, int color1, int color2, int left, int top, int width, int height, int orientation) {
        int max = orientation == VERTICAL ? height : width;
        for (int i = 0; i < max; ++i) {
            int color = BgateCanvas.midColor(color1, color2, max * (max - 1 - i) / (max - 1), max);
            g.setColor(color);
            if (orientation == VERTICAL) {
                g.drawLine(left, top + i, left + width - 1, top + i);
                continue;
            }
            g.drawLine(left + i, top, left + i, top + height - 1);
        }
    }

    static int midColor(int color1, int color2, int prop, int max) {
        int red = ((color1 >> 16 & 0xFF) * prop + (color2 >> 16 & 0xFF) * (max - prop)) / max;
        int green = ((color1 >> 8 & 0xFF) * prop + (color2 >> 8 & 0xFF) * (max - prop)) / max;
        int blue = ((color1 >> 0 & 0xFF) * prop + (color2 >> 0 & 0xFF) * (max - prop)) / max;
        int color = red << 16 | green << 8 | blue;
        return color;
    }

    private int makeColorAsInt(int alpha, int red, int green, int blue) {
        return alpha << 24 | red << 16 | green << 8 | blue;
    }

    protected void keyPressed(int keyCode) {
        int instantkeyCode = KeyCodeAdapter.getInstance().adoptKeyCode(keyCode);
        switch (instantkeyCode) {
            case 223: {
                this.repaint();
                return;
            }
            case 224: {
                this.repaint();
                return;
            }
            case 222: {
                this.downKey();
                this.repaint();
                return;
            }
            case 221: {
                this.upKey();
                this.repaint();
                return;
            }
            case 225: {
                this.fireKey();
                this.repaint();
                return;
            }
            case -203: {
                this.fireKey();
                this.repaint();
                return;
            }
            case -201: {
                this.menuLeftKey();
                this.repaint();
                return;
            }
            case -202: {
                this.menuRightKey();
                this.repaint();
                return;
            }
            case 202: {
                this.upKey();
                this.repaint();
                return;
            }
            case 208: {
                this.downKey();
                this.repaint();
                return;
            }
            case 205: {
                this.fireKey();
                this.repaint();
                return;
            }
        }
    }

    public void upKey() {
        if (this.curMenu > 0) {
            if (this.minMenu == this.curMenu) {
                --this.minMenu;
            }
            --this.curMenu;
        } else {
            this.curMenu = this.menu.length - 1;
            this.minMenu = this.menu.length - 4;
        }
    }

    public void downKey() {
        if (this.curMenu < this.menu.length - 1) {
            if (this.curMenu == this.minMenu + 4) {
                ++this.minMenu;
            }
            ++this.curMenu;
        } else {
            this.curMenu = 0;
            this.minMenu = 0;
        }
    }

    public void fireKey() {
        if (this.isMenu) {
            switch (this.curMenu) {
                case 0: {
                    return;
                }
                case 1: {
                    return;
                }
                case 2: {
                    this.langId = this.langId == 0 ? 1 : 0;
                    return;
                }
                case 3: {
                    return;
                }
                case 4: {
                    return;
                }
                case 6: {
                    return;
                }
                case 5: {
                    return;
                }
                case 7: {
                    return;
                }
            }
        }
    }

    public void menuLeftKey() {
    }

    public void menuRightKey() {
    }

    public void notifyIncomingMessage(MessageConnection conn) {
        Message msg = null;
        try {
            msg = conn.receive();
        }
        catch (Exception e) {
            this.msgReceived = e.toString();
            System.out.println("processMessage.receive " + e);
        }
        if (msg instanceof TextMessage) {
            TextMessage tmsg = (TextMessage)msg;
            this.msgReceived = tmsg.getPayloadText();
        } else if (msg instanceof BinaryMessage) {
            BinaryMessage bmsg = (BinaryMessage)msg;
            byte[] data = bmsg.getPayloadData();
            this.msgReceived = data.toString();
        }
    }
}

