/*
 * Decompiled with CFR 0.152.
 */
package com.innovazione.bubbleshoot;

import com.innovazione.bubbleshoot.BmpWrap;
import com.innovazione.bubbleshoot.Sprite;
import javax.microedition.lcdui.Graphics;

public class BubbleFont {
    private static final char[] CHARACTERS = new char[]{'!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '|', '{', '}', '[', ']', ' ', '\\', ' ', ' '};
    public static final int SEPARATOR_WIDTH = 1;
    public static final int SPACE_CHAR_WIDTH = 6;
    private BmpWrap[] fontMap;

    public BubbleFont(BmpWrap[] fontMap) {
        this.fontMap = fontMap;
    }

    public final int stringWidth(String s, double scale) {
        int width = 0;
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c == ' ') {
                width += 7;
                continue;
            }
            int index = this.getCharIndex(c);
            if (index == -1 || this.fontMap[index].bmp == null) continue;
            width += (int)((double)this.fontMap[index].bmp.getWidth() / scale + 0.5) + 1;
        }
        return width;
    }

    public final void print(String s, int x, int y, Graphics g, double scale, int dx, int dy) {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            x += this.paintChar(c, x, y, g, scale, dx, dy);
        }
    }

    public final int paintChar(char c, int x, int y, Graphics g, double scale, int dx, int dy) {
        if (c == ' ') {
            return 7;
        }
        int index = this.getCharIndex(c);
        if (index == -1 || this.fontMap[index].bmp == null) {
            return 0;
        }
        int imageWidth = (int)((double)this.fontMap[index].bmp.getWidth() / scale + 0.5);
        Sprite.drawImage(this.fontMap[index], x, y, g, scale, dx, dy);
        return imageWidth + 1;
    }

    private int getCharIndex(char c) {
        for (int i = 0; i < CHARACTERS.length; ++i) {
            if (CHARACTERS[i] != c) continue;
            return i;
        }
        return -1;
    }
}

