/*
 * Decompiled with CFR 0.152.
 */
package com.innovazione.bubbleshoot;

import com.innovazione.bubbleshoot.BmpWrap;
import com.innovazione.bubbleshoot.Point;
import com.innovazione.bubbleshoot.Rect;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public abstract class Sprite {
    public static final int TYPE_NULL = 0;
    public static final int TYPE_BUBBLE = 1;
    public static final int TYPE_IMAGE = 2;
    public static final int TYPE_LAUNCH_BUBBLE = 3;
    public static final int TYPE_PENGUIN = 4;
    private Rect spriteArea;
    private int saved_id;

    public Sprite(Rect spriteArea) {
        this.spriteArea = spriteArea;
        this.saved_id = -1;
    }

    public void saveState(DataOutputStream data, Vector savedSprites) throws IOException {
        data.writeInt(this.getTypeId());
        data.writeInt(this.spriteArea.left);
        data.writeInt(this.spriteArea.right);
        data.writeInt(this.spriteArea.top);
        data.writeInt(this.spriteArea.bottom);
        this.saved_id = savedSprites.size();
        savedSprites.addElement(this);
    }

    public final int getSavedId() {
        return this.saved_id;
    }

    public final void clearSavedId() {
        this.saved_id = -1;
    }

    public abstract int getTypeId();

    public void changeSpriteArea(Rect newArea) {
        this.spriteArea = newArea;
    }

    public final void relativeMove(Point p) {
        this.spriteArea = new Rect(this.spriteArea);
        this.spriteArea.offset(p.x, p.y);
    }

    public final void relativeMove(int x, int y) {
        this.spriteArea = new Rect(this.spriteArea);
        this.spriteArea.offset(x, y);
    }

    public final void absoluteMove(Point p) {
        this.spriteArea = new Rect(this.spriteArea);
        this.spriteArea.offsetTo(p.x, p.y);
    }

    public final Point getSpritePosition() {
        return new Point(this.spriteArea.left, this.spriteArea.top);
    }

    public final Rect getSpriteArea() {
        return this.spriteArea;
    }

    public static void drawImage(BmpWrap image, int x, int y, Graphics g, double scale, int dx, int dy) {
        g.drawImage(image.bmp, (int)((double)x * scale + (double)dx), (int)((double)y * scale + (double)dy), 20);
    }

    public static void drawImageClipped(BmpWrap image, int x, int y, Rect clipr, Graphics g, double scale, int dx, int dy) {
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipWidth = g.getClipWidth();
        int clipHeight = g.getClipHeight();
        int left = (int)((double)clipr.left * scale + (double)dx);
        int top = (int)((double)clipr.top * scale + (double)dy);
        int width = (int)((double)clipr.right * scale + (double)dx) - left;
        int height = (int)((double)clipr.bottom * scale + (double)dy) - top;
        g.setClip(left, top, width, height);
        g.drawImage(image.bmp, (int)((double)x * scale + (double)dx), (int)((double)y * scale + (double)dy), 20);
        g.setClip(clipX, clipY, clipWidth, clipHeight);
    }

    public abstract void paint(Graphics var1, double var2, int var4, int var5);
}

