/*
 * Decompiled with CFR 0.152.
 */
package com.ratemyapp;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;
import org.kxml2.io.KXmlParser;

class LocalizedStrings {
    private Hashtable strings = new Hashtable();

    public void setString(String key, String value) {
        this.strings.put(key, value);
    }

    public String getString(String key) {
        if (this.strings.containsKey(key)) {
            return (String)this.strings.get(key);
        }
        return null;
    }

    public boolean readResources(String locale) {
        boolean resourceLoaded = false;
        String filename = "AppResources";
        if (locale != null) {
            filename = String.valueOf(filename) + "." + locale;
        }
        filename = String.valueOf(filename) + ".resx";
        InputStream is = null;
        InputStreamReader isr = null;
        System.out.println("FILE: " + filename);
        try {
            try {
                is = this.getClass().getResourceAsStream("/" + filename);
                isr = new InputStreamReader(is, "UTF-8");
                KXmlParser parser = new KXmlParser();
                parser.setInput(isr);
                this.strings = new Hashtable();
                parser.nextTag();
                parser.require(2, null, "root");
                parser.nextTag();
                while (parser.getEventType() != 3) {
                    String nodeName = parser.getName();
                    if (nodeName.compareTo("data") == 0) {
                        String resourceName = parser.getAttributeValue("", "name");
                        parser.nextTag();
                        while (parser.getEventType() != 3) {
                            if (parser.getName().compareTo("value") == 0) {
                                String resourceValue = parser.nextText();
                                this.strings.put(resourceName, resourceValue);
                            } else {
                                parser.skipSubTree();
                            }
                            parser.nextTag();
                        }
                    } else {
                        parser.skipSubTree();
                    }
                    parser.nextTag();
                }
                resourceLoaded = true;
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (isr != null) {
                        isr.close();
                    }
                    if (is != null) {
                        is.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                if (isr != null) {
                    isr.close();
                }
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception exception) {}
        }
        return resourceLoaded;
    }
}

