/*
 * Decompiled with CFR 0.152.
 */
package com.innovazione.bubbleshoot;

import com.innovazione.bubbleshoot.BmpWrap;
import com.innovazione.bubbleshoot.BubbleFont;
import com.innovazione.bubbleshoot.FrozenBubble;
import com.innovazione.bubbleshoot.FrozenGame;
import com.innovazione.bubbleshoot.LevelManager;
import com.innovazione.bubbleshoot.LifeManager;
import com.innovazione.bubbleshoot.Menu;
import com.innovazione.bubbleshoot.SettingsManager;
import com.innovazione.bubbleshoot.SoundManager;
import com.innovazione.bubbleshoot.Sprite;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class FrozenCanvas
extends GameCanvas {
    private static final int RIGHT_SOFTKEY = -7;
    private static final int FRAME_DELAY = 40;
    private static final int MODE_RUNNING = 1;
    private static final int MODE_PAUSE = 2;
    private static final int MODE_MENU = 3;
    private static final int MODE_ABOUT = 4;
    private static final int MODE_SETTINGS = 5;
    private static final int GAMEFIELD_WIDTH = 320;
    private static final int GAMEFIELD_HEIGHT = 480;
    private static final int EXTENDED_GAMEFIELD_WIDTH = 640;
    private static final double TOUCH_FIRE_Y_THRESHOLD = 380.0;
    private static final double ATS_TOUCH_COEFFICIENT = 0.2;
    private static final double ATS_TOUCH_FIRE_Y_THRESHOLD = 350.0;
    private static final double MENU_Y_THRESHOLD = 420.0;
    private final Menu menu;
    private final Menu settingsMenu;
    private final String[] aboutText;
    private double aboutDY = 0.0;
    private static final int ABOUT_DELAY = 1000;
    private static final double ABOUT_SPEED = 1.0;
    private int canvasHeight = 1;
    private int canvasWidth = 1;
    private int mode;
    private boolean left = false;
    private boolean right = false;
    private boolean up = false;
    private boolean fire = false;
    private boolean wasLeft = false;
    private boolean wasRight = false;
    private boolean wasFire = false;
    private boolean wasUp = false;
    private boolean touchFire = false;
    private double touchX;
    private double touchY;
    private boolean ATSTouchFire = false;
    private double ATSTouchDX = 0.0;
    private double ATSTouchLastX;
    private double displayScale;
    private int displayDX;
    private int displayDY;
    private FrozenGame frozenGame;
    private boolean imagesReady = false;
    private boolean rmsReady = false;
    private boolean firstStart = true;
    private Image splashImage;
    private Image[] splashNumberImages;
    private BmpWrap background;
    private BmpWrap[] bubbles;
    private BmpWrap[] bubblesBlind;
    private BmpWrap[] frozenBubbles;
    private BmpWrap[] targetedBubbles;
    private BmpWrap bubbleBlink;
    private BmpWrap gameWon;
    private BmpWrap gameLost;
    private BmpWrap hurry;
    private BmpWrap penguins;
    private BmpWrap compressorHead;
    private BmpWrap compressor;
    private BmpWrap life;
    private BmpWrap[] font;
    private BmpWrap[] launcher;
    private BmpWrap menuTitle;
    private BmpWrap menuButton;
    private BmpWrap backButton;
    private SoundManager soundManager;
    private LevelManager levelManager;
    private LifeManager lifeManager;
    private BubbleFont bubbleFont;
    private Vector imageList;
    private GameThread gameThread = null;
    private ImageLoaderThread imageLoaderThread = null;
    private volatile int imagesLoaded;
    FrozenBubble instance;

    public FrozenCanvas(FrozenBubble instance) {
        super(false);
        int i;
        this.setFullScreenMode(true);
        this.instance = instance;
        this.setMode(2);
        this.menu = new Menu(5);
        this.menu.setItem(0, "resume");
        this.menu.setItem(1, "new game");
        this.menu.setItem(2, "about");
        this.menu.setItem(3, "settings");
        this.menu.setItem(4, "exit");
        this.settingsMenu = new Menu(5);
        this.settingsMenu.setItem(0, "colorblind mode:");
        this.settingsMenu.setItem(1, "sound:");
        this.settingsMenu.setItem(2, "point to shoot:");
        this.settingsMenu.setItem(3, "don't rush me:");
        this.settingsMenu.setItem(4, "back");
        this.aboutText = new String[]{null, null, "   easter eggs shooter ", null, null, "     version 1.0.0     ", "    innovazione labs   ", null, null, "..........help..........", "1.aim and shoot for same", "  eggs.", "2.special powers in the", "  game.", "3.but finish the game", "  before time.", null, null, "        disclamer       ", " this is app is just for ", "fun and ententainment.", "we take no responsibility", " of the data within.", " based on the opensource ", "game frozen bubbles", null, null, null, null};
        try {
            this.splashImage = Image.createImage((String)"/image/splash.png");
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.splashNumberImages = new Image[10];
            for (int i2 = 0; i2 < this.splashNumberImages.length; ++i2) {
                this.splashNumberImages[i2] = Image.createImage((String)("/image/font/bubble_font_" + (i2 + 15) + ".gif"));
            }
        }
        catch (IOException e) {
            this.splashNumberImages = null;
        }
        this.imageList = new Vector();
        this.background = this.newBmpWrap();
        this.bubbles = new BmpWrap[8];
        for (i = 0; i < this.bubbles.length; ++i) {
            this.bubbles[i] = this.newBmpWrap();
        }
        this.bubblesBlind = new BmpWrap[8];
        for (i = 0; i < this.bubblesBlind.length; ++i) {
            this.bubblesBlind[i] = this.newBmpWrap();
        }
        this.frozenBubbles = new BmpWrap[8];
        for (i = 0; i < this.frozenBubbles.length; ++i) {
            this.frozenBubbles[i] = this.newBmpWrap();
        }
        this.targetedBubbles = new BmpWrap[6];
        for (i = 0; i < this.targetedBubbles.length; ++i) {
            this.targetedBubbles[i] = this.newBmpWrap();
        }
        this.bubbleBlink = this.newBmpWrap();
        this.gameWon = this.newBmpWrap();
        this.gameLost = this.newBmpWrap();
        this.hurry = this.newBmpWrap();
        this.penguins = this.newBmpWrap();
        this.compressorHead = this.newBmpWrap();
        this.compressor = this.newBmpWrap();
        this.life = this.newBmpWrap();
        this.font = new BmpWrap[67];
        for (i = 0; i < this.font.length; ++i) {
            this.font[i] = this.newBmpWrap();
        }
        this.launcher = new BmpWrap[39];
        for (i = 0; i < this.launcher.length; ++i) {
            this.launcher[i] = this.newBmpWrap();
        }
        this.menuTitle = this.newBmpWrap();
        this.menuButton = this.newBmpWrap();
        this.backButton = this.newBmpWrap();
        this.bubbleFont = new BubbleFont(this.font);
        this.soundManager = new SoundManager();
        try {
            InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/levels.txt");
            int size = is.available();
            byte[] levels = new byte[size];
            is.read(levels);
            is.close();
            this.levelManager = new LevelManager(levels, 0);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
        this.lifeManager = new LifeManager(this.life);
        this.frozenGame = new FrozenGame(this.bubbles, this.bubblesBlind, this.frozenBubbles, this.targetedBubbles, this.bubbleBlink, this.gameWon, this.gameLost, this.hurry, this.penguins, this.compressorHead, this.compressor, this.launcher, this.soundManager, this.levelManager, this.lifeManager);
    }

    private BmpWrap newBmpWrap() {
        int new_img_id = this.imageList.size();
        BmpWrap new_img = new BmpWrap(new_img_id);
        this.imageList.addElement(new_img);
        return new_img;
    }

    protected final synchronized void keyPressed(int keyCode) {
        int gameAction = this.getGameAction(keyCode);
        if (this.mode == 3) {
            if (gameAction == 1) {
                this.menu.moveFocusUp();
            } else if (gameAction == 6) {
                this.menu.moveFocusDown();
            } else if (gameAction == 8) {
                switch (this.menu.focused()) {
                    case 0: {
                        this.setMode(1);
                        break;
                    }
                    case 1: {
                        this.newGame();
                        this.setMode(1);
                        break;
                    }
                    case 2: {
                        this.about();
                        this.instance.showMidBillboard();
                        break;
                    }
                    case 3: {
                        this.settings();
                        break;
                    }
                    case 4: {
                        this.instance.exit();
                    }
                }
            }
        } else if (this.mode == 5) {
            if (gameAction == 1) {
                this.settingsMenu.moveFocusUp();
            } else if (gameAction == 6) {
                this.settingsMenu.moveFocusDown();
            } else if (gameAction == 8) {
                switch (this.settingsMenu.focused()) {
                    case 0: {
                        SettingsManager.toggleNormalMode();
                        break;
                    }
                    case 1: {
                        SettingsManager.toggleSoundOn();
                        break;
                    }
                    case 2: {
                        SettingsManager.toggleAimThenShoot();
                        break;
                    }
                    case 3: {
                        SettingsManager.toggleDontRushMe();
                        break;
                    }
                    case 4: {
                        this.menu();
                    }
                }
            }
            if (keyCode == -7) {
                this.menu();
            }
        } else if (keyCode == -7) {
            this.menu();
        } else if (this.mode == 2) {
            this.setMode(1);
        } else if (this.mode == 1) {
            if (gameAction == 2) {
                this.left = true;
                this.wasLeft = true;
            } else if (gameAction == 5) {
                this.right = true;
                this.wasRight = true;
            } else if (gameAction == 8) {
                this.fire = true;
                this.wasFire = true;
            } else if (gameAction == 1) {
                this.up = true;
                this.wasUp = true;
            }
        }
    }

    protected final void keyReleased(int keyCode) {
        int gameAction = this.getGameAction(keyCode);
        if (this.mode == 1) {
            if (gameAction == 2) {
                this.left = false;
            } else if (gameAction == 5) {
                this.right = false;
            } else if (gameAction == 8) {
                this.fire = false;
            } else if (gameAction == 1) {
                this.up = false;
            }
        }
    }

    public final int getGameAction(int keyCode) {
        try {
            return super.getGameAction(keyCode);
        }
        catch (IllegalArgumentException e) {
            return 0;
        }
    }

    protected final synchronized void pointerPressed(int scrX, int scrY) {
        double x = this.xFromScr(scrX);
        double y = this.yFromScr(scrY);
        if (this.mode == 3) {
            this.menu.unfocus();
            if (y > 167.0 && y < 227.0) {
                this.setMode(1);
            } else if (y < 287.0) {
                this.newGame();
                this.setMode(1);
            } else if (y < 347.0) {
                this.about();
                this.instance.showMidBillboard();
            } else if (y < 407.0) {
                this.settings();
            } else {
                this.instance.exit();
            }
        } else if (this.mode == 5) {
            this.settingsMenu.unfocus();
            if (y > 40.0 && y < 120.0) {
                SettingsManager.toggleNormalMode();
            } else if (y < 200.0) {
                SettingsManager.toggleSoundOn();
            } else if (y < 280.0) {
                SettingsManager.toggleAimThenShoot();
            } else if (y < 360.0) {
                SettingsManager.toggleDontRushMe();
            } else if (y < 440.0) {
                this.menu();
            }
        } else if (y > 420.0 && scrX > 2 * (this.canvasWidth / 3)) {
            this.menu();
        } else if (this.mode == 2) {
            this.setMode(1);
        } else if (this.mode == 1) {
            if (y < 380.0) {
                this.touchFire = true;
                this.touchX = x;
                this.touchY = y;
            }
            if (y < 350.0) {
                this.ATSTouchFire = true;
            }
            this.ATSTouchLastX = x;
        }
    }

    protected final synchronized void pointerDragged(int scrX, int scrY) {
        if (this.mode == 1) {
            double x = this.xFromScr(scrX);
            double y = this.yFromScr(scrY);
            if (y >= 350.0) {
                this.ATSTouchDX = (x - this.ATSTouchLastX) * 0.2;
            }
            this.ATSTouchLastX = x;
        }
    }

    protected final void showNotify() {
        this.sizeChanged(this.getWidth(), this.getHeight());
        this.gameThread = new GameThread(this.getGraphics());
        this.gameThread.start();
        if (this.firstStart) {
            this.firstStart = false;
            this.restoreState();
        }
    }

    protected final void hideNotify() {
        this.pause();
        if (this.gameThread != null) {
            this.gameThread.cancel();
            this.gameThread = null;
        }
    }

    protected final synchronized void sizeChanged(int width, int height) {
        this.canvasWidth = width;
        this.canvasHeight = height;
        if (100 * width / height >= 66) {
            this.displayScale = 1.0 * (double)height / 480.0;
            this.displayDX = (int)(((double)width - this.displayScale * 640.0) / 2.0);
            this.displayDY = 0;
        } else {
            this.displayScale = 1.0 * (double)width / 320.0;
            this.displayDX = (int)(-this.displayScale * 320.0 / 2.0);
            this.displayDY = (int)(((double)height - this.displayScale * 480.0) / 2.0);
        }
        if (this.imageLoaderThread != null && this.imageLoaderThread.displayScale != this.displayScale) {
            this.imageLoaderThread.cancel();
            this.imageLoaderThread = null;
        }
        if (this.imageLoaderThread == null) {
            this.imagesReady = false;
            this.imageLoaderThread = new ImageLoaderThread(this.displayScale);
            this.imageLoaderThread.start();
        }
    }

    public final synchronized void cleanUp() {
        this.saveState();
        this.soundManager.cleanUp();
    }

    private synchronized void menu() {
        this.menu.unfocus();
        this.setMode(3);
    }

    private synchronized void about() {
        this.aboutDY = 25.0 * this.displayScale;
        this.setMode(4);
    }

    private synchronized void settings() {
        this.settingsMenu.unfocus();
        this.setMode(5);
    }

    private synchronized void pause() {
        if (this.mode == 1) {
            this.setMode(3);
        }
    }

    private synchronized void setMode(int mode) {
        this.mode = mode;
    }

    private synchronized void newGame() {
        this.levelManager.goToFirstLevel();
        this.lifeManager.restart();
        this.frozenGame = new FrozenGame(this.bubbles, this.bubblesBlind, this.frozenBubbles, this.targetedBubbles, this.bubbleBlink, this.gameWon, this.gameLost, this.hurry, this.penguins, this.compressorHead, this.compressor, this.launcher, this.soundManager, this.levelManager, this.lifeManager);
    }

    private synchronized void runGameLoop(Graphics g) {
        if (this.imagesReady && this.rmsReady) {
            if (this.mode == 3) {
                this.drawMenuScreen(g);
            } else if (this.mode == 4) {
                this.drawAboutScreen(g);
            } else if (this.mode == 5) {
                this.drawSettingsScreen(g);
            } else {
                if (this.mode == 1) {
                    this.updateGameState();
                }
                this.drawGame(g);
            }
        } else {
            this.drawSplash(g);
            this.menu();
        }
        this.flushGraphics();
    }

    private void drawSplash(Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, this.canvasWidth, this.canvasHeight);
        if (this.splashImage != null) {
            g.drawImage(this.splashImage, this.canvasWidth >> 1, this.canvasHeight >> 1, 3);
        }
        if (this.splashNumberImages != null) {
            int p = 100 * this.imagesLoaded / this.imageList.size();
            int x = (this.canvasWidth >> 1) + 7;
            int y = (this.canvasHeight >> 1) + 97;
            int n = p % 10;
            g.drawImage(this.splashNumberImages[n], x -= this.splashNumberImages[n].getWidth() + 1, y, 36);
            if (p > 9) {
                n = p / 10 % 10;
                g.drawImage(this.splashNumberImages[n], x -= this.splashNumberImages[n].getWidth() + 1, y, 36);
                if (p > 99) {
                    g.drawImage(this.splashNumberImages[1], x -= this.splashNumberImages[1].getWidth() + 1, y, 36);
                }
            }
        }
    }

    private void drawBackground(Graphics g) {
        g.setColor(0xFDFDFD);
        g.fillRect(0, 0, this.canvasWidth, this.canvasHeight);
        g.setColor(10795263);
        g.fillRect(0, this.canvasHeight - this.displayDY, this.canvasWidth, this.displayDY);
        Sprite.drawImage(this.background, 93, 0, g, this.displayScale, this.displayDX, this.displayDY);
    }

    private void drawLevelNumber(Graphics g) {
        String levelNumber = "" + (this.levelManager.getLevelIndex() + 1);
        int x = 199 - (this.bubbleFont.stringWidth(levelNumber, this.displayScale) >> 1);
        int y = 433;
        this.bubbleFont.print(levelNumber, x, 433, g, this.displayScale, this.displayDX, this.displayDY);
    }

    private void drawMenuButton(Graphics g) {
        g.drawImage(this.menuButton.bmp, this.canvasWidth, this.canvasHeight, 40);
    }

    private void drawMenuScreen(Graphics g) {
        g.setColor(247, 179, 180);
        g.fillRect(0, 0, this.canvasWidth, this.canvasHeight);
        int y = 0;
        int x = 160;
        Sprite.drawImage(this.menuTitle, x, y, g, this.displayScale, this.displayDX, this.displayDY);
        y = 186;
        int ysp = 60;
        for (int i = 0; i < this.menu.size(); ++i) {
            this.printCentered(this.menu.getItem(i), y, g);
            y += ysp;
        }
    }

    private void printCentered(String s, int y, Graphics g) {
        int x = (640 - this.bubbleFont.stringWidth(s, this.displayScale)) / 2;
        this.bubbleFont.print(s, x, y, g, this.displayScale, this.displayDX, this.displayDY);
    }

    private void drawSettingsScreen(Graphics g) {
        g.setColor(247, 179, 180);
        g.fillRect(0, 0, this.canvasWidth, this.canvasHeight);
        int y = 58;
        int lineHeight = 26;
        int ysp = 80;
        this.printCentered(this.settingsMenu.getItem(0), y, g);
        this.printCentered(SettingsManager.isNormalMode() ? "off" : "on", y + lineHeight, g);
        this.printCentered(this.settingsMenu.getItem(1), y += ysp, g);
        this.printCentered(SettingsManager.isSoundOn() ? "on" : "off", y + lineHeight, g);
        this.printCentered(this.settingsMenu.getItem(2), y += ysp, g);
        this.printCentered(SettingsManager.isAimThenShoot() ? "off" : "on", y + lineHeight, g);
        this.printCentered(this.settingsMenu.getItem(3), y += ysp, g);
        this.printCentered(SettingsManager.isDontRushMe() ? "on" : "off", y + lineHeight, g);
        this.printCentered(this.settingsMenu.getItem(4), y += ysp + 11, g);
    }

    private void drawAboutScreen(Graphics g) {
        g.setColor(247, 179, 180);
        g.fillRect(0, 0, this.canvasWidth, this.canvasHeight);
        int x = 168;
        int y = 0;
        int height = 0;
        int ysp = 26;
        int ybr = 19;
        int dy = (int)Math.min(this.aboutDY, 0.0);
        for (int i = 0; i < this.aboutText.length * 2; ++i) {
            int ceil = (int)((double)y * this.displayScale + (double)this.displayDY + (double)dy);
            int floor = (int)((double)(y + 26) * this.displayScale + (double)this.displayDY + (double)dy);
            if (ceil > this.canvasHeight) break;
            String line = this.aboutText[i % this.aboutText.length];
            if (line == null) {
                y += 19;
            } else {
                if (floor > 0 && ceil < this.canvasHeight) {
                    this.bubbleFont.print(line, x, y, g, this.displayScale, this.displayDX, this.displayDY + dy);
                }
                y += 26;
            }
            if (i != this.aboutText.length - 1) continue;
            height = y;
        }
        double minDY = -((double)height * this.displayScale);
        this.aboutDY -= 1.0 * this.displayScale;
        if (this.aboutDY < minDY) {
            this.aboutDY -= minDY;
        }
        g.drawImage(this.backButton.bmp, this.canvasWidth, this.canvasHeight, 40);
    }

    private void drawGame(Graphics g) {
        this.drawBackground(g);
        this.drawLevelNumber(g);
        this.frozenGame.paint(g, this.displayScale, this.displayDX, this.displayDY);
        if (this.mode == 2) {
            g.fillRect(0, 0, this.canvasWidth, this.canvasHeight);
        }
        this.drawMenuButton(g);
    }

    private void updateGameState() {
        if (this.frozenGame.play(this.left || this.wasLeft, this.right || this.wasRight, this.fire || this.up || this.wasFire || this.wasUp, 0.0, this.touchFire, this.touchX, this.touchY, this.ATSTouchFire, this.ATSTouchDX)) {
            if (this.lifeManager.isDead()) {
                this.levelManager.goToFirstLevel();
                this.lifeManager.restart();
            }
            this.frozenGame = new FrozenGame(this.bubbles, this.bubblesBlind, this.frozenBubbles, this.targetedBubbles, this.bubbleBlink, this.gameWon, this.gameLost, this.hurry, this.penguins, this.compressorHead, this.compressor, this.launcher, this.soundManager, this.levelManager, this.lifeManager);
            this.instance.showMidBillboard();
        }
        this.wasLeft = false;
        this.wasRight = false;
        this.wasFire = false;
        this.wasUp = false;
        this.touchFire = false;
        this.ATSTouchFire = false;
        this.ATSTouchDX = 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void saveState() {
        try {
            RecordStore gameState = RecordStore.openRecordStore((String)"GameState", (boolean)true);
            if (gameState.getNumRecords() == 0) {
                gameState.addRecord(null, 0, 0);
            }
            ByteArrayOutputStream bout = null;
            try {
                bout = new ByteArrayOutputStream();
                DataOutputStream dout = new DataOutputStream(bout);
                this.frozenGame.saveState(dout);
                this.levelManager.saveState(dout);
                SettingsManager.saveState(dout);
                this.lifeManager.saveState(dout);
                byte[] data = bout.toByteArray();
                gameState.setRecord(this.getRecordId(gameState), data, 0, data.length);
                gameState.closeRecordStore();
            }
            catch (IOException e) {
            }
            finally {
                try {
                    if (bout != null) {
                        bout.close();
                    }
                }
                catch (IOException e) {}
            }
        }
        catch (Exception e) {
            try {
                RecordStore.deleteRecordStore((String)"GameState");
            }
            catch (RecordStoreException recordStoreException) {
                // empty catch block
            }
        }
    }

    private synchronized void restoreState() {
        this.rmsReady = false;
        try {
            RecordStore gameState = RecordStore.openRecordStore((String)"GameState", (boolean)true);
            if (gameState.getNumRecords() != 0) {
                try {
                    DataInputStream din = new DataInputStream(new ByteArrayInputStream(gameState.getRecord(this.getRecordId(gameState))));
                    this.frozenGame.restoreState(din, this.imageList);
                    this.levelManager.restoreState(din);
                    SettingsManager.restoreState(din);
                    this.lifeManager.restoreState(din);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            gameState.closeRecordStore();
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
        this.rmsReady = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getRecordId(RecordStore store) throws RecordStoreException {
        RecordEnumeration e = store.enumerateRecords(null, null, false);
        try {
            int n = e.nextRecordId();
            return n;
        }
        finally {
            e.destroy();
        }
    }

    private double xFromScr(float x) {
        return (double)(x - (float)this.displayDX) / this.displayScale;
    }

    private double yFromScr(float y) {
        return (double)(y - (float)this.displayDY) / this.displayScale;
    }

    private static Image pixelMixing(Image original, int newWidth, int newHeight) {
        int[] rawInput = new int[original.getHeight() * original.getWidth()];
        original.getRGB(rawInput, 0, original.getWidth(), 0, 0, original.getWidth(), original.getHeight());
        int[] rawOutput = new int[newWidth * newHeight];
        int oWidth = original.getWidth();
        int[] oX16 = new int[newWidth + 1];
        for (int newX = 0; newX <= newWidth; ++newX) {
            oX16[newX] = (newX * oWidth << 4) / newWidth;
        }
        int[] oXStartWidth = new int[newWidth];
        int[] oXEndWidth = new int[newWidth];
        for (int newX = 0; newX < newWidth; ++newX) {
            oXStartWidth[newX] = 16 - oX16[newX] % 16;
            oXEndWidth[newX] = oX16[newX + 1] % 16;
        }
        int oHeight = original.getHeight();
        int[] oY16 = new int[newHeight + 1];
        for (int newY = 0; newY <= newHeight; ++newY) {
            oY16[newY] = (newY * oHeight << 4) / newHeight;
        }
        for (int newY = 0; newY < newHeight; ++newY) {
            int oY16Start = oY16[newY];
            int oY16End = oY16[newY + 1];
            int oYStart = oY16Start >>> 4;
            int oYEnd = oY16End >>> 4;
            int oYStartHeight = 16 - oY16Start % 16;
            int oYEndHeight = oY16End % 16;
            for (int newX = 0; newX < newWidth; ++newX) {
                int oX16Start = oX16[newX];
                int oX16End = oX16[newX + 1];
                int oXStart = oX16Start >>> 4;
                int oXEnd = oX16End >>> 4;
                int outArea = 0;
                int outColorArea = 0;
                int outAlpha = 0;
                int outRed = 0;
                int outGreen = 0;
                int outBlue = 0;
                for (int j = oYStart; j <= oYEnd; ++j) {
                    int areaHeight = 16;
                    if (oYStart == oYEnd) {
                        areaHeight = oY16End - oY16Start;
                    } else if (j == oYStart) {
                        areaHeight = oYStartHeight;
                    } else if (j == oYEnd) {
                        areaHeight = oYEndHeight;
                    }
                    if (areaHeight == 0) continue;
                    for (int i = oXStart; i <= oXEnd; ++i) {
                        int areaWidth = 16;
                        if (oXStart == oXEnd) {
                            areaWidth = oX16End - oX16Start;
                        } else if (i == oXStart) {
                            areaWidth = oXStartWidth[newX];
                        } else if (i == oXEnd) {
                            areaWidth = oXEndWidth[newX];
                        }
                        if (areaWidth == 0) continue;
                        int area = areaWidth * areaHeight;
                        outArea += area;
                        int argb = rawInput[i + j * original.getWidth()];
                        int a2 = argb >>> 24;
                        if (a2 == 0) continue;
                        area = a2 * area;
                        outColorArea += area;
                        int r = (argb & 0xFF0000) >>> 16;
                        int g = (argb & 0xFF00) >>> 8;
                        int b = argb & 0xFF;
                        outRed += area * r;
                        outGreen += area * g;
                        outBlue += area * b;
                    }
                }
                if (outColorArea > 0) {
                    outAlpha = outColorArea / outArea;
                    outRed /= outColorArea;
                    outGreen /= outColorArea;
                    outBlue /= outColorArea;
                }
                rawOutput[newX + newY * newWidth] = outAlpha << 24 | outRed << 16 | outGreen << 8 | outBlue;
            }
        }
        return Image.createRGBImage((int[])rawOutput, (int)newWidth, (int)newHeight, (boolean)true);
    }

    private static Image bilinearInterpolation(Image original, int newWidth, int newHeight) {
        int[] rawInput = new int[original.getHeight() * original.getWidth()];
        original.getRGB(rawInput, 0, original.getWidth(), 0, 0, original.getWidth(), original.getHeight());
        int[] rawOutput = new int[newWidth * newHeight];
        int oWidth = original.getWidth();
        int[] oX16 = new int[newWidth];
        int max = oWidth - 1 << 4;
        for (int newX = 0; newX < newWidth; ++newX) {
            oX16[newX] = (((newX << 1) + 1) * oWidth << 3) / newWidth - 8;
            if (oX16[newX] < 0) {
                oX16[newX] = 0;
                continue;
            }
            if (oX16[newX] <= max) continue;
            oX16[newX] = max;
        }
        int oHeight = original.getHeight();
        int[] oY16 = new int[newHeight];
        max = oHeight - 1 << 4;
        for (int newY = 0; newY < newHeight; ++newY) {
            oY16[newY] = (((newY << 1) + 1) * oHeight << 3) / newHeight - 8;
            if (oY16[newY] < 0) {
                oY16[newY] = 0;
                continue;
            }
            if (oY16[newY] <= max) continue;
            oY16[newY] = max;
        }
        int[] oX = new int[2];
        int[] oY = new int[2];
        int[] wX = new int[2];
        int[] wY = new int[2];
        for (int newY = 0; newY < newHeight; ++newY) {
            oY[0] = oY16[newY] >>> 4;
            wY[1] = oY16[newY] & 0xF;
            wY[0] = 16 - wY[1];
            oY[1] = wY[1] == 0 ? oY[0] : oY[0] + 1;
            for (int newX = 0; newX < newWidth; ++newX) {
                oX[0] = oX16[newX] >>> 4;
                wX[1] = oX16[newX] & 0xF;
                wX[0] = 16 - wX[1];
                oX[1] = wX[1] == 0 ? oX[0] : oX[0] + 1;
                int outWeight = 0;
                int outColorWeight = 0;
                int outAlpha = 0;
                int outRed = 0;
                int outGreen = 0;
                int outBlue = 0;
                for (int j = 0; j < 2; ++j) {
                    for (int i = 0; i < 2; ++i) {
                        if (wY[j] == 0 || wX[i] == 0) continue;
                        int w = wX[i] * wY[j];
                        outWeight += w;
                        int argb = rawInput[oX[i] + oY[j] * original.getWidth()];
                        int a2 = argb >>> 24;
                        if (a2 == 0) continue;
                        w = a2 * w;
                        outColorWeight += w;
                        int r = (argb & 0xFF0000) >>> 16;
                        int g = (argb & 0xFF00) >>> 8;
                        int b = argb & 0xFF;
                        outRed += w * r;
                        outGreen += w * g;
                        outBlue += w * b;
                    }
                }
                if (outColorWeight > 0) {
                    outAlpha = outColorWeight / outWeight;
                    outRed /= outColorWeight;
                    outGreen /= outColorWeight;
                    outBlue /= outColorWeight;
                }
                rawOutput[newX + newY * newWidth] = outAlpha << 24 | outRed << 16 | outGreen << 8 | outBlue;
            }
        }
        return Image.createRGBImage((int[])rawOutput, (int)newWidth, (int)newHeight, (boolean)true);
    }

    private class ImageLoaderThread
    extends Thread {
        private boolean run = true;
        private final double displayScale;

        public ImageLoaderThread(double displayScale) {
            this.displayScale = displayScale;
        }

        public void run() {
            try {
                int i;
                FrozenCanvas.this.imagesLoaded = 0;
                for (i = 0; i < FrozenCanvas.this.frozenBubbles.length; ++i) {
                    this.scaleFrom(FrozenCanvas.this.frozenBubbles[i], "frozen_" + (i + 1) + ".gif");
                }
                for (i = 0; i < FrozenCanvas.this.targetedBubbles.length; ++i) {
                    this.scaleFrom(FrozenCanvas.this.targetedBubbles[i], "fixed_" + (i + 1) + ".gif");
                }
                this.scaleFrom(FrozenCanvas.this.bubbleBlink, "bubble_blink.gif");
                this.scaleFrom(FrozenCanvas.this.gameWon, "win_panel.png");
                this.scaleFrom(FrozenCanvas.this.gameLost, "lose_panel.png");
                this.scaleFrom(FrozenCanvas.this.hurry, "hurry.png");
                this.scaleFrom(FrozenCanvas.this.penguins, "penguins.png");
                this.scaleFrom(FrozenCanvas.this.compressorHead, "compressor.gif");
                this.scaleFrom(FrozenCanvas.this.compressor, "compressor_body.png");
                this.scaleFrom(FrozenCanvas.this.life, "life.gif");
                for (i = 0; i < FrozenCanvas.this.font.length; ++i) {
                    this.scaleFrom(FrozenCanvas.this.font[i], "simplefont/bubble_font_" + i + ".png", "font/bubble_font_" + i + ".gif");
                }
                for (i = 0; i < FrozenCanvas.this.launcher.length; ++i) {
                    this.scaleFrom(FrozenCanvas.this.launcher[i], "launcher/launcher_" + (i + 1) + ".png");
                }
                this.scaleFrom(FrozenCanvas.this.menuTitle, "menu.png");
                this.scaleFrom(FrozenCanvas.this.menuButton, "simple_menu_button.gif", "menu_button.gif");
                this.scaleFrom(FrozenCanvas.this.backButton, "simple_back_button.gif", "back_button.gif");
                this.scaleFrom(FrozenCanvas.this.background, "simple_background.jpg", "background.jpg");
                for (i = 0; i < FrozenCanvas.this.bubbles.length; ++i) {
                    this.scaleFrom(FrozenCanvas.this.bubbles[i], "bubble_" + (i + 1) + ".png");
                }
                for (i = 0; i < FrozenCanvas.this.bubblesBlind.length; ++i) {
                    this.scaleFrom(FrozenCanvas.this.bubblesBlind[i], "bubble_" + (i + 1) + ".png");
                }
                if (this.run) {
                    FrozenCanvas.this.imagesReady = true;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage());
            }
        }

        private void scaleFrom(BmpWrap image, String simpleResource, String resource) throws IOException {
            if (this.displayScale < 1.0) {
                try {
                    this.scaleFrom(image, simpleResource);
                }
                catch (IOException e) {
                    this.scaleFrom(image, resource);
                }
            } else {
                this.scaleFrom(image, resource);
            }
        }

        private void scaleFrom(BmpWrap image, String resource) throws IOException {
            if (!this.run) {
                return;
            }
            if (image.bmp != null && image.displayScale == this.displayScale) {
                FrozenCanvas.this.imagesLoaded++;
                return;
            }
            image.bmp = null;
            Image bmp = Image.createImage((String)("/image/" + resource));
            FrozenCanvas.this.imagesLoaded++;
            if (this.displayScale > 0.99999 && this.displayScale < 1.00001) {
                image.bmp = bmp;
                return;
            }
            int dstWidth = (int)((double)bmp.getWidth() * this.displayScale);
            int dstHeight = (int)((double)bmp.getHeight() * this.displayScale);
            bmp = this.displayScale > 1.0 ? FrozenCanvas.bilinearInterpolation(bmp, dstWidth, dstHeight) : FrozenCanvas.pixelMixing(bmp, dstWidth, dstHeight);
            if (!this.run) {
                return;
            }
            image.bmp = bmp;
            image.displayScale = this.displayScale;
        }

        public void cancel() {
            this.run = false;
        }
    }

    private class GameThread
    extends Thread {
        private boolean run = true;
        private final Graphics g;

        public GameThread(Graphics g) {
            this.g = g;
        }

        public void run() {
            long lastTime = 0L;
            while (this.run) {
                long now = System.currentTimeMillis();
                long delay = 40L + lastTime - now;
                if (delay < 1L) {
                    delay = 1L;
                }
                try {
                    GameThread.sleep(delay);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                FrozenCanvas.this.runGameLoop(this.g);
                lastTime = now;
            }
        }

        public void cancel() {
            this.run = false;
        }
    }
}

