/*
 * Decompiled with CFR 0.152.
 */
package com.innovazione.bubbleshoot;

import com.innovazione.bubbleshoot.BmpWrap;
import com.innovazione.bubbleshoot.BubbleManager;
import com.innovazione.bubbleshoot.BubbleSprite;
import com.innovazione.bubbleshoot.Compressor;
import com.innovazione.bubbleshoot.GameScreen;
import com.innovazione.bubbleshoot.ImageSprite;
import com.innovazione.bubbleshoot.LaunchBubbleSprite;
import com.innovazione.bubbleshoot.LevelManager;
import com.innovazione.bubbleshoot.LifeManager;
import com.innovazione.bubbleshoot.PenguinSprite;
import com.innovazione.bubbleshoot.Rect;
import com.innovazione.bubbleshoot.SettingsManager;
import com.innovazione.bubbleshoot.SoundManager;
import com.innovazione.bubbleshoot.Sprite;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class FrozenGame
extends GameScreen {
    public static final int HORIZONTAL_MOVE = 0;
    public static final int FIRE = 1;
    public static final int KEY_UP = 38;
    public static final int KEY_LEFT = 37;
    public static final int KEY_RIGHT = 39;
    private boolean levelCompleted = false;
    private BmpWrap[] bubbles;
    private BmpWrap[] bubblesBlind;
    private BmpWrap[] frozenBubbles;
    private BmpWrap[] targetedBubbles;
    private Random random = new Random(System.currentTimeMillis());
    private LaunchBubbleSprite launchBubble;
    private double launchBubblePosition;
    private PenguinSprite penguin;
    private Compressor compressor;
    private ImageSprite nextBubble;
    private int currentColor;
    private int nextColor;
    private BubbleSprite movingBubble;
    private BubbleManager bubbleManager;
    private LevelManager levelManager;
    private LifeManager lifeManager;
    private Vector jumping;
    private Vector falling;
    private BubbleSprite[][] bubblePlay;
    private int fixedBubbles;
    private double moveDown;
    private ImageSprite gameWonSprite;
    private ImageSprite gameLostSprite;
    private int nbBubbles;
    private BmpWrap bubbleBlink;
    private int blinkDelay;
    private ImageSprite hurrySprite;
    private int hurryTime;
    private SoundManager soundManager;
    private boolean readyToFire;
    private boolean endOfGame;
    private ImageSprite freezeLaunchBubble;
    private ImageSprite freezeNextBubble;
    private boolean frozenify;
    private int frozenifyX;
    private int frozenifyY;
    private BmpWrap[] launcher;
    private BmpWrap penguins;

    public FrozenGame(BmpWrap[] bubbles_arg, BmpWrap[] bubblesBlind_arg, BmpWrap[] frozenBubbles_arg, BmpWrap[] targetedBubbles_arg, BmpWrap bubbleBlink_arg, BmpWrap gameWon_arg, BmpWrap gameLost_arg, BmpWrap hurry_arg, BmpWrap penguins_arg, BmpWrap compressorHead_arg, BmpWrap compressor_arg, BmpWrap[] launcher_arg, SoundManager soundManager_arg, LevelManager levelManager_arg, LifeManager lifeManager_arg) {
        this.launcher = launcher_arg;
        this.penguins = penguins_arg;
        this.bubbles = bubbles_arg;
        this.bubblesBlind = bubblesBlind_arg;
        this.frozenBubbles = frozenBubbles_arg;
        this.targetedBubbles = targetedBubbles_arg;
        this.bubbleBlink = bubbleBlink_arg;
        this.gameWonSprite = new ImageSprite(new Rect(152, 190, 489, 306), gameWon_arg);
        this.gameLostSprite = new ImageSprite(new Rect(152, 190, 489, 306), gameLost_arg);
        this.soundManager = soundManager_arg;
        this.levelManager = levelManager_arg;
        this.lifeManager = lifeManager_arg;
        this.launchBubblePosition = 20.0;
        this.penguin = new PenguinSprite(penguins_arg, this.random);
        this.addSprite(this.penguin);
        this.compressor = new Compressor(compressorHead_arg, compressor_arg);
        this.hurrySprite = new ImageSprite(new Rect(203, 265, 443, 355), hurry_arg);
        this.jumping = new Vector();
        this.falling = new Vector();
        this.bubblePlay = new BubbleSprite[8][13];
        this.bubbleManager = new BubbleManager(this.bubbles);
        byte[][] currentLevel = this.levelManager.getCurrentLevel();
        if (currentLevel == null) {
            return;
        }
        for (int j = 0; j < 12; ++j) {
            for (int i = j % 2; i < 8; ++i) {
                BubbleSprite newOne;
                if (currentLevel[i][j] == -1) continue;
                this.bubblePlay[i][j] = newOne = new BubbleSprite(new Rect(190 + i * 32 - j % 2 * 16, 44 + j * 28, 32, 32), currentLevel[i][j], this.bubbles[currentLevel[i][j]], this.bubblesBlind[currentLevel[i][j]], this.frozenBubbles[currentLevel[i][j]], this.bubbleBlink, this.bubbleManager, this.soundManager, this);
                this.addSprite(newOne);
            }
        }
        this.currentColor = this.bubbleManager.nextBubbleIndex(this.random);
        this.nextColor = this.bubbleManager.nextBubbleIndex(this.random);
        this.nextBubble = SettingsManager.isNormalMode() ? new ImageSprite(new Rect(302, 440, 334, 472), this.bubbles[this.nextColor]) : new ImageSprite(new Rect(302, 440, 334, 472), this.bubblesBlind[this.nextColor]);
        this.addSprite(this.nextBubble);
        this.launchBubble = new LaunchBubbleSprite(this.currentColor, (int)this.launchBubblePosition, this.launcher, this.bubbles, this.bubblesBlind);
        this.spriteToBack(this.launchBubble);
        this.nbBubbles = 0;
    }

    public void saveState(DataOutputStream data) throws IOException {
        int i;
        Vector savedSprites = new Vector();
        data.writeInt(this.jumping.size());
        for (i = 0; i < this.jumping.size(); ++i) {
            ((Sprite)this.jumping.elementAt(i)).saveState(data, savedSprites);
        }
        data.writeInt(this.falling.size());
        for (i = 0; i < this.falling.size(); ++i) {
            ((Sprite)this.falling.elementAt(i)).saveState(data, savedSprites);
        }
        for (i = 0; i < 8; ++i) {
            for (int j = 0; j < 13; ++j) {
                if (this.bubblePlay[i][j] != null) {
                    this.bubblePlay[i][j].saveState(data, savedSprites);
                    continue;
                }
                data.writeInt(0);
            }
        }
        data.writeBoolean(this.movingBubble != null);
        if (this.movingBubble != null) {
            this.movingBubble.saveState(data, savedSprites);
        }
        data.writeBoolean(this.freezeLaunchBubble != null);
        if (this.freezeLaunchBubble != null) {
            this.freezeLaunchBubble.saveState(data, savedSprites);
        }
        data.writeBoolean(this.freezeNextBubble != null);
        if (this.freezeNextBubble != null) {
            this.freezeNextBubble.saveState(data, savedSprites);
        }
        this.launchBubble.saveState(data, savedSprites);
        this.penguin.saveState(data, savedSprites);
        this.compressor.saveState(data);
        this.nextBubble.saveState(data, savedSprites);
        this.bubbleManager.saveState(data);
        this.hurrySprite.saveState(data, savedSprites);
        this.gameWonSprite.saveState(data, savedSprites);
        this.gameLostSprite.saveState(data, savedSprites);
        data.writeDouble(this.launchBubblePosition);
        data.writeInt(this.currentColor);
        data.writeInt(this.nextColor);
        data.writeInt(this.fixedBubbles);
        data.writeDouble(this.moveDown);
        data.writeInt(this.nbBubbles);
        data.writeInt(this.blinkDelay);
        data.writeInt(this.hurryTime);
        data.writeBoolean(this.readyToFire);
        data.writeBoolean(this.endOfGame);
        data.writeBoolean(this.frozenify);
        data.writeInt(this.frozenifyX);
        data.writeInt(this.frozenifyY);
        data.writeBoolean(this.levelCompleted);
        this.saveSprites(data, savedSprites);
        for (i = 0; i < savedSprites.size(); ++i) {
            ((Sprite)savedSprites.elementAt(i)).clearSavedId();
        }
    }

    private Sprite restoreSprite(DataInputStream data, Vector imageList, Vector restoredSprites) throws IOException {
        int type = data.readInt();
        if (type == 0) {
            return null;
        }
        Sprite sprite = null;
        int left = data.readInt();
        int right = data.readInt();
        int top = data.readInt();
        int bottom = data.readInt();
        if (type == 1) {
            int color = data.readInt();
            double moveX = data.readDouble();
            double moveY = data.readDouble();
            double realX = data.readDouble();
            double realY = data.readDouble();
            boolean fixed = data.readBoolean();
            boolean blink = data.readBoolean();
            boolean released = data.readBoolean();
            boolean checkJump = data.readBoolean();
            boolean checkFall = data.readBoolean();
            int fixedAnim = data.readInt();
            boolean frozen = data.readBoolean();
            sprite = new BubbleSprite(new Rect(left, top, right, bottom), color, moveX, moveY, realX, realY, fixed, blink, released, checkJump, checkFall, fixedAnim, frozen ? this.frozenBubbles[color] : this.bubbles[color], this.bubblesBlind[color], this.frozenBubbles[color], this.targetedBubbles, this.bubbleBlink, this.bubbleManager, this.soundManager, this);
        } else if (type == 2) {
            int imageId = data.readInt();
            sprite = new ImageSprite(new Rect(left, top, right, bottom), (BmpWrap)imageList.elementAt(imageId));
        } else if (type == 3) {
            int currentColor = data.readInt();
            int currentDirection = data.readInt();
            sprite = new LaunchBubbleSprite(currentColor, currentDirection, this.launcher, this.bubbles, this.bubblesBlind);
        } else if (type == 4) {
            int currentPenguin = data.readInt();
            int count = data.readInt();
            int finalState = data.readInt();
            int nextPosition = data.readInt();
            sprite = new PenguinSprite(this.penguins, this.random, currentPenguin, count, finalState, nextPosition);
        }
        if (sprite != null) {
            restoredSprites.addElement(sprite);
        }
        return sprite;
    }

    public void restoreState(DataInputStream data, Vector imageList) throws IOException {
        int i;
        Vector restoredSprites = new Vector();
        int size = data.readInt();
        this.jumping = new Vector();
        for (i = 0; i < size; ++i) {
            this.jumping.addElement(this.restoreSprite(data, imageList, restoredSprites));
        }
        size = data.readInt();
        this.falling = new Vector();
        for (i = 0; i < size; ++i) {
            this.falling.addElement(this.restoreSprite(data, imageList, restoredSprites));
        }
        for (i = 0; i < 8; ++i) {
            for (int j = 0; j < 13; ++j) {
                this.bubblePlay[i][j] = (BubbleSprite)this.restoreSprite(data, imageList, restoredSprites);
            }
        }
        if (data.readBoolean()) {
            this.movingBubble = (BubbleSprite)this.restoreSprite(data, imageList, restoredSprites);
        }
        if (data.readBoolean()) {
            this.freezeLaunchBubble = (ImageSprite)this.restoreSprite(data, imageList, restoredSprites);
        }
        if (data.readBoolean()) {
            this.freezeNextBubble = (ImageSprite)this.restoreSprite(data, imageList, restoredSprites);
        }
        this.launchBubble = (LaunchBubbleSprite)this.restoreSprite(data, imageList, restoredSprites);
        this.penguin = (PenguinSprite)this.restoreSprite(data, imageList, restoredSprites);
        this.compressor.restoreState(data);
        this.nextBubble = (ImageSprite)this.restoreSprite(data, imageList, restoredSprites);
        this.bubbleManager.restoreState(data);
        this.hurrySprite = (ImageSprite)this.restoreSprite(data, imageList, restoredSprites);
        this.gameWonSprite = (ImageSprite)this.restoreSprite(data, imageList, restoredSprites);
        this.gameLostSprite = (ImageSprite)this.restoreSprite(data, imageList, restoredSprites);
        this.launchBubblePosition = data.readDouble();
        this.currentColor = data.readInt();
        this.nextColor = data.readInt();
        this.fixedBubbles = data.readInt();
        this.moveDown = data.readDouble();
        this.nbBubbles = data.readInt();
        this.blinkDelay = data.readInt();
        this.hurryTime = data.readInt();
        this.readyToFire = data.readBoolean();
        this.endOfGame = data.readBoolean();
        this.frozenify = data.readBoolean();
        this.frozenifyX = data.readInt();
        this.frozenifyY = data.readInt();
        this.levelCompleted = data.readBoolean();
        this.restoreSprites(data, restoredSprites);
    }

    private void initFrozenify() {
        this.freezeLaunchBubble = new ImageSprite(new Rect(301, 389, 34, 42), this.frozenBubbles[this.currentColor]);
        this.freezeNextBubble = new ImageSprite(new Rect(301, 439, 34, 42), this.frozenBubbles[this.nextColor]);
        this.addSprite(this.freezeLaunchBubble);
        this.addSprite(this.freezeNextBubble);
        this.frozenifyX = 7;
        this.frozenifyY = 12;
        this.frozenify = true;
        this.lifeManager.decrease();
    }

    private void frozenify() {
        --this.frozenifyX;
        if (this.frozenifyX < 0) {
            this.frozenifyX = 7;
            --this.frozenifyY;
            if (this.frozenifyY < 0) {
                this.frozenify = false;
                this.addSprite(this.gameLostSprite);
                this.soundManager.playSound(8);
                return;
            }
        }
        while (this.bubblePlay[this.frozenifyX][this.frozenifyY] == null && this.frozenifyY >= 0) {
            --this.frozenifyX;
            if (this.frozenifyX >= 0) continue;
            this.frozenifyX = 7;
            --this.frozenifyY;
            if (this.frozenifyY >= 0) continue;
            this.frozenify = false;
            this.addSprite(this.gameLostSprite);
            this.soundManager.playSound(8);
            return;
        }
        this.spriteToBack(this.bubblePlay[this.frozenifyX][this.frozenifyY]);
        this.bubblePlay[this.frozenifyX][this.frozenifyY].frozenify();
        this.spriteToBack(this.launchBubble);
    }

    public BubbleSprite[][] getGrid() {
        return this.bubblePlay;
    }

    public void addFallingBubble(BubbleSprite sprite) {
        this.spriteToFront(sprite);
        this.falling.addElement(sprite);
    }

    public void deleteFallingBubble(BubbleSprite sprite) {
        this.removeSprite(sprite);
        this.falling.removeElement(sprite);
    }

    public void addJumpingBubble(BubbleSprite sprite) {
        this.spriteToFront(sprite);
        this.jumping.addElement(sprite);
    }

    public void deleteJumpingBubble(BubbleSprite sprite) {
        this.removeSprite(sprite);
        this.jumping.removeElement(sprite);
    }

    public Random getRandom() {
        return this.random;
    }

    public double getMoveDown() {
        return this.moveDown;
    }

    private int nextColor() {
        int next = this.random.nextInt() % 8;
        if (next < 0) {
            return -next;
        }
        return next;
    }

    private void sendBubblesDown() {
        this.soundManager.playSound(7);
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 12; ++j) {
                if (this.bubblePlay[i][j] == null) continue;
                this.bubblePlay[i][j].moveDown();
                if (this.bubblePlay[i][j].getSpritePosition().y < 380) continue;
                this.penguin.updateState(5);
                this.endOfGame = true;
                this.initFrozenify();
                this.soundManager.playSound(1);
            }
        }
        this.moveDown += 28.0;
        this.compressor.moveDown();
    }

    private void blinkLine(int number) {
        int move = number % 2;
        int column = number + 1 >> 1;
        for (int i = move; i < 13; ++i) {
            if (this.bubblePlay[column][i] == null) continue;
            this.bubblePlay[column][i].blink();
        }
    }

    public boolean play(boolean key_left, boolean key_right, boolean key_fire, double trackball_dx, boolean touch_fire, double touch_x, double touch_y, boolean ats_touch_fire, double ats_touch_dx) {
        int i;
        boolean ats = SettingsManager.isAimThenShoot();
        if (ats && ats_touch_fire || !ats && touch_fire) {
            key_fire = true;
        }
        int[] move = new int[]{key_left && !key_right ? 37 : (key_right && !key_left ? 39 : 0), key_fire ? 38 : 0};
        if (!ats && touch_fire && this.movingBubble == null) {
            double xx = touch_x - 318.0;
            double yy = 406.0 - touch_y;
            this.launchBubblePosition = this.calcLaunchBubblePosition(xx, yy);
            if (this.launchBubblePosition < 1.0) {
                this.launchBubblePosition = 1.0;
            }
            if (this.launchBubblePosition > 39.0) {
                this.launchBubblePosition = 39.0;
            }
        }
        if (move[1] == 0 || !ats && touch_fire) {
            this.readyToFire = true;
        }
        if (SettingsManager.isDontRushMe()) {
            this.hurryTime = 1;
        }
        if (this.endOfGame) {
            if (move[1] == 38 && this.readyToFire) {
                if (this.levelCompleted) {
                    this.levelManager.goToNextLevel();
                }
                return true;
            }
            this.penguin.updateState(3);
            if (this.frozenify) {
                this.frozenify();
            }
        } else if (move[1] == 38 || this.hurryTime > 480) {
            if (this.movingBubble == null && this.readyToFire) {
                ++this.nbBubbles;
                this.movingBubble = new BubbleSprite(new Rect(302, 390, 32, 32), (int)this.launchBubblePosition, this.currentColor, this.bubbles[this.currentColor], this.bubblesBlind[this.currentColor], this.frozenBubbles[this.currentColor], this.targetedBubbles, this.bubbleBlink, this.bubbleManager, this.soundManager, this);
                this.addSprite(this.movingBubble);
                this.currentColor = this.nextColor;
                this.nextColor = this.bubbleManager.nextBubbleIndex(this.random);
                if (SettingsManager.isNormalMode()) {
                    this.nextBubble.changeImage(this.bubbles[this.nextColor]);
                } else {
                    this.nextBubble.changeImage(this.bubblesBlind[this.nextColor]);
                }
                this.launchBubble.changeColor(this.currentColor);
                this.penguin.updateState(2);
                this.soundManager.playSound(2);
                this.readyToFire = false;
                this.hurryTime = 0;
                this.removeSprite(this.hurrySprite);
            } else {
                this.penguin.updateState(3);
            }
        } else {
            double dx = 0.0;
            if (move[0] == 37) {
                dx -= 1.0;
            }
            if (move[0] == 39) {
                dx += 1.0;
            }
            dx += trackball_dx;
            if (ats) {
                dx += ats_touch_dx;
            }
            this.launchBubblePosition += dx;
            if (this.launchBubblePosition < 1.0) {
                this.launchBubblePosition = 1.0;
            }
            if (this.launchBubblePosition > 39.0) {
                this.launchBubblePosition = 39.0;
            }
            this.launchBubble.changeDirection((int)this.launchBubblePosition);
            if (dx < 0.0) {
                this.penguin.updateState(0);
            } else if (dx > 0.0) {
                this.penguin.updateState(1);
            } else {
                this.penguin.updateState(3);
            }
        }
        if (this.movingBubble != null) {
            this.movingBubble.move();
            if (this.movingBubble.fixed()) {
                if (this.movingBubble.getSpritePosition().y >= 380 && !this.movingBubble.released()) {
                    this.penguin.updateState(5);
                    this.endOfGame = true;
                    this.initFrozenify();
                    this.soundManager.playSound(1);
                } else if (this.bubbleManager.countBubbles() == 0) {
                    this.penguin.updateState(4);
                    this.addSprite(this.gameWonSprite);
                    if (!this.compressor.hasMoved()) {
                        this.lifeManager.increase();
                    }
                    this.levelCompleted = true;
                    this.endOfGame = true;
                    this.soundManager.playSound(0);
                } else {
                    ++this.fixedBubbles;
                    this.blinkDelay = 0;
                    if (this.fixedBubbles == 8) {
                        this.fixedBubbles = 0;
                        this.sendBubblesDown();
                    }
                }
                this.movingBubble = null;
            }
            if (this.movingBubble != null) {
                this.movingBubble.move();
                if (this.movingBubble.fixed()) {
                    if (this.movingBubble.getSpritePosition().y >= 380 && !this.movingBubble.released()) {
                        this.penguin.updateState(5);
                        this.endOfGame = true;
                        this.initFrozenify();
                        this.soundManager.playSound(1);
                    } else if (this.bubbleManager.countBubbles() == 0) {
                        this.penguin.updateState(4);
                        this.addSprite(this.gameWonSprite);
                        if (!this.compressor.hasMoved()) {
                            this.lifeManager.increase();
                        }
                        this.endOfGame = true;
                        this.levelCompleted = true;
                        this.soundManager.playSound(0);
                    } else {
                        ++this.fixedBubbles;
                        this.blinkDelay = 0;
                        if (this.fixedBubbles == 8) {
                            this.fixedBubbles = 0;
                            this.sendBubblesDown();
                        }
                    }
                    this.movingBubble = null;
                }
            }
        }
        if (this.movingBubble == null && !this.endOfGame) {
            ++this.hurryTime;
            if (this.hurryTime == 2) {
                this.removeSprite(this.hurrySprite);
            }
            if (this.hurryTime >= 240) {
                if (this.hurryTime % 40 == 10) {
                    this.addSprite(this.hurrySprite);
                    this.soundManager.playSound(6);
                } else if (this.hurryTime % 40 == 35) {
                    this.removeSprite(this.hurrySprite);
                }
            }
        }
        if (this.fixedBubbles == 6) {
            if (this.blinkDelay < 15) {
                this.blinkLine(this.blinkDelay);
            }
            ++this.blinkDelay;
            if (this.blinkDelay == 40) {
                this.blinkDelay = 0;
            }
        } else if (this.fixedBubbles == 7) {
            if (this.blinkDelay < 15) {
                this.blinkLine(this.blinkDelay);
            }
            ++this.blinkDelay;
            if (this.blinkDelay == 25) {
                this.blinkDelay = 0;
            }
        }
        for (i = 0; i < this.falling.size(); ++i) {
            ((BubbleSprite)this.falling.elementAt(i)).fall();
        }
        for (i = 0; i < this.jumping.size(); ++i) {
            ((BubbleSprite)this.jumping.elementAt(i)).jump();
        }
        return false;
    }

    private double calcLaunchBubblePosition(double x, double y) {
        return (Math.PI - this.atan2(y, x)) * 40.0 / Math.PI;
    }

    private double atan2(double y, double x) {
        double angle;
        double r;
        double coeff_1 = 0.7853981633974483;
        double coeff_2 = 3.0 * coeff_1;
        double abs_y = Math.abs(y) + (double)1.0E-10f;
        if (x >= 0.0) {
            r = (x - abs_y) / (x + abs_y);
            angle = coeff_1;
        } else {
            r = (x + abs_y) / (abs_y - x);
            angle = coeff_2;
        }
        return y < 0.0 ? -angle : (angle += ((double)0.1963f * r * r - (double)0.9817f) * r);
    }

    public void paint(Graphics g, double scale, int dx, int dy) {
        this.compressor.paint(g, scale, dx, dy);
        this.lifeManager.paint(g, scale, dx, dy);
        if (SettingsManager.isNormalMode()) {
            this.nextBubble.changeImage(this.bubbles[this.nextColor]);
        } else {
            this.nextBubble.changeImage(this.bubblesBlind[this.nextColor]);
        }
        super.paint(g, scale, dx, dy);
    }
}

