/*
 * Decompiled with CFR 0.152.
 */
package com.innovazione.bubbleshoot;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;

public class LevelManager {
    private int currentLevel;
    private Vector levelList;

    public void saveState(DataOutputStream data) throws IOException {
        data.writeInt(this.currentLevel);
    }

    public void restoreState(DataInputStream data) throws IOException {
        this.currentLevel = data.readInt();
    }

    public LevelManager(byte[] levels, int startingLevel) {
        String allLevels = new String(levels);
        this.currentLevel = startingLevel;
        this.levelList = new Vector();
        int nextLevel = allLevels.indexOf("\n\n");
        if (nextLevel == -1 && allLevels.trim().length() != 0) {
            nextLevel = allLevels.length();
        }
        while (nextLevel != -1) {
            String current = allLevels.substring(0, nextLevel).trim();
            this.levelList.addElement(this.getLevel(current));
            allLevels = allLevels.substring(nextLevel).trim();
            if (allLevels.length() == 0) {
                nextLevel = -1;
                continue;
            }
            nextLevel = allLevels.indexOf("\n\n");
            if (nextLevel != -1) continue;
            nextLevel = allLevels.length();
        }
        if (this.currentLevel >= this.levelList.size()) {
            this.currentLevel = 0;
        }
    }

    private byte[][] getLevel(String data) {
        byte[][] temp = new byte[8][12];
        for (int j = 0; j < 12; ++j) {
            for (int i = 0; i < 8; ++i) {
                temp[i][j] = -1;
            }
        }
        int tempX = 0;
        int tempY = 0;
        for (int i = 0; i < data.length(); ++i) {
            if (data.charAt(i) >= '0' && data.charAt(i) <= '7') {
                temp[tempX][tempY] = (byte)(data.charAt(i) - 48);
                ++tempX;
            } else if (data.charAt(i) == '-') {
                temp[tempX][tempY] = -1;
                ++tempX;
            }
            if (tempX != 8) continue;
            if (++tempY == 12) {
                return temp;
            }
            tempX = tempY % 2;
        }
        return temp;
    }

    public byte[][] getCurrentLevel() {
        if (this.currentLevel < this.levelList.size()) {
            return (byte[][])this.levelList.elementAt(this.currentLevel);
        }
        return null;
    }

    public void goToNextLevel() {
        ++this.currentLevel;
        if (this.currentLevel >= this.levelList.size()) {
            this.currentLevel = 0;
        }
    }

    public void goToFirstLevel() {
        this.currentLevel = 0;
    }

    public int getLevelIndex() {
        return this.currentLevel;
    }
}

