/*
 * Decompiled with CFR 0.152.
 */
package com.ratemyapp;

import com.nokia.mid.ui.locale.Locale;
import com.nokia.mid.ui.locale.LocaleManager;
import com.ratemyapp.FeedbackHelper;
import com.ratemyapp.LocalizedStrings;
import com.ratemyapp.RateMyAppListener;
import com.ratemyapp.UrlEncoder;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDlet;

public class RateMyApp {
    public static final String STRING_FEEDBACK_NO = "FeedbackNo";
    public static final String STRING_FEEDBACK_MESSAGE_1 = "FeedbackMessage1";
    public static final String STRING_FEEDBACK_TITLE = "FeedbackTitle";
    public static final String STRING_FEEDBACK_YES = "FeedbackYes";
    public static final String STRING_RATING_NO = "RatingNo";
    public static final String STRING_RATING_MESSAGE_1 = "RatingMessage1";
    public static final String STRING_RATING_MESSAGE_2 = "RatingMessage2";
    public static final String STRING_RATING_TITLE = "RatingTitle";
    public static final String STRING_RATING_YES = "RatingYes";
    public static final String STRING_FEEDBACK_BODY = "FeedbackBody";
    public static final String STRING_FEEDBACK_SUBJECT = "FeedbackSubject";
    private static RateMyApp instance = null;
    private static String languageOverride = null;
    private String appID = null;
    private MIDlet midlet = null;
    private FeedbackHelper feedbackHelper;
    private LocalizedStrings localizedStrings;
    private String feedbackEmailAddress = null;
    private Displayable appDisplayable = null;
    private RateMyAppListener listener = null;
    private RateMyAppCommandListener commandListener = null;
    private boolean visible = false;

    private RateMyApp(MIDlet midlet, String appID) {
        this.midlet = midlet;
        this.appID = appID;
        this.commandListener = new RateMyAppCommandListener();
        this.localizedStrings = new LocalizedStrings();
        this.feedbackHelper = new FeedbackHelper();
        this.asyncInitialize();
    }

    public MIDlet getMIDlet() {
        return this.midlet;
    }

    public String getAppID() {
        return this.appID;
    }

    public static RateMyApp getInstance() {
        return instance;
    }

    public static RateMyApp init(MIDlet midlet, String appId, RateMyAppListener listener) {
        return RateMyApp.init(midlet, appId, null, listener);
    }

    public static RateMyApp init(MIDlet midlet, String appId, String feedbackEmail, RateMyAppListener listener) {
        instance = new RateMyApp(midlet, appId);
        instance.setFeedbackEmailAddress(feedbackEmail);
        instance.setListener(listener);
        return instance;
    }

    public void setListener(RateMyAppListener listener) {
        this.listener = listener;
    }

    public static void setLanguageOverride(String language) {
        languageOverride = language;
    }

    public void setFeedbackEmailAddress(String emailAddress) {
        this.feedbackEmailAddress = emailAddress;
    }

    public void setFirstCount(int firstCount) {
        this.feedbackHelper.setFirstCount(firstCount);
    }

    public void setSecondCount(int secondCount) {
        this.feedbackHelper.setSecondCount(secondCount);
    }

    public void setCountDays(boolean countDays) {
        this.feedbackHelper.setCountDays(countDays);
    }

    public void setStringResource(String key, String value) {
        this.localizedStrings.setString(key, value);
    }

    private void setVisible(boolean visible) {
        if (this.visible != visible) {
            this.visible = visible;
            if (this.listener != null) {
                this.listener.rmaVisibilityChanged(visible);
            }
        }
    }

    private void showRatingDialog(String ratingMessageKey) {
        this.appDisplayable = Display.getDisplay((MIDlet)this.midlet).getCurrent();
        this.showAlert(this.formatText(this.localizedStrings.getString(STRING_RATING_TITLE), this.midlet.getAppProperty("MIDlet-Name")), this.localizedStrings.getString(ratingMessageKey), this.localizedStrings.getString(STRING_RATING_YES), this.localizedStrings.getString(STRING_RATING_NO));
    }

    private void showFeedback() {
        this.feedbackHelper.setState(4);
        this.showAlert(this.formatText(this.localizedStrings.getString(STRING_FEEDBACK_TITLE), this.midlet.getAppProperty("MIDlet-Name")), this.formatText(this.localizedStrings.getString(STRING_FEEDBACK_MESSAGE_1), this.midlet.getAppProperty("MIDlet-Name")), this.localizedStrings.getString(STRING_FEEDBACK_YES), this.localizedStrings.getString(STRING_FEEDBACK_NO));
    }

    private void showAlert(String title, String message, String okLabel, String cancelLabel) {
        Alert a2 = new Alert(title, message, null, AlertType.INFO);
        a2.addCommand(new Command(okLabel, 4, 1));
        a2.addCommand(new Command(cancelLabel, 3, 1));
        a2.setCommandListener((CommandListener)this.commandListener);
        Display.getDisplay((MIDlet)this.midlet).setCurrent(a2, this.appDisplayable);
        this.setVisible(true);
    }

    private String[] getPlatformProperties() {
        int modelSeparator;
        String[] properties = new String[6];
        String platform = System.getProperty("microedition.platform");
        if (platform != null && (modelSeparator = platform.indexOf(47)) >= 0) {
            String manufacturer = null;
            String hardwareVersion = null;
            String model = platform.substring(0, modelSeparator);
            String firmware = platform.substring(modelSeparator + 1);
            int hardwareVersionSeparator = model.indexOf(45);
            if (hardwareVersionSeparator >= 0) {
                hardwareVersion = model.substring(hardwareVersionSeparator + 1);
                model = model.substring(0, hardwareVersionSeparator);
            }
            if (model.indexOf("Nokia") == 0) {
                manufacturer = "Nokia";
                model = model.substring(5);
            }
            properties[0] = model;
            properties[1] = manufacturer;
            properties[2] = firmware;
            properties[3] = hardwareVersion;
        }
        properties[4] = this.midlet.getAppProperty("MIDlet-Version");
        properties[5] = this.midlet.getAppProperty("MIDlet-Vendor");
        return properties;
    }

    private String formatText(String text, String replacement) {
        return this.formatText(text, new String[]{replacement});
    }

    private String formatText(String text, String[] replacements) {
        int i = 0;
        while (i < replacements.length) {
            int matchIndex = text.indexOf("{" + i + "}");
            if (matchIndex >= 0) {
                text = String.valueOf(text.substring(0, matchIndex)) + (replacements[i] != null ? replacements[i] : "") + text.substring(matchIndex + String.valueOf(i).length() + 2);
            }
            ++i;
        }
        return text;
    }

    public void reset() {
        this.feedbackHelper.reset();
    }

    public void review() {
        try {
            this.feedbackHelper.review();
        }
        catch (Exception e) {
            Alert a2 = new Alert("Error", "The Nokia Store client could not be correctly opened", null, AlertType.ERROR);
            Display.getDisplay((MIDlet)this.midlet).setCurrent(a2, this.appDisplayable);
        }
    }

    private void asyncInitialize() {
        new Thread(new Runnable(){

            public void run() {
                RateMyApp.this.initialize();
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        String resourceCode;
        this.feedbackHelper.loadState();
        String string = resourceCode = languageOverride != null ? languageOverride : RateMyApp.resourceCodeFromLocale(LocaleManager.getInstance().getDefaultLocale());
        if (!this.localizedStrings.readResources(resourceCode) && resourceCode != null) {
            this.localizedStrings.readResources(null);
        }
        while (Display.getDisplay((MIDlet)this.midlet).getCurrent() == null) {
            try {
                RateMyApp rateMyApp = this;
                synchronized (rateMyApp) {
                    this.wait(100L);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.listener == null) {
            this.launch();
        } else {
            this.listener.rmaComponentReady();
        }
    }

    private static String resourceCodeFromLocale(Locale locale) {
        if (locale == null) {
            return null;
        }
        String resourceCode = "";
        if (locale.getLanguage() != null) {
            resourceCode = String.valueOf(resourceCode) + locale.getLanguage();
            String country = locale.getCountry();
            if (country != null && country.length() > 0) {
                resourceCode = String.valueOf(resourceCode) + "-" + country;
            }
        }
        return resourceCode;
    }

    public void launch() {
        this.feedbackHelper.launch();
        if (this.feedbackHelper.getState() == 2) {
            this.showRatingDialog(STRING_RATING_MESSAGE_1);
        } else if (this.feedbackHelper.getState() == 3) {
            this.showRatingDialog(STRING_RATING_MESSAGE_2);
        } else {
            this.feedbackHelper.setState(0);
        }
    }

    private void feedback() {
        try {
            RateMyApp.getInstance().getMIDlet().platformRequest("mailto:" + this.feedbackEmailAddress + "?subject=" + UrlEncoder.encode(this.formatText(this.localizedStrings.getString(STRING_FEEDBACK_SUBJECT), this.midlet.getAppProperty("MIDlet-Name"))) + "&body=" + UrlEncoder.encode(this.formatText(this.localizedStrings.getString(STRING_FEEDBACK_BODY), this.getPlatformProperties())));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class RateMyAppCommandListener
    implements CommandListener {
        RateMyAppCommandListener() {
        }

        public void commandAction(Command c, Displayable d) {
            int state = RateMyApp.this.feedbackHelper.getState();
            if (c.getCommandType() == 4) {
                Display.getDisplay((MIDlet)RateMyApp.this.midlet).setCurrent(RateMyApp.this.appDisplayable);
                RateMyApp.this.setVisible(false);
                switch (state) {
                    case 2: 
                    case 3: {
                        RateMyApp.this.review();
                        break;
                    }
                    case 4: {
                        RateMyApp.this.feedback();
                    }
                }
                RateMyApp.this.feedbackHelper.setState(0);
            } else {
                switch (state) {
                    case 2: {
                        if (RateMyApp.this.feedbackEmailAddress != null) {
                            RateMyApp.this.showFeedback();
                            break;
                        }
                    }
                    default: {
                        RateMyApp.this.feedbackHelper.setState(0);
                        Display.getDisplay((MIDlet)RateMyApp.this.midlet).setCurrent(RateMyApp.this.appDisplayable);
                        RateMyApp.this.setVisible(false);
                    }
                }
            }
        }
    }
}

