/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;

class SnakeCanvas
extends Canvas
implements CommandListener {
    Command cmdPause;
    Command cmdResume;
    Command cmdMenu;
    int[] kierQ;
    int kierS;
    int kierE;
    static final int KIER_Q_SIZE = 8;
    static final int kLewo = 0;
    static final int kGora = 1;
    static final int kPrawo = 2;
    static final int kDol = 3;
    static final int KEY_UP = -1;
    static final int KEY_DOWN = -2;
    static final int KEY_LEFT = -3;
    static final int KEY_RIGHT = -4;
    int frameoffx;
    int frameoffy;
    int framewidth;
    int frameheight;
    int blockw;
    int blockh;
    int textoffy;
    int kier;
    int d;
    int x;
    int y;
    int[] xtab;
    int[] ytab;
    Timer timer;
    Snake m;
    int wynik;
    int wm;
    int applecolor;
    public int pauza;
    final int interval;
    boolean konczymy;
    boolean screenPrepared;
    boolean wall;

    private void prepareScreen(int n, int n2, int n3) {
        this.blockw = (n - 3) / 25;
        this.blockh = (n2 - n3 - 5) / 18;
        if (this.blockw < this.blockh) {
            this.blockh = this.blockw;
        } else {
            this.blockw = this.blockh;
        }
        this.framewidth = this.blockw * 25 + 3;
        this.frameheight = this.blockh * 18 + 3;
        this.frameoffx = (n - this.framewidth) / 2;
        this.frameoffy = (n2 - n3 - 2 - this.frameheight) / 2;
        if (this.frameoffy > this.frameoffx) {
            this.frameoffy = this.frameoffx;
        }
        this.textoffy = (n2 + this.frameheight + 2 * this.frameoffy - n3) / 2;
        this.applecolor = this.m.d.isColor() ? 0xFF0000 : 0xFFFFFF;
    }

    public void updateLocale() {
        if (this.pauza == 1) {
            this.removeCommand(this.cmdResume);
        } else {
            this.removeCommand(this.cmdPause);
        }
        this.removeCommand(this.cmdMenu);
        this.cmdPause = new Command(this.m.PAUSE_CMD, 1, 1);
        this.cmdResume = new Command(this.m.RESUME, 1, 1);
        this.cmdMenu = new Command(this.m.MENU, 6, 1);
        if (this.pauza == 1) {
            this.addCommand(this.cmdResume);
        } else {
            this.addCommand(this.cmdPause);
        }
        this.addCommand(this.cmdMenu);
    }

    public SnakeCanvas(Snake snake, int n, int n2, boolean bl) {
        this.wall = bl;
        this.screenPrepared = false;
        this.interval = n;
        this.kierQ = new int[8];
        this.kierS = 0;
        this.kierE = 0;
        this.timer = new Timer();
        this.timer.schedule((TimerTask)new SnakeTimer(this), 0L, (long)this.interval);
        this.m = snake;
        this.kier = 2;
        this.xtab = new int[450];
        this.ytab = new int[450];
        for (int i = 0; i < 450; ++i) {
            this.ytab[i] = -100;
            this.xtab[i] = -100;
        }
        this.xtab[0] = 5;
        this.ytab[0] = 5;
        this.d = 5;
        this.wynik = 0;
        this.y = 10;
        this.x = 10;
        this.wm = n2;
        this.pauza = this.isShown() ? -3000 / this.interval : 1;
        this.konczymy = false;
        this.cmdPause = new Command(this.m.PAUSE_CMD, 1, 1);
        this.cmdResume = new Command(this.m.RESUME, 1, 1);
        this.cmdMenu = new Command(this.m.MENU, 6, 1);
        this.addCommand(this.cmdPause);
        this.addCommand(this.cmdMenu);
        this.setCommandListener(this);
    }

    public SnakeCanvas(Snake snake, DataInputStream dataInputStream) throws IOException {
        int n;
        this.screenPrepared = false;
        this.m = snake;
        this.kier = dataInputStream.readInt();
        this.d = dataInputStream.readInt();
        this.wynik = dataInputStream.readInt();
        this.wm = dataInputStream.readInt();
        this.interval = dataInputStream.readInt();
        this.x = dataInputStream.readInt();
        this.y = dataInputStream.readInt();
        this.wall = dataInputStream.readBoolean();
        this.xtab = new int[450];
        this.ytab = new int[450];
        for (n = 0; n < this.d; ++n) {
            this.xtab[n] = dataInputStream.readInt();
            this.ytab[n] = dataInputStream.readInt();
        }
        for (n = this.d; n < 450; ++n) {
            this.ytab[n] = -100;
            this.xtab[n] = -100;
        }
        this.konczymy = false;
        this.pauza = this.isShown() ? -3000 / this.interval : 1;
        this.kierQ = new int[8];
        this.kierS = 0;
        this.kierE = 0;
        this.timer = new Timer();
        this.timer.schedule((TimerTask)new SnakeTimer(this), 0L, (long)this.interval);
        this.cmdPause = new Command(this.m.PAUSE_CMD, 1, 1);
        this.cmdResume = new Command(this.m.RESUME, 1, 1);
        this.cmdMenu = new Command(this.m.MENU, 6, 1);
        this.addCommand(this.cmdPause);
        this.addCommand(this.cmdMenu);
        this.setCommandListener(this);
    }

    public void saveState(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.kier);
        dataOutputStream.writeInt(this.d);
        dataOutputStream.writeInt(this.wynik);
        dataOutputStream.writeInt(this.wm);
        dataOutputStream.writeInt(this.interval);
        dataOutputStream.writeInt(this.x);
        dataOutputStream.writeInt(this.y);
        dataOutputStream.writeBoolean(this.wall);
        for (int i = 0; i < this.d; ++i) {
            dataOutputStream.writeInt(this.xtab[i]);
            dataOutputStream.writeInt(this.ytab[i]);
        }
    }

    protected void paint(Graphics graphics) {
        int n;
        if (!this.screenPrepared) {
            this.prepareScreen(this.getWidth(), this.getHeight(), graphics.getFont().getHeight());
            this.screenPrepared = true;
        }
        graphics.setColor(0);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics.setColor(0xFFFFFF);
        graphics.drawRect(this.frameoffx, this.frameoffy, this.framewidth - 1, this.frameheight - 1);
        for (n = 0; n < this.d; ++n) {
            graphics.fillRect(this.frameoffx + 2 + this.xtab[n] * this.blockw, this.frameoffy + 2 + this.ytab[n] * this.blockh, this.blockw - 1, this.blockh - 1);
        }
        for (n = 1; n < this.d; ++n) {
            if (this.xtab[n] == this.xtab[n - 1] + 1) {
                graphics.fillRect(this.frameoffx + 1 + this.xtab[n] * this.blockw, this.frameoffy + 2 + this.ytab[n] * this.blockh, 1, this.blockh - 1);
                continue;
            }
            if (this.xtab[n] == this.xtab[n - 1] - 1) {
                graphics.fillRect(this.frameoffx + 1 + this.blockw + this.xtab[n] * this.blockw, this.frameoffy + 2 + this.ytab[n] * this.blockh, 1, this.blockh - 1);
                continue;
            }
            if (this.ytab[n] == this.ytab[n - 1] + 1) {
                graphics.fillRect(this.frameoffx + 2 + this.xtab[n] * this.blockw, this.frameoffy + 1 + this.ytab[n] * this.blockh, this.blockw - 1, 1);
                continue;
            }
            if (this.ytab[n] != this.ytab[n - 1] - 1) continue;
            graphics.fillRect(this.frameoffx + 2 + this.xtab[n] * this.blockw, this.frameoffy + 1 + this.blockh + this.ytab[n] * this.blockh, this.blockw - 1, 1);
        }
        graphics.drawString(this.m.SCORE + ": " + this.wynik, this.frameoffx + 3, this.textoffy, 0x10 | 4);
        if (this.pauza == 1) {
            graphics.drawString(this.m.PAUSE, this.frameoffx + this.framewidth - 3, this.textoffy, 0x10 | 8);
        } else if (this.pauza < 0) {
            graphics.drawString(this.m.PAUSE + ": " + (-this.pauza * this.interval / 1000 + (-this.pauza * this.interval % 1000 == 0 ? 0 : 1)), this.frameoffx + this.framewidth - 3, this.textoffy, 0x10 | 8);
        }
        graphics.setColor(0);
        if (this.blockw > 3 && this.blockh > 3) {
            switch (this.kier) {
                case 0: {
                    graphics.drawLine(this.frameoffx + 2 + this.xtab[0] * this.blockw, this.frameoffy + 2 + this.ytab[0] * this.blockh, this.frameoffx + 2 + this.xtab[0] * this.blockw, this.frameoffy + 2 + this.ytab[0] * this.blockh);
                    graphics.drawLine(this.frameoffx + 2 + this.xtab[0] * this.blockw, this.frameoffy + this.blockh + this.ytab[0] * this.blockh, this.frameoffx + 2 + this.xtab[0] * this.blockw, this.frameoffy + this.blockh + this.ytab[0] * this.blockh);
                    break;
                }
                case 2: {
                    graphics.drawLine(this.frameoffx + this.blockw + this.xtab[0] * this.blockw, this.frameoffy + 2 + this.ytab[0] * this.blockh, this.frameoffx + this.blockw + this.xtab[0] * this.blockw, this.frameoffy + 2 + this.ytab[0] * this.blockh);
                    graphics.drawLine(this.frameoffx + this.blockw + this.xtab[0] * this.blockw, this.frameoffy + this.blockh + this.ytab[0] * this.blockh, this.frameoffx + this.blockw + this.xtab[0] * this.blockw, this.frameoffy + this.blockh + this.ytab[0] * this.blockh);
                    break;
                }
                case 1: {
                    graphics.drawLine(this.frameoffx + 2 + this.xtab[0] * this.blockw, this.frameoffy + 2 + this.ytab[0] * this.blockh, this.frameoffx + 2 + this.xtab[0] * this.blockw, this.frameoffy + 2 + this.ytab[0] * this.blockh);
                    graphics.drawLine(this.frameoffx + this.blockw + this.xtab[0] * this.blockw, this.frameoffy + 2 + this.ytab[0] * this.blockh, this.frameoffx + this.blockw + this.xtab[0] * this.blockw, this.frameoffy + 2 + this.ytab[0] * this.blockh);
                    break;
                }
                case 3: {
                    graphics.drawLine(this.frameoffx + 2 + this.xtab[0] * this.blockw, this.frameoffy + this.blockh + this.ytab[0] * this.blockh, this.frameoffx + 2 + this.xtab[0] * this.blockw, this.frameoffy + this.blockh + this.ytab[0] * this.blockh);
                    graphics.drawLine(this.frameoffx + this.blockw + this.xtab[0] * this.blockw, this.frameoffy + this.blockh + this.ytab[0] * this.blockh, this.frameoffx + this.blockw + this.xtab[0] * this.blockw, this.frameoffy + this.blockh + this.ytab[0] * this.blockh);
                }
            }
        }
        graphics.setColor(this.applecolor);
        graphics.drawLine(this.frameoffx + 3 + this.x * this.blockw, this.frameoffy + 2 + this.y * this.blockh, this.frameoffx + this.blockw - 1 + this.x * this.blockw, this.frameoffy + 2 + this.y * this.blockh);
        graphics.drawLine(this.frameoffx + 3 + this.x * this.blockw, this.frameoffy + this.blockh + this.y * this.blockh, this.frameoffx + this.blockw - 1 + this.x * this.blockw, this.frameoffy + this.blockh + this.y * this.blockh);
        graphics.drawLine(this.frameoffx + 2 + this.x * this.blockw, this.frameoffy + 3 + this.y * this.blockh, this.frameoffx + 2 + this.x * this.blockw, this.frameoffy + this.blockh - 1 + this.y * this.blockh);
        graphics.drawLine(this.frameoffx + this.blockw + this.x * this.blockw, this.frameoffy + 3 + this.y * this.blockh, this.frameoffx + this.blockw + this.x * this.blockw, this.frameoffy + this.blockh - 1 + this.y * this.blockh);
    }

    void timerEvent() {
        int n;
        if (this.pauza < 0) {
            this.repaint();
            ++this.pauza;
            return;
        }
        if (this.pauza == 1) {
            this.repaint();
            return;
        }
        boolean bl = false;
        if (this.kierS != this.kierE) {
            this.kier = this.kierQ[this.kierS++];
            this.kierS %= 8;
        }
        if ((this.kier == 0 && this.xtab[0] == 0 || this.kier == 2 && this.xtab[0] == 24 || this.kier == 1 && this.ytab[0] == 0 || this.kier == 3 && this.ytab[0] == 17) && this.wall) {
            bl = true;
        }
        for (n = 1; n < this.d && !bl; ++n) {
            if (!(this.kier == 0 && this.xtab[0] == this.xtab[n] + 1 && this.ytab[0] == this.ytab[n] || this.kier == 2 && this.xtab[0] == this.xtab[n] - 1 && this.ytab[0] == this.ytab[n] || this.kier == 1 && this.ytab[0] == this.ytab[n] + 1 && this.xtab[0] == this.xtab[n]) && (this.kier != 3 || this.ytab[0] != this.ytab[n] - 1 || this.xtab[0] != this.xtab[n])) continue;
            bl = true;
        }
        if (!bl) {
            for (n = this.d - 1; n >= 1; --n) {
                this.xtab[n] = this.xtab[n - 1];
                this.ytab[n] = this.ytab[n - 1];
            }
            switch (this.kier) {
                case 0: {
                    this.xtab[0] = this.xtab[0] - 1;
                    if (this.xtab[0] != -1) break;
                    this.xtab[0] = 24;
                    break;
                }
                case 2: {
                    this.xtab[0] = this.xtab[0] + 1;
                    if (this.xtab[0] != 25) break;
                    this.xtab[0] = 0;
                    break;
                }
                case 1: {
                    this.ytab[0] = this.ytab[0] - 1;
                    if (this.ytab[0] != -1) break;
                    this.ytab[0] = 17;
                    break;
                }
                case 3: {
                    this.ytab[0] = this.ytab[0] + 1;
                    if (this.ytab[0] != 18) break;
                    this.ytab[0] = 0;
                }
            }
            if (this.xtab[0] == this.x && this.ytab[0] == this.y) {
                boolean bl2;
                SnakeRandom snakeRandom = new SnakeRandom();
                do {
                    int n2 = snakeRandom.next(8) + snakeRandom.next(7) + snakeRandom.next(6) + snakeRandom.next(2) + snakeRandom.next(1);
                    this.x = n2 % 25;
                    this.y = n2 / 25;
                    bl2 = false;
                    for (int i = 0; i < this.d; ++i) {
                        if (this.xtab[i] != this.x || this.ytab[i] != this.y) continue;
                        bl2 = true;
                    }
                } while (bl2);
                this.d += 2;
                this.wynik += this.wm;
            }
            this.repaint();
        } else {
            this.timer.cancel();
            this.konczymy = true;
            this.m.snakeFinished(this.wynik);
        }
    }

    protected void keyPressed(int n) {
        if (this.pauza == 1) {
            this.removeCommand(this.cmdResume);
            this.addCommand(this.cmdPause);
        }
        this.pauza = 0;
        int n2 = this.kierS == this.kierE ? this.kier : this.kierQ[(this.kierE + 8 - 1) % 8];
        switch (n) {
            case -1: 
            case 50: {
                if (n2 == 3) break;
                this.kierQ[this.kierE++] = 1;
                this.kierE %= 8;
                break;
            }
            case -4: 
            case 54: {
                if (n2 == 0) break;
                this.kierQ[this.kierE++] = 2;
                this.kierE %= 8;
                break;
            }
            case -2: 
            case 56: {
                if (n2 == 1) break;
                this.kierQ[this.kierE++] = 3;
                this.kierE %= 8;
                break;
            }
            case -3: 
            case 52: {
                if (n2 == 2) break;
                this.kierQ[this.kierE++] = 0;
                this.kierE %= 8;
                break;
            }
            case 49: {
                if (n2 == 0 || n2 == 2) {
                    this.kierQ[this.kierE++] = 1;
                    this.kierE %= 8;
                    break;
                }
                this.kierQ[this.kierE++] = 0;
                this.kierE %= 8;
                break;
            }
            case 51: {
                if (n2 == 0 || n2 == 2) {
                    this.kierQ[this.kierE++] = 1;
                    this.kierE %= 8;
                    break;
                }
                this.kierQ[this.kierE++] = 2;
                this.kierE %= 8;
                break;
            }
            case 55: {
                if (n2 == 0 || n2 == 2) {
                    this.kierQ[this.kierE++] = 3;
                    this.kierE %= 8;
                    break;
                }
                this.kierQ[this.kierE++] = 0;
                this.kierE %= 8;
                break;
            }
            case 57: {
                if (n2 == 0 || n2 == 2) {
                    this.kierQ[this.kierE++] = 3;
                    this.kierE %= 8;
                    break;
                }
                this.kierQ[this.kierE++] = 2;
                this.kierE %= 8;
                break;
            }
            case 42: {
                switch (n2) {
                    case 0: {
                        this.kierQ[this.kierE++] = 3;
                        break;
                    }
                    case 3: {
                        this.kierQ[this.kierE++] = 2;
                        break;
                    }
                    case 2: {
                        this.kierQ[this.kierE++] = 1;
                        break;
                    }
                    case 1: {
                        this.kierQ[this.kierE++] = 0;
                    }
                }
                this.kierE %= 8;
                break;
            }
            case 35: {
                switch (n2) {
                    case 0: {
                        this.kierQ[this.kierE++] = 1;
                        break;
                    }
                    case 1: {
                        this.kierQ[this.kierE++] = 2;
                        break;
                    }
                    case 2: {
                        this.kierQ[this.kierE++] = 3;
                        break;
                    }
                    case 3: {
                        this.kierQ[this.kierE++] = 0;
                    }
                }
                this.kierE %= 8;
            }
        }
    }

    protected void hideNotify() {
        this.pauza = 1;
    }

    protected void showNotify() {
        if (this.konczymy) {
            this.m.snakeFinished(-1);
        } else {
            this.pauza = -3000 / this.interval;
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.cmdPause) {
            this.kierS = this.kierE;
            this.pauza = 1;
            this.removeCommand(this.cmdPause);
            this.addCommand(this.cmdResume);
        } else if (command == this.cmdResume) {
            this.kierS = this.kierE;
            this.pauza = 0;
            this.removeCommand(this.cmdResume);
            this.addCommand(this.cmdPause);
        } else if (command == this.cmdMenu) {
            this.m.showMenu();
        }
    }

    protected void sizeChanged(int n, int n2) {
        this.screenPrepared = false;
    }

    class SnakeRandom
    extends Random {
        SnakeRandom() {
        }

        public int next(int n) {
            return super.next(n);
        }
    }

    class SnakeTimer
    extends TimerTask {
        SnakeCanvas parent;

        SnakeTimer(SnakeCanvas snakeCanvas2) {
            this.parent = snakeCanvas2;
        }

        public void run() {
            this.parent.timerEvent();
        }
    }
}

