/*
 * Decompiled with CFR 0.152.
 */
public class HScrollBar {
    private boolean stopping;
    private int pScroll;
    private int lX;
    private int wX;
    private int wY;
    private int wWidth;
    private int wHeight;
    private int value;
    private int mValue;
    private int sHeight;
    private int dir;
    private int bx;
    private float sAspect;
    private float sSpeed;
    private float sTime;
    private long lTime;

    public HScrollBar(int wX, int wY, int wWidth, int wHeight, int mValue, int extent) {
        this.wX = wX;
        this.wY = wY;
        this.wWidth = wWidth;
        this.wHeight = wHeight;
        this.mValue = mValue;
        this.sHeight = (int)((float)wHeight * ((float)wHeight / (float)extent));
        this.sAspect = (float)(wHeight - this.sHeight) / (float)mValue;
    }

    public void init() {
        this.value = 0;
        this.pScroll = 0;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        if (value < 0) {
            value = 0;
        }
        if (value > this.mValue) {
            value = this.mValue;
        }
        this.value = value;
        this.pScroll = (int)((float)value * this.sAspect);
    }

    public void pCheck(float fps_time, int pX, int pY, int rX, int rY, int dX, int dY) {
        if (Wand.region(pX, pY, this.wX, this.wY, this.wWidth, this.wHeight)) {
            this.lX = pX;
            this.dir = 0;
            this.bx = 0;
            this.sSpeed = this.sTime = (float)0;
            this.stopping = false;
            this.lTime = System.currentTimeMillis();
        }
        if (Wand.region(dX, dY, this.wX, this.wY, this.wWidth, this.wHeight)) {
            this.pScroll += this.lX - dX;
            if (this.pScroll < 0) {
                this.pScroll = 0;
            }
            if (this.pScroll > this.wHeight - this.sHeight) {
                this.pScroll = this.wHeight - this.sHeight;
            }
            this.value = (int)((float)this.pScroll / this.sAspect);
            float distance = (float)Math.sqrt((dX - this.lX) * (dX - this.lX));
            float time = (float)(System.currentTimeMillis() - this.lTime) / 1000.0f;
            this.lTime = System.currentTimeMillis();
            if (time != 0.0f) {
                this.sSpeed = distance / time;
            }
            if (this.lX < dX) {
                this.dir = 1;
            }
            if (this.lX > dX) {
                this.dir = 2;
            }
            this.lX = dX;
        }
        if ((Wand.region(rX, rY, this.wX, this.wY, this.wWidth, this.wHeight) || this.stopping) && this.sSpeed != 0.0f) {
            int x = (int)(this.sSpeed * this.sTime - 1000.0f * (this.sTime * this.sTime) / 2.0f);
            if (x >= this.bx) {
                this.sTime += fps_time;
                if (this.dir == 1) {
                    this.pScroll -= x - this.bx;
                }
                if (this.dir == 2) {
                    this.pScroll += x - this.bx;
                }
                if (this.pScroll < 0) {
                    this.pScroll = 0;
                }
                if (this.pScroll > this.wHeight - this.sHeight) {
                    this.pScroll = this.wHeight - this.sHeight;
                }
                this.value = (int)((float)this.pScroll / this.sAspect);
                this.bx = x;
                this.stopping = true;
            } else {
                this.stopping = false;
            }
        }
    }
}

