/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class InputBox {
    private boolean isSelect;
    private boolean isLockKeyboard;
    private boolean write;
    private boolean showBlink;
    private boolean addLetter;
    private boolean userNameWrite;
    private int mode;
    private int width;
    private int height;
    private int bIndex;
    private int sDistance;
    private int bDistance;
    private int cLetter;
    private int lMode = 1;
    private int[] clip;
    private long time;
    private long ptime;
    private char[] lLast;
    private char[][][] letters;
    private String value;
    private StringBuffer buff;
    private DrawText dt;
    public static final int STRING = 1;
    public static final int NUMERIC = 2;

    public InputBox(int wSize, int hSize, String value, int mode, DrawText dt) {
        this.value = value;
        this.mode = mode;
        this.dt = dt;
        this.width = wSize;
        this.height = hSize;
        this.buff = new StringBuffer(value);
        this.bIndex = value.length();
        this.letters = new char[2][][];
        this.letters[0] = new char[][]{{'A', 'B', 'C'}, {'D', 'E', 'F'}, {'G', 'H', 'I'}, {'J', 'K', 'L'}, {'M', 'N', 'O'}, {'P', 'Q', 'R', 'S'}, {'T', 'U', 'V'}, {'X', 'Y', 'Z'}};
        this.letters[1] = new char[][]{{'a', 'b', 'c'}, {'d', 'e', 'f'}, {'g', 'h', 'i'}, {'j', 'k', 'l'}, {'m', 'n', 'o'}, {'p', 'q', 'r', 's'}, {'t', 'u', 'v'}, {'x', 'y', 'z'}};
        this.clip = new int[4];
        this.checkDistance();
    }

    public void setUserNameWrite(boolean flag) {
        this.isLockKeyboard = this.userNameWrite = flag;
        this.write = this.userNameWrite;
        this.showBlink = this.userNameWrite;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
        this.buff = new StringBuffer(value);
        this.bIndex = value.length();
        this.checkDistance();
    }

    private void addSymbol(char ch) {
        if (!this.checkMaxLen(ch)) {
            this.buff.insert(this.bIndex, ch);
            this.value = this.buff.toString();
            this.moveBlink(2);
        }
    }

    private void setLastSymbol(char ch) {
        this.buff.setCharAt(this.buff.length() - 1, ch);
        this.value = this.buff.toString();
        this.checkDistance();
    }

    private void addNumber(char ch) {
        if (this.mode == 1) {
            this.setLastSymbol(ch);
            if (this.addLetter) {
                this.addLetter = false;
            }
        } else {
            this.addSymbol(ch);
        }
    }

    private void addLetter(char[] l) {
        if (l != this.lLast) {
            this.lLast = l;
            this.cLetter = 0;
            this.addLetter = false;
            this.ptime = 0L;
        } else if (System.currentTimeMillis() - this.ptime >= 1000L) {
            this.cLetter = 0;
            this.addLetter = false;
            this.ptime = 0L;
        }
        if (!this.addLetter && !this.checkMaxLen(l[0])) {
            this.ptime = System.currentTimeMillis();
        }
        this.time = System.currentTimeMillis() - this.ptime;
        if (this.time < 1000L) {
            if (!this.addLetter) {
                this.addSymbol(l[0]);
                this.addLetter = true;
            } else {
                this.setLastSymbol(l[this.cLetter]);
                this.ptime = System.currentTimeMillis();
            }
            ++this.cLetter;
            if (this.cLetter == l.length) {
                this.cLetter = 0;
            }
        }
    }

    private void moveBlink(int d) {
        if (d == 1 && this.bIndex > 0) {
            --this.bIndex;
        }
        if (d == 2 && this.bIndex < this.value.length()) {
            ++this.bIndex;
        }
        this.checkDistance();
    }

    private void checkDistance() {
        this.sDistance = this.width / 2 - this.dt.stringWidth(this.value) / 2;
        this.bDistance = this.sDistance + this.dt.stringWidth(this.value.substring(0, this.bIndex));
    }

    private boolean checkMaxLen(int ch) {
        return this.dt.stringWidth(this.value + ch) > this.width - 4;
    }

    public void setSelect(boolean flag) {
        this.isSelect = flag;
    }

    public boolean isLockKeyboard() {
        return this.isLockKeyboard;
    }

    public void check(int pKey, int rpKey) {
        if (!this.write) {
            if (pKey == 53 || pKey == -5 || pKey == 103) {
                this.isLockKeyboard = true;
                this.write = true;
                this.showBlink = true;
            }
        } else {
            int cCode;
            if (!(pKey != -5 && pKey != 10 || this.userNameWrite)) {
                this.isLockKeyboard = false;
                this.write = false;
                this.showBlink = false;
            }
            if ((pKey == 35 || pKey == 8) && this.bIndex > 0) {
                this.buff.deleteCharAt(this.bIndex - 1);
                this.value = this.buff.toString();
                this.moveBlink(1);
            }
            switch (pKey) {
                case -3: {
                    this.moveBlink(1);
                    break;
                }
                case -4: {
                    this.moveBlink(2);
                }
            }
            int n = cCode = this.mode == 1 ? rpKey : pKey;
            if (cCode == 48) {
                this.addNumber('0');
            }
            if (cCode == 49 || cCode == 114) {
                this.addNumber('1');
            }
            if (cCode == 50 || cCode == 116) {
                this.addNumber('2');
            }
            if (cCode == 51 || cCode == 121) {
                this.addNumber('3');
            }
            if (cCode == 52 || cCode == 102) {
                this.addNumber('4');
            }
            if (cCode == 53 || cCode == 103) {
                this.addNumber('5');
            }
            if (cCode == 54 || cCode == 104) {
                this.addNumber('6');
            }
            if (cCode == 55 || cCode == 118) {
                this.addNumber('7');
            }
            if (cCode == 56 || cCode == 98) {
                this.addNumber('8');
            }
            if (cCode == 57 || cCode == 110) {
                this.addNumber('9');
            }
            if (this.mode == 1) {
                if (pKey == 48) {
                    this.addSymbol(' ');
                }
                if (pKey == 49 || pKey == 114) {
                    this.addSymbol('.');
                }
                if (pKey == 50 || pKey == 116) {
                    this.addLetter(this.letters[this.lMode][0]);
                }
                if (pKey == 51 || pKey == 121) {
                    this.addLetter(this.letters[this.lMode][1]);
                }
                if (pKey == 52 || pKey == 102) {
                    this.addLetter(this.letters[this.lMode][2]);
                }
                if (pKey == 53 || pKey == 103) {
                    this.addLetter(this.letters[this.lMode][3]);
                }
                if (pKey == 54 || pKey == 104) {
                    this.addLetter(this.letters[this.lMode][4]);
                }
                if (pKey == 55 || pKey == 118) {
                    this.addLetter(this.letters[this.lMode][5]);
                }
                if (pKey == 56 || pKey == 98) {
                    this.addLetter(this.letters[this.lMode][6]);
                }
                if (pKey == 57 || pKey == 110) {
                    this.addLetter(this.letters[this.lMode][7]);
                }
                if (pKey == 42) {
                    this.lMode = this.lMode == 0 ? 1 : 0;
                }
            }
        }
    }

    public void paint(Graphics g, int x, int y) {
        this.getClip(g);
        g.setClip(x + 2, y + 2, this.width - 4, this.height - 4);
        if (!this.userNameWrite) {
            g.setColor(0xFFFFFF);
        } else {
            g.setColor(0xE0E0E0);
        }
        g.drawRect(x + 2, y + 2, this.width - 5, this.height - 5);
        g.setClip(x + 3, y + 3, this.width - 7, this.height - 7);
        this.dt.drawString(g, x + this.sDistance, y + this.height / 2 - 7, this.value);
        if (this.showBlink) {
            g.drawLine(x + this.bDistance, y + this.height / 2 - 7, x + this.bDistance, y + this.height / 2 + 7 - 1);
        }
        if (this.isSelect) {
            g.setClip(x, y, this.width, this.height);
            g.drawRect(x, y, this.width - 1, this.height - 1);
        }
        this.setClip(g);
    }

    private void getClip(Graphics g) {
        this.clip[0] = g.getClipX();
        this.clip[1] = g.getClipY();
        this.clip[2] = g.getClipWidth();
        this.clip[3] = g.getClipHeight();
    }

    private void setClip(Graphics g) {
        g.setClip(this.clip[0], this.clip[1], this.clip[2], this.clip[3]);
    }
}

