/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Joystick {
    private int jX;
    private int jY;
    private int dBack;
    private int[] lXY;
    private Image joy;
    private Ball ball;
    private static final float AGL_225 = 0.38268343f;
    private static final float AGL_675 = 0.9238795f;

    public Joystick(int jX, int jY, Image joy, Ball ball) {
        this.jX = jX;
        this.jY = jY;
        this.joy = joy;
        this.ball = ball;
        this.lXY = new int[2];
        this.lXY[1] = -1;
        this.lXY[0] = -1;
    }

    public void paint(Graphics g) {
        g.drawImage(this.joy, this.jX, this.jY, 20);
    }

    public void pCheck(int pX, int pY, int rX, int rY, int dX, int dY) {
        if (Wand.isAction(pX, pY)) {
            this.action(pX, pY);
        } else if (Wand.isAction(dX, dY)) {
            this.action(dX, dY);
            this.lXY[0] = dX;
            this.lXY[1] = dY;
        } else if (Wand.isAction(this.lXY[0], this.lXY[1])) {
            this.action(this.lXY[0], this.lXY[1]);
        }
        if (Wand.isAction(rX, rY)) {
            if (this.dBack != 0) {
                this.ball.stopMove(this.dBack);
                this.dBack = 0;
            }
            this.lXY[1] = -1;
            this.lXY[0] = -1;
        }
    }

    private void action(int x, int y) {
        float sin = this.getAngle(this.jX - x, this.jY - y);
        if (sin >= 0.38268343f && this.jY - y > 48) {
            this.ball.jump();
        }
        if (Math.abs(sin) <= 0.9238795f) {
            int dir;
            int n = dir = x < this.jX ? 1 : 2;
            if (this.dBack != 0 && this.dBack != dir) {
                this.ball.stopMove(this.dBack);
            }
            this.dBack = 0;
            this.ball.startMove(dir);
            if (this.dBack == 0) {
                this.dBack = dir;
            }
        }
    }

    private float getAngle(int x, int y) {
        return (float)y / (float)Math.sqrt(this.sqr(x) + this.sqr(y));
    }

    private int sqr(int n) {
        return n * n;
    }
}

