/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.TextBox;

public class MapParameters
implements CommandListener {
    private int sWidth;
    private int sHeight;
    private int cInputBox;
    private int nLevel;
    private int[][] ibsXY;
    private String[] ibsTitle;
    private Image bg;
    private Image board;
    private Image[] button_long1;
    private Image[] button_long3;
    private Button p_create;
    private Button p_cancel;
    private DrawText dt;
    private InputBox[] ibs;
    private Command ok;
    private Command cancel;
    private TextBox textBox;
    private RB2 rb2;

    public MapParameters(int sWidth, int sHeight, int nLevel, Image bg, Image board, Image[] button_long1, Image[] button_long3, DrawText dt, RB2 rb2) {
        this.sWidth = sWidth;
        this.sHeight = sHeight;
        this.nLevel = nLevel;
        this.bg = bg;
        this.board = board;
        this.button_long1 = button_long1;
        this.button_long3 = button_long3;
        this.dt = dt;
        this.rb2 = rb2;
        this.ibs = new InputBox[2];
        this.ibs[0] = new InputBox(dt.stringWidth("40") + 12, 24, "20", 2, dt);
        this.ibs[0].setSelect(true);
        this.cInputBox = 0;
        this.ibs[1] = new InputBox(dt.stringWidth("40") + 12, 24, "20", 2, dt);
        this.ibsXY = new int[][]{{sWidth / 4 - this.ibs[0].getWidth() / 2, sHeight / 2 + 10}, {sWidth / 2 + sWidth / 4 - this.ibs[1].getWidth() / 2, sHeight / 2 + 10}};
        this.ibsTitle = new String[]{Localization.getAloneText(8), Localization.getAloneText(9)};
        this.p_create = new Button();
        this.p_cancel = new Button();
    }

    public Button getCreateButton() {
        return this.p_create;
    }

    public Button getCancelButton() {
        return this.p_cancel;
    }

    public String getName() {
        return Localization.getAloneText(6) + this.nLevel;
    }

    public int getWidth() {
        return Integer.parseInt(this.ibs[0].getValue());
    }

    public int getHeight() {
        return Integer.parseInt(this.ibs[1].getValue());
    }

    private void reSelect(int newIndex) {
        this.ibs[this.cInputBox].setSelect(false);
        this.cInputBox = newIndex;
        this.ibs[this.cInputBox].setSelect(true);
    }

    public boolean isLockKeyboard() {
        return this.ibs[this.cInputBox].isLockKeyboard();
    }

    public void check(int pKey, int rpKey, int pX, int pY) {
        if (!this.ibs[this.cInputBox].isLockKeyboard()) {
            if ((pKey == -3 || pKey == 52 || pKey == 102) && this.cInputBox > 0) {
                this.reSelect(this.cInputBox - 1);
            }
            if ((pKey == -4 || pKey == 54 || pKey == 104) && this.cInputBox < this.ibs.length - 1) {
                this.reSelect(this.cInputBox + 1);
            }
            for (int i = 0; i < this.ibs.length; ++i) {
                if (!Wand.region(pX, pY, this.ibsXY[i][0], this.ibsXY[i][1], this.ibs[i].getWidth(), this.ibs[i].getHeight())) continue;
                if (this.cInputBox != i) {
                    this.ibs[this.cInputBox].setSelect(false);
                    this.cInputBox = i;
                    this.ibs[this.cInputBox].setSelect(true);
                    continue;
                }
                this.textBox = new TextBox(this.ibsTitle[i], this.ibs[i].getValue(), 2, 0);
                this.ok = new Command("OK", 4, 0);
                this.cancel = new Command("Cancel", 3, 0);
                this.textBox.addCommand(this.ok);
                this.textBox.addCommand(this.cancel);
                this.textBox.setCommandListener((CommandListener)this);
                this.rb2.rb2MIDlet.display.setCurrent((Displayable)this.textBox);
            }
        }
        if ((pKey == -5 || pKey == 53 || pKey == 103) && this.ibs[this.cInputBox].isLockKeyboard()) {
            if (Integer.parseInt(this.ibs[this.cInputBox].getValue()) < 10) {
                this.ibs[this.cInputBox].setValue("10");
            }
            if (Integer.parseInt(this.ibs[this.cInputBox].getValue()) > 40) {
                this.ibs[this.cInputBox].setValue("40");
            }
        }
        this.ibs[this.cInputBox].check(pKey, rpKey);
    }

    public void paint(Graphics g) {
        g.drawImage(this.bg, 0, 0, 20);
        g.drawImage(this.board, this.sWidth / 2 - this.board.getWidth() / 2, this.sHeight / 2 - this.board.getHeight() / 2 - 6, 20);
        String string = Localization.getAloneText(6) + this.nLevel;
        this.dt.drawString(g, this.sWidth / 2 - this.dt.stringWidth(string) / 2, this.sHeight / 2 - 46, string);
        string = Localization.getAloneText(8);
        this.dt.drawString(g, this.sWidth / 4 - this.dt.stringWidth(string) / 2, this.sHeight / 2 - 9, string);
        string = null;
        this.ibs[0].paint(g, this.sWidth / 4 - this.ibs[0].getWidth() / 2, this.sHeight / 2 + 10);
        string = Localization.getAloneText(9);
        this.dt.drawString(g, this.sWidth / 2 + this.sWidth / 4 - this.dt.stringWidth(string) / 2, this.sHeight / 2 - 9, string);
        string = null;
        this.ibs[1].paint(g, this.sWidth / 2 + this.sWidth / 4 - this.ibs[1].getWidth() / 2, this.sHeight / 2 + 10);
        this.dt.setColor(0xDDDDDD);
        string = Localization.getAloneText(10);
        this.p_create.paint(g, 20 + this.dt.stringWidth(string) / 2 - this.button_long3[0].getWidth() / 2, this.sHeight - 24 + 7 - this.button_long3[0].getHeight() / 2, this.button_long3);
        this.dt.drawString(g, 20, this.sHeight - 24, string);
        string = null;
        string = Localization.getAloneText(11);
        this.p_cancel.paint(g, this.sWidth - this.dt.stringWidth(string) / 2 - this.button_long1[0].getWidth() / 2 - 20, this.sHeight - 24 + 7 - this.button_long1[0].getHeight() / 2, this.button_long1);
        this.dt.drawString(g, this.sWidth - this.dt.stringWidth(string) - 20, this.sHeight - 24, string);
        string = null;
    }

    public void commandAction(Command c, Displayable d) {
        if (c == this.ok || c == this.cancel) {
            if (c == this.ok) {
                this.ibs[this.cInputBox].setValue(this.textBox.getString());
                if (Integer.parseInt(this.ibs[this.cInputBox].getValue()) < 10) {
                    this.ibs[this.cInputBox].setValue("10");
                }
                if (Integer.parseInt(this.ibs[this.cInputBox].getValue()) > 40) {
                    this.ibs[this.cInputBox].setValue("40");
                }
            }
            this.rb2.rb2MIDlet.display.setCurrent((Displayable)this.rb2.canvas);
        }
    }
}

