/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;

public class MapSides {
    private int[][][] sides;
    private Vector[] vsides;

    public MapSides(int[][] lifts, int lWidth, int lHeight) {
        int[][] temp_sides = new int[][]{{lifts[2][1], lifts[2][0], lifts[2][0] + lWidth}, {lifts[2][1] + lHeight, lifts[2][0], lifts[2][0] + lWidth}, {lifts[1][0] + lWidth, lifts[1][1], lifts[1][1] + lHeight}, {lifts[2][0] + lWidth, lifts[2][1], lifts[2][1] + lHeight}};
        this.vsides = new Vector[4];
        for (int i = 0; i < 4; ++i) {
            this.vsides[i] = new Vector();
            for (int j = 0; j < 3; ++j) {
                this.add(this.vsides[i], temp_sides[i][j]);
            }
        }
    }

    public MapSides() {
        this.vsides = new Vector[4];
        for (int i = 0; i < 4; ++i) {
            this.vsides[i] = new Vector();
        }
    }

    public void addLayer(int[][] tiles, int mw, int mh, int tw, int th) {
        int rwsb = 0;
        int lwsb = 0;
        int fsb = 0;
        int csb = 0;
        boolean rwsLine = false;
        boolean lwsLine = false;
        boolean fsLine = false;
        boolean csLine = false;
        for (int row = 1; row < mh - 1; ++row) {
            for (int col = 0; col < mw; ++col) {
                if (tiles[row][col] == 0) {
                    if (tiles[row - 1][col] != 0 && !csLine) {
                        csb = col;
                        csLine = true;
                    }
                    if (tiles[row - 1][col] == 0 && csLine) {
                        this.addSide(this.vsides[0], 1, col, row, csb, tw, th);
                        csLine = false;
                    }
                    if (tiles[row + 1][col] != 0 && !fsLine) {
                        fsb = col;
                        fsLine = true;
                    }
                    if (tiles[row + 1][col] == 0 && fsLine) {
                        this.addSide(this.vsides[1], 2, col, row, fsb, tw, th);
                        fsLine = false;
                    }
                }
                if (tiles[row][col] == 0) continue;
                if (csLine) {
                    this.addSide(this.vsides[0], 1, col, row, csb, tw, th);
                    csLine = false;
                }
                if (!fsLine) continue;
                this.addSide(this.vsides[1], 2, col, row, fsb, tw, th);
                fsLine = false;
            }
            if (csLine) {
                this.addSide(this.vsides[0], 1, mw, row, csb, tw, th);
                csLine = false;
            }
            if (!fsLine) continue;
            this.addSide(this.vsides[1], 2, mw, row, fsb, tw, th);
            fsLine = false;
        }
        for (int col = 1; col < mw - 1; ++col) {
            for (int row = 0; row < mh; ++row) {
                if (tiles[row][col] == 0) {
                    if (tiles[row][col - 1] != 0 && !lwsLine) {
                        lwsb = row;
                        lwsLine = true;
                    }
                    if (tiles[row][col - 1] == 0 && lwsLine) {
                        this.addSide(this.vsides[2], 3, col, row, lwsb, tw, th);
                        lwsLine = false;
                    }
                    if (tiles[row][col + 1] != 0 && !rwsLine) {
                        rwsb = row;
                        rwsLine = true;
                    }
                    if (tiles[row][col + 1] == 0 && rwsLine) {
                        this.addSide(this.vsides[3], 4, col, row, rwsb, tw, th);
                        rwsLine = false;
                    }
                }
                if (tiles[row][col] == 0) continue;
                if (lwsLine) {
                    this.addSide(this.vsides[2], 3, col, row, lwsb, tw, th);
                    lwsLine = false;
                }
                if (!rwsLine) continue;
                this.addSide(this.vsides[3], 4, col, row, rwsb, tw, th);
                rwsLine = false;
            }
            if (lwsLine) {
                this.addSide(this.vsides[2], 3, col, mh, lwsb, tw, th);
                lwsLine = false;
            }
            if (!rwsLine) continue;
            this.addSide(this.vsides[3], 4, col, mh, rwsb, tw, th);
            rwsLine = false;
        }
    }

    public void addLayer(int[][] tiles, int tw, int th) {
        for (int row = 0; row < tiles.length; ++row) {
            for (int col = 0; col < tiles[row].length; ++col) {
                if (tiles[row][col] == 0) continue;
                for (int i = 0; i < this.vsides.length; ++i) {
                    if (i == 0 || i == 1) {
                        this.addSide(this.vsides[i], i == 0 ? 2 : 1, col + 1, row, col, tw, th);
                    }
                    if (i != 2 && i != 3) continue;
                    this.addSide(this.vsides[i], i == 2 ? 4 : 3, col, row + 1, row, tw, th);
                }
            }
        }
    }

    public void build() {
        this.sides = new int[4][][];
        for (int i = 0; i < 4; ++i) {
            this.sides[i] = new int[this.vsides[i].size() / 3][3];
            for (int j = 0; j < this.sides[i].length; ++j) {
                for (int k = 0; k < 3; ++k) {
                    this.sides[i][j][k] = this.get(this.vsides[i], j * 3 + k);
                }
            }
        }
    }

    public int[][][] getSides() {
        return this.sides;
    }

    private void add(Vector vector, int value) {
        vector.addElement("" + value);
    }

    private int get(Vector vector, int index) {
        return Integer.parseInt((String)vector.elementAt(index));
    }

    private void addSide(Vector sides, int type, int col, int row, int b, int tw, int th) {
        if (type == 1 || type == 2) {
            this.add(sides, (row + (type == 1 ? 0 : 1)) * th);
            this.add(sides, b * tw);
            this.add(sides, col * tw);
        }
        if (type == 3 || type == 4) {
            this.add(sides, (col + (type == 3 ? 0 : 1)) * tw);
            this.add(sides, b * th);
            this.add(sides, row * th);
        }
    }
}

