/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;

public class Sound
implements PlayerListener {
    private boolean enable;
    private Vector vSound = new Vector();

    public boolean isEnable() {
        return this.enable;
    }

    public boolean soundOn() {
        if (!this.enable) {
            this.restoreAll();
            this.enable = true;
            return true;
        }
        return false;
    }

    public void soundOff() {
        this.stopAll();
        this.enable = false;
    }

    public Player play(String name, String mime, int loopCount) {
        Player player = null;
        if (this.enable) {
            InputStream is = this.getClass().getResourceAsStream("/resources/sound/" + name);
            try {
                player = Manager.createPlayer((InputStream)is, (String)mime);
                player.addPlayerListener((PlayerListener)this);
                player.setLoopCount(loopCount);
                player.start();
            }
            catch (IOException ex) {
            }
            catch (MediaException ex) {
                // empty catch block
            }
            this.vSound.addElement(player);
        }
        return player;
    }

    public void fullStop(Player player) {
        if (this.enable && this.vSound.contains(player)) {
            player.close();
            this.vSound.removeElement(player);
        }
    }

    public void restoreAll() {
        for (int i = 0; i < this.vSound.size(); ++i) {
            try {
                ((Player)this.vSound.elementAt(i)).start();
                continue;
            }
            catch (MediaException mediaException) {
                // empty catch block
            }
        }
    }

    public void stopAll() {
        for (int i = 0; i < this.vSound.size(); ++i) {
            try {
                ((Player)this.vSound.elementAt(i)).stop();
                continue;
            }
            catch (MediaException mediaException) {
                // empty catch block
            }
        }
    }

    public void fullStopAll() {
        for (int i = 0; i < this.vSound.size(); ++i) {
            ((Player)this.vSound.elementAt(i)).close();
        }
        this.vSound.removeAllElements();
    }

    public void playerUpdate(Player player, String event, Object eventData) {
        if (event.equals("endOfMedia")) {
            this.vSound.removeElement(player);
        }
    }
}

