package gamepacker;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.*;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.*;
/**
 *
 * @author user
 */
public class GamePacker extends JFrame implements ActionListener, MouseListener, MouseMotionListener {
    
    private boolean mPresence;
    private JButton iPack, mPack;
    private JToggleButton[] bObjects;
    private JTextField iLoad, iSave, mLoad, mSave, mName, mWidth, mHeight, mTimeMinutes, mTimeSeconds, mPoints;
    private JComboBox lMaps, mMaps, eMaps;
    private JScrollPane mScrollPane;
    private JDialog loc, loadMaps, saveMaps, packGraphics;
    
    private ArrayList<HashMap<String, Object>> maps;
    
    private MapCanvas mCanvas;
    private Load load;
    private Packing pack;
    
    public GamePacker() {
        super("GamePacker");
        init();
        load = new Load();
        pack = new Packing(this);
    }
    
    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        } catch (ClassNotFoundException ex) {
            Logger.getLogger(GamePacker.class.getName()).log(Level.SEVERE, null, ex);
        } catch (InstantiationException ex) {
            Logger.getLogger(GamePacker.class.getName()).log(Level.SEVERE, null, ex);
        } catch (IllegalAccessException ex) {
            Logger.getLogger(GamePacker.class.getName()).log(Level.SEVERE, null, ex);
        } catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(GamePacker.class.getName()).log(Level.SEVERE, null, ex);
        }
        
        SwingUtilities.invokeLater(new Runnable() {
            @Override
            public void run() {
                new GamePacker().setVisible(true);
            }
        });
    }
    
    private void init() {
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        
        JMenuBar menu = new JMenuBar();
        JMenu mFile = new JMenu("File");
        JMenuItem nMap = new JMenuItem("New Map");
        nMap.addActionListener(this);
        mFile.add(nMap);
        JMenuItem iLoadMaps = new JMenuItem("Load Maps");
        iLoadMaps.addActionListener(this);
        mFile.add(iLoadMaps);
        JMenuItem sMaps = new JMenuItem("Save Maps");
        sMaps.addActionListener(this);
        mFile.add(sMaps);
        JMenuItem pGraphics = new JMenuItem("Pack Graphics");
        pGraphics.addActionListener(this);
        mFile.add(pGraphics);
        JMenuItem exit = new JMenuItem("Exit");
        exit.addActionListener(this);
        mFile.add(exit);
        menu.add(mFile);
        JMenu mEdit = new JMenu("Edit");
        JMenuItem location = new JMenuItem("Location");
        location.addActionListener(this);
        mEdit.add(location);
        JMenuItem delete = new JMenuItem("Delete");
        delete.addActionListener(this);
        mEdit.add(delete);
        menu.add(mEdit);
        setJMenuBar(menu);
        
        JPanel mainPanel = new JPanel();
        
        JPanel sPanel = new JPanel(new GridLayout(1, 1));
        lMaps = new JComboBox(new String[] {"No Maps"});
        lMaps.addActionListener(this);
        sPanel.add(lMaps);
        
        JSeparator s1 = new JSeparator();
        s1.setOrientation(SwingConstants.HORIZONTAL);
        
        ButtonGroup bGroup = new ButtonGroup();
        bObjects = new JToggleButton[13];
        Image[] iObjects = new Image[bObjects.length];
        String[] icons = new String[] {"empty", "block", "glass_block", "thron_direction_up", "thron_direction_down", "fan_up", "fan_down", "fan_left", "fan_right", "lift_enter", "lift_exit", "enter_lift", "exit_lift"};
        for(int i=0; i<bObjects.length; i++) {
            bObjects[i] = new JToggleButton();
            ImageIcon icon = getIcon(icons[i]);
            iObjects[i] = icon.getImage();
            bObjects[i].setIcon(icon);
            bObjects[i].addActionListener(this);
            bGroup.add(bObjects[i]);
        }
        JSeparator js = new JSeparator();
        js.setOrientation(JSeparator.HORIZONTAL);
        JPanel oPanel = new JPanel();
        GroupLayout oLayout = new GroupLayout(oPanel);
        oPanel.setLayout(oLayout);
        oLayout.setHorizontalGroup(
            oLayout.createParallelGroup(GroupLayout.Alignment.CENTER)
                .addComponent(bObjects[0], GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(bObjects[1], GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(js, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(bObjects[2], GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );
        oLayout.setVerticalGroup(
            oLayout.createSequentialGroup()
                .addComponent(bObjects[0], GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(bObjects[1], GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(js, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(bObjects[2], GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
        );
        
        JSeparator s2 = new JSeparator();
        s2.setOrientation(SwingConstants.HORIZONTAL);
        
        JPanel bPanel = new JPanel();
        GroupLayout bLayout = new GroupLayout(bPanel);
        bPanel.setLayout(bLayout);
        bLayout.setHorizontalGroup(
            bLayout.createParallelGroup(GroupLayout.Alignment.CENTER)
                .addGroup(bLayout.createSequentialGroup()
                    .addComponent(bObjects[3], GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(bObjects[4], GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addGroup(bLayout.createSequentialGroup()
                    .addComponent(bObjects[5], GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(bObjects[6], GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(bObjects[7], GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(bObjects[8], GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        bLayout.setVerticalGroup(
            bLayout.createSequentialGroup()
                .addGroup(bLayout.createParallelGroup(GroupLayout.Alignment.CENTER)
                    .addComponent(bObjects[3], GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
                    .addComponent(bObjects[4], GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addGroup(bLayout.createParallelGroup(GroupLayout.Alignment.CENTER)
                    .addComponent(bObjects[5], GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
                    .addComponent(bObjects[6], GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
                    .addComponent(bObjects[7], GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
                    .addComponent(bObjects[8], GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE))
        );
        
        JSeparator s3 = new JSeparator();
        s3.setOrientation(SwingConstants.HORIZONTAL);
        
        JPanel lPanel = new JPanel();
        GroupLayout lLayout = new GroupLayout(lPanel);
        lPanel.setLayout(lLayout);
        lLayout.setHorizontalGroup(
            lLayout.createParallelGroup(GroupLayout.Alignment.CENTER)
                .addGroup(lLayout.createSequentialGroup()
                    .addComponent(bObjects[9], GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(bObjects[10], GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addGroup(lLayout.createSequentialGroup()
                    .addComponent(bObjects[11], GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(bObjects[12], GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        lLayout.setVerticalGroup(
            lLayout.createSequentialGroup()
                .addGroup(lLayout.createParallelGroup(GroupLayout.Alignment.CENTER)
                    .addComponent(bObjects[9], GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
                    .addComponent(bObjects[10], GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE))
                .addGroup(lLayout.createParallelGroup(GroupLayout.Alignment.CENTER)
                    .addComponent(bObjects[11], GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
                    .addComponent(bObjects[12], GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE))
        );
        
        GroupLayout mainLayout = new GroupLayout(mainPanel);
        mainPanel.setLayout(mainLayout);
        mainLayout.setHorizontalGroup(
            mainLayout.createParallelGroup(GroupLayout.Alignment.CENTER)
                .addComponent(sPanel, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(s1, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(oPanel, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(s2, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(bPanel, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(s3, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(lPanel, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );
        mainLayout.setVerticalGroup(
            mainLayout.createSequentialGroup()
                .addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(sPanel, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(s1, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(oPanel, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(s2, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(bPanel, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(s3, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(lPanel, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );
        
        mCanvas = new MapCanvas(iObjects);
        mCanvas.addMouseListener(this);
        mCanvas.addMouseMotionListener(this);
        mScrollPane = new JScrollPane(mCanvas);
        
        JPanel fPanel = new JPanel();
        JLabel nLabel = new JLabel("Name:");
        mName = new JTextField();
        mName.setHorizontalAlignment(JTextField.CENTER);
        JButton mRename = new JButton("Rename");
        mRename.addActionListener(this);
        JSeparator js1 = new JSeparator();
        js1.setOrientation(JSeparator.VERTICAL);
        JLabel whLabel = new JLabel("WH:");
        mWidth = new JTextField();
        mWidth.setHorizontalAlignment(JTextField.CENTER);
        JLabel xLabel = new JLabel("X");
        mHeight = new JTextField();
        mHeight.setHorizontalAlignment(JTextField.CENTER);
        JButton mResize = new JButton("Resize");
        mResize.addActionListener(this);
        JSeparator js2 = new JSeparator();
        js2.setOrientation(JSeparator.VERTICAL);
        JLabel tLabel = new JLabel("Time:");
        mTimeMinutes = new JTextField();
        mTimeMinutes.setHorizontalAlignment(JTextField.CENTER);
        JLabel sLabel = new JLabel(":");
        mTimeSeconds = new JTextField();
        mTimeSeconds.setHorizontalAlignment(JTextField.CENTER);
        JButton mSetTime = new JButton("Set Time");
        mSetTime.addActionListener(this);
        JSeparator js3 = new JSeparator();
        js3.setOrientation(JSeparator.VERTICAL);
        JLabel pLabel = new JLabel("Points:");
        mPoints = new JTextField();
        mPoints.setHorizontalAlignment(JTextField.CENTER);
        JButton mSetPoints = new JButton("Set Points");
        mSetPoints.addActionListener(this);
        GroupLayout fLayout = new GroupLayout(fPanel);
        fPanel.setLayout(fLayout);
        fLayout.setHorizontalGroup(
            fLayout.createSequentialGroup()
                .addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(nLabel)
                .addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(mName, GroupLayout.PREFERRED_SIZE, 100, GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(mRename)
                .addGap(20, 20, Short.MAX_VALUE)
                .addComponent(js1, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
                .addGap(14, 14, Short.MAX_VALUE)
                .addComponent(whLabel)
                .addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(mWidth, GroupLayout.PREFERRED_SIZE, 50, GroupLayout.PREFERRED_SIZE)
                .addComponent(xLabel)
                .addComponent(mHeight, GroupLayout.PREFERRED_SIZE, 50, GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(mResize)
                .addGap(20, 20, Short.MAX_VALUE)
                .addComponent(js2, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
                .addGap(14, 14, Short.MAX_VALUE)
                .addComponent(tLabel)
                .addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(mTimeMinutes, GroupLayout.PREFERRED_SIZE, 30, GroupLayout.PREFERRED_SIZE)
                .addComponent(sLabel)
                .addComponent(mTimeSeconds, GroupLayout.PREFERRED_SIZE, 40, GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(mSetTime)
                .addGap(20, 20, Short.MAX_VALUE)
                .addComponent(js3, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
                .addGap(14, 14, Short.MAX_VALUE)
                .addComponent(pLabel)
                .addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(mPoints, GroupLayout.PREFERRED_SIZE, 60, GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(mSetPoints)
                .addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );
        fLayout.setVerticalGroup(
            fLayout.createParallelGroup(GroupLayout.Alignment.CENTER)
                .addComponent(nLabel)
                .addComponent(mName)
                .addComponent(mRename)
                .addComponent(js1, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(whLabel)
                .addComponent(mWidth, GroupLayout.PREFERRED_SIZE, 30, GroupLayout.PREFERRED_SIZE)
                .addComponent(xLabel)
                .addComponent(mHeight, GroupLayout.PREFERRED_SIZE, 30, GroupLayout.PREFERRED_SIZE)
                .addComponent(mResize)
                .addComponent(js2, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(tLabel)
                .addComponent(mTimeMinutes, GroupLayout.PREFERRED_SIZE, 30, GroupLayout.PREFERRED_SIZE)
                .addComponent(sLabel)
                .addComponent(mTimeSeconds, GroupLayout.PREFERRED_SIZE, 30, GroupLayout.PREFERRED_SIZE)
                .addComponent(mSetTime)
                .addComponent(js3, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(pLabel)
                .addComponent(mPoints, GroupLayout.PREFERRED_SIZE, 30, GroupLayout.PREFERRED_SIZE)
                .addComponent(mSetPoints)
        );
        
        JPanel mapPanel = new JPanel();
        GroupLayout mapLayout = new GroupLayout(mapPanel);
        mapPanel.setLayout(mapLayout);
        mapLayout.setHorizontalGroup(
            mapLayout.createParallelGroup(GroupLayout.Alignment.CENTER)
                .addComponent(mScrollPane, GroupLayout.PREFERRED_SIZE, (fPanel.getPreferredSize().width)-(mainPanel.getPreferredSize().width), Short.MAX_VALUE)
        );
        mapLayout.setVerticalGroup(
            mapLayout.createSequentialGroup()
                .addComponent(mScrollPane, GroupLayout.PREFERRED_SIZE, (mainPanel.getPreferredSize().height), Short.MAX_VALUE)
        );
        
        JSeparator separator1 = new JSeparator();
        separator1.setOrientation(SwingConstants.VERTICAL);
        JSeparator separator2 = new JSeparator();
        separator2.setOrientation(SwingConstants.HORIZONTAL);
        JSeparator separator3 = new JSeparator();
        separator3.setOrientation(SwingConstants.VERTICAL);
        GroupLayout layout = new GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        layout.setHorizontalGroup(
            layout.createParallelGroup(GroupLayout.Alignment.CENTER)
                .addGroup(layout.createSequentialGroup()
                    .addComponent(mapPanel, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED)
                    .addComponent(separator1, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
                    .addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED)
                    .addComponent(mainPanel, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE))
                .addComponent(separator2, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(fPanel, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER)
                    .addComponent(mapPanel, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(separator1, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(mainPanel, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(separator2, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(fPanel, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
        );
        
        pack();
        Dimension sSize = Toolkit.getDefaultToolkit().getScreenSize();
        setLocation(sSize.width/2-getWidth()/2, sSize.height/2-getHeight()/2);
    }
    
    private ImageIcon getIcon(String name) {
        return (new ImageIcon(getClass().getResource("/gamepacker/resources/"+name+".png")));
    }
    
    private void buildListOfMaps() {
        String[] list = new String[maps.size()];
        for(int i=0; i<list.length; i++) {
            list[i] = ""+(maps.get(i).get("name"));
        }
        lMaps.setModel(new DefaultComboBoxModel(list));
    }
    
    private void buildLocation() {
        ComboBoxModel cbx = lMaps.getModel();
        String[] list = new String[cbx.getSize()];
        for(int i=0; i<list.length; i++) {
            list[i] = (String)cbx.getElementAt(i);
        }
        mMaps.setModel(new DefaultComboBoxModel(list));
        mMaps.setSelectedIndex(lMaps.getSelectedIndex());
        eMaps.setModel(new DefaultComboBoxModel(list));
        eMaps.setSelectedIndex(lMaps.getSelectedIndex());
        
    }
    
    private void loadMap(int index) {
        HashMap<String, Object> map = maps.get(index);
        mName.setText(""+map.get("name"));
        int[] wh = (int[])map.get("wh");
        mWidth.setText(""+wh[0]);
        mHeight.setText(""+wh[1]);
        int[] time = (int[])map.get("time");
        mTimeMinutes.setText(""+time[0]);
        String seconds = ""+time[1];
        if(seconds.length() == 1) seconds = "0"+seconds;
        mTimeSeconds.setText(seconds);
        mPoints.setText(""+map.get("points"));
        mCanvas.setMap(map);
    }
    
    @Override
    public void actionPerformed(ActionEvent e) {
        if(lMaps == e.getSource() && mPresence) {
            loadMap(lMaps.getSelectedIndex());
            mCanvas.repaint();
            mScrollPane.setViewportView(mCanvas);
        }
        for(int i=0; i<bObjects.length; i++) {
            if(bObjects[i] == e.getSource()) {
                mCanvas.setCurrentObject(i);
            }
        }
        if(iPack == e.getSource()) {
            pack.packGraphics(iLoad.getText(), iSave.getText());
        }
        if("Load".equals(e.getActionCommand())) {
            maps = load.loadMaps(mLoad.getText());
            buildListOfMaps();
            loadMap(0);
            mCanvas.repaint();
            mScrollPane.setViewportView(mCanvas);
            mPresence = !maps.isEmpty();
            loadMaps.setVisible(false);
        }
        if(mPack == e.getSource() && mPresence) {
            pack.packMaps(maps, mSave.getText());
        }
        if("Move".equals(e.getActionCommand())) {
            int findex = lMaps.getSelectedIndex();
            int lindex = mMaps.getSelectedIndex();
            if(lindex > findex) lindex++;
            maps.add(lindex, maps.get(findex));
            if(findex > lindex) findex++;
            maps.remove(findex);
            buildListOfMaps();
            if(lindex > findex) lindex--;
            lMaps.setSelectedIndex(lindex);
            buildLocation();
            JOptionPane.showMessageDialog(loc, "Move is completed!", "Information Message", JOptionPane.INFORMATION_MESSAGE);
        }
        if("Exchange".equals(e.getActionCommand())) {
            int index = lMaps.getSelectedIndex();
            HashMap<String, Object> bMap = maps.get(eMaps.getSelectedIndex());
            maps.set(eMaps.getSelectedIndex(), maps.get(index));
            maps.set(index, bMap);
            buildListOfMaps();
            lMaps.setSelectedIndex(eMaps.getSelectedIndex());
            buildLocation();
            JOptionPane.showMessageDialog(loc, "Exchange is completed!", "Information Message", JOptionPane.INFORMATION_MESSAGE);
        }
        if("Rename".equals(e.getActionCommand()) && mPresence) {
            label:
            {
                if(mName.getText().length() > 255) {
                    JOptionPane.showMessageDialog(this, "Maximum lenght of name is 255 symbols!", "Error Message", JOptionPane.ERROR_MESSAGE);
                    break label;
                }
                HashMap<String, Object> map = maps.get(lMaps.getSelectedIndex());
                map.remove("name");
                map.put("name", mName.getText());
                int index = lMaps.getSelectedIndex();
                buildListOfMaps();
                lMaps.setSelectedIndex(index);
            }
        }
        if("Resize".equals(e.getActionCommand()) && mPresence) {
            label:
            {
                if(Integer.parseInt(mWidth.getText()) > 255 || Integer.parseInt(mHeight.getText()) > 255) {
                    if(Integer.parseInt(mWidth.getText()) > 255) mWidth.setText("255");
                    if(Integer.parseInt(mHeight.getText()) > 255) mHeight.setText("255");
                    JOptionPane.showMessageDialog(this, "Maximum width or height is 255 cells!", "Error Message", JOptionPane.ERROR_MESSAGE);
                    break label;
                }
                HashMap<String, Object> map = maps.get(lMaps.getSelectedIndex());
                int[] wh = new int[] {Integer.parseInt(mWidth.getText()), Integer.parseInt(mHeight.getText())};
                map.remove("wh");
                map.put("wh", wh);
                int[][] old_tiles = (int[][])map.get("tiles");
                int[][] tiles = new int[wh[1]][wh[0]];
                for(int i=0; i<tiles.length; i++) {
                    for(int j=0; j<tiles[i].length; j++) {
                        if(i >= 0 && i < old_tiles.length && j >= 0 && j < old_tiles[i].length) {
                            tiles[i][j] = old_tiles[i][j];
                        } else {
                            tiles[i][j] = 1;
                        }
                    }
                }
                map.remove("tiles");
                map.put("tiles", tiles);
                mCanvas.setMap(map);
                mScrollPane.setViewportView(mCanvas);
            }
        }
        if("Set Time".equals(e.getActionCommand()) && mPresence) {
            label:
            {
                if(Integer.parseInt(mTimeMinutes.getText()) > 255) {
                    mTimeMinutes.setText("255");
                    JOptionPane.showMessageDialog(this, "Maximum 255 minutes!", "Error Message", JOptionPane.ERROR_MESSAGE);
                    break label;
                }
                if(Integer.parseInt(mTimeSeconds.getText()) > 59) {
                    mTimeSeconds.setText("59");
                    JOptionPane.showMessageDialog(this, "Maximum 59 seconds!", "Error Message", JOptionPane.ERROR_MESSAGE);
                    break label;
                }
                HashMap<String, Object> map = maps.get(lMaps.getSelectedIndex());
                map.remove("time");
                map.put("time", (new int[] {Integer.parseInt(mTimeMinutes.getText()), Integer.parseInt(mTimeSeconds.getText())}));
                if(mTimeSeconds.getText().length() == 1) mTimeSeconds.setText("0"+mTimeSeconds.getText());
                JOptionPane.showMessageDialog(this, "Time is Set!", "Information Message", JOptionPane.INFORMATION_MESSAGE);
            }
        }
        if("Set Points".equals(e.getActionCommand()) && mPresence) {
            label:
            {
                if(Integer.parseInt(mPoints.getText()) > 65535) {
                    mPoints.setText("65535");
                    JOptionPane.showMessageDialog(this, "Maximum 65535 points!", "Error Message", JOptionPane.ERROR_MESSAGE);
                    break label;
                }
                HashMap<String, Object> map = maps.get(lMaps.getSelectedIndex());
                map.remove("points");
                map.put("points", mPoints.getText());
                JOptionPane.showMessageDialog(this, "Points is Set!", "Information Message", JOptionPane.INFORMATION_MESSAGE);
            }
        }
        if("New Map".equals(e.getActionCommand())) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            if(maps == null) maps = new ArrayList<HashMap<String, Object>>();
            map.put("name", "Map "+(maps.size()+1));
            mName.setText("Map "+(maps.size()+1));
            map.put("wh", (new int[] {10, 10}));
            mWidth.setText("10");
            mHeight.setText("10");
            int[][] tiles = new int[10][10];
            for(int i=0; i<10; i++) {
                for(int j=0; j<10; j++) {
                    tiles[i][j] = 1;
                }
            }
            map.put("tiles", tiles);
            map.put("time", (new int[] {1, 0}));
            mTimeMinutes.setText("1");
            mTimeSeconds.setText("00");
            map.put("points", "1000");
            mPoints.setText("1000");
            maps.add(map);
            buildListOfMaps();
            lMaps.setSelectedIndex(maps.size()-1);
            mCanvas.setMap(map);
            mScrollPane.setViewportView(mCanvas);
            if(!mPresence) mPresence = true;
            
        }
        if("Load Maps".equals(e.getActionCommand())) {
            loadMaps = new JDialog(this, "load Maps", true);
            loadMaps.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
            
            JLabel lPath = new JLabel("Path:");
            mLoad = new JTextField("C:/Users/AlexeyW/Documents/NetBeansProjects/ReboundBall2/res/resources/maps.dat");
            JButton bMapsLoad = new JButton("Load");
            bMapsLoad.addActionListener(this);
            
            GroupLayout layout = new GroupLayout(loadMaps.getContentPane());
            loadMaps.setLayout(layout);
            layout.setAutoCreateGaps(true);
            layout.setAutoCreateContainerGaps(true);
            layout.setHorizontalGroup(
                layout.createParallelGroup(GroupLayout.Alignment.CENTER)
                    .addComponent(lPath, GroupLayout.Alignment.LEADING)
                    .addComponent(mLoad, GroupLayout.PREFERRED_SIZE, 300, Short.MAX_VALUE)
                    .addComponent(bMapsLoad, GroupLayout.Alignment.TRAILING)
            );
            layout.setVerticalGroup(
                layout.createSequentialGroup()
                    .addGap(15, 15, Short.MAX_VALUE)
                    .addComponent(lPath)
                    .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                    .addComponent(mLoad, GroupLayout.PREFERRED_SIZE, 30, GroupLayout.PREFERRED_SIZE)
                    .addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED)
                    .addComponent(bMapsLoad)
                    .addGap(15, 15, Short.MAX_VALUE)
            );
            loadMaps.pack();
            loadMaps.setLocation(getX()+getWidth()/2-loadMaps.getWidth()/2, getY()+getHeight()/2-loadMaps.getHeight()/2);
            loadMaps.setVisible(true);
        }
        if("Save Maps".equals(e.getActionCommand())) {
            saveMaps = new JDialog(this, "Save Maps", true);
            saveMaps.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
            
            JLabel lPath = new JLabel("Path:");
            mSave = new JTextField("C:/Users/AlexeyW/Documents/NetBeansProjects/ReboundBall2/res/resources/maps.dat");
            mPack = new JButton("Pack");
            mPack.addActionListener(this);
            
            GroupLayout layout = new GroupLayout(saveMaps.getContentPane());
            saveMaps.setLayout(layout);
            layout.setAutoCreateGaps(true);
            layout.setAutoCreateContainerGaps(true);
            layout.setHorizontalGroup(
                layout.createParallelGroup(GroupLayout.Alignment.CENTER)
                    .addComponent(lPath, GroupLayout.Alignment.LEADING)
                    .addComponent(mSave, GroupLayout.PREFERRED_SIZE, 300, Short.MAX_VALUE)
                    .addComponent(mPack, GroupLayout.Alignment.TRAILING)
            );
            layout.setVerticalGroup(
                layout.createSequentialGroup()
                    .addGap(15, 15, Short.MAX_VALUE)
                    .addComponent(lPath)
                    .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                    .addComponent(mSave, GroupLayout.PREFERRED_SIZE, 30, GroupLayout.PREFERRED_SIZE)
                    .addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED)
                    .addComponent(mPack)
                    .addGap(15, 15, Short.MAX_VALUE)
            );
            saveMaps.pack();
            saveMaps.setLocation(getX()+getWidth()/2-saveMaps.getWidth()/2, getY()+getHeight()/2-saveMaps.getHeight()/2);
            saveMaps.setVisible(true);
        }
        if("Pack Graphics".equals(e.getActionCommand())) {
            packGraphics = new JDialog(this, "Pack Graphics", true);
            packGraphics.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
            
            JLabel iLabelOpen = new JLabel("Load from:");
            iLoad = new JTextField("C:/game_pack/graphics/");
            JLabel iLabelSave = new JLabel("Save in:");
            iSave = new JTextField("C:/Users/AlexeyW/Documents/NetBeansProjects/ReboundBall2/res/resources/graphics.dat");
            iPack = new JButton("Pack");
            iPack.addActionListener(this);
            
            GroupLayout layout = new GroupLayout(packGraphics.getContentPane());
            packGraphics.setLayout(layout);
            layout.setAutoCreateGaps(true);
            layout.setAutoCreateContainerGaps(true);
            layout.setHorizontalGroup(
                layout.createParallelGroup(GroupLayout.Alignment.CENTER)
                    .addComponent(iLabelOpen, GroupLayout.Alignment.LEADING)
                    .addComponent(iLoad, GroupLayout.PREFERRED_SIZE, 400, Short.MAX_VALUE)
                    .addComponent(iLabelSave, GroupLayout.Alignment.LEADING)
                    .addComponent(iSave, GroupLayout.PREFERRED_SIZE, 400, Short.MAX_VALUE)
                    .addComponent(iPack, GroupLayout.Alignment.TRAILING)
            );
            layout.setVerticalGroup(
                layout.createSequentialGroup()
                    .addGap(15, 15, Short.MAX_VALUE)
                    .addComponent(iLabelOpen)
                    .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                    .addComponent(iLoad, GroupLayout.PREFERRED_SIZE, 30, GroupLayout.PREFERRED_SIZE)
                    .addGap(20, 20, Short.MAX_VALUE)
                    .addComponent(iLabelSave)
                    .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                    .addComponent(iSave, GroupLayout.PREFERRED_SIZE, 30, GroupLayout.PREFERRED_SIZE)
                    .addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED)
                    .addComponent(iPack)
                    .addGap(15, 15, Short.MAX_VALUE)
            );
            packGraphics.pack();
            packGraphics.setLocation(getX()+getWidth()/2-packGraphics.getWidth()/2, getY()+getHeight()/2-packGraphics.getHeight()/2);
            packGraphics.setVisible(true);
        }
        if("Exit".equals(e.getActionCommand())) {
            System.exit(0);
        }
        if("Location".equals(e.getActionCommand()) && mPresence) {
            HashMap<String, Object> map = maps.get(lMaps.getSelectedIndex());
            String[] list = new String[maps.size()];
            for(int i=0; i<list.length; i++) {
                list[i] = ""+(maps.get(i).get("name"));
            }
            loc = new JDialog(this, "Location ("+map.get("name") +")", true);
            loc.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
            JPanel mPanel = new JPanel();
            mPanel.setBorder(BorderFactory.createTitledBorder("Move"));
            JLabel ipo1 = new JLabel("Into place of:");
            mMaps = new JComboBox(new DefaultComboBoxModel(list));
            JButton bRemove = new JButton("Move");
            bRemove.addActionListener(this);
            GroupLayout mLayout = new GroupLayout(mPanel);
            mPanel.setLayout(mLayout);
            mLayout.setAutoCreateGaps(true);
            mLayout.setAutoCreateContainerGaps(true);
            mLayout.setHorizontalGroup(
                mLayout.createParallelGroup(GroupLayout.Alignment.CENTER)
                    .addComponent(ipo1)
                    .addComponent(mMaps, GroupLayout.PREFERRED_SIZE, 200, Short.MAX_VALUE)
                    .addComponent(bRemove, GroupLayout.Alignment.TRAILING)
            );
            mLayout.setVerticalGroup(
                mLayout.createSequentialGroup()
                    .addGap(0, 0, Short.MAX_VALUE)
                    .addComponent(ipo1)
                    .addComponent(mMaps, GroupLayout.PREFERRED_SIZE, 30, Short.MAX_VALUE)
                    .addGap(20, 20, Short.MAX_VALUE)
                    .addComponent(bRemove)
                    .addGap(10, 10, Short.MAX_VALUE)
            );
            JSeparator sep = new JSeparator();
            sep.setOrientation(JSeparator.VERTICAL);
            JPanel ePanel = new JPanel();
            JLabel ipo2 = new JLabel("Into place of:");
            ePanel.setBorder(BorderFactory.createTitledBorder("Exchange"));
            eMaps = new JComboBox(new DefaultComboBoxModel(list));
            JButton bExchange = new JButton("Exchange");
            bExchange.addActionListener(this);
            GroupLayout eLayout = new GroupLayout(ePanel);
            ePanel.setLayout(eLayout);
            eLayout.setAutoCreateGaps(true);
            eLayout.setAutoCreateContainerGaps(true);
            eLayout.setHorizontalGroup(
                eLayout.createParallelGroup(GroupLayout.Alignment.CENTER)
                    .addComponent(ipo2)
                    .addComponent(eMaps, GroupLayout.PREFERRED_SIZE, 200, Short.MAX_VALUE)
                    .addComponent(bExchange, GroupLayout.Alignment.TRAILING)
            );
            eLayout.setVerticalGroup(
                eLayout.createSequentialGroup()
                    .addGap(0, 0, Short.MAX_VALUE)
                    .addComponent(ipo2)
                    .addComponent(eMaps, GroupLayout.PREFERRED_SIZE, 30, Short.MAX_VALUE)
                    .addGap(20, 20, Short.MAX_VALUE)
                    .addComponent(bExchange)
                    .addGap(10, 10, Short.MAX_VALUE)
            );
            GroupLayout layout = new GroupLayout(loc.getContentPane());
            loc.setLayout(layout);
            layout.setAutoCreateGaps(true);
            layout.setAutoCreateContainerGaps(true);
            layout.setHorizontalGroup(
                layout.createSequentialGroup()
                    .addGap(20, 20, Short.MAX_VALUE)
                    .addComponent(mPanel, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(sep, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
                    .addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(ePanel, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addGap(20, 20, Short.MAX_VALUE)
            );
            layout.setVerticalGroup(
                layout.createParallelGroup(GroupLayout.Alignment.CENTER)
                    .addComponent(mPanel, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(sep, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(ePanel, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
            );
            loc.pack();
            loc.setLocation(getX()+getWidth()/2-loc.getWidth()/2, getY()+getHeight()/2-loc.getHeight()/2);
            loc.setVisible(true);
        }
        if("Delete".equals(e.getActionCommand()) && mPresence) {
            int index = lMaps.getSelectedIndex();
            maps.remove(index);
            buildListOfMaps();
            if(lMaps.getModel().getSize() == 0) {
                lMaps.setModel(new DefaultComboBoxModel(new String[] {"No Maps"}));
                mName.setText("");
                mWidth.setText("");
                mHeight.setText("");
                mTimeMinutes.setText("");
                mPoints.setText("");
                mCanvas.setEmptyMap();
                mPresence = false;
            } else {
                if(index > 0) index--;
                lMaps.setSelectedIndex(index);
                loadMap(index);
                mCanvas.repaint();
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {}

    @Override
    public void mousePressed(MouseEvent e) {
        mCanvas.setObject(true);
        mCanvas.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {}

    @Override
    public void mouseEntered(MouseEvent e) {
        mCanvas.setShowCursor(true);
        mCanvas.repaint();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        mCanvas.setShowCursor(false);
        mCanvas.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        mCanvas.setCursorXY(e.getX(), e.getY());
        mCanvas.setObject(false);
        mCanvas.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        mCanvas.setCursorXY(e.getX(), e.getY());
        mCanvas.repaint();
    }
    
}