package gamepacker;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
/**
 *
 * @author user
 */
public class Load {
    
    private ByteArrayInputStream bais;
    
    public ArrayList<HashMap<String, Object>> loadMaps(String path) {
        ArrayList<HashMap<String, Object>> maps = new ArrayList<HashMap<String, Object>>();
        lMaps(path);
        bais.skip(1);
        while(getValue(3) > 0) {
            maps.add(getNextMap());
        }
        bais = null;
        return maps;
    }
    
    private void lMaps(String path) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(path);
        } catch (FileNotFoundException ex) {}
        byte[] data = null;
        try {
            data = new byte[fis.available()];
            fis.read(data);
            fis.close();
        } catch (IOException ex) {}
        bais = new ByteArrayInputStream(Encode.encode(data));
    }
    
    private HashMap<String, Object> getNextMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        byte[] data = new byte[getValue(1)];
        bais.read(data, 0, data.length);
        map.put("name", new String(data));
        int[] wh = {getValue(1), getValue(1)};
        map.put("wh", wh);
        int[][] tiles = new int[wh[1]][wh[0]];
        for(int i=0; i<wh[1]; i++) {
            for(int j=0; j<wh[0]; j++) {
                tiles[i][j] = getValue(1);
            }
        }
        map.put("tiles", tiles);
        int[] time = {getValue(1), getValue(1)};
        map.put("time", time);
        int points = getValue(2);
        map.put("points", ""+points);
        return map;
    }
    
    private int getValue(int d) {
        switch(d) {
            case 1:
                return bais.read();
            case 2:
                return bais.read()*256+bais.read();
            case 3:
                return bais.read()*65536+bais.read()*256+bais.read();
        }
        return 0;
    }
    
}