package gamepacker;

import java.io.*;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
/**
 *
 * @author user
 */
public class Packing {
    
    private JFrame window;
    
    public Packing(JFrame window) {
        this.window = window;
    }
    
    public void packGraphics(String pOpen, String pSave) {
        byte[] data = null;
        FileInputStream fis = null;
        FileOutputStream fos = null;
        
        String error = null;
        label:
        {
            File file = new File(pOpen);
            File[] files = file.listFiles(new FilenameFilter() {
                @Override
                public boolean accept(File dir, String name) {
                    if(name.endsWith(".png") || name.endsWith(".jpg")) {
                        return true;
                    }
                    return false;
                }
            });
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            for(int i=0; i<files.length; i++) {
                try {
                    fis = new FileInputStream(files[i]);
                } catch (FileNotFoundException ex) {}
                try {
                    data = new byte[fis.available()];
                    fis.read(data);
                    fis.close();
                } catch (IOException ex) {}
                error = putImage(baos, files[i].getName(), data);
                if(error != null) break label;
            }
            try {
                fos = new FileOutputStream(pSave);
            } catch (FileNotFoundException ex) {}
            try {
                fos.write(Encode.encode(baos.toByteArray()));
                fos.close();
            } catch (IOException ex) {}
        }
        if(error == null) {
            JOptionPane.showMessageDialog(window, "Packing is completed!", "Information Message", JOptionPane.INFORMATION_MESSAGE);
        } else {
            JOptionPane.showMessageDialog(window, "Error at time packing!\n"+error, "Error Message", JOptionPane.ERROR_MESSAGE);
        }
    }
    
    public void packMaps(ArrayList<HashMap<String, Object>> maps, String pSave) {
        FileOutputStream fos = null;
        
        String error = null;
        label:
        {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(maps.size());
            for(int i=0; i<maps.size(); i++) {
                HashMap<String, Object> map = maps.get(i);
                error = putLevel(baos, map);
                if(error != null) break label;
            }
            try {
                fos = new FileOutputStream(pSave);
            } catch (FileNotFoundException ex) {}
            try {
                fos.write(Encode.encode(baos.toByteArray()));
                fos.close();
            } catch (IOException ex) {}
        }
        if(error == null) {
            JOptionPane.showMessageDialog(window, "Packing is completed :)", "Information Message", JOptionPane.INFORMATION_MESSAGE);
        } else {
            JOptionPane.showMessageDialog(window, "Error at time packing :(\n"+error, "Error Message", JOptionPane.ERROR_MESSAGE);
        }
    }
    
    private String putImage(ByteArrayOutputStream baos, String name, byte[] image) {
        String error = null;
        label:
        {
            name = name.substring(0, name.lastIndexOf('.'));
            baos.write(name.length());
            baos.write(name.getBytes(), 0, name.length());
            writeValue(baos, image.length, 2);
            baos.write(image, 0, image.length);
        }
        return error;
    }
    
    private String putLevel(ByteArrayOutputStream baos, HashMap<String, Object> map) {
        String error = null;
        label:
        {
            ByteArrayOutputStream map_baos = new ByteArrayOutputStream();
            String name = (String)map.get("name");
            map_baos.write(name.length());
            map_baos.write(name.getBytes(), 0, name.length());
            int[] wh = (int[])map.get("wh");
            for(int i=0; i<wh.length; i++) {
                map_baos.write(wh[i]);
            }
            int[][] tiles = (int[][])map.get("tiles");
            for(int i=0; i<tiles.length; i++) {
                for(int j=0; j<tiles[i].length; j++) {
                    map_baos.write(tiles[i][j]);
                }
            }
            int[] time = (int[])map.get("time");
            for(int i=0; i<time.length; i++) {
                map_baos.write(time[i]);
            }
            int points = toInt(map.get("points"));
            writeValue(map_baos, points, 2);
            writeValue(baos, map_baos.size(), 3);
            baos.write(map_baos.toByteArray(), 0, map_baos.size());
        }
        return error;
    }
    
    private int toInt(Object value) {
        return Integer.parseInt(""+value);
    }
    
    private void writeValue(ByteArrayOutputStream baos, int value, int d) {
        int p1 = 0, p2 = 0;
        if(d == 3) baos.write(p1 = value/65536);
        if(d == 2 || d == 3) {
            baos.write(p2 = (value-p1*65536)/256);
            baos.write(value-p1*65536-p2*256);
        }
    }
    
}
