import game.S;
import java.util.Timer;
import java.util.TimerTask;
/**
 *
 * @author user
 */
public class GlassBlock extends TimerTask {
    
    private boolean crash, fall;
    private int sHeight, delay, gbY;
    private Timer timer;
    
    private S gb, fallGB;
    
    /*
     * Конструктор класса, принимает высоту экрана, спрайта стеклянного блока, спрайт разбившегося стеклянного блока, и задержку анимации
     */
    public GlassBlock(int sHeight, S gb, S fallGB, int delay) {
        this.sHeight = sHeight;
        this.gb = gb;
        gbY = gb.getY();
        this.fallGB = fallGB;
        this.delay = delay;
        timer = new Timer();
    }
    
    /*
     * Возвращает спрайт стеклянного блока
     */
    public S getGlassBlock() {
        return gb;
    }
    
    /*
     * Разбивает стеклянный блок
     */
    public void crash() {
        if(!crash) {
            timer.scheduleAtFixedRate(this, delay, delay);
            crash = true;
        }
    }
    
    /*
     * Цикл run, осуществляает анимацию разбивания блока
     */
    public void run() {
        if(!fall) {
            gb.nextFrame();
            if(gb.getFrame() == 5) {
                fallGB.setPosition(gb.getX(), gb.getY());
                gb.setPosition(-gb.getX(), gb.getY());
                fall = true;
            }
        } else {
            fallGB.move(0, 10);
            if(fallGB.getY() > gbY+sHeight*2) {
                fallGB.setPosition(-fallGB.getWidth(), -fallGB.getHeight());
                timer.cancel();
            }
        }
    }
    
}
