import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import javax.microedition.lcdui.Image;
/**
 *
 * @author user
 */
public class ILoader {
    
    private Hashtable hashtable;
    
    /*
     * Конструктор класса, инициализирует и загружает картинки из resource про адресу 'path'
     */
    public ILoader(String path) {
        InputStream is = getClass().getResourceAsStream(path);
        byte[] bytes = null;
        try {
            bytes = new byte[is.available()];
            is.read(bytes);
            is.close();
        } catch (IOException ex) {}
        is = null;
        ByteArrayInputStream bais = new ByteArrayInputStream(Encode.encode(bytes));
        bytes = null;
        
        int size;
        String name;
        hashtable = new Hashtable();
        while((size = bais.read()) != -1) {
            bytes = new byte[size];
            bais.read(bytes, 0, size);
            name = new String(bytes);
            bytes = new byte[bais.read()*256+bais.read()];
            bais.read(bytes, 0, bytes.length);
            hashtable.put(name, Image.createImage(bytes, 0, bytes.length));
            name = null;
            bytes = null;
        }
    }
    
    /*
     * Возвращает картинку с именем name
     */
    public Image get(String name) {
        return (Image)hashtable.get(name);
    }
    
}
