import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

/**
 *
 * @author AlexeyW
 */
public class Joystick {
    
    private int jX, jY, dBack;
    private int[] lXY;
    private Image joy;
    private Ball ball;
    
    private final static float AGL_225 = 0.38268343f;
    private final static float AGL_675 = 0.9238795f;
    
    /*
     * Конструктор класса, инициализирует данные. jX и jY - координаты джойстика, joy - спрайт джойстика, ball - класс шарика
     */
    public Joystick(int jX, int jY, Image joy, Ball ball) {
        this.jX = jX;
        this.jY = jY;
        this.joy = joy;
        this.ball = ball;
        lXY = new int[2];
        lXY[0] = lXY[1] = -1;
    }
    
    /*
     * Выводит спрайт джойстика на экран
     */
    public void paint(Graphics g) {
        g.drawImage(joy, jX, jY, 20);
    }
    
    /*
     * Проверяет нажатие на экран, принимает presssed, released и dragged значения курсора
     */
    public void pCheck(int pX, int pY, int rX, int rY, int dX, int dY) {
        if(Wand.isAction(pX, pY)) {
            action(pX, pY);
        } else {
            if(Wand.isAction(dX, dY)) {
                action(dX, dY);
                lXY[0] = dX; lXY[1] = dY;
            } else {
                if(Wand.isAction(lXY[0], lXY[1])) action(lXY[0], lXY[1]);
            }
        }
        if(Wand.isAction(rX, rY)) {
            if(dBack != 0) {
                ball.stopMove(dBack);
                dBack = 0;
            }
            lXY[0] = lXY[1] = -1;
        }
    }
    
    /*
     * Приватный метод, проверяет какой действие совершает игрок (прыжок или движение)
     */
    private void action(int x, int y) {
        float sin = getAngle(jX-x, jY-y);
        if(sin >= AGL_225 && (jY-y) > 48) {
            ball.jump();
        }
        if(Math.abs(sin) <= AGL_675) {
            int dir = x < jX ? 1 : 2;
            if(dBack != 0 && dBack != dir) ball.stopMove(dBack); dBack = 0;
            ball.startMove(dir);
            if(dBack == 0) dBack = dir;
        }
    }
    
    /*
     * Приватный метод, узнает угол между точкой нажатия на экран и центром джойстика
     */
    private float getAngle(int x, int y) {
        return y/(float)Math.sqrt(sqr(x)+sqr(y));
    }
    
    /*
     * Приватный метод, возводит число в квадрат
     */
    private int sqr(int n) {
        return n*n;
    }
    
}