import javax.microedition.lcdui.game.Sprite;
/**
 *
 * @author user
 */
public class Lift {
    
    private boolean isIn, isOut, inLiftOut;
    private int x, bx, mode;
    private int[][] InOut;
    private float t;
    private Sprite inLift, outLift, ball;
    
    /*
     * Конструктор класса, инициализирует и принимает inLift - спрайт лифта для подъема, outLift - спрайт лифта для спуска, координаты лифтов, и спрайт шарика (ball)
     */
    public Lift(Sprite inLift, Sprite outLift, int[][] InOut, Sprite ball) {
        this.inLift = inLift;
        this.outLift = outLift;
        this.InOut = InOut;
        this.ball = ball;
        inLift.setPosition(InOut[0][0], InOut[0][1]);
        ball.setPosition(InOut[0][0]+inLift.getWidth()/2-ball.getWidth()/2, InOut[0][1]+inLift.getHeight()-ball.getWidth());
        outLift.setPosition(InOut[2][0], InOut[2][1]);
    }
    
    /*
     * Запускает лифт для подъема (шарик поднимается вместе с лифтом)
     */
    public void inStart() {
        t = 0;
        bx = 0;
        mode = 1;
        inLiftOut = false;
        isIn = false;
    }
    
    /*
     * Возвращает состояние лифта для подъема, true - если шарик сошел с лифта
     */
    public boolean isIn() {
        return isIn;
    }
    
    /*
     * Запускает лифт для спуска (шарик спускается вместе с лифтом)
     */
    public void outStart() {
        t = 0;
        bx = 0;
        mode = 2;
        isOut = false;
    }
    
    /*
     * Возвращает состояние лифта для спуска, true - если шарик покуинул уровень
     */
    public boolean isOut() {
        return isOut;
    }
    
    /*
     * Цикличная функция, производит движение запущенного лифта, где t - 1/fps
     */
    public void move(float t) {
        if(mode == 1) {
            if(!inLiftOut) {
                if(inLift.getY() > InOut[1][1]) {
                    x = (int)(1.0f*this.t*60);
                    this.t+=t;
                    if(x != bx) {
                        inLift.move(0, -(x-bx));
                        ball.move(0, -(x-bx));
                    }
                    bx = x;
                } else {
                    this.t = 0;
                    bx = 0;
                    inLiftOut = true;
                }
            } else {
                if(ball.getX() < InOut[1][0]+inLift.getWidth()*1.5f-ball.getWidth()/2) {
                    x = (int)(0.5f*this.t*60);
                    this.t+=t;
                    if(x != bx) ball.move(x-bx, 0);
                    bx = x;
                } else {
                    isIn = true;
                }
            }
        }
        if(mode == 2) {
            if(outLift.getY() < InOut[3][1]) {
                x = (int)(1.0f*this.t*60);
                this.t+=t;
                if(x != bx) {
                    outLift.move(0, x-bx);
                    ball.move(0, x-bx);
                }
                bx = x;
            } else {
                isOut = true;
            }
        }
    }
    
}
