import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

/**
 *
 * @author user
 */
public class MapList {
    
    private boolean wasMotion;
    private int sWidth, sHeight, cIndex, lHeight, lMax;
    private String[] list;
    private Image bg, board, title;
    private Image[] button, button_long1, button_long2;
    private Button m_create, m_start, m_back, m_edit, m_delete;
    private DrawText dt;
    
    private ScrollBar scrollBar;
    
    /*
     * Конструктор класса, инициализирует и принимает, sWidth и sHeight - ширину и высоту экрана, массив строк (список уровней), картинку фона, картинку рамки, две картинки нопки, и класс DrawText
     */
    public MapList(int sWidth, int sHeight, String[] list, Image bg, Image board, Image title, Image[] button, Image[] button_long1, Image[] button_long2, DrawText dt) {
        this.sWidth = sWidth;
        this.sHeight = sHeight;
        this.list = list;
        this.bg = bg;
        this.board = board;
        this.title = title;
        this.button = button;
        this.button_long1 = button_long1;
        this.button_long2 = button_long2;
        this.dt = dt;
        lHeight = 14+8;
        lMax = 220-title.getHeight();
        
        if(list.length*lHeight > lMax) {
            scrollBar = new ScrollBar(22, 30+title.getHeight(), sWidth-48, lMax, (list.length*lHeight)-lMax, list.length*lHeight, false);
        }
        
        m_create = new Button();
        m_start = new Button();
        m_back = new Button();
        m_edit = new Button();
        m_delete = new Button();
    }
    
    public Button getCreateButton() {
        return m_create;
    }
    
    public Button getStartButton() {
        return m_start;
    }
    
    public Button getBackButton() {
        return m_back;
    }
    
    public Button getEditButton() {
        return m_edit;
    }
    
    public Button getDeleteButton() {
        return m_delete;
    }
    
    /*
     * Возвращает максимальную высоту списка карт
     */
    public int getlMax() {
        return lMax;
    }
    
    /*
     * Возвращает текущий индекс выбранной карты
     */
    public int getCurrentIndex() {
        return cIndex;
    }
    
    /*
     * Перестраивает список list
     */
    public void rebuild(String[] list) {
        this.list = list;
        if(cIndex < 0) cIndex = 0;
        if(cIndex > list.length-1) cIndex = list.length-1;
    }
    
    /*
     * Цикличная функция, проверяет нажатие кнопок и нажатия на экран, принимает fps_time - 1/fps, кнопку pressed, указатель pressed, released и dragged
     */
    public boolean check(float fps_time, int pKey, int dKey, int pX, int pY, int rX, int rY, int dX, int dY) {
        int lY = scrollBar == null ? 0 : -scrollBar.getValue();
        if(pKey == -1 || pKey == Canvas.KEY_NUM2 || pKey == 116) {
            if(cIndex > 0) {
                cIndex--;
                if(lY+lHeight*cIndex < 0 && scrollBar != null) scrollBar.setValue(scrollBar.getValue()-lHeight);
            }
            
            if(scrollBar != null) {
                if(lY+lHeight*cIndex < 0) cIndex = -lY/lHeight;
                if(lY+cIndex*lHeight > lMax) cIndex = (-lY+lMax)/lHeight;
            }
        }
        if(pKey == -2 || pKey == Canvas.KEY_NUM8 || pKey == 98) {
            if(cIndex < list.length-1) {
                cIndex++;
                if(lY+lHeight*cIndex > lY+lMax-lHeight && scrollBar != null) scrollBar.setValue(scrollBar.getValue()+lHeight);
            }
            
            if(scrollBar != null) {
                if(lY+lHeight*cIndex < 0) cIndex = -lY/lHeight;
                if(lY+cIndex*lHeight > lMax) cIndex = (-lY+lMax)/lHeight;
            }
        }
        for(int i=0; i<list.length; i++) {
            if(Wand.region(rX, rY, 26, 30+title.getHeight()+lY+i*lHeight, sWidth-56, lHeight) && !wasMotion) {
                if(rY >= 30+title.getHeight() && rY < 30+title.getHeight()+lMax) {
                    if(cIndex != i) {
                        cIndex = i;
                    } else {
                        return true;
                    }
                }
            }
        }
        if(!wasMotion) {
            if(Wand.isAction(dX, dY)) wasMotion = true;
        } else {
            if(Wand.isAction(rX, rY)) wasMotion = false;
        }
        if(scrollBar != null) scrollBar.pCheck(fps_time, dKey, pX, pY, rX, rY, dX, dY);
        
        return false;
    }
    
    /*
     * Цикличная функция, принимает класс Graphics и отображает список карт
     */
    public void paint(Graphics g) {
        g.drawImage(bg, 0, 0, 20);
        g.drawImage(board, 20, 10, 20);
        if(list.length > 0) {
            g.drawImage(title, sWidth/2-title.getWidth()/2, 20, 20);
            dt.setColor(0xffffff);
            dt.drawString(g, sWidth/2-dt.stringWidth(Localization.getAloneText(64))/2, 20+title.getHeight()/2-7, Localization.getAloneText(64));
        }
        g.setClip(22, 30+title.getHeight(), sWidth-44, lMax);
        g.setColor(0x999999);
        int lY = scrollBar == null ? 0 : -scrollBar.getValue();
        for(int i=0; i<list.length; i++) {
            if(i == cIndex) {
                dt.setColor(0xe0e0e0);
                g.fillRect(40, 30+title.getHeight()+lY+i*lHeight, sWidth-80, lHeight);
            } else {
                dt.setColor(0x000000);
            }
            dt.drawString(g, sWidth/2-dt.stringWidth(list[i])/2, 30+title.getHeight()+lY+i*lHeight+lHeight/2-7, list[i]);
        }
        dt.setColor(0xe0e0e0);
        if(list.length == 0) {
            String sign = Localization.getAloneText(0);
            dt.drawString(g, sWidth/2-dt.stringWidth(sign)/2, 20+lMax/2-7, sign);
            sign = null;
        }
        g.setClip(0, 0, sWidth, sHeight);
        switch(Localization.getLocale()) {
            case Localization.EN:
                String string = Localization.getAloneText(1);
                m_create.paint(g, 10+dt.stringWidth(string)/2-button_long1[0].getWidth()/2, sHeight-24+7-button_long1[0].getHeight()/2+4, button_long1);
                m_edit.paint(g, sWidth/2-button_long1[0].getWidth()/2, 28+title.getHeight()+lMax+(sHeight-lMax-44-title.getHeight())/2-3+7-button_long1[0].getHeight()/2, button_long1);
                m_start.paint(g, sWidth/2-button_long1[0].getWidth()/2, sHeight-24+7-button_long1[0].getHeight()/2+4, button_long1);
                string = Localization.getAloneText(4);
                m_delete.paint(g, sWidth-dt.stringWidth(string)-2+dt.stringWidth(string)/2-button_long2[0].getWidth()/2-5, 28+title.getHeight()+lMax+(sHeight-lMax-44-title.getHeight())/2-3+7-button_long2[0].getHeight()/2, button_long2);
                string = Localization.getAloneText(5);
                m_back.paint(g, sWidth-dt.stringWidth(string)-10+dt.stringWidth(string)/2-button[0].getWidth()/2, sHeight-24+7-button[0].getHeight()/2+4, button);
                break;
            case Localization.RU:
                String string1 = Localization.getAloneText(1);
                m_create.paint(g, 10+dt.stringWidth(string1)/2-button_long1[0].getWidth()/2, sHeight-24+7-button_long1[0].getHeight()/2+4, button_long1);
                m_edit.paint(g, sWidth/2-button_long2[0].getWidth()/2, 28+title.getHeight()+lMax+(sHeight-lMax-44-title.getHeight())/2-3+7-button_long2[0].getHeight()/2, button_long2);
                m_start.paint(g, sWidth/2-button_long2[0].getWidth()/2, sHeight-24+7-button_long2[0].getHeight()/2+4,button_long2);
                string1 = Localization.getAloneText(4);
                m_delete.paint(g, sWidth-dt.stringWidth(string1)-2+dt.stringWidth(string1)/2-button_long2[0].getWidth()/2, 28+title.getHeight()+lMax+(sHeight-lMax-44-title.getHeight())/2-3+7-button_long2[0].getHeight()/2, button_long2);
                string1 = Localization.getAloneText(5);
                m_back.paint(g, sWidth-dt.stringWidth(string1)-10+dt.stringWidth(string1)/2-button[0].getWidth()/2, sHeight-24+7-button[0].getHeight()/2+4, button);
                break;
        }
        String string = Localization.getAloneText(1);
        dt.drawString(g, 10, sHeight-20, string);
        string = null;
        string = Localization.getAloneText(2);
        dt.drawString(g, sWidth/2-dt.stringWidth(string)/2, 28+title.getHeight()+lMax+(sHeight-lMax-44-title.getHeight())/2-3, string);
        string = null;
        string = Localization.getAloneText(3);
        dt.drawString(g, sWidth/2-dt.stringWidth(string)/2, sHeight-20, string);
        string = null;
        string = Localization.getAloneText(4);
        dt.drawString(g, sWidth-dt.stringWidth(string)-(Localization.getLocale() == Localization.EN ? 7 : 2), 28+title.getHeight()+lMax+(sHeight-lMax-44-title.getHeight())/2-3, string);
        string = null;
        string = Localization.getAloneText(5);
        dt.drawString(g, sWidth-dt.stringWidth(string)-10, sHeight-20, string);
        if(scrollBar != null) scrollBar.paint(g);
    }
    
}
