import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
/**
 *
 * @author user
 */
public class Records {
    
    private int sWidth, sHeight, lH, lMax;
    private int[] pWindow, mWindow, bColors = new int[] {0x999999, 0x999999};
    private String[][] records;
    private Image bg, board;
    private Image[] button;
    private Button back;
    private DrawText dt;
    private ScrollBar scrollBar;
    private Slider slider;
    private RMS rms;
    
    /*
     * Конструктор класса, инициализирует и принмает, wWidth и wHeight - ширину и высоту экрана, класс RMS, картинку фона, картинку рамки, картинку кнопки, класс DrawText
     */
    public Records(int sWidth, int sHeight, RMS rms, Image bg, Image board, Image[] button, DrawText dt) {
        this.sWidth = sWidth;
        this.sHeight = sHeight;
        this.rms = rms;
        this.bg = bg;
        this.board = board;
        this.button = button;
        this.dt = dt;
        pWindow = new int[3];
        mWindow = new int[3];
        
        getRecords(rms.getGameData()[4]-1);
        
        lH = 14+8;
        lMax = (board.getHeight()-24);
        
        back = new Button();
        
        String[] diff = Localization.getFullText(21);
        slider = new Slider(diff, sWidth/2-RB2.max(dt, diff[0], diff[1], diff[2])/2, 15-8, RB2.max(dt, diff[0], diff[1], diff[2]), 16, dt);
        slider.setIndex(rms.getGameData()[4]-1);
        
        if(records.length > 0 && records.length > 0) {
            initScroll();
        }
    }
    
    /*
     * Приватная функция, переводит скролл таблицы рекордов в начально положение (на 0)
     */
    private void initScroll() {
        if(lH*records.length > lMax-46) {
            scrollBar = new ScrollBar(25, 50, sWidth-50, lMax-46, lH*records.length-(lMax-46), lH*records.length, false);
            scrollBar.setVisibleScroll(false);
        }
    }
    
    /*
     * Возвращает скролл таблицы рекордов
     */
    public ScrollBar getScrollBar() {
        return scrollBar;
    }
    
    public Button getBackButton() {
        return back;
    }
    
    /*
     * Приватная функция, правильно округляет float до int
     */
    private int round(float f) {
        return (int)(f+0.5f);
    }
    
    /*
     * Цикличная функция, проверяет нажатие кнопок на экран типа pressed, released и dragged
     */
    public void check(int pKey, int rKey, int dKey, int pX, int pY, int rX, int rY, int dX, int dY) {
        if(bColors[0] == 0x999999 && (pKey == -3 || pKey == Canvas.KEY_NUM4 ||  pKey == 102) && slider.getIndex() > 0) {
            bColors[0] = 0xb97a57;
        }
        if(bColors[0] == 0xb97a57 && (rKey == -3 || rKey == Canvas.KEY_NUM4 ||  rKey == 102) && slider.getIndex() > 0) {
            slider.setIndex(slider.getIndex()-1);
            getRecords(slider.getIndex());
            bColors[0] = 0x999999;
        }
        if(bColors[1] == 0x999999 && (pKey == -4 || pKey == Canvas.KEY_NUM6 || pKey == 104) && slider.getIndex() < 2) {
            bColors[1] = 0xb97a57;
        }
        if(bColors[1] == 0xb97a57 && (rKey == -4 || rKey == Canvas.KEY_NUM6 || rKey == 104) && slider.getIndex() < 2) {
            slider.setIndex(slider.getIndex()+1);
            getRecords(slider.getIndex());
            bColors[1] = 0x999999;
        }
        slider.pCheck(pX, pY, rX, rY, dX, dY);
        if(slider.hasValue()) {
            getRecords(slider.getIndex());
        }
        if(records.length > 0) {
            if(scrollBar != null) {
                int lY = -scrollBar.getValue();
                if((dKey == -1 || dKey == Canvas.KEY_NUM2 || dKey == 116) && lY < 0) {
                    scrollBar.setValue(scrollBar.getValue()-1);
                }
                if((dKey == -2 || dKey == Canvas.KEY_NUM8 || dKey == 98) && lY > (lMax-46)-lH*records.length) {
                    scrollBar.setValue(scrollBar.getValue()+1);
                }
            }
        }
    }
    
    /*
     * Приватный метод загрузки рекордов
     */
    private void getRecords(int diff) {
        int[][] temp_records = rms.getRecords(diff);
        records = new String[temp_records.length][3];
        for(int j=0; j<records.length; j++) {
            records[j][0] = Localization.getAloneText(46)+temp_records[j][0];
            int second = (int)((temp_records[j][1]-(temp_records[j][1]/60000*60000))/1000);
            records[j][1] = (temp_records[j][1]/60000)+":"+(second < 10 ? "0" : "")+second;
            records[j][2] = ""+temp_records[j][2];
            for(int k=0; k<mWindow.length; k++) {
                mWindow[k] = Math.max(mWindow[k], dt.stringWidth(records[j][k])+8);
            }
        }
        float mAll = mWindow[0]+mWindow[1]+mWindow[2];
        for(int j=0; j<mWindow.length; j++) {
            pWindow[j] = (j == 0 ? 0 : pWindow[j-1]+mWindow[j-1]);
            mWindow[j] = round((sWidth-50)*(mWindow[j]/mAll));
        }
    }
    
    /*
     * Цикличная функция, принмает класс Graphics и отображает таблицу рекордов
     */
    public void paint(Graphics g) {
        g.drawImage(bg, 0, 0, 20);
        g.drawImage(board, 20, 30, 20);
        dt.setColor(0xe0e0e0);
        slider.paint(g);
        g.setColor(bColors[0]);
        if(slider.getIndex() > 0) {
            g.fillTriangle(slider.getX()-8, slider.getY()+2, slider.getX()-8, slider.getY()+slider.getHeight()-2, slider.getX()-18, slider.getY()+slider.getHeight()/2);
        }
        g.setColor(bColors[1]);
        if(slider.getIndex() < 2) {
            g.fillTriangle(slider.getX()+slider.getWidth()+8, slider.getY()+2, slider.getX()+slider.getWidth()+8, slider.getY()+slider.getHeight()-2, slider.getX()+slider.getWidth()+18, slider.getY()+slider.getHeight()/2);
        }
        
        dt.setColor(0xd0d0d0);
        if(records.length == 0) {
            String sign = Localization.getAloneText(47);
            dt.drawString(g, sWidth/2-dt.stringWidth(sign)/2, 30+lMax/2-7, sign);
            sign = null;
        } else {
            g.setClip(25, 42, sWidth-50, lMax);
            g.setColor(0xd0d0d0);
            g.drawRect(25, 42, sWidth-51, lMax-1);
            for(int i=0; i<records.length; i++) {
                int lY = scrollBar != null ? -scrollBar.getValue() : 0;
                g.drawRect(25, 42+lY+lH*i, sWidth-51, lH);
                for(int j=0; j<pWindow.length; j++) {
                    if(j > 0) {
                        g.drawLine(25+pWindow[j], 42+lY+lH*i, 25+pWindow[j], 42+lY+lH*i+lH);
                    }
                    dt.drawString(g, 25+pWindow[j]+mWindow[j]/2-dt.stringWidth(records[i][j])/2, 42+lY+lH*i+lH/2-7, records[i][j]);
                }
            }
            //if(records.length == 0) {
            //    String sign = Localization.getAloneText(48);
            //    dt.drawString(g, 25+(sWidth-50)/2-dt.stringWidth(sign)/2, 42+lMax/2-7, sign);
            //    sign = null;
            //}
        }
        g.setClip(0, 0, sWidth, sHeight);
        String string = Localization.getAloneText(39);
        dt.setColor(0xffffff);
        int x = sWidth-dt.stringWidth(string)-14;
        back.paint(g, x+dt.stringWidth(string)/2-button[0].getWidth()/2, sHeight-23+7-button[0].getHeight()/2, button);
        dt.drawString(g, x+1, sHeight-23, string);
        string = null;
    }
    
}
