import javax.microedition.lcdui.Graphics;

/**
 *
 * @author AlexeyW
 */
public class Slider {
    
    private boolean has;
    private int idx, wX, wY, wWidth, wHeight, sX, bX, move, dMove;
    private int[] lX, clip;
    private String[] l;
    
    private DrawText dt;
    
    /*
     * Конструктор класса, инициализирует и принмает, l - массив строк слайдера, wX - wY - wWidth - wHeight - положение слайдера на экране и его высота с шириной, класс DrawText
     */
    public Slider(String[] l, int wX, int wY, int wWidth, int wHeight, DrawText dt) {
        this.l = l;
        this.wX = wX;
        this.wY = wY;
        this.wWidth = wWidth;
        this.wHeight = wHeight;
        this.dt = dt;
        lX = new int[l.length];
        for(int i=0; i<l.length; i++) {
            lX[i] = wWidth*i+(wWidth/2-dt.stringWidth(l[i])/2);
        }
        clip = new int[4];
    }
    
    /*
     * Цикличная функция, возвращает true - если проищошла смена значения в слайдере
     */
    public boolean hasValue() {
        if(has) {
            has = false;
            return true;
        }
        return false;
    }
    
    /*
     * Устанавливает X координату слайдера
     */
    public void setX(int x) {
        wX = x;
    }
    
    /*
     * Возвращает X координату слайдера
     */
    public int getX() {
        return wX;
    }
    
    /*
     * Возврашает Y координату слайдера
     */
    public int getY() {
        return wY;
    }
    
    /*
     * Возвращает ширину слайдера
     */
    public int getWidth() {
        return wWidth;
    }
    
    /*
     * Возвращает высоту слайдера
     */
    public int getHeight() {
        return wHeight;
    }
    
    /*
     * Устанавливает индекс (элемент массива l) слайдера
     */
    public void setIndex(int idx) {
        this.idx = idx;
        sX = -(idx*wWidth);
    }
    
    /*
     * Возвращет индекс (элемент массива l) слайдера
     */
    public int getIndex() {
        return idx;
    }
    
    /*
     * Цикличная функция, проверяет нажатие кнопок и нажатия на экран, нажатия на экран типа pressed, released и dragged
     */
    public void pCheck(int pX, int pY, int rX, int rY, int dX, int dY) {
        if(move == 0) {
            if(bX == 0 && pY >= wY && pY < wY+wHeight) {
                bX = pX;
            }
            if(bX != 0 && dY >= wY && dY < wY+wHeight) {
                sX += dX-bX;
                if(sX > 0) {
                    idx = 0;
                    has = true;
                    sX = 0;
                }
                if(sX <= -(wWidth*(l.length-1))) {
                    idx = l.length-1;
                    has = true;
                    sX = -(wWidth*(l.length-1));
                }
                bX = dX;
            }
            if(bX != 0 && rY >= wY && rY < wY+wHeight) {
                for(int i=0; i<l.length-1; i++) {
                    if(sX+wWidth*(i+1) > 0 && sX+wWidth*(i+1) < wWidth) {
                        if(sX+wWidth*(i+1) > wWidth/2) {
                            idx = i;
                            has = true;
                            dMove = wWidth-(sX+wWidth*(i+1));
                            move = 2;
                        } else {
                            idx = i+1;
                            has = true;
                            dMove = sX+wWidth*(i+1);
                            move = 1;
                        }
                        break;
                    }
                }
                bX = 0;
            }
        } else {
            if(move == 1) sX--;
            if(move == 2) sX++;
            dMove--;
            if(dMove <= 0) move = 0;
        }
    }
    
    /*
     * Цикличная функция, принмает класс Graphics, ширину и высоту экрана, и отображает слайдер
     */
    public void paint(Graphics g) {
        getClip(g);
        g.setClip((wX < clip[0] ? clip[0] : wX), (wY < clip[1] ? clip[1] : wY), (wX < clip[0] ? wWidth-(clip[0]-wX) : wWidth), (wY < clip[1] ? wHeight-(clip[1]-wY) : wHeight));
        for(int i=0; i<l.length; i++) {
            dt.drawString(g, wX+sX+lX[i], wY+wHeight/2-7, l[i]);
        }
        setClip(g);
    }
    
    /*
     * Приватная функция, записывает в массив текущий сетКлип класса Graphics
     */
    private void getClip(Graphics g) {
        clip[0] = g.getClipX();
        clip[1] = g.getClipY();
        clip[2] = g.getClipWidth();
        clip[3] = g.getClipHeight();
    }
    
    /*
     * Востанавливает сетКлип из массива для класса Graphics
     */
    private void setClip(Graphics g) {
        g.setClip(clip[0], clip[1], clip[2], clip[3]);
    }
    
}