package game;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.LayerManager;

/**
 *
 * @author user
 */

public class LM {
    
    private int sWidth, sHeight;
    private L[] layers;
    private LayerManager lm;
    
    public LM(int sWidth, int sHeight) {
        this.sWidth = sWidth;
        this.sHeight = sHeight;
        lm = new LayerManager();
        layers = new L[0];
    }
    
    private void append_layer(L layer) {
        L[] temp_layers = new L[layers.length+1];
        temp_layers[layers.length] = layer;
        System.arraycopy(layers, 0, temp_layers, 0, layers.length);
        layers = temp_layers;
        temp_layers = null;
    }
    
    public void append(S sprite) {
        lm.append(sprite);
        append_layer(sprite);
    }
    public void append(TL tl, int x, int y) {
        tl.appendTo(lm, x, y);
        append_layer(tl);
    }
    
    public void paint(Graphics g, int x, int y) {
        lm.paint(g, x, y);
    }
    
    public void check(int x, int y) {
        for(int i=0; i<layers.length; i++) {
            layers[i].check(x, y, sWidth, sHeight);
        }
    }
    
}
