import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
/**
 *
 * @author AlexeyW
 */
public class Handler extends Canvas {
    
    private RB2 rb2;
    
    /*
     * Конструктор класса, принимает главный класс RB2
     */
    public Handler(RB2 rb2) {
        this.rb2 = rb2;
    }
    
    /*
     * Возвращает true, если телефон поддерживает сенсорное управление
     */
    public boolean pUsing() {
        if(hasPointerEvents() && hasPointerMotionEvents() && hasRepeatEvents()) {
            return true;
        }
        return false;
    }

    /*
     * Вызывает главную отрисовку класса RB2
     */
    public void paint(Graphics g) {
        rb2.paint(g);
    }
    
    /*
     * Считывает код клавиши, если клавиша нажата
     */
    public void keyPressed(int keyCode) {
        if(rb2.pKey == 0) rb2.pKey = keyCode;
        if(rb2.dKey == 0) rb2.dKey = keyCode;
        if(!rb2.keys[rb2.KEY_FIRE] && (keyCode == Canvas.UP || keyCode == Canvas.KEY_NUM2 || keyCode == -1 || keyCode == 116)) rb2.keys[rb2.KEY_FIRE] = true;
        if(!rb2.keys[rb2.KEY_LEFT] && (keyCode == Canvas.LEFT || keyCode == Canvas.KEY_NUM4 || keyCode == -3 || keyCode == 102)) rb2.keys[rb2.KEY_LEFT] = true;
        if(!rb2.keys[rb2.KEY_RIGHT] && keyCode == Canvas.RIGHT || keyCode == Canvas.KEY_NUM6 || keyCode == -4 || keyCode == 104) rb2.keys[rb2.KEY_RIGHT] = true;
    }
    
    /*
     * Считывает код клавиши, если клавиша отпушена
     */
    public void keyReleased(int keyCode) {
        if(rb2.rKey == 0 && !rb2.press_rpKey) rb2.rKey = keyCode;
        if(rb2.dKey == keyCode) rb2.dKey = 0;
        if(rb2.press_rpKey) rb2.press_rpKey = false;
        if(rb2.keys[rb2.KEY_FIRE] && (keyCode == Canvas.UP || keyCode == Canvas.KEY_NUM2 || keyCode == -1 || keyCode == 116)) rb2.keys[rb2.KEY_FIRE] = false;
        if(rb2.keys[rb2.KEY_LEFT] && (keyCode == Canvas.LEFT || keyCode == Canvas.KEY_NUM4 || keyCode == -3 || keyCode == 102)) rb2.keys[rb2.KEY_LEFT] = false;
        if(rb2.keys[rb2.KEY_RIGHT] && keyCode == Canvas.RIGHT || keyCode == Canvas.KEY_NUM6 || keyCode == -4 || keyCode == 104) rb2.keys[rb2.KEY_RIGHT] = false;
    }
    
    /*
     * Считывает код клавиши, если клавиша зажата
     */
    public void keyRepeated(int keyCode) {
        if(rb2.hKey == 0) rb2.hKey = keyCode;
        if(rb2.rpKey == 0 && !rb2.press_rpKey) {
            rb2.rpKey = keyCode;
            rb2.press_rpKey = true;
        }
    }
    
    /*
     * Считывает координаты нажатия пальца на экран
     */
    public void pointerPressed(int x, int y) {
        rb2.pX = x;
        rb2.pY = y;
    }
    
    /*
     * Считывает коордианты отпускания пальца от экрана
     */
    public void pointerReleased(int x, int y) {
        rb2.rX = x;
        rb2.rY = y;
    }
    
    /*
     * Считывает координаты движения пальца по экрану
     */
    public void pointerDragged(int x, int y) {
        rb2.dX = x;
        rb2.dY = y;
    }
    
}