/**
 *
 * @author AlexeyW
 */
public class Localization {
    
    private static int locale;
    
    public static final int EN = 0;
    public static final int RU = 1;
    
    private static final String[][] alone_localization = {
        {"No maps", "Create", "Edit (0)", "Start", "Delete (#)", "Back", "Map ", "Name:", "Width:", "Height:", "Continue", "Back", "Cell ", "Save", "Exit", "Too close to", " another ",
        "lift", "Lift for ", "elevating", "descending", " is not set", "Not on the same line with lift", "Wrong direction", "On the line with the other lift", "Lift is not set for elevating",
        "Lift is not set for descending", "Point is not set for elevating", "Point is not set for descending", "Vibration: ", "Off", "On", "Level of complexity: ", "Time: ", "Reset the game: ", "No", 
        "Reset the game: No / ", "Yes", "No / Yes", "Back", "Level ", "This level of complexity", "will be opened after", "the passing game.", "+2500 points!", "Open a new complexity!",
        "Level ", "No records", "No records", "Language: ", "English", "Russian", "Cancel", "Sound:", "Off", "On", "Enable sound?", "Yes", "No", "Close", "Back", "Select language: ", "English", "Russian", "Selection map"},
        {"Нет карт", "Создать", "Редакт. (0)", "Запустить", "Удалить (#)", "Назад", "Map ", "Название:", "Ширина:", "Высота:", "Продолжить", "Назад", "Ячейка ", "Сохранить", "Выход", "Слишком близко к", " другому ",
        "лифту", "Лифт для ", "подъема", "спуска", " еще не установлен", "Не на одной линии с лифтом", "Неверное направление", "На одной линии с другим лифтом", "Не установлен лифт для подъема",
        "Не установлен лифт для спуска", "Не установлена точка подъема", "Не установлена точка спуска", "Вибрация: ", "Выкл", "Вкл", "Уровень сложности: ", "Время: ", "Сброс игры: ", "Нет",
        "Сброс игры: Нет / ", "Да", "Нет / Да", "Назад", "Уровень ", "Данный уровень сложности", "будет открыт после", "прохождения игры.", "+2500 очков!", "Открыта новая сложность!",
        "Уровень ", "Нет рекордов", "Нет рекордов", "Язык: ", "Английский", "Русский", "Отмена", "Звук:", "Выкл", "Вкл", "Включить звук?", "Да", "Нет", "Закрыть", "Назад", "Выберите язык: ", "Английский", "Русский", "Выбор карты"}
    };
    private static final String[][][] full_localization = {
        {   {"Continue", "New Game", "Map editor", "Scores", "Settings", "Help", "About", "Exit"},
            {"Level ", "Points: ", "Quickness of jumping: ", "Quickness of moving: ", " m/s", "Lowering of quickness after of jumping away on: ", " %", "Start playing", "Increasing the speed moving on 0.1 m/s (1500 points)", "Increasing the speed jumping on 0.1 m/s (2000 points)", "Lowering of down falling quickness after jumping away on 2% (2500 points)", "Level of difficulty:", "Easy", "Normal", "Hard"},
            {"Starting a new game will", "delete your current progress.", "Proceed anyway?", "Yes", "No"},
            {"The aim of the game:\n\nPass the level for are definite time. After passing the level, will be credited a certain number of points. For the obtained points can upgrade the characteristics of the ball.\n", "\nControl:\n\n4 - moving to the lift\n 6 - moving to the right\n2 - jump\nLeft Soft - pause\n\n", "Control for the touch screen:\n\nControl in the game going by pressing and moving of the finger on translucent circle on the screen.\n\n", "\nOrdinary moving can be done by clicking beside with a circle according to the side, where you want to move the ball. To make the jump is enough to press a slightly above the circle.\n\n", "Back"},
            {"Rebound Ball 2", "\nVersion 1.0.2\n\nProject Lead:\nRoman Baglay\n\nProgrammer:\nAlexey Popov\n\nGraphics:\nPavel Shevelev\nKirill Sukhorukov\n\nDeveloped by:\nEternity Games\nwww.e-games.su\n\nPublushed by:\nDaSuppa Studios\nwww.dasuppa.com\n\n(c) Eternity Games 2012\n", "Back"},
            {"Do you want to quit the game?", "Yes", "No"},
            {"Help to the map editor:\n\nMaking maps for the game very easy. First set the blocks in order you like.\n\nControl for moving cells:\n2, 4, 6, 8 - up, down, left, right and joystick - up, left, right, down.\n5 - set or remove block.\n1 and 3 -  moving on slider.\n0 - change the slider.\n\nAfter setting blocks, you will need to set lifts. First of all, set the lift, which the ball will be lifting. Do not forget to set the point from which the lift will appear. In the same way set the lift on which the ball will leave the level.\n", "Do not show"},
            {"Start playing", "Upgrade ball", "Choice level", "Back"},
            {"Exit", "Exit to main menu?", "No", "Yes", "Game over", "Level", "Again", "Scores", "Time", "Passed"},
            {"Do you want reset the game?\nIf you click \"Yes\", there will be a full reset and the game closes.", "Yes", "No"},
            {"Continue", "Restart", "Help", "Exit"},
            {"Are you really want", "restart this level?", "Are you really want", "exit to menu?", "Yes", "No"},
            {"Pass the level for are difinite time.", "After passing the level, will be", "credited a certain number of points.", "Close"},
            {"Congratulations! You earned ", " bonuses.", "Now you can improve your ball", "in section \"Upgrade ball\"."},
            {"Continue", "Restart", "Map Editor", "Exit"},
            {"You did not pass the level.", "Replay?", "Yes", "No"},
            {"Time is up.", "Replay?", "Yes", "No"},
            {"That jump to the top blocks, you need", " to accelerate aside the wall and just", "before the clash press jump.", "Close"},
            {"All unsaved data will be lost.", "Continue?", "Yes", "No"},
            {"This upgrade will be opened after", "the passing game.", "Close"},
            {"Congratulations!", "You completed the game on a ", "easy difficulty.", "difficult complexity.", "hard difficulty.", " points!", "Open a new complexity:", "Hard", "Open a new upgrade:", "Lowering of down falling", "quickness after jumping away on 2%."},
            {"Easy", "Normal", "Hard"}},
        {   {"Продолжить", "Новая игра", "Редактор карт", "Рекорды", "Настройки", "Помощь", "Об игре", "Выход"},
            {"Уровень ", "Очки: ", "Скорость прыжка: ", "Скорость движения: ", " м/с", "Падение скорости после отскока на: ", " %", "Начать играть", "Повышение скорости движения на 0.1 м/с (1500 очков)", "Повышение начальной скорости прыжка на 0.1 м/с (2000 очков)", "Понижение падения скорости после отскока на 2% (2500 очков)", "Уровень сложности:", "Легко", "Нормально", "Сложно"},
            {"Начало новой игры", "удалит текущий прогресс игры.", "Продолжить?", "Да", "Нет"},
            {"Цель игры:\n\nНужно пройти уровень за определенный промежуток времени. После прохождения уровня будет начислятся определенное количество очков. За полученные очки можно улучшать характеристики шара.\n", "\nУправление:\n\n4 - движение влево\n 6 - движение вправо\n2 - прыжок\nЛевый Софт - пауза\n\n", "Управление сенсорным экраном:\n\nУправление в игре осуществляется нажатием и движением пальца относительно центра полупрозрачного кружка на экране.\n\n", "\nОбыкновенное движение в стороны, можно сделать - нажав рядом с кружком относительно той стороны, в которую вы хотите направить шарик. Чтобы сделать прыжок - вам достаточно будет нажать немного выше кружка.\n\n", "Назад"},
            {"Rebound Ball 2", "\nVersion 1.0.2\n\nРуководитель проекта:\nРоман Баглай\n\nПрограммист:\nАлексей Попов\n\nГрафика:\nПавел Шевелев\nКирилл Сухоруков\n\nDeveloped by:\nEternity Games\nwww.e-games.su\n\nPublushed by:\nDaSuppa Studios\nwww.dasuppa.com\n\n(c) Eternity Games 2012\n", "Назад"},
            {"Вы действительно хотите покинуть игру?", "Да", "Нет"},
            {"Помощь по редактору карт:\n\nСоздавать карты для игры ReboundBall довольно просто. В первую очередь вам будет нужно расставить блоки в том порядке в котором вы хотите.\n\nУправление для перемещения\nпо ячейкам:\n2, 4, 6, 8 и джойстик - вверх, влево, вправо, вниз.\n5 - установить/удалить блок\n1 и 3 - перемещение по каретке.\n0 - сменить каретку.\n\nПосле того как вы расставили блоки, вам надо будет установить лифты. В первую очередь установите лифт на котором шарик будет приезжать. Также не забудьте установить точку из которой будет появляться лифт. Таким же образом будет происходить установка лифта и точки, на котором шарик будет покидать уровень.\n\n", "Больше не показывать"},
            {"Начать играть", "Улучшения мячика", "Выбор уровня", "Назад"},
            {"Выйти", "Выйти в главное меню?", "Нет", "Да", "Игра окончена", "Уровень", "Заново", "Набрано", "Время", "Пройден"},
            {"Вы действительно хотите сделать сброс игры?\nЕсли вы нажмете \"Да\", произойдет полный сброс и игра закроется.", "Да", "Нет"},
            {"Продолжить", "Переиграть", "Помощь", "Выход"},
            {"Вы действительно хотите", "переиграть этот уровень?", "Вы действительно хотите выйти", "в главное меню?", "Да", "Нет"},
            {"Вам нужно пройти уровень за", "отведенное время. После прохождения", "уровня вам будут начислены бонусы.", "Закрыть"},
            {"Поздравляем! Вы зароботали ", " бонусов.", "Теперь у вас есть возможность улучшить", "свой мячик в разделе \"Улучшения мячика\"."},
            {"Продолжить", "Переиграть", "Редактор карт", "Выход"},
            {"Вы не прошли уровень.", "Переиграть?", "Да", "Нет"},
            {"Время вышло.", "Переиграть?", "Yes", "No"},
            {"Чтобы запрыгнуть на верхние блоки, вам", "нужно разогнаться в сторону стены и", "перед столкновением нажать прыжок.", "Close"},
            {"Все несохраненные данные будут потеряны.", "Продолжить?", "Да", "Нет"},
            {"Это улучшение будет открыто", "после прохождения игры.", "Закрыть"},
            {"Поздравляем!", "Вы прошли игру на", "легкой сложности.", "средней сложности.", "тяжелом уровне сложности.", " очков!", "Открыта новая сложность:", "Тяжело", "Открыто новое улучшение:", "Понижение падения скорости", "после отскока на 2%"},
            {"Легко", "Нормально", "Сложно"}}
    };
    
    /*
     * Устанавливает язык локализации, EN - английский, RU - русский
     */
    public static void setLocale(int l) {
        locale = l;
    }
    
    /*
     * Возвращает одиночную строку локализации
     */
    public static String getAloneText(int n) {
        return alone_localization[locale][n];
    }
    /*
     * Возвращает набор строк (массив) локализцации
     */
    public static String[] getFullText(int n) {
        return full_localization[locale][n];
    }
    
    /*
     * Возвращает язык локализации, EN - английский, RU - русский
     */
    public static int getLocale() {
        return locale;
    }
    
    /*
     * Возвращает язык локализации в виде строки, "en" - английский, "ru" - русский
     */
    public static String getLocaleAsString() {
        return (locale == EN ? "en" : "ru");
    }
    
}
