import game.LM;
import game.S;
import game.TL;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.*;
import javax.microedition.lcdui.game.Sprite;

/**
 *
 * @author user
 */
public class RB2 implements Runnable {

    private boolean beContinue, jLevel, eLevel, noTime, rLevel, sAlpha, nSelectDiff, wasMotion, wasBack, p_pressed, f_board, already_scores, sound_index, m_index, l_index, d_index, b_index, s_index, p_index, r_index, e_index, fromEditor, go_index, destroying, to_index, hint_rebound, me_index, notOpenYet, fPassed;
    private int width, height, bKey, lQuantity, levelX, levelY, levelWidth, levelHeight, levelTime, levelPoints, mIndex, bIndex, mH, mHeight, slIndex, lbY, lHeight, lbHeight, nPoints, lMode, lbIndex, sdY, sdIndex, gipY, cMode, stIndex, slColorUp = 0xd0d0d0, slColorDown = 0xd0d0d0, lSelect, countOfMaps, lChangeMode, mlHeight, mAbout, sIndex, hMode, pIndex, rIndex, eIndex, goIndex, rMode, toIndex, meIndex;
    private int[] logo, rms_game, liftOut, lsY, lsH, checkXY, slColor = {0x666666, 0x666666, 0x666666, 0x666666, 0x666666, 0x666666, 0x666666, 0x666666}, stY;
    private int[][] liftCable, sXYWH;
    private float fps_time, lAlpha, gipTime, tAbout;
    private float[] rms_ball, rXY;
    private long fps, time, ptime, delta, fcount, gtime, otime, ltime, lPauseTime, pTime, h_time;
    private String[] menu_points, begin_text, help, lb_text, cast, sb_text, p_text, pause_text, f_text, s_text, e_text, go_text, to_text, h_text, me_text, no_text, cast_text;
    private String[][] menu_text, hArray;
    private Image offscreen, main_logo, dasuppa_logo, bg_menu, bg_begin, bg_game, stand, iBall, jump, go, rebound, box_frame, box_frame_selected, box_frame_pressed, old_frame, old_frame_selected, cover, board1, board3, board4, board5, board6, board7, board8, board9, board10, board11, pause, pause_pressed, hourglass, joy, help1, help2, bls, arrow, title;
    private Image[] sb_images, destruction, addl, flag, button, button_long1, button_long2, button_long3, button_open, button_close;
    private Button ng_yes, ng_no, st_back, h_back, a_back, e_yes, e_no, hp_back, im_back, sl_back, sd_back, f_continue, s_close, h_close, no_close;
    private S sBall, sLiftIn, sLiftOut;
    private LM lm;
    private Ball ball;
    private Lift lift;
    private Thorns thorns;
    private Signboard sb;
    private DrawText drawText;
    private ILoader iLoader;
    private ScrollBar mScroll, aScroll, hScroll, iScroll, sScroll;
    private Slider[] sSlider;
    private NewMap newMap;
    private MapList mList;
    private MapParameters mParam;
    private Records records;
    private RMS rms;
    private Joystick joystick;
    private Graphics gOS;
    public String gFlag, pauseFlag;
    public RB2MIDlet rb2MIDlet;
    private Sound sound;
    
    public static boolean pUsing;
    public boolean press_rpKey;
    public boolean[] keys;
    public int pKey, rKey, dKey, rpKey, hKey, pX = -1, pY = -1, rX = -1, rY = -1, dX = -1, dY = -1;
    public Handler canvas;
    public final int KEY_FIRE = 0;
    public final int KEY_LEFT = 1;
    public final int KEY_RIGHT = 2;

    /*
     * Консутруктор класса, принимает значения RB2MIDlet - мидлет, и Sound - класс звука
     */
    public RB2(RB2MIDlet rb2MIDlet, Sound sound) {
        this.rb2MIDlet = rb2MIDlet;
        this.sound = sound;
        canvas = new Handler(this);
        pUsing = canvas.pUsing();
        canvas.setFullScreenMode(true);
        init();
    }

    /*
     * Приватный метод инициализации основных компонентов игры
     */
    private void init() {
        keys = new boolean[3];
        iLoader = new ILoader("/resources/graphics.dat");
        main_logo = iLoader.get("logo");
        dasuppa_logo = iLoader.get("dasuppa_logo");
        sb_images = new Image[22];
        sBall = new S((iBall = iLoader.get("ball")), 18, 18);
        sLiftIn = new S(iLoader.get("lift"), 40, 60);
        sLiftOut = new S(iLoader.get("lift"), 40, 60);
        //sb_images[11] = iLoader.get("passed");
        sb_images[13] = iLoader.get("points");
        //sb_images[15] = iLoader.get("out");
        bg_menu = iLoader.get("bg_menu");
        bg_begin = iLoader.get("bg_begin");
        stand = iLoader.get("stand");
        jump = iLoader.get("jump");
        go = iLoader.get("go");
        rebound = iLoader.get("rebound");
        box_frame = iLoader.get("box_frame");
        box_frame_selected = iLoader.get("box_frame_selected");
        box_frame_pressed = iLoader.get("box_frame_pressed");
        old_frame = iLoader.get("old_frame");
        old_frame_selected = iLoader.get("old_frame_selected");
        cover = iLoader.get("cover");
        board1 = iLoader.get("board_1");
        board3 = iLoader.get("board_3");
        board4 = iLoader.get("board_4");
        board5 = iLoader.get("board_5");
        board6 = iLoader.get("board_6");
        board7 = iLoader.get("board_7");
        board8 = iLoader.get("board_8");
        board9 = iLoader.get("board_9");
        board10 = iLoader.get("board_10");
        board11 = iLoader.get("board_11");
        pause = iLoader.get("pause");
        arrow = iLoader.get("arrow");
        title = iLoader.get("title");
        pause_pressed = iLoader.get("pause_pressed");
        button = new Image[] {iLoader.get("button_np"), iLoader.get("button_p")};
        hourglass = iLoader.get("hourglass");
        button_long1 = new Image[] {iLoader.get("button_long1_np"), iLoader.get("button_long1_p")};
        button_long2 = new Image[] {iLoader.get("button_long2_np"), iLoader.get("button_long2_p")};
        button_long3 = new Image[] {iLoader.get("button_long3_np"), iLoader.get("button_long3_p")};
        button_open = new Image[] {iLoader.get("button_open_np"), iLoader.get("button_open_p")};
        button_close = new Image[] {iLoader.get("button_close_np"), iLoader.get("button_close_p")};
        joy = iLoader.get("joy");
        help1 = iLoader.get("help1");
        help2 = iLoader.get("help2");
        flag = new Image[] {
            iLoader.get("flag_not_selected"), iLoader.get("flag_selected")
        };
        
        ng_yes = new Button();
        ng_no = new Button();
        st_back = new Button();
        h_back = new Button();
        a_back = new Button();
        e_yes = new Button();
        e_no = new Button();
        hp_back = new Button();
        im_back = new Button();
        sl_back = new Button();
        sd_back = new Button();
        f_continue = new Button();
        s_close = new Button();
        h_close = new Button();
        no_close = new Button();

        Image addl_img = iLoader.get("addl");
        addl = new Image[7];
        for (int i = 0; i < 5; i++) {
            addl[i] = Image.createImage(addl_img, i * 28, 0, 28, 21, Sprite.TRANS_NONE);
        }
        
        bls = iLoader.get("ball_like_selection");

        mH = box_frame.getHeight() + 10;

        destruction = new Image[8];
        int[][] xywh = {
            {0, 10, 16, 18},
            {17, 10, 18, 18},
            {36, 8, 22, 22},
            {59, 7, 26, 24},
            {87, 1, 31, 33},
            {120, 1, 38, 35},
            {3, 42, 53, 34},
            {62, 40, 61, 36}
        };
        Image destroying = iLoader.get("destruction");
        for (int i = 0; i < 8; i++) {
            destruction[i] = Image.createImage(destroying, xywh[i][0], xywh[i][1], xywh[i][2], xywh[i][3], Sprite.TRANS_NONE);
        }
        destroying = null;
        xywh = null;

        countOfMaps = 30;

        rms = new RMS();
        beContinue = rms.beContinued();
        
        rms_game = rms.getGameData();
        rms_game = rms.getGameData();
        rms_ball = rms.getBallData();
        width = canvas.getWidth();
        height = canvas.getHeight();
        checkXY = new int[2];
        mHeight = (height-150) / mH * mH - 10;
        int fH = old_frame.getHeight() + 8;
        mlHeight = (height - 150) / fH * fH - 8;

        if (!canvas.isDoubleBuffered()) {
            offscreen = Image.createImage(width, height);
            gOS = offscreen.getGraphics();
            gOS.setClip(0, 0, width, height);
            gOS.setFont(Font.getFont(Font.FACE_PROPORTIONAL, Font.STYLE_BOLD, Font.SIZE_SMALL));
        }
        if (rms_game[8] != 0) {
            Localization.setLocale(rms_game[8] - 1);
        } else {
            Localization.setLocale(Localization.EN);
        }
        getLocalization();
        
        gFlag = "LOGO";
        
        new Thread(this).start();
    }

    /*
     * Прватный метод загрузки локализации игры
     */
    private void getLocalization() {
        drawText = new DrawText();
        drawText.loadFont(iLoader.get(Localization.getLocaleAsString() + "_font"));

        updateMenuList();
        begin_text = Localization.getFullText(1);
        lsY = new int[3];
        lsH = new int[3];
        for (int i = 0; i < lsY.length; i++) {
            lsY[i] = (i == 0 ? 0 : lsY[i - 1] + lsH[i - 1] + 10);
            lsH[i] = Math.max(50, drawText.setText(begin_text[7 + i], 70, 0, width - 80));
        }
        menu_text = new String[4][];
        menu_text[0] = Localization.getFullText(2);
        menu_text[1] = Localization.getFullText(3);
        menu_text[2] = Localization.getFullText(4);
        menu_text[3] = Localization.getFullText(5);
        help = Localization.getFullText(6);
        lb_text = Localization.getFullText(7);
        sb_text = Localization.getFullText(8);
        p_text = Localization.getFullText(10);
        pause_text = Localization.getFullText(11);
        f_text = Localization.getFullText(12);
        s_text = Localization.getFullText(13);
        e_text = Localization.getFullText(14);
        go_text = Localization.getFullText(15);
        to_text = Localization.getFullText(16);
        h_text = Localization.getFullText(17);
        me_text = Localization.getFullText(18);
        no_text = Localization.getFullText(19);
        cast_text = Localization.getFullText(20);
        sb = new Signboard(sb_text, sb_images, (new DrawFont(iLoader.get("nums"), iLoader.get(Localization.getLocaleAsString() + "_bfont"), iLoader.get(Localization.getLocaleAsString() + "_sfont"))), width, height);
        
        drawText.setText(menu_text[2][1], width / 8 + 5, height / 2 - height / 4 + 19, width - width / 4 - 10, height / 2 - 34);
        aScroll = new ScrollBar(width / 8 + 5, height / 2 - height / 4 + 19, width - width / 4 - 10, height / 2 - 30, drawText.getHText() - (height / 2 - 34), drawText.getHText(), true);
        aScroll.setMovingAspect(4);

        int h = mlHeight;
        sScroll = new ScrollBar(width / 2 - old_frame.getWidth() / 2, 150, old_frame.getWidth() + 8, h, ((old_frame.getHeight() + 8) * countOfMaps - 5) - h, (old_frame.getHeight() + 8) * countOfMaps - 5, false);

        iScroll = new ScrollBar(0, 158 - 5, width, (height - 14) - 158, (lsY[2] + lsH[2] + 16) - ((height - 14) - 158), lsY[2] + lsH[2] + 10, false);
        iScroll.setVisibleScroll(false);
        
        stY = new int[] {
            0, 23, 46, 69
        };
        
        sXYWH = new int[stY.length][];
        int bX = width / 2 - board6.getWidth() / 2 + 25, bY = height / 2 - board6.getHeight() / 2 + 18, bWidth = board6.getWidth() - 50, bHeight = 18;
        for(int i=0; i<sXYWH.length; i++) {
            sXYWH[i] = new int[] {bX, bY+stY[i], bWidth, bHeight};
        }
        
        //sXYWH = new int[][]{
        //    {bX, bY, bWidth, bHeight},
        //    {bX, bY + 23, bWidth, bHeight},
        //    {bX, bY + 46, bWidth, bHeight},
        //    {bX, bY + 69, bWidth, bHeight}
        //};
        
        sSlider = new Slider[] {
            new Slider(new String[] {Localization.getAloneText(54), Localization.getAloneText(55)}, bX + drawText.stringWidth(Localization.getAloneText(53)) + 16, bY+stY[0], max(drawText, Localization.getAloneText(54), Localization.getAloneText(55)) + 6, 18, drawText),
            new Slider(new String[]{Localization.getAloneText(30), Localization.getAloneText(31)}, bX + drawText.stringWidth(Localization.getAloneText(29)) + 16, bY + stY[1], max(drawText, Localization.getAloneText(30), Localization.getAloneText(31)) + 6, 18, drawText),
            new Slider(rms_game[5] == 0 ? (new String[]{begin_text[12], begin_text[13]}) : (new String[]{begin_text[12], begin_text[13], begin_text[14]}), bX + drawText.stringWidth(Localization.getAloneText(32)) + 16, bY+stY[2], max(drawText, begin_text[12], begin_text[13], begin_text[14]) + 6, 18, drawText),
            new Slider(new String[]{Localization.getAloneText(50), Localization.getAloneText(51)}, bX + drawText.stringWidth(Localization.getAloneText(49)) + 16, bY + stY[3], max(drawText, Localization.getAloneText(50), Localization.getAloneText(51)) + 6, 18, drawText)
        };
        
        
        sSlider[1].setIndex(rms_game[6]);
        sSlider[2].setIndex(rms_game[4] - 1);
        sSlider[3].setIndex(rms_game[8] - 1);
        
        hMode = 0;
    }
    
    /*
     * Приватный метод создания списка меню
     */
    private void updateMenuList() {
        menu_points = Localization.getFullText(0);
        if(!beContinue) {
            String[] temp = new String[menu_points.length-1];
            for(int i=0; i<temp.length; i++) {
                temp[i] = menu_points[i+1];
            }
            menu_points = temp;
        }
        mScroll = new ScrollBar(5, 150, width - 10, mHeight, mH * menu_points.length - mHeight - 10, mH * menu_points.length - 10, false);
    }

    /*
     * Метод нахождения максимальной ширины строки из s1 и s2
     */
    public static int max(DrawText dt, String s1, String s2) {
        return Math.max(dt.stringWidth(s1), dt.stringWidth(s2));
    }

    /*
     * Метод нахождения максимальной ширины строки из s1, s2 и s3
     */
    public static int max(DrawText dt, String s1, String s2, String s3) {
        return Math.max(Math.max(dt.stringWidth(s1), dt.stringWidth(s2)), dt.stringWidth(s3));
    }

    /*
     * Приватный метод запуска игрового уровня
     */
    private void createLevel(MLoader mLoader, String mode) {
        lQuantity = mLoader.quantity();
        levelPoints = Integer.parseInt("" + mLoader.get("points"));
        int[] mWH = (int[]) mLoader.get("wh");
        Image block = iLoader.get("block");
        int[][] tiles = (int[][]) mLoader.get("tiles");
        int[][] temp_tiles = new int[mWH[1]][mWH[0]];
        int[][] lifts = new int[4][2];
        getLifts(tiles, lifts, block.getWidth(), block.getHeight());
        liftOut = new int[]{lifts[2][0], lifts[2][1], lifts[2][1] + sLiftOut.getHeight()};
        liftCable = new int[][]{lifts[1], lifts[2]};
        getTiles(tiles, temp_tiles, 1, 1);
        TL tl = new TL(mWH[0], mWH[1], block, block.getWidth(), block.getHeight(), temp_tiles, width, height);
        levelWidth = mWH[0] * block.getWidth();
        levelHeight = mWH[1] * block.getHeight();
        int[] mTime = (int[]) mLoader.get("time");
        mLoader = null;
        levelTime = mTime[0] * 60000 + mTime[1] * 1000;
        if (jLevel) {
            jLevel = false;
        }
        if (noTime) {
            noTime = false;
        }
        if (rLevel) {
            rLevel = false;
        }
        if (mode.equals("JP")) {
            jLevel = noTime = true;
        }
        if (mode.equals("JPR")) {
            rLevel = true;
        }
        switch(rms_game[4]) {
            case 1:
                levelTime += 14000;
                break;
            case 2:
                levelTime += 7000;
                break;
            case 3:
                levelTime += 3000;
                break;
        }
        mTime = null;
        lm = new LM(width, height);
        MapSides msBlocks = new MapSides(lifts, sLiftIn.getWidth(), sLiftOut.getHeight());
        msBlocks.addLayer(temp_tiles, mWH[0], mWH[1], block.getWidth(), block.getHeight());
        getTiles(tiles, temp_tiles, 5, 8);
        msBlocks.addLayer(temp_tiles, mWH[0], mWH[1], block.getWidth(), block.getHeight());
        msBlocks.build();
        
        sBall.setImage(iBall, 18, 18);
        
        ball = new Ball(sBall, rms_ball[1], rms_ball[0], 1 - rms_ball[2] / 100, msBlocks.getSides(), block.getWidth(), block.getHeight());
        msBlocks = null;
        lift = new Lift(sLiftIn, sLiftOut, lifts, sBall);
        lifts = null;
        
        Vector vGBS = new Vector();
        getObjects(tiles, vGBS, 3, block.getWidth(), block.getHeight());
        GlassBlock[] gbs = new GlassBlock[vGBS.size() / 2];
        for (int i = 0; i < vGBS.size() / 2; i++) {
            gbs[i] = new GlassBlock(height, (S) vGBS.elementAt(i * 2), (S) vGBS.elementAt(i * 2 + 1), 40);
            lm.append((S) vGBS.elementAt(i * 2));
            lm.append((S) vGBS.elementAt(i * 2 + 1));
        }
        vGBS = null;
        getTiles(tiles, temp_tiles, 2, 2);
        MapSides msGBS = new MapSides();
        msGBS.addLayer(temp_tiles, block.getWidth(), block.getHeight());
        msGBS.build();
        ball.setGlassBlocks(gbs, msGBS.getSides());
        msGBS = null;
        gbs = null;
        
        lm.append(tl, 0, 0);
        lm.append(sLiftIn);
        lm.append(sLiftOut);
        lm.append(sBall);
        
        if (pUsing) {
            joystick = new Joystick(width/2-joy.getWidth()/2, height-height/8-joy.getHeight()/2, joy, ball);
        }
        
        Vector vThorn = new Vector();
        getObjects(tiles, vThorn, 1, block.getWidth(), block.getHeight());
        for (int i = 0; i < vThorn.size(); i++) {
            lm.append((S) vThorn.elementAt(i));
        }
        vThorn = null;
        getTiles(tiles, temp_tiles, 3, 4);
        MapSides msThorns = new MapSides();
        msThorns.addLayer(temp_tiles, block.getWidth(), block.getHeight());
        msThorns.build();
        thorns = new Thorns(msThorns.getSides(), block.getHeight());
        ball.setThorns(msThorns.getSides());
        msThorns = null;
        Vector vFans = new Vector();
        getObjects(tiles, vFans, 2, block.getWidth(), block.getHeight());
        Fan[] fans = new Fan[vFans.size()];
        for (int i = 0; i < vFans.size(); i++) {
            fans[i] = (Fan) vFans.elementAt(i);
            lm.append(fans[i].getFan());
        }
        vFans = null;
        getTiles(tiles, temp_tiles, 5, 8);
        MapSides msFans = new MapSides();
        msFans.addLayer(temp_tiles, block.getWidth(), block.getHeight());
        msFans.build();
        ball.setFans(fans, msFans.getSides());
        msFans = null;
        fans = null;
        Random rnd = new Random();
        bg_game = iLoader.get("bg_" + (rnd.nextInt(6) + 1));
        rnd = null;
    }

    /*
     * Приватный метод загрузки карты
     */
    private void getTiles(int[][] tiles, int[][] temp_tiles, int begin, int end) {
        for (int i = 0; i < tiles.length; i++) {
            for (int j = 0; j < tiles[i].length; j++) {
                temp_tiles[i][j] = 0;
                if (tiles[i][j] >= begin && tiles[i][j] <= end) {
                    temp_tiles[i][j] = tiles[i][j];
                }
            }
        }
    }

    /*
     * Приватный метод загрузки игровых объектов
     */
    private void getObjects(int[][] tiles, Vector objects, int type, int bW, int bH) {
        for (int i = 0; i < tiles.length; i++) {
            for (int j = 0; j < tiles[i].length; j++) {
                if (type == 1 && (tiles[i][j] == 3 || tiles[i][j] == 4)) {
                    S sThorn = new S(iLoader.get("thorn_direction_" + (tiles[i][j] == 3 ? "up" : "down")), 40, 30);
                    sThorn.setPosition(j * bW, i * bH);
                    objects.addElement(sThorn);
                    sThorn = null;
                }
                if (type == 2 && (tiles[i][j] >= 5 && tiles[i][j] <= 8)) {
                    S sFan = new S(iLoader.get("fan_direction_" + (tiles[i][j] == 5 ? "up" : tiles[i][j] == 6 ? "down" : tiles[i][j] == 7 ? "left" : "right")), 40, 30);
                    sFan.setPosition(j * bW, i * bH);
                    Fan fan = new Fan(sFan, tiles[i][j] - 4, 1);
                    sFan = null;
                    fan.start();
                    objects.addElement(fan);
                    fan = null;
                }
                if (type == 3 && tiles[i][j] == 2) {
                    S sGB = new S(iLoader.get("glass_block"), 40, 60);
                    S sFallGB = new S(iLoader.get("glass_block"), 40, 60);
                    sFallGB.setFrame(6);
                    sGB.setPosition(j * bW, i * bH);
                    sFallGB.setPosition(-sFallGB.getWidth(), -sFallGB.getHeight());
                    objects.addElement(sGB);
                    objects.addElement(sFallGB);
                    sFallGB = null;
                    sGB = null;
                }
            }
        }
    }

    /*
     * Приватный метод загрузки лифтов игрового уровня
     */
    private void getLifts(int[][] tiles, int[][] lifts, int bW, int bH) {
        for (int i = 0; i < tiles.length; i++) {
            for (int j = 0; j < tiles[i].length; j++) {
                if (tiles[i][j] >= 9) {
                    int nLift = tiles[i][j] == 9 ? 1 : tiles[i][j] == 10 ? 2 : tiles[i][j] == 11 ? 0 : 3;
                    lifts[nLift][0] = j * bW;
                    lifts[nLift][1] = i * bH;
                    if (nLift == 0 || nLift == 3) {
                        lifts[nLift][1] += bH;
                    }
                }
            }
        }
    }

    /*
     * Приватный метод перехода к редактированию уровня
     */
    private void createLoadNewMap() {
        newMap = new NewMap(new MLoader(Encode.encode(rms.getLevel(mList.getCurrentIndex()))), iLoader, width, height, board3, button, button_long1, button_long2, button_open, button_close, addl, drawText);
        gFlag = "CREATE_MAP";
    }

    /*
     * Приватный метод перехода к созданию уровня с шириной wSize и высотой hSize
     */
    private void createNewMap(int wSize, int hSize) {
        newMap = new NewMap(wSize, hSize, iLoader.get("blocks"), 40, 30, iLoader.get("mblocks"), board3, iLoader.get("lift_enter"), iLoader.get("enter_lift"), iLoader.get("lift_exit"), iLoader.get("exit_lift"), button, button_long1, button_long2, button_open, button_close, addl, width, height, drawText);
        newMap.setHelp(help, flag, rms);
        gFlag = "CREATE_MAP";
    }

    /*
     * Приватный метод перехода в меню запуска, создания, редактирования уровня
     */
    private void createNewMapMenu() {
        mList = new MapList(width, height, rms.getLevelList(), bg_begin, board3, title, button, button_long1, button_long2, drawText);
        gFlag = "CREATE_MAP_MENU";
    }

    /*
     * Приватный метод перехода в меню установки ширины и длины уровня
     */
    private void createNewMapBegin() {
        mParam = new MapParameters(width, height, (rms.getLevelList()).length + 1, bg_begin, board10, button_long1, button_long3, drawText, this);
        gFlag = "CREATE_MAP_BEGIN";
    }

    /*
     * Приватный метод перехода в таблицу рекордов
     */
    private void createTableRecords() {
        records = new Records(width, height, rms, bg_begin, board3, button, drawText);
        gFlag = "TABLE_RECORDS";
    }

    /*
     * Главный метод игрового цикла
     */
    public void run() {
        while (true) {
            check();
            canvas.repaint(0, 0, width, height);
            try {
                Thread.sleep(1);
            } catch (InterruptedException ex) {}
        }
    }

    /*
     * Приватный метод считывания FPS
     */
    private void getFPS() {
        time = System.currentTimeMillis();
        delta = time - ptime;
        fcount++;
        if (delta >= 1000) {
            fps = fcount * 1000 / delta;
            fps_time = 1f / fps;
            ptime = time;
            fcount = 0;
        }
    }

    /*
     * Приватный метод перехода в один из пунктов главного меню, принимает n - номер пункта (нумерация с нуля)
     */
    private void goMenu(int n) {
        if(!beContinue) {
            n++;
        }
        switch (n) {
            case 0:
                lbIndex = 0;
                rms_ball = rms.getBallData();
                sound.fullStopAll();
                playBackground2();
                if(rms_game[15] == 1) {
                    gFlag = "BEGIN";
                } else {
                    sdIndex = 1;
                    gFlag = "SD";
                }
                break;
            case 1:
                if(beContinue) {
                    mScroll.setVisibleScroll(false);
                    gFlag = "NEW_GAME";
                } else {
                    newGame();
                }
                break;
            case 2:
                createNewMapMenu();
                break;
            case 3:
                createTableRecords();
                if (records.getScrollBar() != null) {
                    records.getScrollBar().init();
                }
                break;
            case 4:
                stIndex = 0;
                mScroll.setVisibleScroll(false);
                gFlag = "SETTINGS";
                break;
            case 5:
                if(hScroll != null) {
                    hScroll.init();
                }
                mScroll.setVisibleScroll(false);
                gFlag = "HELP";
                break;
            case 6:
                tAbout = 0;
                mAbout = 1;
                drawText.setText(menu_text[2][1], width / 8 + 5, height / 2 - height / 4 + 19, width - width / 4 - 10, height / 2 - 34);
                aScroll.init();
                mScroll.setVisibleScroll(false);
                gFlag = "ABOUT";
                break;
            case 7:
                drawText.setText(menu_text[3][0], width / 8 + 5, height / 2 - height / 8 + 5, width - width / 4 - 10, height / 4 - 10);
                mScroll.setVisibleScroll(false);
                gFlag = "EXIT";
                break;
        }
    }
    
    /*
     * Приватный метод воспроизведения мелодии меню
     */
    private void playBackground() {
        sound.play("background.mid", "audio/midi", -1);
    }
    
    /*
     * Приватный метод воспроизведения мелодии геймплея
     */
    private void playBackground2() {
        sound.play("background2.mid", "audio/midi", -1);
    }
    
    /*
     * Приватный метод сброса и начала новой игры
     */
    private void newGame() {
        if (!beContinue) {
            beContinue = true;
            updateMenuList();
        }
        lbIndex = 0;
        rms_game = rms.getGameData();
        int back5 = rms_game[5], back6 = rms_game[6], back7 = rms_game[7], back8 = rms_game[8], back15 = rms_game[15], back16 = rms_game[16], back17 = rms_game[17], back18 = rms_game[18];
        rms.flush();
        rms.setGameVars(new int[][] {{5, back5}, {6, back6}, {7, back7}, {8, back8}, {15, back15}, {16, back16}, {17, back17}, {18, back18}});
        //rms.setGameVar(back5, 5);
        //rms.setGameVar(back6, 6);
        //rms.setGameVar(back7, 7);
        //rms.setGameVar(back8, 8);
        //rms.setGameVar(back15, 15);
        //rms.setGameVar(back16, 16);
        //rms.setGameVar(back17, 17);
        rms_game = rms.getGameData();
        rms_ball = rms.getBallData();
        sdIndex = 0;
        mScroll.setVisibleScroll(true);
        sound.fullStopAll();
        playBackground2();
        gFlag = "SD";
    }

    /*
     * Основной метод проверки клавиш на нажатие и нажатия пальца на экран
     */
    private void check() {
        if (gFlag.equals("LOGO") && (pKey == -5 || pKey == 10 || pKey == Canvas.KEY_NUM5 || pKey == 103 || Wand.isAction(pX, pY))) {
            
            if(rms_game[8] == 0) {
                gFlag = "LANGUAGE";
            } else {
                logo = null;
                dasuppa_logo = null;
                gFlag = "SOUND";
            }
            
            pKey = rKey = 0; pX = pY = rX = rY = dX = dY = -1;
        }
        if (gFlag.equals("LANGUAGE")) {
            if (pKey == Canvas.KEY_NUM5 || pKey == -5 || pKey == 10 || pKey == 103) {
                l_index = true;
            }
            if (rKey == Canvas.KEY_NUM5 || rKey == -5 || rKey == 10 || rKey == 103) {
                rms.setGameVar(lSelect + 1, 8);
                rms_game = rms.getGameData();
                Localization.setLocale(lSelect);
                getLocalization();
                gFlag = "SOUND";
            }
            if (pKey == Canvas.KEY_NUM2 || pKey == -1 || pKey == 116) {
                lSelect = 0;
                Localization.setLocale(Localization.EN);
                getLocalization();
            }
            if (pKey == Canvas.KEY_NUM8 || pKey == -2 || pKey == 98) {
                lSelect = 1;
                Localization.setLocale(Localization.RU);
                getLocalization();
            }
            
            if (Wand.region(pX, pY, width/2-old_frame.getWidth()/2, 186, old_frame.getWidth(), old_frame.getHeight())) {
                lSelect = 0;
                Localization.setLocale(Localization.EN);
                getLocalization();
                l_index = true;
            }
            if (l_index && lSelect == 0 && Wand.region(rX, rY, width/2-old_frame.getWidth()/2, 186, old_frame.getWidth(), old_frame.getHeight())) {
                rms.setGameVar(1, 8);
                rms_game = rms.getGameData();
                getLocalization();
                gFlag = "SOUND";
            }
            if (Wand.region(pX, pY, width/2-old_frame.getWidth()/2, 199+old_frame.getHeight(), old_frame.getWidth(), old_frame.getHeight())) {
                lSelect = 1;
                Localization.setLocale(Localization.RU);
                getLocalization();
                l_index = true;
            }
            if (l_index && lSelect == 1 && Wand.region(rX, rY, width/2-old_frame.getWidth()/2, 199+old_frame.getHeight(), old_frame.getWidth(), old_frame.getHeight())) {
                rms.setGameVar(2, 8);
                rms_game = rms.getGameData();
                getLocalization();
                gFlag = "SOUND";
            }
            
            if(rKey != 0 || Wand.isAction(rX, rY)) {
                l_index = false;
            }
            
            pKey = rKey = 0;
            pX = pY = rX = rY = dX = dY = -1;
        }
        if (gFlag.equals("SOUND")) {
            if(pKey == Canvas.KEY_NUM5 || pKey == -5 || pKey == 10 || pKey == 103) {
                sound_index = true;
            }
            if(rKey == Canvas.KEY_NUM5 || rKey == -5 || rKey == 10 || rKey == 103) {
                if(sIndex == 0) {
                    sound.soundOn();
                    sSlider[0].setIndex(1);
                } else {
                    sound.soundOff();
                    sSlider[0].setIndex(0);
                }
                
                playBackground();
                gFlag = "MENU";
            }
            if(pKey == Canvas.KEY_NUM2 || pKey == -1 || pKey == 116) {
                sIndex = 0;
            }
            if(pKey == Canvas.KEY_NUM8 || pKey == -2 || pKey == 98) {
                sIndex = 1;
            }
            
            if(Wand.region(pX, pY, width/2-old_frame.getWidth()/2, 186, old_frame.getWidth(), old_frame.getHeight())) {
                sIndex = 0; sound_index = true;
            }
            if(sound_index && sIndex == 0 && Wand.region(rX, rY, width/2-old_frame.getWidth()/2, 186, old_frame.getWidth(), old_frame.getHeight())) {
                sSlider[0].setIndex(1);
                sound.soundOn();
                playBackground();
                gFlag = "MENU";
            }
            
            if(Wand.region(pX, pY, width/2-old_frame.getWidth()/2, 199+old_frame.getHeight(), old_frame.getWidth(), old_frame.getHeight())) {
                sIndex = 1; sound_index = true;
            }
            if(sound_index && sIndex == 1 && Wand.region(rX, rY, width/2-old_frame.getWidth()/2, 199+old_frame.getHeight(), old_frame.getWidth(), old_frame.getHeight())) {
                sSlider[0].setIndex(0);
                sound.soundOff();
                playBackground();
                gFlag = "MENU";
            }
            
            if(rKey != 0 || Wand.isAction(rX, rY)) {
                sound_index = false;
            }
            
            pKey = rKey = 0;
            pX = pY = rX = rY = dX = dY = -1;
        }
            
        if (gFlag.equals("MENU")) {

            if (pKey == Canvas.KEY_NUM5 || pKey == -5 || pKey == 10 || pKey == 103) {
                m_index = true;
            }
            if (m_index && (rKey == Canvas.KEY_NUM5 || rKey == -5 || rKey == 10 || rKey == 103)) {
                goMenu(mIndex);
            }
            if (pKey == Canvas.KEY_NUM2 || pKey == -1 || pKey == 116) {
                int mY = -mScroll.getValue();
                if (mIndex > 0) {
                    mIndex--;
                    if (mY + mH * mIndex < 0) {
                        mY += mH;
                    }
                    mScroll.setValue(-mY);
                }
                if (mY + mIndex * mH < 0) {
                    mIndex = (-mY + 10) / mH;
                }
                if (mY + mIndex * mH > mHeight) {
                    mIndex = (-mY + mHeight) / mH;
                }
            }
            if (pKey == Canvas.KEY_NUM8 || pKey == -2 || pKey == 98) {
                int mY = -mScroll.getValue();
                if (mIndex < menu_points.length - 1) {
                    mIndex++;
                    if (mY + mH * mIndex > mHeight - mH + 10) {
                        mY -= mH;
                    }
                    mScroll.setValue(-mY);
                }
                if (mY + mIndex * mH < 0) {
                    mIndex = (-mY + 10) / mH;
                }
                if (mY + mIndex * mH > mHeight) {
                    mIndex = (-mY + mHeight) / mH;
                }
            }
            
            for (int i = 0; i < menu_points.length; i++) {
                if (pY >= 150 && pY < 150 + mHeight && Wand.region(pX, pY, width / 2 - box_frame.getWidth() / 2 - 14, 150 - mScroll.getValue() + i * mH - (i == menu_points.length - 1 ? 10 : 0), box_frame.getWidth(), box_frame.getHeight()) && !wasMotion && !wasBack) {
                    if(mIndex != i) {
                        mIndex = i;
                    } else {
                        m_index = true;
                    }
                    break;
                }
                if (m_index && mIndex == i && Wand.region(rX, rY, width / 2 - box_frame.getWidth() / 2 - 14, 150 - mScroll.getValue() + i * mH - (i == menu_points.length - 1 ? 10 : 0), box_frame.getWidth(), box_frame.getHeight()) && !wasMotion && !wasBack) {
                    if (rY >= 150 && rY < 150 + mHeight) {
                        goMenu(mIndex);
                        break;
                    }
                }
            }
            
            if (Wand.isAction(rX, rY)) {
                wasBack = false;
            }
            if (!wasMotion) {
                if (Wand.isAction(dX, dY)) {
                    wasMotion = true;
                }
            } else {
                if (Wand.isAction(rX, rY)) {
                    wasMotion = false;
                }
            }
            
            mScroll.pCheck(fps_time, dKey, pX, pY, rX, rY, dX, dY);
            
            if(rKey != 0 || Wand.isAction(rX, rY)) {
                m_index = false;
            }

            pX = pY = rX = rY = dX = dY = -1;
            pKey = rKey = 0;
        }
        if (gFlag.equals("NEW_GAME")) {
                if (pKey == -6 || pKey == 10 || pKey == 114 || Wand.region(pX, pY, width/2-board9.getWidth()/2+6, height/2+board9.getHeight()/2-button[0].getHeight()-10, button[0].getWidth() + 4, button[0].getHeight() + 4)) {
                    ng_yes.setState(true);
                }
                if (ng_yes.getState() && (rKey != 0 || Wand.isAction(rX, rY))) {
                    if(rKey == -6 || rKey == 10 || rKey == 114 || Wand.region(rX, rY, width/2-board9.getWidth()/2+6, height/2+board9.getHeight()/2-button[0].getHeight()-10, button[0].getWidth() + 4, button[0].getHeight() + 4)) {
                        newGame();
                    }
                    ng_yes.setState(false);
                }

                if (pKey == -7 || pKey == 8 || pKey == 121 || Wand.region(pX, pY, width/2+board9.getWidth()/2-button[0].getWidth()-10, height/2+board9.getHeight()/2-button[0].getHeight()-10, button_long1[0].getWidth() + 4, button_long1[0].getHeight() + 4)) {
                    ng_no.setState(true);
                }
                if (ng_no.getState() && (rKey != 0 || Wand.isAction(rX, rY))) {
                    if(rKey == -7 || rKey == 8 || rKey == 121 || Wand.region(rX, rY, width/2+board9.getWidth()/2-button[0].getWidth()-10, height/2+board9.getHeight()/2-button[0].getHeight()-10, button_long1[0].getWidth() + 4, button_long1[0].getHeight() + 4)) {
                        wasBack = true;
                        mScroll.setVisibleScroll(true);
                        gFlag = "MENU";
                    }
                    ng_no.setState(false);
                }
            pKey = rKey = rpKey = 0;
            pX = pY = rX = rY = dX = dY = -1;
        }
        if (gFlag.equals("HELP") || gFlag.equals("ABOUT")) {
            if (pKey == -7 || pKey == 8 || pKey == 121) {
                (gFlag.equals("HELP") ? h_back : a_back).setState(true);
            }
            if((gFlag.equals("HELP") ? h_back : a_back).getState() && rKey != 0) {
                if (rKey == -7 || rKey == 8 || rKey == 121) {
                    mScroll.setVisibleScroll(true);
                    gFlag = "MENU";
                }
                (gFlag.equals("HELP") ? h_back : a_back).setState(false);
            }
            if (gFlag.equals("HELP")) {
                if (Wand.region(pX, pY, width / 2 + board3.getWidth() / 2 - button[0].getWidth()-12 - 2, height/2+board3.getHeight()/2-button[0].getHeight()-8 - 2, button[0].getWidth() + 4, button[0].getHeight() + 4)) {
                    h_back.setState(true);
                }
                if(h_back.getState() && Wand.isAction(rX, rY)) {
                    if (Wand.region(rX, rY, width / 2 + board3.getWidth() / 2 - button[0].getWidth()-12 - 2, height/2+board3.getHeight()/2-button[0].getHeight()-8 - 2, button[0].getWidth() + 4, button[0].getHeight() + 4)) {
                        wasBack = true;
                        mScroll.setVisibleScroll(true);
                        gFlag = "MENU";
                    }
                    h_back.setState(false);
                }
                if(hScroll != null) {
                    hScroll.pCheck(fps_time, dKey, pX, pY, rX, rY, dX, dY);
                }
                pX = pY = rX = rY = dX = dY = -1;
            }
            if (gFlag.equals("ABOUT")) {
                if (Wand.region(pX, pY, width - width / 8 - drawText.stringWidth(menu_text[2][2]) - 15 + drawText.stringWidth(menu_text[2][2]) / 2 - button[0].getWidth() / 2 - 2, height / 2 + height / 4 + 7 - button[0].getHeight() / 2 - 10, button[0].getWidth() + 4, button[0].getHeight() + 4)) {
                    a_back.setState(true);
                }
                if(a_back.getState() && Wand.isAction(rX, rY)) {
                    if (Wand.region(rX, rY, width - width / 8 - drawText.stringWidth(menu_text[2][2]) - 15 + drawText.stringWidth(menu_text[2][2]) / 2 - button[0].getWidth() / 2 - 2, height / 2 + height / 4 + 7 - button[0].getHeight() / 2 - 10, button[0].getWidth() + 4, button[0].getHeight() + 4)) {
                        wasBack = true;
                        mScroll.setVisibleScroll(true);
                        gFlag = "MENU";
                    }
                    a_back.setState(false);
                }
                if(mAbout != 1) {
                    aScroll.pCheck(fps_time, dKey, pX, pY, rX, rY, dX, dY);
                    drawText.setY(-aScroll.getValue());
                }
                if (Wand.region(pX, pY, width / 8 + 5, height / 2 - height / 4 + 5, width - width / 4 - 10, height / 2 - 10)) {
                    mAbout = 0;
                }
                pX = pY = rX = rY = dX = dY = -1;
            }
            pKey = rKey = 0;
        }
        if (gFlag.equals("EXIT")) {
            if (pKey == -6 || pKey == 10 || pKey == 114 || Wand.region(pX, pY, width / 8 + 20 + drawText.stringWidth(menu_text[3][1]) / 2 - button[0].getWidth() / 2 - 2, height / 2 + height / 8 + 7 - button[0].getHeight() / 2 - 7, button[0].getWidth() + 4, button[0].getHeight() + 4)) {
                e_yes.setState(true);
            }
            if(e_yes.getState() && (rKey != 0 || Wand.isAction(rX, rY))) {
                if (rKey == -6 || rKey == 10 || rKey == 114 || Wand.region(rX, rY, width / 8 + 20 + drawText.stringWidth(menu_text[3][1]) / 2 - button[0].getWidth() / 2 - 2, height / 2 + height / 8 + 7 - button[0].getHeight() / 2 - 7, button[0].getWidth() + 4, button[0].getHeight() + 4)) {
                    rb2MIDlet.exit();
                }
                e_yes.setState(false);
            }
            if (pKey == -7 || pKey ==  8|| pKey == 121 || Wand.region(pX, pY, width - width / 8 - drawText.stringWidth(menu_text[3][2]) - 23 + drawText.stringWidth(menu_text[3][2]) / 2 - button[0].getWidth() / 2 - 2, height / 2 + height / 8 + 7 - button[0].getHeight() / 2 - 7, button[0].getWidth() + 4, button[0].getHeight() + 4)) {
                e_no.setState(true);
            }
            if(e_no.getState() && (rKey != 0 || Wand.isAction(rX, rY))) {
                if (rKey == -7 || rKey ==  8|| rKey == 121 || Wand.region(rX, rY, width - width / 8 - drawText.stringWidth(menu_text[3][2]) - 23 + drawText.stringWidth(menu_text[3][2]) / 2 - button[0].getWidth() / 2 - 2, height / 2 + height / 8 + 7 - button[0].getHeight() / 2 - 7, button[0].getWidth() + 4, button[0].getHeight() + 4)) {
                    wasBack = true;
                    mScroll.setVisibleScroll(true);
                    gFlag = "MENU";
                }
                e_no.setState(false);
            }
            pKey = rKey = 0;
        }
        if (gFlag.equals("HELP") || gFlag.equals("ABOUT")) {
            if (dKey == Canvas.KEY_NUM2 || dKey == -1 || dKey == 116) {
                if (gFlag.equals("ABOUT")) {
                    if(mAbout != 0) {
                        mAbout = 0;
                    }
                }
            }
            if (dKey == Canvas.KEY_NUM8 || dKey == -2 || dKey == 98) {
                if (gFlag.equals("ABOUT")) {
                    if(mAbout != 0) {
                        mAbout = 0;
                    }
                }
            }

            pX = pY = rX = rY = dX = dY = -1;
        }
        
        if (gFlag.equals("BEGIN")) {
            if(!already_scores) {
                if (pKey == Canvas.KEY_NUM5 || pKey == -5 || pKey == 10 || pKey == 103) {
                    b_index = true;
                }
                if (rKey == Canvas.KEY_NUM5 || rKey == -5 || rKey == 10 || rKey == 103) {
                    switch (lbIndex) {
                        case 0:
                            createLevel(new MLoader("/resources/maps.dat", rms.getGameLevel(rms_game)), "");
                            lift.inStart();
                            gFlag = "LIFT_ENTER";
                            break;
                        case 1:
                            bIndex = 0;
                            iScroll.init();
                            gFlag = "IMPROVEMENTS";
                            break;
                        case 2:
                            slIndex = 0;
                            gFlag = "SL";
                            break;
                        case 3:
                            mIndex = 0;
                            mScroll.init();
                            wasBack = true;
                            sound.fullStopAll();
                            playBackground();
                            gFlag = "MENU";
                            break;
                    }
                }
                int fH = old_frame.getHeight() + 5;
                if (pKey == Canvas.KEY_NUM2 || pKey == -1 || pKey == 116) {
                    if (lbIndex > 0) {
                        lbIndex--;
                        if (lbY + fH * lbIndex < 0) {
                            lbY += fH;
                        }
                    }
                }
                if (pKey == Canvas.KEY_NUM8 || pKey == -2 || pKey == 98) {
                    if (lbIndex < 3) {
                        lbIndex++;
                        if (lbY + fH * lbIndex > lbHeight - fH) {
                            lbY -= fH;
                        }
                    }
                }
                for (int i = 0; i < 4; i++) {
                    if (Wand.region(pX, pY, width / 2 - old_frame.getWidth() / 2 - 2, 158 + i * (old_frame.getHeight() + 8) - 2, old_frame.getWidth() + 4, old_frame.getHeight() + 4)) {
                        lbIndex = i; b_index = true;
                        break;
                    }
                    if (b_index && lbIndex == i && Wand.region(rX, rY, width / 2 - old_frame.getWidth() / 2 - 2, 158 + i * (old_frame.getHeight() + 8) - 2, old_frame.getWidth() + 4, old_frame.getHeight() + 4)) {
                        switch (lbIndex) {
                            case 0:
                                createLevel(new MLoader("/resources/maps.dat", rms.getGameLevel(rms_game)), "");
                                lift.inStart();
                                sb.startShowlevelBegin();
                                gFlag = "LIFT_ENTER";
                                break;
                            case 1:
                                bIndex = 0;
                                iScroll.init();
                                gFlag = "IMPROVEMENTS";
                                break;
                            case 2:
                                slIndex = 0;
                                gFlag = "SL";
                                break;
                            case 3:
                                mIndex = 0;
                                mScroll.init();
                                wasBack = true;
                                sound.fullStopAll();
                                playBackground();
                                gFlag = "MENU";
                                break;
                        }
                        break;
                    }
                }
                
                if(rKey != 0 || Wand.isAction(rX, rY)) {
                    b_index = false;
                }
            } else {
                if (pKey == -7 || pKey == 8 || pKey == 121 || Wand.region(pX, pY, width/2+board8.getWidth()/2-button_long1[0].getWidth()-8, height/2+board8.getHeight()/2-button_long1[0].getHeight()-10, button_long1[0].getWidth() + 4, button_long1[0].getHeight() + 4)) {
                    s_close.setState(true);
                }
                if(s_close.getState() && (rKey != 0 || Wand.isAction(rX, rY))) {
                    if (rKey == -7 || rKey == 8 || rKey == 121 || Wand.region(rX, rY, width/2+board8.getWidth()/2-button_long1[0].getWidth()-8, height/2+board8.getHeight()/2-button_long1[0].getHeight()-10, button_long1[0].getWidth() + 4, button_long1[0].getHeight() + 4)) {
                        already_scores = false;
                        rms.setGameVar(1, 16);
                        rms_game = rms.getGameData();
                    }
                    s_close.setState(false);
                }
            }
            
            pKey = rKey = 0;
            pX = pY = rX = rY = dX = dY = -1;
        }
        if(gFlag.equals("PAUSE")) {
            if (pKey == Canvas.KEY_NUM5 || pKey == -5 || pKey == 10 || pKey == 103) {
                p_index = true;
            }
            if (rKey == Canvas.KEY_NUM5 || rKey == -5 || rKey == 10 || rKey == 103) {
                switch (pIndex) {
                    case 0:
                        if (pauseFlag.equals("GAME")) {
                            gtime += System.currentTimeMillis() - (gtime + otime);
                        }
                        sb.play();
                        gFlag = pauseFlag;
                        break;
                    case 1:
                        rIndex = 1;
                        gFlag = "RESTART_AT_PAUSE";
                        break;
                    case 2:
                        if(!fromEditor) {
                            if(hScroll != null) {
                                hScroll.init();
                            }
                            gFlag = "HELP_IN_PAUSE";
                        } else {
                            gFlag = "CREATE_MAP_MENU";
                        }
                        break;
                    case 3:
                        eIndex = 1;
                        gFlag = "EXIT_FROM_PAUSE";
                        break;
                }
            }
            int fH = old_frame.getHeight() + 5;
            if (pKey == Canvas.KEY_NUM2 || pKey == -1 || pKey == 116) {
                if (pIndex > 0) {
                    pIndex--;
                    if (lbY + fH * pIndex < 0) {
                        lbY += fH;
                    }
                }
            }
            if (pKey == Canvas.KEY_NUM8 || pKey == -2 || pKey == 98) {
                if (pIndex < 3) {
                    pIndex++;
                    if (lbY + fH * pIndex > lbHeight - fH) {
                        lbY -= fH;
                    }
                }
            }
            for (int i = 0; i < 4; i++) {
                if (Wand.region(pX, pY, width / 2 - old_frame.getWidth() / 2 - 2, 158 + i * (old_frame.getHeight() + 8) - 2, old_frame.getWidth() + 4, old_frame.getHeight() + 4)) {
                    pIndex = i; 
                    p_index = true;
                    break;
                }
                if (p_index && pIndex == i && Wand.region(rX, rY, width / 2 - old_frame.getWidth() / 2 - 2, 158 + i * (old_frame.getHeight() + 8) - 2, old_frame.getWidth() + 4, old_frame.getHeight() + 4)) {
                    switch (pIndex) {
                        case 0:
                            if (pauseFlag.equals("GAME")) {
                                gtime += System.currentTimeMillis() - (gtime + otime);
                            }
                            sb.play();
                            gFlag = pauseFlag;
                            break;
                        case 1:
                            rIndex = 1;
                            gFlag = "RESTART_AT_PAUSE";
                            break;
                        case 2:
                            if(!fromEditor) {
                                if(hScroll != null) {
                                    hScroll.init();
                                }
                                gFlag = "HELP_IN_PAUSE";
                            } else {
                                gFlag = "CREATE_MAP_MENU";
                            }
                            break;
                        case 3:
                            eIndex = 1;
                            gFlag = "EXIT_FROM_PAUSE";
                            break;
                    }
                    break;
                }
            }
            
            if(rKey != 0 || Wand.isAction(rX, rY)) {
                p_index = false;
            }
            
            pKey = rKey = 0;
            pX = pY = rX = rY = dX = dY = -1;
        }
        if (gFlag.equals("RESTART_AT_PAUSE")) {
            if (pKey == Canvas.KEY_NUM5 || pKey == -5 || pKey == 10 || pKey == 103) {
                r_index = true;
            }
            if (rKey == Canvas.KEY_NUM5 || rKey == -5 || rKey == 10 || rKey == 103) {
                if(rIndex == 0) {
                    if(!fromEditor) {
                        createLevel(new MLoader("/resources/maps.dat", rms.getGameLevel(rms_game)), "");
                        lift.inStart();
                        sb.startShowlevelBegin();
                        gFlag = "LIFT_ENTER";
                    } else {
                        createLevel(new MLoader(Encode.encode(rms.getLevel(mList.getCurrentIndex()))), "JP");
                        lift.inStart();
                        sb.startShowlevelBegin();
                        //if(!fromEditor && rms_game[13] == 0) {
                        //    if(hScroll != null) {
                        //        hScroll.init();
                        //    }
                        //    hFirst = true;
                        //}
                        gFlag = "LIFT_ENTER";
                    }
                }
                if(rIndex == 1) {
                    gFlag = "PAUSE";
                }
            }
            if ((pKey == Canvas.KEY_NUM2 || pKey == -1 || pKey == 116) && rIndex > 0) {
                rIndex--;
            }
            if ((pKey == Canvas.KEY_NUM8 || pKey == -2 || pKey == 98) && rIndex < 1) {
                rIndex++;
            }
            if (Wand.region(pX, pY, width/2-old_frame.getWidth()/2, 203, old_frame.getWidth(), old_frame.getHeight())) {
                rIndex = 0; r_index = true;
            }
            if (r_index && rIndex == 0 && Wand.region(rX, rY, width/2-old_frame.getWidth()/2, 203, old_frame.getWidth(), old_frame.getHeight())) {
                if(!fromEditor) {
                    createLevel(new MLoader("/resources/maps.dat", rms.getGameLevel(rms_game)), "");
                    lift.inStart();
                    sb.startShowlevelBegin();
                    gFlag = "LIFT_ENTER";
                } else {
                    createLevel(new MLoader(Encode.encode(rms.getLevel(mList.getCurrentIndex()))), "JP");
                    lift.inStart();
                    sb.startShowlevelBegin();
                    //if(!fromEditor && rms_game[13] == 0) {
                    //    if(hScroll != null) {
                    //        hScroll.init();
                    //    }
                    //    hFirst = true;
                    //}
                    gFlag = "LIFT_ENTER";
                }
            }
            if (Wand.region(pX, pY, width/2-old_frame.getWidth()/2, 245, old_frame.getWidth(), old_frame.getHeight())) {
                rIndex = 1; r_index = true;
            }
            if (r_index && rIndex == 1 && Wand.region(rX, rY, width/2-old_frame.getWidth()/2, 245, old_frame.getWidth(), old_frame.getHeight())) {
                gFlag = "PAUSE";
            }
            
            if(rKey != 0 || Wand.isAction(rX, rY)) {
                r_index = false;
            }
            
            pKey = rKey = 0;
            pX = pY = rX = rY = dX = dY = -1;
        }
        if (gFlag.equals("HELP_IN_PAUSE")) {
            if (pKey == -7 || pKey == 8 || pKey == 121 || Wand.region(pX, pY, width - button_long1[0].getWidth() - 7 , height - button_long1[0].getHeight() - 7, button_long1[0].getWidth() + 4, button_long1[0].getHeight() + 4)) {
                hp_back.setState(true);
            }
            if(hp_back.getState() && (rKey != 0 || Wand.isAction(rX, rY))) {
                if (rKey == -7 || rKey == 8 || rKey == 121 || Wand.region(rX, rY, width - button_long1[0].getWidth() - 7 , height - button_long1[0].getHeight() - 7, button_long1[0].getWidth() + 4, button_long1[0].getHeight() + 4)) {
                    gFlag = "PAUSE";
                }
                hp_back.setState(false);
            }
            
            if(hScroll != null) {
                hScroll.pCheck(fps_time, dKey, pX, pY, rX, rY, dX, dY);
            }
            
            pKey = rKey = 0;
            pX = pY = rX = rY = dX = dY = -1;
        }
        if (gFlag.equals("EXIT_FROM_PAUSE")) {
            if (pKey == Canvas.KEY_NUM5 || pKey == -5 || pKey == 10 || pKey == 103) {
                e_index = true;
            }
            if (rKey == Canvas.KEY_NUM5 || rKey == -5 || rKey == 10 || rKey == 103) {
                if(eIndex == 0) {
                    mIndex = 0;
                    mScroll.init();
                    wasBack = true;
                    if(!fromEditor) {
                        sound.fullStopAll();
                        playBackground();
                    }
                    gFlag = "MENU";
                    
                    fromEditor = false;
                }
                if(eIndex == 1) {
                    gFlag = "PAUSE";
                }
            }
            if ((pKey == Canvas.KEY_NUM2 || pKey == -1 || pKey == 116) && eIndex > 0) {
                eIndex--;
            }
            if ((pKey == Canvas.KEY_NUM8 || pKey == -2 || pKey == 98) && eIndex < 1) {
                eIndex++;
            }
            if (Wand.region(pX, pY, width/2-old_frame.getWidth()/2, 203, old_frame.getWidth(), old_frame.getHeight())) {
                eIndex = 0; e_index = true;
            }
            if (e_index && eIndex == 0 && Wand.region(rX, rY, width/2-old_frame.getWidth()/2, 203, old_frame.getWidth(), old_frame.getHeight())) {
                mIndex = 0;
                mScroll.init();
                wasBack = true;
                if(!fromEditor) {
                    sound.fullStopAll();
                    playBackground();
                }
                gFlag = "MENU";
                
                fromEditor = false;
            }
            if (Wand.region(pX, pY, width/2-old_frame.getWidth()/2, 245, old_frame.getWidth(), old_frame.getHeight())) {
                eIndex = 1; e_index = true;
            }
            if (e_index && eIndex == 1 && Wand.region(rX, rY, width/2-old_frame.getWidth()/2, 245, old_frame.getWidth(), old_frame.getHeight())) {
                gFlag = "PAUSE";
            }
            
            if(rKey != 0 || Wand.isAction(rX, rY)) {
                e_index = false;
            }
            
            pKey = rKey = 0;
            pX = pY = rX = rY = dX = dY = -1;
        }
        if (gFlag.equals("IMPROVEMENTS")) {
            if(!notOpenYet) {
                if (pKey == -7 || pKey == 8 || pKey == 121 || Wand.region(pX, pY, width - drawText.stringWidth(Localization.getAloneText(39)) - 10 + drawText.stringWidth(Localization.getAloneText(39)) / 2 - button[0].getWidth() / 2 - 2, height - 20 + 7 - button[0].getHeight() / 2 - 2, button[0].getWidth() + 4, button[0].getHeight() + 4)) {
                    im_back.setState(true);
                }
                if(im_back.getState() && (rKey != 0 || Wand.isAction(rX, rY))) {
                    if (rKey == -7 || rKey == 8 || rKey == 121 || Wand.region(rX, rY, width - drawText.stringWidth(Localization.getAloneText(39)) - 10 + drawText.stringWidth(Localization.getAloneText(39)) / 2 - button[0].getWidth() / 2 - 2, height - 20 + 7 - button[0].getHeight() / 2 - 2, button[0].getWidth() + 4, button[0].getHeight() + 4)) {
                        gFlag = "BEGIN";
                    }
                    im_back.setState(false);
                }
                if (pKey == Canvas.KEY_NUM5 || pKey == -5 || pKey == 10 || pKey == 103) {
                    if(bIndex == 2 && rms_game[5] == 0) {
                        notOpenYet = true;
                    } else {
                        int points = bIndex == 0 ? 1500 : bIndex == 1 ? 2000 : 2500;
                        if (rms_game[1] >= points) {
                            rms.setBallVar(rms_ball[bIndex] + (bIndex != 2 ? 0.1f : -2), bIndex);
                            rms.setGameVar(rms_game[1] - points, 1);
                            rms_game = rms.getGameData();
                            rms_ball = rms.getBallData();
                        } else {
                            pTime = System.currentTimeMillis();
                        }
                    }
                }
                int lY = -iScroll.getValue();
                if ((pKey == Canvas.KEY_NUM2 || pKey == -1 || pKey == 116) && bIndex > 0) {
                    bIndex--;
                    if (bIndex >= 0 && lY + lsY[bIndex] < 0) {
                        iScroll.setValue(iScroll.getValue() + (lY + lsY[bIndex]));
                    }
                }
                if ((pKey == Canvas.KEY_NUM8 || pKey == -2 || pKey == 98) && bIndex < 2) {
                    bIndex++;
                    if (bIndex >= 0 && lY + lsY[bIndex] > lHeight - lsH[bIndex] - 12) {
                        iScroll.setValue(iScroll.getValue() + (lY + lsY[bIndex]) - (lHeight - lsH[bIndex] - 12));
                    }
                }
                for (int i = 0; i < 3; i++) {
                    if (Wand.region(rX, rY, 5, 158 + lY + lsY[i], width - 10, lsH[i]) && !wasMotion) {
                        if (rY >= 153 && rY < 158 + ((height - 16) - 158)) {
                            if (i == bIndex) {
                                if(bIndex == 2 && rms_game[5] == 0) {
                                    notOpenYet = true;
                                } else {
                                    int points = bIndex == 0 ? 1500 : bIndex == 1 ? 2000 : 2500;
                                    if (rms_game[1] >= points) {
                                        rms.setBallVar(rms_ball[bIndex] + (bIndex != 2 ? 0.1f : -2), bIndex);
                                        rms.setGameVar(rms_game[1] - points, 1);
                                        rms_game = rms.getGameData();
                                        rms_ball = rms.getBallData();
                                    } else {
                                        pTime = System.currentTimeMillis();
                                    }
                                }
                            } else {
                                bIndex = i;
                            }
                        }
                        break;
                    }
                }
                if (!wasMotion) {
                    if (Wand.isAction(dX, dY)) {
                        wasMotion = true;
                    }
                } else {
                    if (Wand.isAction(rX, rY)) {
                        wasMotion = false;
                    }
                }
                iScroll.pCheck(fps_time, dKey, pX, pY, rX, rY, dX, dY);
            } else {
                if (pKey == -7 || pKey == 8 || pKey == 121 || Wand.region(pX, pY, width/2+board1.getWidth()/2-button_long1[0].getWidth()-7, height/2+board1.getHeight()/2-button_long1[0].getHeight()-7, button_long1[0].getWidth() + 4, button_long1[0].getHeight() + 4)) {
                    no_close.setState(true);
                }
                if(no_close.getState() && (rKey != 0 || Wand.isAction(rX, rY))) {
                    if (rKey == -7 || rKey == 8 || rKey == 121 || Wand.region(rX, rY, width/2+board1.getWidth()/2-button_long1[0].getWidth()-7, height/2+board1.getHeight()/2-button_long1[0].getHeight()-7, button_long1[0].getWidth() + 4, button_long1[0].getHeight() + 4)) {
                        notOpenYet = false;
                    }
                    no_close.setState(false);
                }
            }
            pX = pY = rX = rY = dX = dY = -1;
            pKey = rKey = 0;
        }
        if (gFlag.equals("SL")) {
            if (pKey == -7 || pKey == 8 || pKey == 121 || Wand.region(pX, pY, width - drawText.stringWidth(Localization.getAloneText(39)) - 14 + drawText.stringWidth(Localization.getAloneText(39)) / 2 - button[0].getWidth() / 2 + 4, height - 19 + 7 - button[0].getHeight() / 2 - 1, drawText.stringWidth(Localization.getAloneText(39)) + 4, button[0].getHeight() + 4)) {
                sl_back.setState(true);
            }
            if(sl_back.getState() && (rKey != 0 || Wand.isAction(rX, rY))) {
                if (rKey == -7 || rKey == 8 || rKey == 121 || Wand.region(rX, rY, width - drawText.stringWidth(Localization.getAloneText(39)) - 14 + drawText.stringWidth(Localization.getAloneText(39)) / 2 - button[0].getWidth() / 2 + 4, height - 19 + 7 - button[0].getHeight() / 2 - 1, drawText.stringWidth(Localization.getAloneText(39)) + 4, button[0].getHeight() + 4)) {
                    gFlag = "BEGIN";
                }
                sl_back.setState(false);
            }
            if (pKey == Canvas.KEY_NUM5 || pKey == -5 || pKey == 10 || pKey == 103) {
                s_index = true;
            }
            if (rKey == Canvas.KEY_NUM5 || rKey == -5 || rKey == 10 || rKey == 103) {
                createLevel(new MLoader("/resources/maps.dat", slIndex + 1), "JPR");
                lift.inStart();
                sb.startShowlevelBegin();
                gFlag = "LIFT_ENTER";
            }
            int fH = old_frame.getHeight() + 8, slY = -sScroll.getValue();
            if (pKey == Canvas.KEY_NUM2 || pKey == -1 || pKey == 116) {
                if (slIndex > 0) {
                    if (slY + fH * (slIndex - 1) < 0) {
                        slColorUp = 0xb97a57;
                    } else {
                        slIndex--;
                    }
                }
                if (slColorUp != 0xb97a57) {
                    if (slY + slIndex * fH < 0) {
                        slIndex = (-slY + 10) / fH;
                    }
                    if (slY + slIndex * fH > mlHeight) {
                        slIndex = (-slY + mlHeight) / fH;
                    }
                    if (slIndex >= rms.getGameLevel(rms_game)) {
                        slIndex = rms.getGameLevel(rms_game) - 1;
                    }
                }
            }
            if ((rKey == Canvas.KEY_NUM2 || rKey == -1 || rKey == 116) && slColorUp == 0xb97a57) {
                slIndex--;
                sScroll.setValue(sScroll.getValue()+fH);
                slColorUp = 0xd0d0d0;
            }
            if (pKey == Canvas.KEY_NUM8 || pKey == -2 || pKey == 98) {
                if (slIndex < rms.getGameLevel(rms_game) - 1) {
                    if (slY + fH * (slIndex + 1) > mlHeight - fH + 5) {
                        slColorDown = 0xb97a57;
                    } else {
                        slIndex++;
                    }
                }
                if (slColorUp != 0xb97a57) {
                    if (slY + slIndex * fH < 0) {
                        slIndex = (-slY + 10) / fH;
                    }
                    if (slY + slIndex * fH > mlHeight) {
                        slIndex = (-slY + mlHeight) / fH;
                    }
                    if (slIndex >= rms.getGameLevel(rms_game)) {
                        slIndex = rms.getGameLevel(rms_game) - 1;
                    }
                }
            }
            if ((rKey == Canvas.KEY_NUM8 || rKey == -2 || rKey == 98) && slColorDown == 0xb97a57) {
                slIndex++;
                sScroll.setValue(sScroll.getValue()-fH);
                slColorDown = 0xd0d0d0;
            }
            
            for (int i = 0; i < rms.getGameLevel(rms_game); i++) {
                if (pY >= 150 && pY < 150 + mlHeight + 5 && Wand.region(pX, pY, width / 2 - old_frame.getWidth() / 2, 150 + slY + i * (old_frame.getHeight() + 8), old_frame.getWidth(), old_frame.getHeight()) && !wasMotion) {
                    if(slIndex != i) {
                        slIndex = i;
                    } else {
                        s_index = true;
                    }
                    break;
                }
                if (s_index && slIndex == i && Wand.region(rX, rY, width / 2 - old_frame.getWidth() / 2, 150 + slY + i * (old_frame.getHeight() + 8), old_frame.getWidth(), old_frame.getHeight()) && !wasMotion) {
                    if (rY >= 150 && rY < 150 + mlHeight + 5) {
                        if (i == slIndex) {
                            createLevel(new MLoader("/resources/maps.dat", slIndex + 1), "JPR");
                            lift.inStart();
                            sb.startShowlevelBegin();
                            gFlag = "LIFT_ENTER";
                        } else {
                            if (i < rms.getGameLevel(rms_game)) {
                                slIndex = i;
                            }
                        }
                    }
                    break;
                }
            }
            if (!wasMotion) {
                if (Wand.isAction(dX, dY)) {
                    wasMotion = true;
                }
            } else {
                if (Wand.isAction(rX, rY)) {
                    wasMotion = false;
                }
            }
            
            sScroll.pCheck(fps_time, dKey, pX, pY, rX, rY, dX, dY);
            
            if(pKey != 0 || Wand.isAction(rX, rY)) {
                s_index = false;
            }
            
            pX = pY = rX = rY = dX = dY = -1;
            pKey = rKey = 0;
        }
        if (gFlag.equals("SD")) {
            if (!nSelectDiff) {
                if (pKey == Canvas.KEY_NUM5 || pKey == -5 || pKey == 10 || pKey == 103) {
                    d_index = true;
                }
                if (rKey == Canvas.KEY_NUM5 || rKey == -5 || rKey == 10 || rKey == 103) {
                    if (rms_game[5] == 0 && sdIndex == 2) {
                        nSelectDiff = true;
                    } else {
                        rms.setGameVar(sdIndex + 1, 4);
                        if(rms_game[5] == 1 && rms_game[15] == 0) {
                            rms.setGameVar(1, 15);
                        }
                        rms_game = rms.getGameData();
                        
                        sSlider[2].setIndex(rms_game[4] - 1);
                        
                        gFlag = "BEGIN";
                    }
                }
                int fH = old_frame.getHeight() + 15;
                if (pKey == Canvas.KEY_NUM2 || pKey == -1 || pKey == 116) {
                    if (sdIndex > 0) {
                        sdIndex--;
                        if (sdY + fH * sdIndex < 0) {
                            sdY += fH;
                        }
                    }
                }
                if (pKey == Canvas.KEY_NUM8 || pKey == -2 || pKey == 98) {
                    if (sdIndex < 2) {
                        sdIndex++;
                        if (sdY + fH * sdIndex > mHeight - fH) {
                            sdY -= fH;
                        }
                    }
                }
                for (int i = 0; i < 3; i++) {
                    if (Wand.region(pX, pY, width / 2 - drawText.stringWidth(begin_text[12 + i]) / 2 - 2, 150 + sdY + i * (old_frame.getHeight() + 15) + old_frame.getHeight() / 2 - 9, drawText.stringWidth(begin_text[12 + i]) + 4, old_frame.getHeight() + 4)) {
                        sdIndex = i; d_index = true;
                        break;
                    }
                    if (d_index && sdIndex == i && Wand.region(rX, rY, width / 2 - drawText.stringWidth(begin_text[12 + i]) / 2 - 2, 150 + sdY + i * (old_frame.getHeight() + 15) + old_frame.getHeight() / 2 - 9, drawText.stringWidth(begin_text[12 + i]) + 4, old_frame.getHeight() + 4)) {
                        if (rms_game[5] == 0 && sdIndex == 2) {
                            nSelectDiff = true;
                        } else {
                            rms.setGameVar(sdIndex + 1, 4);
                            if(rms_game[5] == 1 && rms_game[15] == 0) {
                                rms.setGameVar(1, 15);
                            }
                            rms_game = rms.getGameData();
                            
                            sSlider[2].setIndex(rms_game[4] - 1);
                            
                            gFlag = "BEGIN";
                        }
                        break;
                    }
                }
                
                if(rKey != 0 || Wand.isAction(rX, rY)) {
                    d_index = false;
                }
            } else {
                if (pKey == -7 || pKey == 8 || pKey == 121 || Wand.region(pX, pY, width / 2 + board1.getWidth() / 2 - drawText.stringWidth(Localization.getAloneText(39)) - 16 + drawText.stringWidth(Localization.getAloneText(39)) / 2 - button[0].getWidth() / 2 - 2, height / 2 + board1.getHeight() / 2 - 22, button[0].getWidth() + 4, button[0].getHeight() + 4)) {
                    sd_back.setState(true);
                }
                if(sd_back.getState() && (rKey != 0 || Wand.isAction(rX, rY))) {
                    if (rKey == -7 || rKey == 8 || rKey == 121 || Wand.region(rX, rY, width / 2 + board1.getWidth() / 2 - drawText.stringWidth(Localization.getAloneText(39)) - 16 + drawText.stringWidth(Localization.getAloneText(39)) / 2 - button[0].getWidth() / 2 - 2, height / 2 + board1.getHeight() / 2 - 22, button[0].getWidth() + 4, button[0].getHeight() + 4)) {
                        nSelectDiff = false;
                    }
                    sd_back.setState(false);
                }
            }
                
            pKey = rKey = 0;
            pX = pY = rX = rY = dX = dY = -1;
        }
        if (gFlag.equals("SETTINGS")) {
            if (pKey == -7 || pKey == 8 || pKey == 121 || Wand.region(pX, pY, width/2+board6.getWidth()/2-button[0].getWidth()-15, height / 2 - board6.getHeight() / 2 + 18 + stY[3] + 6, button[0].getWidth() + 12, button[0].getHeight() + 12)) {
                st_back.setState(true);
            }
            if(st_back.getState() && (rKey != 0 || Wand.isAction(rX, rY))) {
                if (rKey == -7 || rKey == 8 || rKey == 121 || Wand.region(rX, rY, width/2+board6.getWidth()/2-button[0].getWidth()-15, height / 2 - board6.getHeight() / 2 + 18 + stY[3] + 6, button[0].getWidth() + 12, button[0].getHeight() + 12)) {
                    wasBack = true;
                    mScroll.setVisibleScroll(true);
                    gFlag = "MENU";
                }
                st_back.setState(false);
            }
            if ((pKey == Canvas.KEY_NUM2 || pKey == -1 || pKey == 116) && stIndex > 0) {
                stIndex--;
            }
            if ((pKey == Canvas.KEY_NUM8 || pKey == -2 || pKey == 98) && stIndex < stY.length-1) {
                stIndex++;
            }
            switch (stIndex) {
                case 0:
                    if ((pKey == Canvas.KEY_NUM4 || pKey == -3 || pKey == 102) && sound.isEnable()) {
                        slColor[0] = 0xb97a57;
                    }
                    if ((rKey == Canvas.KEY_NUM4 || rKey == -3 || rKey == 102) && slColor[0] == 0xb97a57) {
                        rms.setGameVar(0, 13);
                        rms_game = rms.getGameData();
                        sSlider[0].setIndex(0);
                        slColor[0] = 0x666666;
                        sound.fullStopAll();
                        sound.soundOff();
                    }
                    if ((pKey == Canvas.KEY_NUM6 || pKey == -4 || pKey == 104) && !sound.isEnable()) {
                        slColor[1] = 0xb97a57;
                    }
                    if ((rKey == Canvas.KEY_NUM6 || rKey == -4 || rKey == 104) && slColor[1] == 0xb97a57) {
                        rms.setGameVar(1, 13);
                        rms_game = rms.getGameData();
                        sSlider[0].setIndex(1);
                        slColor[1] = 0x666666;
                        sound.soundOn();
                        playBackground();
                    }
                    break;
                case 1:
                    if ((pKey == Canvas.KEY_NUM4 || pKey == -3 || pKey == 102) && rms_game[6] > 0) {
                        slColor[2] = 0xb97a57;
                    }
                    if ((rKey == Canvas.KEY_NUM4 || rKey == -3 || rKey == 102) && slColor[2] == 0xb97a57) {
                        rms.setGameVar(rms_game[6] - 1, 6);
                        rms_game = rms.getGameData();
                        sSlider[1].setIndex(rms_game[6]);
                        slColor[2] = 0x666666;
                    }
                    if ((pKey == Canvas.KEY_NUM6 || pKey == -4 || pKey == 104) && rms_game[6] < 1) {
                        slColor[3] = 0xb97a57;
                    }
                    if ((rKey == Canvas.KEY_NUM6 || rKey == -4 || rKey == 104) && slColor[3] == 0xb97a57) {
                        rms.setGameVar(rms_game[6] + 1, 6);
                        rms_game = rms.getGameData();
                        sSlider[1].setIndex(rms_game[6]);
                        slColor[3] = 0x666666;
                        Vibration.vib(rb2MIDlet, 500);
                    }
                    break;
                case 2:
                    if ((pKey == Canvas.KEY_NUM4 || pKey == -3 || pKey == 102) && rms_game[4] > 1) {
                        slColor[4] = 0xb97a57;
                    }
                    if ((rKey == Canvas.KEY_NUM4 || rKey == -3 || rKey == 102) && slColor[4] == 0xb97a57) {
                        rms.setGameVar(rms_game[4] - 1, 4);
                        rms_game = rms.getGameData();
                        sSlider[2].setIndex(rms_game[4] - 1);
                        slColor[4] = 0x666666;
                    }
                    if ((pKey == Canvas.KEY_NUM6 || pKey == -4 || pKey == 104) && rms_game[4] < (rms_game[5] == 0 ? 2 : 3)) {
                        slColor[5] = 0xb97a57;
                    }
                    if ((rKey == Canvas.KEY_NUM6 || rKey == -4 || rKey == 104) && slColor[5] == 0xb97a57) {
                        rms.setGameVar(rms_game[4] + 1, 4);
                        rms_game = rms.getGameData();
                        sSlider[2].setIndex(rms_game[4] - 1);
                        slColor[5] = 0x666666;
                    }
                    break;
                case 3:
                    if ((pKey == Canvas.KEY_NUM4 || pKey == -3 || pKey == 102) && rms_game[8] == 2) {
                        slColor[6] = 0xb97a57;
                    }
                    if ((rKey == Canvas.KEY_NUM4 || rKey == -3 || rKey == 102) && slColor[6] == 0xb97a57) {
                        rms.setGameVar(1, 8);
                        rms_game = rms.getGameData();
                        sSlider[3].setIndex(rms_game[8] - 1);
                        Localization.setLocale(0);
                        getLocalization();
                        slColor[6] = 0x666666;
                    }
                    if ((pKey == Canvas.KEY_NUM6 || pKey == -4 || pKey == 104) && rms_game[8] == 1) {
                        slColor[7] = 0xb97a57;
                    }
                    if ((rKey == Canvas.KEY_NUM6 || rKey == -4 || rKey == 104) && slColor[7] == 0xb97a57) {
                        rms.setGameVar(2, 8);
                        rms_game = rms.getGameData();
                        sSlider[3].setIndex(rms_game[8] - 1);
                        Localization.setLocale(1);
                        getLocalization();
                        slColor[7] = 0x666666;
                    }
                    break;
            }
            for (int i = 0; i < sXYWH.length; i++) {
                if (Wand.region(pX, pY, sXYWH[i][0], sXYWH[i][1], sXYWH[i][2], sXYWH[i][3])) {
                    stIndex = i;
                }
            }

            for (int i = 0; i < sSlider.length; i++) {
                sSlider[i].pCheck(pX, pY, rX, rY, dX, dY);
                if (sSlider[i].hasValue()) {
                    if(i == 0) {
                        if(sSlider[0].getIndex() == 0) {
                            sound.fullStopAll();
                            sound.soundOff();
                        } else {
                            if(sound.soundOn()) {
                                playBackground();
                            }
                        }
                    }
                    if (i == 1) {
                        rms.setGameVar(sSlider[1].getIndex(), 6);
                        rms_game = rms.getGameData();
                        if(sSlider[1].getIndex() == 1) {
                            Vibration.vib(rb2MIDlet, 500);
                        }
                    }
                    if (i == 2) {
                        rms.setGameVar(sSlider[2].getIndex() + 1, 4);
                        rms_game = rms.getGameData();
                    }
                    if (i == 3) {
                        rms.setGameVar(sSlider[3].getIndex() + 1, 8);
                        rms_game = rms.getGameData();
                        Localization.setLocale(rms_game[8] - 1);
                        getLocalization();
                    }
                }
            }
            
            pKey = rKey = 0;
            pX = pY = rX = rY = dX = dY = -1;
        }
        //if (gFlag.equals("PURCHASE")) {
        //    if(pMode == 0) {
        //        int X = bsX+(width/2-board6.getWidth()/2)+(board6.getWidth()-9), Y = height/2+board6.getHeight()/2-22;
        //        if(Localization.getLocale() == Localization.EN) {
        //            if(hasIAP && !fDetails && (pKey == -7 || pKey == 10 || pKey == 121 || Wand.region(pX, pY, X+board6.getWidth()-button_long1.getWidth()-17, Y-2, button_long1.getWidth()+4, button_long1.getHeight()+4))) {
        //                if(fAds) {
        //                    fAds = false;
        //                } else {
        //                    boolean status = iap.purchaseProduct();
        //                    if(!status) {
        //                        fAds = true;
        //                    }
        //                }
        //            }
        //            if(pKey == -6 || pKey == 8 || pKey == 114 || Wand.region(pX, pY, X+13, Y-2, button.getWidth()+4, button.getHeight()+4)) {
        //                pMode = 2;
        //            }
        //        } else {
        //            if(hasIAP && !fDetails && (pKey == -7 || pKey == 10 || pKey == 121 || Wand.region(pX, pY, X+board6.getWidth()-button_long2.getWidth()-17, Y-2, button_long2.getWidth()+4, button_long2.getHeight()+4))) {
        //                if(fAds) {
        //                    fAds = false;
        //                } else {
        //                    boolean status = iap.purchaseProduct();
        //                    if(!status) {
        //                        fAds = true;
        //                    }
        //                }
        //            }
        //            if(pKey == -6 || pKey == 8 || pKey == 114 || Wand.region(pX, pY, X+13, Y-2, button_long1.getWidth()+4, button_long1.getHeight()+4)) {
        //                pMode = 2;
        //            }
        //        }
        //    } else {
        //        switch(pMode) {
        //            case 1:
        //                bsX -= 10;
        //                break;
        //            case 2:
        //                bsX += 10;
        //                break;
        //        }
        //        boolean change = false;
        //        if(pMode == 1 && bsX <= -(board6.getWidth()-9)) {
        //            bsX = -(board6.getWidth()-9);
        //            pMode = 0; change = true;
        //        }
        //        if(pMode == 2 && bsX >=  0) {
        //            bsX = 0;
        //            fAds = fDetails = false;
        //            gFlag = "SETTINGS";
        //            pMode = 0; change = true;
        //        }
        //        if(!change) {
        //            for(int i=0; i<sSlider.length; i++) {
        //                sSlider[i].setX(sSlider[i].getX()-(pMode == 1 ? 10 : -10));
        //            }
        //        }
        //    }
        //    pKey = 0;
        //    pX = pY = rX = rY = dX = dY = -1;
        //}
        if (gFlag.equals("CAST")) {
            if ((rKey == -5 || rKey == 10 || rKey == Canvas.KEY_NUM5 || rKey == 103 || Wand.isAction(rX, rY)) && cMode == 2) {
                drawText.setColorWithAlpha(false);
                drawText.setColor(0xffffff);
                cast = null; sAlpha = fPassed = false;
                sound.fullStopAll();
                playBackground();
                gFlag = "MENU";
            }
            rKey = 0; pX = pY = rX = rY = dX = dY = -1;
        }
        
        //if (!hFirst && (gFlag.equals("GAME") || gFlag.equals("LIFT_ENTER") || gFlag.equals("LIFT_EXIT"))) {
        //    if (pKey == -7 || pKey == 8 || pKey == 121 || Wand.region(rX, rY, !pUsing ? width - 28 : 0, !pUsing ? height - 30 : 0, 28, 30)) {
        //        sb.pause();
        ///       pauseFlag = gFlag;
        //        gFlag = "PAUSE";
        //    }
        //}
        
        if (gFlag.equals("GAME")) {
            if(!f_board && !hint_rebound) {
                if (pKey == -6 || pKey == 10 || pKey == 114 || Wand.region(pX, pY, 0, !pUsing ? height - 30 : 0, 28, 30)) {
                    p_pressed = true;
                }
                if(p_pressed && (rKey != 0 || Wand.isAction(rX, rY))) {
                    if (rKey == -6 || rKey == 10 || rKey == 114 || Wand.region(rX, rY, 0, !pUsing ? height - 30 : 0, 28, 30)) {
                        pIndex = 0;
                        sb.pause();
                        pauseFlag = gFlag;
                        otime = System.currentTimeMillis() - gtime;
                        gFlag = "PAUSE";
                    }
                    p_pressed = false;
                }

                if (keys[KEY_FIRE] || keys[KEY_LEFT] || keys[KEY_RIGHT]) {
                    if (keys[KEY_FIRE]) {
                        ball.jump();
                    }
                    if (keys[KEY_LEFT]) {
                        ball.startMove(1);
                        if (bKey == 0) {
                            bKey = 1;
                        }
                    }
                    if (keys[KEY_RIGHT]) {
                        ball.startMove(2);
                        if (bKey == 0) {
                            bKey = 2;
                        }
                    }
                } else {
                    if (bKey != 0) {
                        ball.stopMove(bKey);
                        bKey = 0;
                    }
                }
                if (thorns.check(sBall)) {
                    otime = System.currentTimeMillis() - gtime;
                    if(rms_game[6] == 1) {
                        Vibration.vib(rb2MIDlet, 1000);
                    }
                    ball.destroy(destruction);
                    gFlag = "GAME_OVER";
                } else {
                    ball.updateMove(fps_time);
                    ball.updateJump(fps_time);
                    ball.updateFall(fps_time);
                    ball.updateFans(fps_time);
                }
                if (!noTime) {
                    if (System.currentTimeMillis() - gtime > levelTime) {
                        otime = System.currentTimeMillis() - gtime;
                        gFlag = "TIME_OUT";
                    }
                }
                if (sBall.getX() > liftOut[0] && sBall.getX() < liftOut[0] + sLiftOut.getWidth() && sBall.getY() > liftOut[1] - sBall.getHeight() && sBall.getY() < liftOut[2]) {
                    sBall.setPosition(sLiftOut.getX() + sLiftOut.getWidth() / 2 - sBall.getWidth() / 2, sLiftOut.getY() + sLiftOut.getHeight() - sBall.getHeight());
                    otime = System.currentTimeMillis() - gtime;
                    lift.outStart();
                    sb.startShowLevelEnd();
                    nPoints = levelPoints + (int)((levelTime - otime) / 1000);
                    gFlag = "LIFT_EXIT";
                }

                if (joystick != null && gFlag.equals("GAME") && !p_pressed && !Wand.region(rX, rY, !pUsing ? width - 28 : 0, !pUsing ? height - 30 : 0, 28, 30)) {
                    joystick.pCheck(pX, pY, rX, rY, dX, dY);
                }
                
                if(!hint_rebound && rms_game[18] == 0 && rms.getGameLevel(rms_game) == 9) {
                    if(sBall.getX() >= 320 && sBall.getY() >= 510 && sBall.getY() < 570) {
                        h_time = System.currentTimeMillis()-gtime;
                        hint_rebound = true;
                    }
                }
            } else {
                if(f_board) {
                    if(rMode == 1) {
                        rXY[0] -= 0.8f;
                        rXY[1] += 0.8f;
                        if(rXY[0] < 167 || rXY[1] > 42) {
                            rMode = 2;
                        }
                    }
                    if(rMode == 2) {
                        rXY[0] += 0.8f;
                        rXY[1] -= 0.8f;
                        if(rXY[0] > 174 || rXY[1] < 35) {
                            rMode = 1;
                        }
                    }
                    if(pKey == -7 || pKey == 8 || pKey == 121 || pKey == Canvas.KEY_NUM5 || pKey == -5 || pKey == 103 || Wand.region(pX, pY, width/2+board7.getWidth()/2-button_long1[0].getWidth()-7, height/2+board7.getHeight()/2-button_long1[0].getHeight()-9, button_long1[0].getWidth() + 4, button_long1[0].getHeight() + 4)) {
                        f_continue.setState(true);
                    }
                    if(f_continue.getState() && (rKey != 0 || Wand.isAction(rX, rY))) {
                        if(rKey == -7 || rKey == 8 || rKey == 121 || rKey == Canvas.KEY_NUM5 || rKey == -5 || rKey == 103 || Wand.region(rX, rY, width/2+board7.getWidth()/2-button_long1[0].getWidth()-7, height/2+board7.getHeight()/2-button_long1[0].getHeight()-9, button_long1[0].getWidth() + 4, button_long1[0].getHeight() + 4)) {
                            rms.setGameVar(1, 13);
                            rms_game = rms.getGameData();
                            f_board = false;
                            gtime = System.currentTimeMillis();
                        }
                        f_continue.setState(false);
                    }
                }
                if(hint_rebound) {
                    if(pKey == -7 || pKey == 8 || pKey == 121 || pKey == Canvas.KEY_NUM5 || pKey == -5 || pKey == 103 || Wand.region(pX, pY, width/2+board7.getWidth()/2-button_long1[0].getWidth()-7, height/2+board7.getHeight()/2-button_long1[0].getHeight()-9, button_long1[0].getWidth() + 4, button_long1[0].getHeight() + 4)) {
                        h_close.setState(true);
                    }
                    if(h_close.getState() && (rKey != 0 || Wand.isAction(rX, rY))) {
                        if(rKey == -7 || rKey == 8 || rKey == 121 || rKey == Canvas.KEY_NUM5 || rKey == -5 || rKey == 103 || Wand.region(rX, rY, width/2+board7.getWidth()/2-button_long1[0].getWidth()-7, height/2+board7.getHeight()/2-button_long1[0].getHeight()-9, button_long1[0].getWidth() + 4, button_long1[0].getHeight() + 4)) {
                            rms.setGameVar(1, 18);
                            rms_game = rms.getGameData();
                            hint_rebound = false;
                            gtime += System.currentTimeMillis() - (gtime + h_time);
                        }
                        h_close.setState(false);
                    }
                }
            }
            pKey = rKey = 0;
            pX = pY = rX = rY = dX = dY = -1;
        }
        if (gFlag.equals("LIFT_ENTER")) {
            if (pKey == -6 || pKey == 10 || pKey == 114 || Wand.region(pX, pY, 0, !pUsing ? height - 30 : 0, 28, 30)) {
                p_pressed = true;
            }
            if(p_pressed && (rKey != 0 || Wand.isAction(rX, rY))) {
                if (rKey == -6 || rKey == 10 || rKey == 114 || Wand.region(rX, rY, 0, !pUsing ? height - 30 : 0, 28, 30)) {
                    pIndex = 0;
                    sb.pause();
                    pauseFlag = gFlag;
                    otime = System.currentTimeMillis() - gtime;
                    gFlag = "PAUSE";
                }
                p_pressed = false;
            }
            if (!lift.isIn()) {
                lift.move(fps_time);
            } else {
                if(rms_game[13] == 0 && !fromEditor) {
                    rXY = new float[] {174, 35};
                    rMode = 1;
                    f_board = true;
                }
                gtime = System.currentTimeMillis();
                gFlag = "GAME";
            }
            
            pKey = rKey = 0;
            pX = pY = rX = rY = dX = dY = -1;
        }
        if (gFlag.equals("LIFT_EXIT")) {
            if (pKey == -6 || pKey == 10 || pKey == 114 || Wand.region(pX, pY, 0, !pUsing ? height - 30 : 0, 28, 30)) {
                p_pressed = true;
            }
            if(p_pressed && (rKey != 0 || Wand.isAction(rX, rY))) {
                if (rKey == -6 || rKey == 10 || rKey == 114 || Wand.region(rX, rY, 0, !pUsing ? height - 30 : 0, 28, 30)) {
                    pIndex = 0;
                    sb.pause();
                    pauseFlag = gFlag;
                    otime = System.currentTimeMillis() - gtime;
                    gFlag = "PAUSE";
                }
                p_pressed = false;
            }
            
            if (!lift.isOut()) {
                lift.move(fps_time);
            } else {
                if (!sb.isShowLevelEnd()) {
                    if (!jLevel) {
                        int tMode = 0;
                        if (!rLevel) {
                            if(!rms.isPassed(rms_game)) {
                                rms.setGameVar(rms_game[1] + nPoints, 1);
                                rms_game = rms.getGameData();
                            }
                            
                            if (rms.getGameLevel(rms_game) == lQuantity) {
                                if (rms_game[5] == 0) {
                                    
                                    int bX = width / 2 - board6.getWidth() / 2 + 25, bY = height / 2 - board6.getHeight() / 2 + 18;
                                    int bSliderIndex = sSlider[2].getIndex();
                                    sSlider[2] = new Slider(new String[]{begin_text[12], begin_text[13], begin_text[14]}, bX + drawText.stringWidth(Localization.getAloneText(32)) + 16, bY+stY[2], max(drawText, begin_text[12], begin_text[13], begin_text[14]) + 6, 18, drawText);
                                    sSlider[2].setIndex(bSliderIndex);

                                    rms.setGameVar(1, 5);
                                    rms_game = rms.getGameData();
                                    
                                    fPassed = true;
                                }
                                
                                int[] points = new int[] {2250, 2500, 2800};
                                rms.setGameVar(rms_game[1]+points[rms_game[4]-1], 1);
                                rms_game = rms.getGameData();
                                
                                if(!rms.isPassed(rms_game)) {
                                    tMode = 1;
                                } else {
                                    tMode = 2;
                                }
                                    
                                rms.setGameVar(0, 15);
                                rms.setPassed(rms_game);
                                rms_game = rms.getGameData();
                            } else {
                                rms.setGameLevel(rms_game, rms.getGameLevel(rms_game)+1);
                                rms_game = rms.getGameData();
                            }
                        }
                        if (!noTime) {
                            rms.upRecord(rms_game[4]-1, rms.getGameLevel(rms_game), otime, nPoints);
                        }
                        
                        if(rms_game[16] == 0 && rms_game[1] >= 1500) {
                            already_scores = true;
                        }
                        
                        if (tMode == 0) {
                            gFlag = "BEGIN";
                        } else {
                            if(tMode == 1) {
                                gFlag = "CAST";
                            }
                            if(tMode == 2) {
                                gFlag = "MENU";
                            }
                        }
                    } else {
                        drawText.setColor(0xffffff);
                        sound.fullStopAll();
                        playBackground();
                        gFlag = "CREATE_MAP_MENU";
                    }
                    
                    fromEditor = false;
                }
            }
            pKey = 0;
            pX = pY = rX = rY = dX = dY = -1;
        }
        if (gFlag.equals("TIME_OUT")) {
            if (pKey == Canvas.KEY_NUM5 || pKey == -5 || pKey == 10 || pKey == 103) {
                to_index = true;
            }
            if (rKey == Canvas.KEY_NUM5 || rKey == -5 || rKey == 10 || rKey == 103) {
                if(goIndex == 0) {
                    if (jLevel) {
                        createLevel(new MLoader(Encode.encode(rms.getLevel(mList.getCurrentIndex()))), "JP");
                    } else {
                        if (rLevel) {
                            createLevel(new MLoader("/resources/maps.dat", slIndex + 1), "JPR");
                        } else {
                            createLevel(new MLoader("/resources/maps.dat", rms.getGameLevel(rms_game)), "");
                        }
                    }
                    lift.inStart();
                    sb.startShowlevelBegin();
                    gFlag = "LIFT_ENTER";
                }
                if(goIndex == 1) {
                    sound.fullStopAll();
                    playBackground();
                    gFlag = "MENU";

                    fromEditor = false;
                }
            }
            if ((pKey == Canvas.KEY_NUM2 || pKey == -1 || pKey == 116) && toIndex > 0) {
                toIndex--;
            }
            if ((pKey == Canvas.KEY_NUM8 || pKey == -2 || pKey == 98) && toIndex < 1) {
                toIndex++;
            }
            if (Wand.region(pX, pY, width/2-old_frame.getWidth()/2, height/2-old_frame.getHeight()/2, old_frame.getWidth(), old_frame.getHeight())) {
                toIndex = 0; to_index = true;
            }
            if (to_index && toIndex == 0 && Wand.region(rX, rY, width/2-old_frame.getWidth()/2, height/2-old_frame.getHeight()/2, old_frame.getWidth(), old_frame.getHeight())) {
                if (jLevel) {
                        createLevel(new MLoader(Encode.encode(rms.getLevel(mList.getCurrentIndex()))), "JP");
                    } else {
                        if (rLevel) {
                            createLevel(new MLoader("/resources/maps.dat", slIndex + 1), "JPR");
                        } else {
                            createLevel(new MLoader("/resources/maps.dat", rms.getGameLevel(rms_game)), "");
                        }
                    }
                    lift.inStart();
                    sb.startShowlevelBegin();
                    gFlag = "LIFT_ENTER";
            }
            if (Wand.region(pX, pY, width/2-old_frame.getWidth()/2, height/2+old_frame.getHeight()/2+14, old_frame.getWidth(), old_frame.getHeight())) {
                toIndex = 1; to_index = true;
            }
            if (to_index && toIndex == 1 && Wand.region(rX, rY, width/2-old_frame.getWidth()/2, height/2+old_frame.getHeight()/2+14, old_frame.getWidth(), old_frame.getHeight())) {
                sound.fullStopAll();
                playBackground();
                gFlag = "MENU";

                fromEditor = false;
            }

            if(rKey != 0 || Wand.isAction(rX, rY)) {
                to_index = false;
            }

            pKey = rKey = 0;
            pX = pY = rX = rY = dX = dY = -1;
        }
        if (gFlag.equals("GAME_OVER")) {
            if(!(destroying = ball.destroying())) {
                if (pKey == Canvas.KEY_NUM5 || pKey == -5 || pKey == 10 || pKey == 103) {
                    go_index = true;
                }
                if (rKey == Canvas.KEY_NUM5 || rKey == -5 || rKey == 10 || rKey == 103) {
                    if(goIndex == 0) {
                        if (jLevel) {
                            createLevel(new MLoader(Encode.encode(rms.getLevel(mList.getCurrentIndex()))), "JP");
                        } else {
                            if (rLevel) {
                                createLevel(new MLoader("/resources/maps.dat", slIndex + 1), "JPR");
                            } else {
                                createLevel(new MLoader("/resources/maps.dat", rms.getGameLevel(rms_game)), "");
                            }
                        }
                        lift.inStart();
                        sb.startShowlevelBegin();
                        gFlag = "LIFT_ENTER";
                    }
                    if(goIndex == 1) {
                        sound.fullStopAll();
                        playBackground();
                        gFlag = "MENU";

                        fromEditor = false;
                    }
                }
                if ((pKey == Canvas.KEY_NUM2 || pKey == -1 || pKey == 116) && goIndex > 0) {
                    goIndex--;
                }
                if ((pKey == Canvas.KEY_NUM8 || pKey == -2 || pKey == 98) && goIndex < 1) {
                    goIndex++;
                }
                if (Wand.region(pX, pY, width/2-old_frame.getWidth()/2, height/2-old_frame.getHeight()/2, old_frame.getWidth(), old_frame.getHeight())) {
                    goIndex = 0; go_index = true;
                }
                if (go_index && goIndex == 0 && Wand.region(rX, rY, width/2-old_frame.getWidth()/2, height/2-old_frame.getHeight()/2, old_frame.getWidth(), old_frame.getHeight())) {
                    if (jLevel) {
                            createLevel(new MLoader(Encode.encode(rms.getLevel(mList.getCurrentIndex()))), "JP");
                        } else {
                            if (rLevel) {
                                createLevel(new MLoader("/resources/maps.dat", slIndex + 1), "JPR");
                            } else {
                                createLevel(new MLoader("/resources/maps.dat", rms.getGameLevel(rms_game)), "");
                            }
                        }
                        lift.inStart();
                        sb.startShowlevelBegin();
                        gFlag = "LIFT_ENTER";
                }
                if (Wand.region(pX, pY, width/2-old_frame.getWidth()/2, height/2+old_frame.getHeight()/2+14, old_frame.getWidth(), old_frame.getHeight())) {
                    goIndex = 1; go_index = true;
                }
                if (go_index && goIndex == 1 && Wand.region(rX, rY, width/2-old_frame.getWidth()/2, height/2+old_frame.getHeight()/2+14, old_frame.getWidth(), old_frame.getHeight())) {
                    sound.fullStopAll();
                    playBackground();
                    gFlag = "MENU";

                    fromEditor = false;
                }

                if(rKey != 0 || Wand.isAction(rX, rY)) {
                    go_index = false;
                }

                pKey = rKey = 0;
                pX = pY = rX = rY = dX = dY = -1;
            }
        }
        if (gFlag.equals("GAME") || gFlag.equals("LIFT_ENTER") || gFlag.equals("LIFT_EXIT")) {
            levelX = sBall.getX() > width / 2 ? -(sBall.getX() - width / 2) : 0;
            levelY = sBall.getY() > height / 2 ? -(sBall.getY() - height / 2) : 0;
            if (levelWidth <= width) {
                levelX = width/2-levelWidth/2;
            } else {
                if (levelX <= -(levelWidth - width) && levelWidth > width) {
                    levelX = -(levelWidth - width);
                }
            }
            if (levelHeight <= height) {
                levelY = height/2-levelHeight/2;
            } else {
                if (levelY <= -(levelHeight - height) && levelHeight > height) {
                    levelY = -(levelHeight - height);
                }
            }
            checkXY[0] = sBall.getX() + sBall.getWidth() / 2;
            checkXY[1] = sBall.getY() + sBall.getHeight() / 2;
            lm.check(checkXY[0] < 0 ? 0 : checkXY[0] >= levelWidth ? levelWidth - 1 : checkXY[0], checkXY[1] < 0 ? 0 : checkXY[1] >= levelHeight ? levelHeight - 1 : checkXY[1]);
        }
        if (gFlag.equals("CREATE_MAP")) {
            if (pKey == -6 || pKey == 10 || pKey == 114 || NMWand(0, pX, pY)) {
                newMap.getSaveButton().setState(true);
            }
            if(newMap.getSaveButton().getState() && (rKey != 0 || Wand.isAction(rX, rY))) {
                if ((rKey == -6 || rKey == 10 || rKey == 114 || NMWand(0, rX, rY)) && !newMap.isShowHelp()) {
                    label:
                    {
                        if (!newMap.isSetLift(1)) {
                            newMap.ptime = System.currentTimeMillis();
                            newMap.error = NewMap.DONT_SET_LIFT_UP;
                            break label;
                        }
                        if (!newMap.isSetLift(2)) {
                            newMap.ptime = System.currentTimeMillis();
                            newMap.error = NewMap.DONT_SET_LIFT_DOWN;
                            break label;
                        }
                        if (!newMap.isSetLift(0)) {
                            newMap.ptime = System.currentTimeMillis();
                            newMap.error = NewMap.DONT_SET_POINT_UP;
                            break label;
                        }
                        if (!newMap.isSetLift(3)) {
                            newMap.ptime = System.currentTimeMillis();
                            newMap.error = NewMap.DONT_SET_POINT_DOWN;
                            break label;
                        }

                        if (!eLevel) {
                            rms.putLevel(mParam.getName(), Encode.encode(newMap.getNewMap()));
                        } else {
                            rms.updateLevel(mList.getCurrentIndex(), Encode.encode(newMap.getNewMap()));
                        }
                        createNewMapMenu();
                    }
                }
                newMap.getSaveButton().setState(false);
            }
            if (pKey == -7 || pKey == 8 || pKey == 121 || NMWand(1, pX, pY)) {
                newMap.getCancelButton().setState(true);
            }
            if(newMap.getCancelButton().getState() && (rKey != 0 || Wand.isAction(rX, rY))) {
                if ((rKey == -7 || rKey == 8 || rKey == 121 || NMWand(1, rX, rY)) && !newMap.isShowHelp()) {
                    //drawText.setColor(0xffffff);
                    gFlag = "CREATE_MAP_EXIT";
                }
                newMap.getCancelButton().setState(false);
            }
            if (newMap.check(fps_time, pKey, rKey, hKey, dKey, pX, pY, rX, rY, dX, dY) && !newMap.isShowHelp()) {
                newMap.setHelp(help);
            }
            pKey = rKey = rpKey = 0;
            pX = pY = rX = rY = dX = dY = -1;
        }
        if (gFlag.equals("CREATE_MAP_EXIT")) {
            if (pKey == Canvas.KEY_NUM5 || pKey == -5 || pKey == 10 || pKey == 103) {
                me_index = true;
            }
            if (rKey == Canvas.KEY_NUM5 || rKey == -5 || rKey == 10 || rKey == 103) {
                if(meIndex == 0) {
                    gFlag = "CREATE_MAP_MENU";
                }
                if(meIndex == 1) {
                    gFlag = "CREATE_MAP";
                }
            }
            if ((pKey == Canvas.KEY_NUM2 || pKey == -1 || pKey == 116) && meIndex > 0) {
                meIndex--;
            }
            if ((pKey == Canvas.KEY_NUM8 || pKey == -2 || pKey == 98) && meIndex < 1) {
                meIndex++;
            }
            if (Wand.region(pX, pY, width/2-old_frame.getWidth()/2, 203, old_frame.getWidth(), old_frame.getHeight())) {
                meIndex = 0; me_index = true;
            }
            if (me_index && meIndex == 0 && Wand.region(rX, rY, width/2-old_frame.getWidth()/2, 203, old_frame.getWidth(), old_frame.getHeight())) {
                gFlag = "CREATE_MAP_MENU";
            }
            if (Wand.region(pX, pY, width/2-old_frame.getWidth()/2, 245, old_frame.getWidth(), old_frame.getHeight())) {
                meIndex = 1; me_index = true;
            }
            if (me_index && meIndex == 1 && Wand.region(rX, rY, width/2-old_frame.getWidth()/2, 245, old_frame.getWidth(), old_frame.getHeight())) {
                gFlag = "CREATE_MAP";
            }
            
            if(rKey != 0 || Wand.isAction(rX, rY)) {
                me_index = false;
            }
            
            pKey = rKey = 0;
            pX = pY = rX = rY = dX = dY = -1;
        }
        if (gFlag.equals("CREATE_MAP_MENU")) {
            if (pKey == -5 || pKey == 103 || pKey == Canvas.KEY_NUM5 || MLWand(2, pX, pY)) {
                mList.getStartButton().setState(true);
            }
            if(mList.check(fps_time, pKey, dKey, pX, pY, rX, rY, dX, dY) || (mList.getStartButton().getState() && (rKey != 0 || Wand.isAction(rX, rY)))) {
                if ((rKey == -5 || rKey == 103 || rKey == Canvas.KEY_NUM5 || MLWand(2, rX, rY) || mList.check(fps_time, pKey, dKey, pX, pY, rX, rY, dX, dY)) && rms.getLevelList().length > 0) {
                    createLevel(new MLoader(Encode.encode(rms.getLevel(mList.getCurrentIndex()))), "JP");
                    lift.inStart();
                    sb.startShowlevelBegin();
                    //if(rms_game[13] == 0) {
                    //    if(hScroll != null) {
                    //        hScroll.init();
                    //    }
                    //    hFirst = true;
                    //}
                    gFlag = "LIFT_ENTER";
                    fromEditor = true;
                }
                mList.getStartButton().setState(false);
            }
            
            if (pKey == Canvas.KEY_POUND || MLWand(3, pX, pY)) {
                mList.getDeleteButton().setState(true);
            }
            if(mList.getDeleteButton().getState() && (rKey != 0 || Wand.isAction(rX, rY))) {
                if ((rKey == Canvas.KEY_POUND || MLWand(3, rX, rY)) && rms.getLevelList().length > 0) {
                    rms.deleteLevel(mList.getCurrentIndex());
                    mList.rebuild(rms.getLevelList());
                }
                mList.getDeleteButton().setState(false);
            }
            
            if (pKey == Canvas.KEY_NUM0 || MLWand(1, pX, pY)) {
                mList.getEditButton().setState(true);
            }
            if(mList.getEditButton().getState() && (rKey != 0 || Wand.isAction(rX, rY))) {
                if ((rKey == Canvas.KEY_NUM0 || MLWand(1, rX, rY)) && rms.getLevelList().length > 0) {
                    createLoadNewMap();
                    eLevel = true;
                }
                mList.getEditButton().setState(false);
            }
            
            if (pKey == -6 || pKey == 10 || pKey == 114 || MLWand(0, pX, pY)) {
                mList.getCreateButton().setState(true);
            }
            if(mList.getCreateButton().getState() && (rKey != 0 || Wand.isAction(rX, rY))) {
                if (rKey == -6 || rKey == 10 || rKey == 114 || MLWand(0, rX, rY)) {
                    createNewMapBegin();
                }
                mList.getCreateButton().setState(false);
            }
            
            if (pKey == -7 || pKey == 8 || pKey == 121 || MLWand(4, pX, pY)) {
                mList.getBackButton().setState(true);
            }
            if(mList.getBackButton().getState() && (rKey != 0 || Wand.isAction(rX, rY))) {
                if (rKey == -7 || rKey == 8 || rKey == 121 || MLWand(4, rX, rY)) {
                    wasBack = true;
                    gFlag = "MENU";
                }
                mList.getBackButton().setState(false);
            }
            
            pX = pY = rX = rY = dX = dY = -1;
            pKey = rKey = 0;
        }        
        if (gFlag.equals("CREATE_MAP_BEGIN")) {
            if (!mParam.isLockKeyboard()) {
                String string = Localization.getAloneText(10);
                if (pKey == -6 || pKey == 10 || pKey == 114 || Wand.region(pX, pY, 20 + drawText.stringWidth(string) / 2 - button_long3[0].getWidth() / 2 - 2, height - 24 + 7 - button_long3[0].getHeight() / 2 - 2, button_long3[0].getWidth() + 4, button_long3[0].getHeight() + 4)) {
                    mParam.getCreateButton().setState(true);
                }
                if(mParam.getCreateButton().getState() && (rKey != 0 || Wand.isAction(rX, rY))) {
                    if (rKey == -6 || rKey == 10 || rKey == 114 || Wand.region(rX, rY, 20 + drawText.stringWidth(string) / 2 - button_long3[0].getWidth() / 2 - 2, height - 24 + 7 - button_long3[0].getHeight() / 2 - 2, button_long3[0].getWidth() + 4, button_long3[0].getHeight() + 4)) {
                        createNewMap(mParam.getWidth(), mParam.getHeight());
                        eLevel = false;
                    }
                    mParam.getCreateButton().setState(false);
                }
                string = Localization.getAloneText(11);
                if (pKey == -7 || pKey == 8 || pKey == 121 || Wand.region(pX, pY, width - drawText.stringWidth(string) / 2 - button_long1[0].getWidth() / 2 - 20 - 2, height - 24 + 7 - button_long1[0].getHeight() / 2 - 2, button_long1[0].getWidth() + 4, button_long1[0].getHeight() + 4)) {
                    mParam.getCancelButton().setState(true);
                }
                if(mParam.getCancelButton().getState() && (rKey != 0 || Wand.isAction(rX, rY))) {
                    if (rKey == -7 || rKey == 8 || rKey == 121 || Wand.region(rX, rY, width - drawText.stringWidth(string) / 2 - button_long1[0].getWidth() / 2 - 20 - 2, height - 24 + 7 - button_long1[0].getHeight() / 2 - 2, button_long1[0].getWidth() + 4, button_long1[0].getHeight() + 4)) {
                        drawText.setColor(0xffffff);
                        gFlag = "CREATE_MAP_MENU";
                    }
                    mParam.getCancelButton().setState(false);
                }
            }
            mParam.check(pKey, rpKey, pX, pY);
            pKey = rKey = rpKey = 0;
            pX = pY = rX = rY = dX = dY = -1;
        }
        if (gFlag.equals("TABLE_RECORDS")) {
            if (pKey == -7 || pKey == 8 || pKey == 121 || Wand.region(pX, pY, width - drawText.stringWidth(Localization.getAloneText(39)) - 14 + drawText.stringWidth(Localization.getAloneText(39)) / 2 - button[0].getWidth() / 2 - 2, height - 23 + 7 - button[0].getHeight() / 2 - 2, button[0].getWidth() + 4, button[0].getHeight() + 4)) {
                records.getBackButton().setState(true);
            }
            if(records.getBackButton().getState() && (rKey != 0 || Wand.isAction(rX, rY))) {
                if (rKey == -7 || rKey == 8 || rKey == 121 || Wand.region(rX, rY, width - drawText.stringWidth(Localization.getAloneText(39)) - 14 + drawText.stringWidth(Localization.getAloneText(39)) / 2 - button[0].getWidth() / 2 - 2, height - 23 + 7 - button[0].getHeight() / 2 - 2, button[0].getWidth() + 4, button[0].getHeight() + 4)) {
                    wasBack = true;
                    gFlag = "MENU";
                }
                records.getBackButton().setState(false);
            }
            records.check(pKey, rKey, dKey, pX, pY, rX, rY, dX, dY);
            if (records.getScrollBar() != null) {
                records.getScrollBar().pCheck(fps_time, dKey, pX, pY, rX, rY, dX, dY);
            }
            pKey = rKey = 0;
            pX = pY = rX = rY = dX = dY = -1;
        }
    }

    /*
     * Приватный внешний метод проверки нажатия пальца на экран класса MapParameters
     */
    private boolean NMWand(int m, int pX, int pY) {
        switch (m) {
            case 0:
                if (Localization.getLocale() == Localization.EN && Wand.region(pX, pY, -1, height - 17 + 7 - button[0].getHeight() / 2 - 2, button[0].getWidth() + 4, button[0].getHeight() + 4)) {
                    return true;
                }
                if (Localization.getLocale() == Localization.RU && Wand.region(pX, pY, -1, height - 17 + 7 - button_long2[0].getHeight() / 2 - 2, button_long2[0].getWidth() + 4, button_long2[0].getHeight() + 4)) {
                    return true;
                }
                break;
            case 1:
                if (Localization.getLocale() == Localization.EN && Wand.region(pX, pY, width - button[0].getWidth() - 3, height - 17 + 7 - button[0].getHeight() / 2 - 2, button[0].getWidth() + 4, button[0].getHeight() + 4)) {
                    return true;
                }
                if (Localization.getLocale() == Localization.RU && Wand.region(pX, pY, width - button_long1[0].getWidth() - 3, height - 17 + 7 - button_long1[0].getHeight() / 2 - 2, button[0].getWidth() + 4, button[0].getHeight() + 4)) {
                    return true;
                }
                break;
        }
        return false;
    }

    /*
     * Приватный внешний метод проверки нажатия пальца на экран класса MapList
     */
    private boolean MLWand(int m, int pX, int pY) {
        switch (m) {
            case 0:
                String string = Localization.getAloneText(1);
                if (Localization.getLocale() == Localization.EN && Wand.region(pX, pY, 10 + drawText.stringWidth(string) / 2 - button_long1[0].getWidth() / 2 - 2, height - 24 + 7 - button_long1[0].getHeight() / 2 - 2 + 4, button_long1[0].getWidth() + 4, button_long1[0].getHeight() + 4)) {
                    return true;
                }
                if (Localization.getLocale() == Localization.RU && Wand.region(pX, pY, 10 + drawText.stringWidth(string) / 2 - button_long1[0].getWidth() / 2 - 2, height - 24 + 7 - button_long1[0].getHeight() / 2 - 2 + 4, button_long1[0].getWidth() + 4, button_long1[0].getHeight() + 4)) {
                    return true;
                }
                break;
            case 1:
                if (Localization.getLocale() == Localization.EN && Wand.region(pX, pY, width / 2 - button_long1[0].getWidth() / 2 - 2, 28 + title.getHeight() + mList.getlMax() + (height - mList.getlMax() - 44 - title.getHeight()) / 2 - 3 + 7 - button_long1[0].getHeight() / 2 - 2, button_long1[0].getWidth() + 4, button_long1[0].getHeight() + 4)) {
                    return true;
                }
                if (Localization.getLocale() == Localization.RU && Wand.region(pX, pY, width / 2 - button_long2[0].getWidth() / 2 - 2, 28 + title.getHeight() + mList.getlMax() + (height - mList.getlMax() - 44 - title.getHeight()) / 2 - 3 + 7 - button_long2[0].getHeight() / 2 - 2, button_long2[0].getWidth() + 4, button_long2[0].getHeight() + 4)) {
                    return true;
                }
                break;
            case 2:
                if (Localization.getLocale() == Localization.EN && Wand.region(pX, pY, width / 2 - button_long1[0].getWidth() / 2 - 2, height - 24 + 7 - button_long1[0].getHeight() / 2 - 2 + 4, button_long1[0].getWidth() + 4, button_long1[0].getHeight() + 4)) {
                    return true;
                }
                if (Localization.getLocale() == Localization.RU && Wand.region(pX, pY, width / 2 - button_long2[0].getWidth() / 2 - 2, height - 24 + 7 - button_long2[0].getHeight() / 2 - 2 + 4, button_long2[0].getWidth() + 4, button_long2[0].getHeight() + 4)) {
                    return true;
                }
                break;
            case 3:
                string = Localization.getAloneText(4);
                if (Localization.getLocale() == Localization.EN && Wand.region(pX, pY, width - drawText.stringWidth(string) - 2 + drawText.stringWidth(string) / 2 - button_long2[0].getWidth() / 2 - 7, 28 + title.getHeight() + mList.getlMax() + (height - mList.getlMax() - 44 - title.getHeight()) / 2 - 3 + 7 - button_long2[0].getHeight() / 2 - 2, button_long2[0].getWidth() + 4, button_long2[0].getHeight() + 4)) {
                    return true;
                }
                if (Localization.getLocale() == Localization.RU && Wand.region(pX, pY, width - drawText.stringWidth(string) - 2 + drawText.stringWidth(string) / 2 - button_long2[0].getWidth() / 2 - 2, 28 + title.getHeight() + mList.getlMax() + (height - mList.getlMax() - 44 - title.getHeight()) / 2 - 3 + 7 - button_long2[0].getHeight() / 2 - 2, button_long2[0].getWidth() + 4, button_long2[0].getHeight() + 4)) {
                    return true;
                }
                break;
            case 4:
                string = Localization.getAloneText(5);
                if (Localization.getLocale() == Localization.EN && Wand.region(pX, pY, width - drawText.stringWidth(string) - 10 + drawText.stringWidth(string) / 2 - button[0].getWidth() / 2 - 2, height - 24 + 7 - button[0].getHeight() / 2 - 2 + 4, button[0].getWidth() + 4, button[0].getHeight() + 4)) {
                    return true;
                }
                if (Localization.getLocale() == Localization.RU && Wand.region(pX, pY, width - drawText.stringWidth(string) - 10 + drawText.stringWidth(string) / 2 - button[0].getWidth() / 2 - 2, height - 24 + 7 - button[0].getHeight() / 2 - 2 + 4, button[0].getWidth() + 4, button[0].getHeight() + 4)) {
                    return true;
                }
                break;
        }
        return false;
    }

    /*
     * Главный метод определения способа и самой отрисовки экрана
     */
    public void paint(Graphics g) {
        if (!canvas.isDoubleBuffered()) {
            rb2_paint(gOS);
            g.drawImage(offscreen, 0, 0, 20);
        } else {
            g.setClip(0, 0, width, height);
            g.setFont(Font.getFont(Font.FACE_PROPORTIONAL, Font.STYLE_BOLD, Font.SIZE_SMALL));
            rb2_paint(g);
        }
    }

    /*
     * Основной метод отрисовки экрана
     */
    private void rb2_paint(Graphics g) {
        g.setColor(0x000000);
        g.fillRect(0, 0, width, height);
        if (gFlag.equals("LOGO")) {
            g.setColor(0x000000);
            g.fillRect(0, 0, width, height);
            if (fps != 0) {
                if (logo == null) {
                    logo = new int[main_logo.getWidth() * main_logo.getHeight()];
                    lMode = 1;
                    lChangeMode = 1;
                }
                Image l = (lChangeMode == 1 ? main_logo : dasuppa_logo);
                if (System.currentTimeMillis() - lPauseTime >= 3000) {
                    l.getRGB(logo, 0, l.getWidth(), 0, 0, l.getWidth(), l.getHeight());
                    for (int i = 0; i < logo.length; i++) {
                        int alpha = (logo[i] >> 24) & 0xff;
                        alpha = (int) (alpha / 100f * lAlpha + 0.5f);
                        logo[i] = (alpha << 24) | (logo[i] & 0xffffff);
                    }
                    lAlpha += (lMode == 1 ? (lChangeMode == 2 ? 2000 : 1000) * fps_time : -((lChangeMode == 2 ? 2000 : 1000) * fps_time));
                    if (lAlpha > 100) {
                        lAlpha = 100;
                        lMode = 2;
                        lPauseTime = System.currentTimeMillis();
                    }
                    g.drawRGB(logo, 0, l.getWidth(), width / 2 - l.getWidth() / 2, height / 2 - l.getHeight() / 2, l.getWidth(), l.getHeight(), true);
                    if (lAlpha < 0) {
                        main_logo = null;
                        if (lChangeMode == 2) {
                            logo = null;
                            dasuppa_logo = null;
                            if (rms_game[8] == 0) {
                                gFlag = "LANGUAGE";
                            } else {
                                gFlag = "SOUND";
                            }
                        } else {
                            logo = new int[dasuppa_logo.getWidth() * dasuppa_logo.getHeight()];
                            lAlpha = 0;
                            lMode = 1;
                            lChangeMode = 2;
                        }
                    }
                } else {
                    g.drawImage(l, width / 2 - l.getWidth() / 2, height / 2 - l.getHeight() / 2, 20);
                }
            }
        }
        if (gFlag.equals("LANGUAGE")) {
            g.drawImage(bg_menu, 0, 0, 20);
            int Y = 155;
            drawText.setColor(0xffffff);
            drawText.drawString(g, width/2-drawText.stringWidth(Localization.getAloneText(61))/2, Y, Localization.getAloneText(61));
            g.drawImage(lSelect == 0 && l_index ? old_frame_selected : old_frame, width/2-old_frame.getWidth()/2, Y+31, 20);
            drawText.setColor(lSelect == 0 ? 0xdddddd : 0x1e1e1e);
            drawText.drawString(g, width/2-drawText.stringWidth(Localization.getAloneText(62))/2, Y+31+old_frame.getHeight()/2-7, Localization.getAloneText(62));
            g.drawImage(lSelect == 1 && l_index ? old_frame_selected : old_frame, width/2-old_frame.getWidth()/2, Y+44+old_frame.getHeight(), 20);
            drawText.setColor(lSelect == 1 ? 0xdddddd : 0x1e1e1e);
            drawText.drawString(g, width/2-drawText.stringWidth(Localization.getAloneText(63))/2, Y+44+old_frame.getHeight()+old_frame.getHeight()/2-7, Localization.getAloneText(63));
        }
        if (gFlag.equals("SOUND")) {
            g.drawImage(bg_menu, 0, 0, 20);
            int Y = 155;
            drawText.setColor(0xffffff);
            drawText.drawString(g, width/2-drawText.stringWidth(Localization.getAloneText(56))/2, Y, Localization.getAloneText(56));
            g.drawImage(sIndex == 0 && sound_index ? old_frame_selected : old_frame, width/2-old_frame.getWidth()/2, Y+31, 20);
            drawText.setColor(sIndex == 0 ? 0xdddddd : 0x1e1e1e);
            drawText.drawString(g, width/2-drawText.stringWidth(Localization.getAloneText(57))/2, Y+31+old_frame.getHeight()/2-7, Localization.getAloneText(57));
            g.drawImage(sIndex == 1 && sound_index ? old_frame_selected : old_frame, width/2-old_frame.getWidth()/2, Y+44+old_frame.getHeight(), 20);
            drawText.setColor(sIndex == 1 ? 0xdddddd : 0x1e1e1e);
            drawText.drawString(g, width/2-drawText.stringWidth(Localization.getAloneText(58))/2, Y+44+old_frame.getHeight()+old_frame.getHeight()/2-7, Localization.getAloneText(58));
        }
        if (gFlag.equals("MENU") || gFlag.equals("NEW_GAME") || gFlag.equals("TURN_OFF_ADS") || gFlag.equals("SETTINGS") || gFlag.equals("HELP") || gFlag.equals("ABOUT") || gFlag.equals("EXIT")) {
            g.drawImage(bg_menu, 0, 0, 20);
            g.setClip(5, 150, width - 10, mHeight);
            drawText.setColor(0xdddddd);
            for (int i = 0; i < menu_points.length; i++) {
                int Y = -mScroll.getValue();
                if (mIndex == i) {
                    g.drawImage(!m_index ? box_frame_selected : box_frame_pressed, width / 2 - box_frame_selected.getWidth() / 2, 150 + Y + mH * i, 20);
                    g.drawImage(bls, width / 2 - box_frame_selected.getWidth() / 2 - 3, 156 - 13 + Y + mH * i, 20);
                } else {
                    g.drawImage(box_frame, width / 2 - box_frame.getWidth() / 2, 150 + Y + mH * i, 20);
                }
                drawText.drawString(g, width / 2 - drawText.stringWidth(menu_points[i]) / 2, 149 + Y + mH * i + box_frame.getHeight() / 2 - 14 / 2, menu_points[i]);
            }
            g.setClip(0, 0, width, height);
            mScroll.paint(g);
            if (gFlag.equals("NEW_GAME")) {
                g.drawImage(board9, width / 2 - board9.getWidth() / 2, height / 2 - board9.getHeight() / 2, 20);
                drawText.setColor(0xe0e0e0);
                for(int i=0; i<3; i++) {
                    drawText.drawString(g, width/2-drawText.stringWidth(menu_text[0][i])/2, (height/2-32)+i*18, menu_text[0][i]);
                }
                ng_yes.paint(g, width/2-board9.getWidth()/2+8, height/2+board9.getHeight()/2-button[0].getHeight()-8, button);
                drawText.drawString(g, width/2-board9.getWidth()/2+button[0].getWidth()/2-drawText.stringWidth(menu_text[0][3])/2+8, height/2+board9.getHeight()/2-button[0].getHeight()/2-15, menu_text[0][3]);
                ng_no.paint(g, width/2+board9.getWidth()/2-button[0].getWidth()-8, height/2+board9.getHeight()/2-button[0].getHeight()-8, button);
                drawText.drawString(g, width/2+board9.getWidth()/2-button[0].getWidth()/2-drawText.stringWidth(menu_text[0][4])/2-8, height/2+board9.getHeight()/2-button[0].getHeight()/2-15, menu_text[0][4]);
            }
            if (gFlag.equals("SETTINGS")) {
                int bX = width / 2 - board6.getWidth() / 2, bY = height / 2 - board6.getHeight() / 2;
                g.drawImage(board6, bX, bY + 3, 20);
                bX += 25;
                bY += 18;
                
                g.setColor(0xbbbbbb);
                if (stIndex == 0) {
                    g.fillRect(bX + drawText.stringWidth(Localization.getAloneText(53)) + 16, bY+stY[0], sSlider[0].getWidth(), 18);
                }
                if (stIndex == 1) {
                    g.fillRect(bX + drawText.stringWidth(Localization.getAloneText(29)) + 16, bY + stY[1], sSlider[1].getWidth(), 18);
                }
                if (stIndex == 2) {
                    g.fillRect(bX + drawText.stringWidth(Localization.getAloneText(32)) + 16, bY+stY[2], sSlider[2].getWidth(), 18);
                }
                if (stIndex == 3) {
                    g.fillRect(bX + drawText.stringWidth(Localization.getAloneText(49)) + 16, bY + stY[3], sSlider[3].getWidth(), 18);
                }
                
                drawText.setColor(0xeeeeee);
                drawText.drawString(g, bX, bY + stY[0] + 2, Localization.getAloneText(53));
                g.setColor(0x666666);
                if (stIndex == 0) {
                    int xPos0 = bX + drawText.stringWidth(Localization.getAloneText(53)) + 2;
                    int yPos0 = bY + stY[0] + 9;
                    g.setColor(slColor[0]);
                    if (sound.isEnable()) {
                        g.fillTriangle(xPos0, yPos0, xPos0 + 10, yPos0-5, xPos0 + 10, yPos0+5);
                    }
                    xPos0 += 14 + sSlider[0].getWidth() + 14;
                    g.setColor(slColor[1]);
                    if (!sound.isEnable()) {
                        g.fillTriangle(xPos0, yPos0, xPos0 - 10, yPos0-5, xPos0 - 10, yPos0+5);
                    }
                }
                drawText.setColor(0x000000);
                sSlider[0].paint(g);
                
                drawText.setColor(0xeeeeee);
                drawText.drawString(g, bX, bY + stY[1] + 2, Localization.getAloneText(29));
                if (stIndex == 1) {
                    int xPos0 = bX + drawText.stringWidth(Localization.getAloneText(29)) + 2;
                    int yPos0 = bY + stY[1] + 9;
                    g.setColor(slColor[2]);
                    if (rms_game[6] > 0) {
                        g.fillTriangle(xPos0, yPos0, xPos0 + 10, yPos0-5, xPos0 + 10, yPos0+5);
                    }
                    xPos0 += 14 + sSlider[1].getWidth() + 14;
                    g.setColor(slColor[3]);
                    if (rms_game[6] < 1) {
                        g.fillTriangle(xPos0, yPos0, xPos0 - 10, yPos0-5, xPos0 - 10, yPos0+5);
                    }
                }
                drawText.setColor(0x000000);
                sSlider[1].paint(g);

                drawText.setColor(0xeeeeee);
                drawText.drawString(g, bX, bY + stY[2] + 2, Localization.getAloneText(32));
                g.setColor(0x666666);
                if (stIndex == 2) {
                    int xPos0 = bX + drawText.stringWidth(Localization.getAloneText(32)) + 2;
                    int yPos0 = bY + stY[2] + 9;
                    g.setColor(slColor[4]);
                    if (rms_game[4] > 1) {
                        g.fillTriangle(xPos0, yPos0, xPos0 + 10, yPos0-5, xPos0 + 10, yPos0+5);
                    }
                    xPos0 += 14 + sSlider[2].getWidth() + 14;
                    g.setColor(slColor[5]);
                    if (rms_game[4] < (rms_game[5] == 0 ? 2 : 3)) {
                        g.fillTriangle(xPos0, yPos0, xPos0 - 10, yPos0-5, xPos0 - 10, yPos0+5);
                    }
                }
                drawText.setColor(0x000000);
                sSlider[2].paint(g);

                drawText.setColor(0xeeeeee);
                drawText.drawString(g, bX, bY + stY[3] + 2, Localization.getAloneText(49));
                g.setColor(0x666666);
                if (stIndex == 3) {
                    int xPos0 = bX + drawText.stringWidth(Localization.getAloneText(49)) + 2;
                    int yPos0 = bY + stY[3] + 9;
                    g.setColor(slColor[6]);
                    if (rms_game[8] == 2) {
                        g.fillTriangle(xPos0, yPos0, xPos0 + 10, yPos0-5, xPos0 + 10, yPos0+5);
                    }
                    xPos0 += 14 + sSlider[3].getWidth() + 14;
                    g.setColor(slColor[7]);
                    if (rms_game[8] == 1) {
                        g.fillTriangle(xPos0, yPos0, xPos0 - 10, yPos0-5, xPos0 - 10, yPos0+5);
                    }
                }
                drawText.setColor(0x000000);
                sSlider[3].paint(g);

                drawText.setColor(0xeeeeee);
                int x = width/2+board6.getWidth()/2-button[0].getWidth()-9;
                st_back.paint(g, x, bY + stY[3] + 12, button);
                drawText.drawString(g, x+button[0].getWidth()/2-drawText.stringWidth(Localization.getAloneText(39))/2+1, bY + stY[3] + 13, Localization.getAloneText(39));
                
            }
            //if(gFlag.equals("PURCHASE")) {
            //    drawText.setColor(0xffffff);
            //    int X = bsX+(width/2-board6.getWidth()/2)+(board6.getWidth()-9), Y = height/2+board6.getHeight()/2-22;
            //    if(hasIAP) {
            //        if(!fAds) {
            //            drawText.drawString(g, X+board6.getWidth()/2-drawText.stringWidth(Localization.getAloneText(57))/2, height/2-28, Localization.getAloneText(57));
            //            drawText.drawString(g, X+board6.getWidth()/2-drawText.stringWidth(Localization.getAloneText(58))/2, height/2-14, Localization.getAloneText(58));
            //            drawText.drawString(g, X+board6.getWidth()/2-drawText.stringWidth(price)/2, height/2+7, price);
            //        } else {
            //            drawText.drawString(g, X+board6.getWidth()/2-drawText.stringWidth(Localization.getAloneText(67))/2, height/2-14, Localization.getAloneText(67));
            //            drawText.drawString(g, X+board6.getWidth()/2-drawText.stringWidth(Localization.getAloneText(68))/2, height/2, Localization.getAloneText(68));
            //        }
            //    } else {
            //        drawText.drawString(g, X+board6.getWidth()/2-drawText.stringWidth(Localization.getAloneText(64))/2, height/2-14, Localization.getAloneText(64));
            //        drawText.drawString(g, X+board6.getWidth()/2-drawText.stringWidth(Localization.getAloneText(65))/2, height/2, Localization.getAloneText(65));
            //    }
            //    if(pMode == 0) {
            //        if(hasIAP) {
            //            if(Localization.getLocale() == Localization.EN) {
            //                g.drawImage(button, X+15, Y, 20);
            //                drawText.drawString(g, X+15+button.getWidth()/2-drawText.stringWidth(Localization.getAloneText(60))/2, Y+button.getHeight()/2-7, Localization.getAloneText(60));
            //                if(!fDetails) {
            //                    g.drawImage(button_long1, X+board6.getWidth()-button_long1.getWidth()-15, Y, 20);
            //                    drawText.drawString(g, X+board6.getWidth()-button_long1.getWidth()/2-15-drawText.stringWidth(Localization.getAloneText(!fAds ? 59 : 69))/2, Y+button_long1.getHeight()/2-7, Localization.getAloneText(!fAds ? 59 : 69));
            //                }
            //            }
            //            if(Localization.getLocale() == Localization.RU) {
            //                g.drawImage(button_long1, X+15, Y, 20);
            //               drawText.drawString(g, X+15+button_long1.getWidth()/2-drawText.stringWidth(Localization.getAloneText(60))/2, Y+button_long1.getHeight()/2-7, Localization.getAloneText(60));
            //                if(!fDetails) {
            //                    g.drawImage(button_long2, X+board6.getWidth()-button_long2.getWidth()-15, Y, 20);
            //                    drawText.drawString(g, X+board6.getWidth()-button_long2.getWidth()/2-15-drawText.stringWidth(Localization.getAloneText(!fAds ? 59 : 69))/2, Y+button_long2.getHeight()/2-7, Localization.getAloneText(!fAds ? 59 : 69));
            //                }
            //            }
            //        } else {
            //            g.drawImage(button, X+15, Y, 20);
            //            drawText.drawString(g, X+15+button.getWidth()/2-drawText.stringWidth(Localization.getAloneText(66))/2+1, Y+button.getHeight()/2-7, Localization.getAloneText(66));
            //        }
            //    }
            //}
            if (gFlag.equals("HELP")) {
                showHelp(g, 1);
            }
            if (gFlag.equals("ABOUT")) {
                if(mAbout != 0) {
                    if (drawText.getY() > (height / 2 - 34) - drawText.getHText()) {
                        int Y = (height / 2 - 34) - (int) (10 * tAbout);
                        if(Y > 0) {
                            drawText.setY(Y);
                        } else {
                            aScroll.setValue(-Y);
                            if(mAbout == 1) {
                                mAbout = 2;
                            }
                        }
                        tAbout += fps_time;
                    } else {
                        mAbout = 0;
                    }
                }
                g.drawImage(board4, width / 8, height / 2 - height / 4, 20);
                g.setClip(width / 8 + 5, height / 2 - height / 4 + 19, width - width / 4 - 10, height / 2 - 34);
                drawText.setColor(0xa0a0a0);
                drawText.drawString(g, (width/8+5)+(width-width/4-10)/2-drawText.stringWidth(menu_text[2][0])/2-2, (height / 2 - height / 4 + 19)+drawText.getY(), menu_text[2][0]);
                drawText.setColor(0xe0e0e0);
                drawText.drawText(g, false);
                g.setClip(0, 0, width, height);
                int x = width - width / 8 - drawText.stringWidth(menu_text[2][2]) - 15;
                a_back.paint(g, x + drawText.stringWidth(menu_text[2][2]) / 2 - button[0].getWidth() / 2, height / 2 + height / 4 + 7 - button[0].getHeight() / 2 - 8, button);
                drawText.drawString(g, x + 1, height / 2 + height / 4 - 8, menu_text[2][2]);
                aScroll.paint(g);
            }
            if (gFlag.equals("EXIT")) {
                g.drawImage(board1, width / 8, height / 2 - height / 8, 20);
                drawText.setColor(0xe0e0e0);
                drawText.drawText(g, true);
                int x0 = width / 8 + 20;
                e_yes.paint(g, x0 + drawText.stringWidth(menu_text[3][1]) / 2 - button[0].getWidth() / 2, height / 2 + height / 8 + 7 - button[0].getHeight() / 2 - 5, button);
                drawText.drawString(g, x0, height / 2 + height / 8 - 5, menu_text[3][1]);
                int x1 = width - width / 8 - drawText.stringWidth(menu_text[3][2]) - 23;
                e_no.paint(g, x1 + drawText.stringWidth(menu_text[3][2]) / 2 - button[0].getWidth() / 2, height / 2 + height / 8 + 7 - button[0].getHeight() / 2 - 5, button);
                drawText.drawString(g, x1 + 2, height / 2 + height / 8 - 5, menu_text[3][2]);
            }
        }
        if (gFlag.equals("BEGIN") || gFlag.equals("PAUSE") || gFlag.equals("IMPROVEMENTS")) {
            switch (Localization.getLocale()) {
                case Localization.EN:
                    g.drawImage(bg_begin, 0, 0, 20);
                    g.drawImage(board5, 4, 9, 20);
                    drawText.setColor(0xe4e4e4);
                    drawText.drawString(g, 67 - drawText.stringWidth(begin_text[0] + rms.getGameLevel(rms_game)) / 2, 19, begin_text[0] + rms.getGameLevel(rms_game));
                    g.drawImage(stand, width / 4 - 45, 94 - stand.getHeight() / 2, 20);
                    drawText.setColor((System.currentTimeMillis() - pTime) > 1000 ? 0xb0b0b0 : 0xff0000);
                    drawText.drawString(g, 179 - drawText.stringWidth(begin_text[1] + rms_game[1]) / 2, 20, begin_text[1] + rms_game[1]);

                    drawText.setColor(0xe0e0e0);

                    drawText.drawString(g, 113 + drawText.stringWidth(begin_text[3]) / 2 - drawText.stringWidth(begin_text[2]) / 2, 45, begin_text[2]);
                    drawText.drawString(g, 114 + drawText.stringWidth(begin_text[3]) / 2 - drawText.stringWidth(rms_ball[1] + begin_text[4]) / 2, 59, rms_ball[1] + begin_text[4]);

                    drawText.drawString(g, 114, 73, begin_text[3]);
                    drawText.drawString(g, 113 + drawText.stringWidth(begin_text[3]) / 2 - drawText.stringWidth(rms_ball[0] + begin_text[4]) / 2, 87, rms_ball[0] + begin_text[4]);

                    drawText.drawString(g, 111 + drawText.stringWidth(begin_text[3]) / 2 - drawText.stringWidth(begin_text[5].substring(0, 21).trim()) / 2, 101, begin_text[5].substring(0, 21).trim());
                    drawText.drawString(g, 111 + drawText.stringWidth(begin_text[3]) / 2 - drawText.stringWidth(begin_text[5].substring(22).trim()) / 2, 115, begin_text[5].substring(22).trim());
                    drawText.drawString(g, 113 + drawText.stringWidth(begin_text[3]) / 2 - drawText.stringWidth(rms_ball[2] + begin_text[6]) / 2, 129, rms_ball[2] + begin_text[6]);
                    break;
                case Localization.RU:
                    g.drawImage(bg_begin, 0, 0, 20);
                    g.drawImage(board5, 4, 9, 20);
                    drawText.setColor(0xe4e4e4);
                    drawText.drawString(g, 67 - drawText.stringWidth(begin_text[0] + rms.getGameLevel(rms_game)) / 2, 19, begin_text[0] + rms.getGameLevel(rms_game));
                    g.drawImage(stand, width / 4 - 40, 94 - stand.getHeight() / 2, 20);
                    drawText.setColor((System.currentTimeMillis() - pTime) > 1000 ? 0xb0b0b0 : 0xff0000);
                    drawText.drawString(g, 177 - drawText.stringWidth(begin_text[1] + rms_game[1]) / 2, 20, begin_text[1] + rms_game[1]);

                    drawText.setColor(0xe0e0e0);

                    drawText.drawString(g, 118 + drawText.stringWidth(begin_text[3]) / 2 - drawText.stringWidth(begin_text[2]) / 2, 45, begin_text[2]);
                    drawText.drawString(g, 119 + drawText.stringWidth(begin_text[3]) / 2 - drawText.stringWidth(rms_ball[1] + begin_text[4]) / 2, 59, rms_ball[1] + begin_text[4]);

                    drawText.drawString(g, 119, 73, begin_text[3]);
                    drawText.drawString(g, 118 + drawText.stringWidth(begin_text[3]) / 2 - drawText.stringWidth(rms_ball[0] + begin_text[4]) / 2, 87, rms_ball[0] + begin_text[4]);

                    drawText.drawString(g, 116 + drawText.stringWidth(begin_text[3]) / 2 - drawText.stringWidth(begin_text[5].substring(0, 16).trim()) / 2, 101, begin_text[5].substring(0, 16).trim());
                    drawText.drawString(g, 117 + drawText.stringWidth(begin_text[3]) / 2 - drawText.stringWidth(begin_text[5].substring(17).trim()) / 2, 115, begin_text[5].substring(17).trim());
                    drawText.drawString(g, 118 + drawText.stringWidth(begin_text[3]) / 2 - drawText.stringWidth(rms_ball[2] + begin_text[6]) / 2, 129, rms_ball[2] + begin_text[6]);
                    break;
            }
        }
        if (gFlag.equals("BEGIN")) {
            int bY = 158;
            g.setClip(0, bY - 5, width, (lbHeight = height - bY));
            bY += lbY;
            for (int i = 0; i < 4; i++) {
                g.drawImage(lbIndex == i && b_index ? old_frame_selected : old_frame, width / 2 - old_frame.getWidth() / 2, bY + i * (old_frame.getHeight() + 8), 20);
                if (lbIndex != i) {
                    drawText.setColor(0x000000);
                } else {
                    drawText.setColor(0xe0e0e0);
                }
                drawText.drawString(g, width / 2 - drawText.stringWidth(lb_text[i]) / 2, bY + i * (old_frame.getHeight() + 8) + old_frame.getHeight() / 2 - 7, lb_text[i]);
            }
            if(already_scores) {
                g.setClip(0, 0, width, height);
                g.drawImage(board8, width/2-board8.getWidth()/2, height/2-board8.getHeight()/2, 20);
                drawText.setColor(0xffffff);
                for(int i=0; i<3; i++) {
                    String s = i == 0 ? s_text[0]+rms_game[1]+s_text[1] : s_text[i+1];
                    drawText.drawString(g, width/2-drawText.stringWidth(s)/2, height/2-board7.getHeight()/2+i*17+2+17, s);
                }
                s_close.paint(g, width/2+board8.getWidth()/2-button_long1[0].getWidth()-6, height/2+board8.getHeight()/2-button_long1[0].getHeight()-7, button_long1);
                drawText.setColor(0xe0e0e0);
                drawText.drawString(g, width/2+board8.getWidth()/2-button_long1[0].getWidth()/2-drawText.stringWidth(Localization.getAloneText(59))/2-6,
                        height/2+board8.getHeight()/2-button_long1[0].getHeight()/2-14, Localization.getAloneText(59));
            }
        }
        if (gFlag.equals("PAUSE")) {
            int bY = 158;
            g.setClip(0, bY - 5, width, (lbHeight = height - bY));
            bY += lbY;
            for (int i = 0; i < 4; i++) {
                g.drawImage(pIndex == i && p_index ? old_frame_selected : old_frame, width / 2 - old_frame.getWidth() / 2, bY + i * (old_frame.getHeight() + 8), 20);
                if (pIndex != i) {
                    drawText.setColor(0x000000);
                } else {
                    drawText.setColor(0xe0e0e0);
                }
                drawText.drawString(g, width / 2 - drawText.stringWidth(!fromEditor ? p_text[i] : e_text[i]) / 2, bY + i * (old_frame.getHeight() + 8) + old_frame.getHeight() / 2 - 7, (!fromEditor ? p_text[i] : e_text[i]));
            }
        }
        if (gFlag.equals("RESTART_AT_PAUSE")) {
            g.drawImage(bg_menu, 0, 0, 20);
            drawText.setColor(0xffffff);
            int Y = 152;
            drawText.drawString(g, width/2-drawText.stringWidth(pause_text[0])/2, Y, pause_text[0]);
            Y += 18;
            drawText.drawString(g, width/2-drawText.stringWidth(pause_text[1])/2, Y, pause_text[1]);
            Y += 33;
            g.drawImage(rIndex == 0 && r_index ? old_frame_selected : old_frame, width/2-old_frame.getWidth()/2, Y, 20);
            
            if (rIndex == 0) {
                drawText.setColor(0xe0e0e0);
            } else {
                drawText.setColor(0x000000);
            }
            drawText.drawString(g, width/2-drawText.stringWidth(pause_text[4])/2, Y+old_frame.getHeight()/2-7, pause_text[4]);
            
            Y += old_frame.getHeight()+12;
            g.drawImage(rIndex == 1 && r_index ? old_frame_selected : old_frame, width/2-old_frame.getWidth()/2, Y, 20);
            
            if (rIndex == 1) {
                drawText.setColor(0xe0e0e0);
            } else {
                drawText.setColor(0x000000);
            }
            drawText.drawString(g, width/2-drawText.stringWidth(pause_text[5])/2, Y+old_frame.getHeight()/2-7, pause_text[5]);
        }
        if (gFlag.equals("HELP_IN_PAUSE")) {
            g.drawImage(bg_begin, 0, 0, 20);
            showHelp(g, 3);
            int x = width - button_long1[0].getWidth() - 5 , y = height - button_long1[0].getHeight() - 5;
            hp_back.paint(g, x, y, button_long1);
            drawText.drawString(g, x+button_long1[0].getWidth()/2-drawText.stringWidth(Localization.getAloneText(60))/2+1, y+button_long1[0].getHeight()/2-7, Localization.getAloneText(60));
        }
        if (gFlag.equals("EXIT_FROM_PAUSE")) {
            g.drawImage(bg_menu, 0, 0, 20);
            drawText.setColor(0xffffff);
            int Y = 152;
            drawText.drawString(g, width/2-drawText.stringWidth(pause_text[2])/2, Y, pause_text[2]);
            Y += 18;
            drawText.drawString(g, width/2-drawText.stringWidth(pause_text[3])/2, Y, pause_text[3]);
            Y += 33;
            g.drawImage(eIndex == 0 && e_index ? old_frame_selected : old_frame, width/2-old_frame.getWidth()/2, Y, 20);
            
            if (eIndex == 0) {
                drawText.setColor(0xe0e0e0);
            } else {
                drawText.setColor(0x000000);
            }
            drawText.drawString(g, width/2-drawText.stringWidth(pause_text[4])/2, Y+old_frame.getHeight()/2-7, pause_text[4]);
            
            Y += old_frame.getHeight()+12;
            g.drawImage(eIndex == 1 && e_index ? old_frame_selected : old_frame, width/2-old_frame.getWidth()/2, Y, 20);
            
            if (eIndex == 1) {
                drawText.setColor(0xe0e0e0);
            } else {
                drawText.setColor(0x000000);
            }
            drawText.drawString(g, width/2-drawText.stringWidth(pause_text[5])/2, Y+old_frame.getHeight()/2-7, pause_text[5]);
        }
        if (gFlag.equals("IMPROVEMENTS")) {
            int bY = 158;
            g.setClip(0, bY - 5, width, (lHeight = (height - 16) - bY));
            bY += -iScroll.getValue();
            for (int i = 0; i < 3; i++) {
                switch (i) {
                    case 0:
                        g.drawImage(go, 10, bY + lsY[i] + lsH[i] / 2 - go.getHeight() / 2, 20);
                        break;
                    case 1:
                        g.drawImage(jump, 10, bY + lsY[i] + lsH[i] / 2 - jump.getHeight() / 2, 20);
                        break;
                    case 2:
                        g.drawImage(rebound, 10, bY + lsY[i] + lsH[i] / 2 - rebound.getHeight() / 2, 20);
                        break;
                }
                drawText.setColor(0xe4e4e4);
                drawText.setText(begin_text[8 + i], 70, bY + lsY[i], width - 80, 50);
                drawText.drawText(g, false);
                if (i == bIndex) {
                    g.setColor(0xb0b0b0);
                    g.drawRect(5, bY + lsY[i] - 5, width - 10, lsH[i] + 10);
                }
            }
            g.setClip(0, 0, width, height);
            drawText.setColor(0xf0f0f0);
            int x = width - drawText.stringWidth(Localization.getAloneText(39)) - 10;
            im_back.paint(g, x + drawText.stringWidth(Localization.getAloneText(39)) / 2 - button[0].getWidth() / 2, height - 20 + 7 - button[0].getHeight() / 2, button);
            drawText.drawString(g, x, height - 20, Localization.getAloneText(39));
            if(notOpenYet) {
                g.drawImage(board1, width/2-board1.getWidth()/2, height/2-board1.getHeight()/2, 20);
                drawText.setColor(0xe0e0e0);
                for(int i=0; i<2; i++) {
                    drawText.drawString(g, width/2-drawText.stringWidth(no_text[i])/2, height/2-22+i*16, no_text[i]);
                }
                no_close.paint(g, width/2+board1.getWidth()/2-button_long1[0].getWidth()-5, height/2+board1.getHeight()/2-button_long1[0].getHeight()-5, button_long1);
                drawText.drawString(g, width/2+board1.getWidth()/2-button_long1[0].getWidth()/2-drawText.stringWidth(no_text[2])/2-5, height/2+board1.getHeight()/2-button_long1[0].getHeight()/2-12, no_text[2]);
            }
        }
        if (gFlag.equals("SL")) {
            g.drawImage(bg_menu, 0, 0, 20);
            int h = mlHeight, slY = -sScroll.getValue();
            g.setClip(width / 2 - old_frame.getWidth() / 2, 150, old_frame.getWidth(), h + 5);
            drawText.setColor(0xdddddd);
            for (int i = 0; i < countOfMaps; i++) {
                int lY = 150 + slY + i * (old_frame.getHeight() + 8);
                if (lY > 150 - old_frame.getHeight() && lY <= 150 + h) {
                    g.drawImage(slIndex == i && s_index ? old_frame_selected : old_frame, width / 2 - old_frame.getWidth() / 2, lY, 20);
                    if (slIndex != i) {
                        drawText.setColor(0x000000);
                    } else {
                        drawText.setColor(0xe0e0e0);
                    }
                    drawText.drawString(g, width / 2 - drawText.stringWidth(Localization.getAloneText(40) + (i + 1)) / 2, lY + old_frame.getHeight() / 2 - 7, Localization.getAloneText(40) + (i + 1));
                    if (i >= rms.getGameLevel(rms_game)) {
                        g.drawImage(cover, width / 2 - cover.getWidth() / 2, lY + old_frame.getHeight() / 2 - cover.getHeight() / 2, 20);
                    }
                }
            }
            g.setClip(0, 0, width, height);
            drawText.setColor(0xf0f0f0);
            int x = width - drawText.stringWidth(Localization.getAloneText(39)) - 14;
            sl_back.paint(g, x + drawText.stringWidth(Localization.getAloneText(39)) / 2 - button[0].getWidth() / 2 + 4, height - 19 + 7 - button[0].getHeight() / 2 - 1, button);
            drawText.drawString(g, x + 4, height - 20, Localization.getAloneText(39));
            //g.setColor(slColorUp);
            //if (slY < 0) {
            //    g.fillTriangle(width / 2 - 10, 150 - 10, width / 2, 150 - 20, width / 2 + 10, 150 - 10);
            //}
            //g.setColor(slColorDown);
            //if (slY > h - ((!pUsing ? rms.getGameLevel(rms_game) : countOfMaps) * (old_frame.getHeight() + 5) - (!pUsing ? 0 : 10))) {
            //    g.fillTriangle(width / 2 - 10, 150 + h + 15, width / 2, 150 + h + 25, width / 2 + 10, 150 + h + 15);
            //}
            sScroll.paint(g);
        }
        if (gFlag.equals("SD")) {
            g.drawImage(bg_menu, 0, 0, 20);
            //g.setClip(width / 2 - old_frame.getWidth() / 2, 150, old_frame.getWidth(), mHeight);
            drawText.setColor(0xdddddd);
            for (int i = 0; i < 3; i++) {
                g.drawImage(sdIndex == i && d_index ? old_frame_selected : old_frame, width / 2 - old_frame.getWidth() / 2, 150 + sdY + i * (old_frame.getHeight() + 15), 20);
                if (sdIndex != i) {
                    drawText.setColor(0x000000);
                } else {
                    drawText.setColor(0xe0e0e0);
                }
                drawText.drawString(g, width / 2 - drawText.stringWidth(begin_text[12 + i]) / 2, 150 + sdY + i * (old_frame.getHeight() + 15) + old_frame.getHeight() / 2 - 7, begin_text[12 + i]);
            }
            g.setClip(0, 0, width, height);
            if (nSelectDiff) {
                g.drawImage(board1, width / 2 - board1.getWidth() / 2, height / 2 - board1.getHeight() / 2, 20);
                drawText.setColor(0xe0e0e0);
                drawText.drawString(g, width / 2 - drawText.stringWidth(Localization.getAloneText(41)) / 2, height / 2 - 30, Localization.getAloneText(41));
                drawText.drawString(g, width / 2 - drawText.stringWidth(Localization.getAloneText(42)) / 2 + 1, height / 2 - 15, Localization.getAloneText(42));
                drawText.drawString(g, width / 2 - drawText.stringWidth(Localization.getAloneText(43)) / 2, height / 2 + 1, Localization.getAloneText(43));
                int x = width / 2 + board1.getWidth() / 2 - drawText.stringWidth(Localization.getAloneText(39)) - 16;
                sd_back.paint(g, x + drawText.stringWidth(Localization.getAloneText(39)) / 2 - button[0].getWidth() / 2, height / 2 + board1.getHeight() / 2 - 20 + 7 - button[0].getHeight() / 2, button);
                drawText.drawString(g, x, height / 2 + board1.getHeight() / 2 - 20, Localization.getAloneText(39));
            }
            
        }

        if (gFlag.equals("CAST")) {
            if (!sAlpha) {
                drawText.setColorWithAlpha(true);
                sAlpha = true; cMode = 0;
            }
            g.drawImage(bg_menu, 0, 0, 20);
            if (cMode == 0) {
                drawText.setColor(((int) (gipTime < 2.5f ? 255f / 2.5f * gipTime : gipTime >= 5f ? 255f / 2.5f * (7.5f - gipTime) : 255f) << 24) | 0xe4e4e4);
                drawText.drawString(g, width / 2 - drawText.stringWidth(cast_text[0]) / 2, 170, cast_text[0]);
                drawText.drawString(g, width / 2 - drawText.stringWidth(cast_text[1]) / 2, 194, cast_text[1]);
                drawText.drawString(g, width/2-drawText.stringWidth(cast_text[rms_game[4]+1])/2, 210, cast_text[rms_game[4]+1]);
                gipTime += fps_time;
                if (gipTime >= 7.5f) {
                    gipTime = 0;
                    cMode = 1;
                }
            }
            if (cMode == 1) {
                drawText.setColor(((int) (gipTime < 2.5f ? 255f / 2.5f * gipTime : gipTime >= 7.5f ? 255f / 2.5f * (10f - gipTime) : 255f) << 24) | 0xe4e4e4);
                if(fPassed) {
                    int[] points = new int[] {2250, 2500, 2800};
                    drawText.drawString(g, width / 2 - drawText.stringWidth("+"+points[rms_game[4]-1]+cast_text[5]) / 2, 160, "+"+points[rms_game[4]-1]+cast_text[5]);
                    drawText.drawString(g, width / 2 - drawText.stringWidth(cast_text[6]) / 2, 184, cast_text[6]);
                    drawText.drawString(g, width / 2 - drawText.stringWidth(cast_text[7]) / 2, 200, cast_text[7]);
                    drawText.drawString(g, width / 2 - drawText.stringWidth(cast_text[8]) / 2, 224, cast_text[8]);
                    drawText.drawString(g, width / 2 - drawText.stringWidth(cast_text[9]) / 2, 240, cast_text[9]);
                    drawText.drawString(g, width / 2 - drawText.stringWidth(cast_text[10]) / 2, 256, cast_text[10]);
                } else {
                    int[] points = new int[] {2250, 2500, 2800};
                    drawText.drawString(g, width / 2 - drawText.stringWidth("+"+points[rms_game[4]-1]+cast_text[5]) / 2, 190, "+"+points[rms_game[4]-1]+cast_text[5]);
                }
                gipTime += fps_time;
                if (gipTime >= 10f) {
                    if(fPassed) {
                        gipTime = 0;
                        cMode = 2;
                    } else {
                        drawText.setColorWithAlpha(false);
                        drawText.setColor(0xffffff);
                        cast = null; sAlpha = fPassed = false;
                        sound.fullStopAll();
                        playBackground();
                        gFlag = "MENU";
                    }
                }
            }
            if (cMode == 2) {
                g.setClip(0, 150, width, 150+(height-160));
                
                if (cast == null) {
                    drawText.setText(menu_text[2][0]+menu_text[2][1], 30, gipY, width - 60);
                    cast = drawText.getArray();
                }
                
                gipY = (150+(height-160)) - (int) (15 * gipTime);
                gipTime += fps_time;
                
                for (int i = 0; i < cast.length; i++) {
                    int Y = gipY + i * 14;
                    if (Y >= 0 && Y < height) {
                        int middle = 150+(height-160)/2;
                        drawText.setColor(((int) (Y > middle ? 255f - (255f / (middle / 2f)) * (Y - middle / 2f) : (255f / (middle / 2f)) * Y) << 24) | 0xe4e4e4);
                        drawText.drawString(g, width / 2 - drawText.stringWidth(cast[i]) / 2, Y, cast[i]);
                    }
                }

                if (gipY + cast.length * 14 < 150) {
                    drawText.setColorWithAlpha(false);
                    drawText.setColor(0xffffff);
                    cast = null; sAlpha = fPassed = false;
                    sound.fullStopAll();
                    playBackground();
                    gFlag = "MENU";
                }
            }
        }
        if (gFlag.equals("GAME") || gFlag.equals("LIFT_ENTER") || gFlag.equals("LIFT_EXIT") || gFlag.equals("TIME_OUT") || gFlag.equals("GAME_OVER")) {
            if (bg_game != null) {
                g.drawImage(bg_game, width / 2 - bg_game.getWidth() / 2, height / 2 - bg_game.getHeight() / 2, 20);
            }
            lm.paint(g, levelX, levelY);
            if (gFlag.equals("LIFT_ENTER") || gFlag.equals("PAUSE")) {
                if (sLiftIn.getY() > liftCable[0][1]) {
                    g.setColor(0x000000);
                    g.drawLine(levelX + liftCable[0][0] + 17, levelY + liftCable[0][1], levelX + liftCable[0][0] + 17, levelY + sLiftIn.getY() - 1);
                    g.drawLine(levelX + liftCable[0][0] + 22, levelY + liftCable[0][1], levelX + liftCable[0][0] + 22, levelY + sLiftIn.getY() - 1);
                }
            }
            if (gFlag.equals("LIFT_EXIT") || gFlag.equals("PAUSE")) {
                if (sLiftOut.getY() > liftCable[1][1]) {
                    g.setColor(0x000000);
                    g.drawLine(levelX + liftCable[1][0] + 17, levelY + liftCable[1][1], levelX + liftCable[1][0] + 17, levelY + sLiftOut.getY() - 1);
                    g.drawLine(levelX + liftCable[1][0] + 22, levelY + liftCable[1][1], levelX + liftCable[1][0] + 22, levelY + sLiftOut.getY() - 1);
                }
            }
            if(joystick != null) {
                joystick.paint(g);
            }
            if(gFlag.equals("GAME") || gFlag.equals("LIFT_ENTER") || gFlag.equals("LIFT_EXIT")) {
                g.drawImage(!p_pressed ? pause : pause_pressed, !pUsing ? width - pause.getWidth()-1 : 1, !pUsing ? height - pause.getHeight()-2 : 2, 20);
            }
            if (gFlag.equals("GAME") || gFlag.equals("LIFT_ENTER")) {
                if (sb.isShowLevelBegin()) {
                    sb.showLevelBegin(g, (jLevel ? 1 : rLevel ? slIndex + 1 : rms.getGameLevel(rms_game)));
                }
            }
            if (gFlag.equals("LIFT_EXIT")) {
                if (sb.isShowLevelEnd()) {
                    sb.showLevelEnd(g, (jLevel ? 1 : rLevel ? slIndex + 1 : rms.getGameLevel(rms_game)), nPoints, (jLevel || rLevel ? true : false));
                }
            }
            g.setColor(0x000000);
            if (rms_game[7] == 1) {
                if (gFlag.equals("GAME") || gFlag.equals("LIFT_ENTER") || gFlag.equals("LIFT_EXIT") || gFlag.equals("TIME_OUT") || gFlag.equals("PAUSE") || gFlag.equals("GAME_OVER")) {
                    if (!gFlag.equals("LIFT_ENTER")) {
                        if (gFlag.equals("GAME")) {
                            ltime = System.currentTimeMillis() - gtime;
                        } else {
                            ltime = otime;
                        }
                        if (!noTime) {
                            ltime = levelTime - ltime;
                        }
                        if(f_board) {
                            ltime = levelTime;
                        }
                        if(hint_rebound) {
                            ltime = levelTime - h_time;
                        }
                    } else {
                        if (!noTime) {
                            ltime = levelTime;
                        } else {
                            ltime = 0;
                        }
                    }
                    if (!noTime && ltime <= levelTime * 0.2f) {
                        g.setColor(0xff0000);
                    } else {
                        g.setColor(0x9f9f9f);
                    }
                    int second = (int) ((ltime - (ltime / 60000 * 60000)) / 1000);
                    String minutes = ""+(ltime / 60000);
                    String split = ":";
                    String seconds = (second < 10 ? "0" : "") + second;
                    if(gFlag.equals("GAME") || gFlag.equals("LIFT_ENTER") || gFlag.equals("LIFT_EXIT") || gFlag.equals("TIME_OUT") || gFlag.equals("GAME_OVER")) {
                        g.drawImage(hourglass, width - hourglass.getWidth()-6, 3, 20);
                        g.setFont(Font.getFont(Font.FACE_PROPORTIONAL, Font.STYLE_BOLD, Font.SIZE_MEDIUM));
                        g.drawString(minutes, width-hourglass.getWidth()-(g.getFont().stringWidth(seconds))-(g.getFont().stringWidth(split))-(g.getFont().stringWidth(minutes))-15, 3+hourglass.getHeight()/2-g.getFont().getHeight()/2, 20);
                        g.drawString(split, width-hourglass.getWidth()-(g.getFont().stringWidth(seconds))-(g.getFont().stringWidth(split))-13, 3+hourglass.getHeight()/2-g.getFont().getHeight()/2, 20);
                        g.drawString(seconds, width-hourglass.getWidth()-(g.getFont().stringWidth(seconds))-11, 3+hourglass.getHeight()/2-g.getFont().getHeight()/2, 20);
                    }
                }
                if(f_board && gFlag.equals("GAME")) {
                    g.drawImage(board7, width/2-board7.getWidth()/2, height/2-board7.getHeight()/2, 20);
                    drawText.setColor(0xffffff);
                    for(int i=0; i<3; i++) {
                        drawText.drawString(g, width/2-drawText.stringWidth(f_text[i])/2, height/2-board7.getHeight()/2+i*16+17, f_text[i]);
                    }
                    f_continue.paint(g, width/2+board7.getWidth()/2-button_long1[0].getWidth()-5, height/2+board7.getHeight()/2-button_long1[0].getHeight()-7, button_long1);
                    drawText.setColor(0xe0e0e0);
                    drawText.drawString(g, width/2+board7.getWidth()/2-button_long1[0].getWidth()/2-drawText.stringWidth(f_text[3])/2-5,
                            height/2+board7.getHeight()/2-button_long1[0].getHeight()/2-14, f_text[3]);
                    g.drawImage(arrow, (int)rXY[0], (int)rXY[1], 20);
                }
                if(hint_rebound && gFlag.equals("GAME")) {
                    g.drawImage(board7, width/2-board7.getWidth()/2, height/2-board7.getHeight()/2, 20);
                    drawText.setColor(0xffffff);
                    for(int i=0; i<3; i++) {
                        drawText.drawString(g, width/2-drawText.stringWidth(h_text[i])/2, height/2-board7.getHeight()/2+i*16+17, h_text[i]);
                    }
                    h_close.paint(g, width/2+board7.getWidth()/2-button_long1[0].getWidth()-5, height/2+board7.getHeight()/2-button_long1[0].getHeight()-7, button_long1);
                    drawText.setColor(0xe0e0e0);
                    drawText.drawString(g, width/2+board7.getWidth()/2-button_long1[0].getWidth()/2-drawText.stringWidth(h_text[3])/2-5,
                            height/2+board7.getHeight()/2-button_long1[0].getHeight()/2-14, h_text[3]);
                }
            }
            if (gFlag.equals("TIME_OUT")) {
                g.drawImage(board11, width/2-board11.getWidth()/2, height/2-board11.getHeight()/2, 20);
                drawText.setColor(0xe0e0e0);
                for(int i=0; i<2; i++) {
                    drawText.drawString(g, width/2-drawText.stringWidth(to_text[i])/2, height/2-board11.getHeight()/2+16+18*i, to_text[i]);
                }
                g.drawImage(toIndex == 0 && to_index ? old_frame_selected : old_frame, width/2-old_frame.getWidth()/2, height/2-old_frame.getHeight()/2, 20);
                if(toIndex == 0) {
                    drawText.setColor(0xffffff);
                } else {
                    drawText.setColor(0x000000);
                }
                drawText.drawString(g, width/2-drawText.stringWidth(to_text[2])/2, height/2-7, to_text[2]);
                g.drawImage(toIndex == 1 && to_index ? old_frame_selected : old_frame, width/2-old_frame.getWidth()/2, height/2+old_frame.getHeight()/2+14, 20);
                if(toIndex == 1) {
                    drawText.setColor(0xffffff);
                } else {
                    drawText.setColor(0x000000);
                }
                drawText.drawString(g, width/2-drawText.stringWidth(to_text[3])/2, height/2+old_frame.getHeight()+7, to_text[3]);
            }
            if (gFlag.equals("GAME_OVER") && !destroying) {
                g.drawImage(board11, width/2-board11.getWidth()/2, height/2-board11.getHeight()/2, 20);
                drawText.setColor(0xe0e0e0);
                for(int i=0; i<2; i++) {
                    drawText.drawString(g, width/2-drawText.stringWidth(go_text[i])/2, height/2-board11.getHeight()/2+16+18*i, go_text[i]);
                }
                g.drawImage(goIndex == 0 && go_index ? old_frame_selected : old_frame, width/2-old_frame.getWidth()/2, height/2-old_frame.getHeight()/2, 20);
                if(goIndex == 0) {
                    drawText.setColor(0xffffff);
                } else {
                    drawText.setColor(0x000000);
                }
                drawText.drawString(g, width/2-drawText.stringWidth(go_text[2])/2, height/2-7, go_text[2]);
                g.drawImage(goIndex == 1 && go_index ? old_frame_selected : old_frame, width/2-old_frame.getWidth()/2, height/2+old_frame.getHeight()/2+14, 20);
                if(goIndex == 1) {
                    drawText.setColor(0xffffff);
                } else {
                    drawText.setColor(0x000000);
                }
                drawText.drawString(g, width/2-drawText.stringWidth(go_text[3])/2, height/2+old_frame.getHeight()+7, go_text[3]);
            }
        }
        if (gFlag.equals("CREATE_MAP")) {
            drawText.setColor(0x000000);
            newMap.paint(g);
        }
        if(gFlag.equals("CREATE_MAP_EXIT")) {
            g.drawImage(bg_menu, 0, 0, 20);
            drawText.setColor(0xffffff);
            int Y = 152;
            drawText.drawString(g, width/2-drawText.stringWidth(me_text[0])/2, Y, me_text[0]);
            Y += 18;
            drawText.drawString(g, width/2-drawText.stringWidth(me_text[1])/2, Y, me_text[1]);
            Y += 33;
            g.drawImage(meIndex == 0 && me_index ? old_frame_selected : old_frame, width/2-old_frame.getWidth()/2, Y, 20);
            
            if (meIndex == 0) {
                drawText.setColor(0xe0e0e0);
            } else {
                drawText.setColor(0x000000);
            }
            drawText.drawString(g, width/2-drawText.stringWidth(me_text[2])/2, Y+old_frame.getHeight()/2-7, me_text[2]);
            
            Y += old_frame.getHeight()+12;
            g.drawImage(meIndex == 1 && me_index ? old_frame_selected : old_frame, width/2-old_frame.getWidth()/2, Y, 20);
            
            if (meIndex == 1) {
                drawText.setColor(0xe0e0e0);
            } else {
                drawText.setColor(0x000000);
            }
            drawText.drawString(g, width/2-drawText.stringWidth(me_text[3])/2, Y+old_frame.getHeight()/2-7, me_text[3]);
        }
        if (gFlag.equals("CREATE_MAP_MENU")) {
            drawText.setColor(0xffffff);
            mList.paint(g);
        }
        if (gFlag.equals("CREATE_MAP_BEGIN")) {
            drawText.setColor(0xc0c0c0);
            mParam.paint(g);
        }
        if (gFlag.equals("TABLE_RECORDS")) {
            drawText.setColor(0x000000);
            records.paint(g);
            if (records.getScrollBar() != null) {
                records.getScrollBar().paint(g);
            }
        }
        getFPS();
    }
    
    /*
     * Приватный внешний метод, метода showHelp, для отрисовки текста на экране
     */
    private int drawText(Graphics g, String[] text, int y) {
        for(int i=0; i<text.length; i++) {
            drawText.drawString(g, width/2-drawText.stringWidth(text[i])/2, y, text[i]);
            y += 14;
        }
        return y;
    }
    
    /*
     * Приватный внешний метод, метода showHelp, для отрисовки текста на экране
     */
    private int drawImage(Graphics g, Image img, int y) {
        g.drawImage(img, width/2-img.getWidth()/2, y, 20);
        y += img.getHeight();
        return y;
    }
    
    /*
     * Приватный метод отрисовки справки на экране
     */
    private void showHelp(Graphics g, int mode) {
        if(hMode != mode) {
            hArray = new String[menu_text[1].length][];
            for(int i=0; i<hArray.length; i++) {
                drawText.setText(menu_text[1][i], 0, 0, board3.getWidth()-22);
                hArray[i] = drawText.getArray();
            }
            
            int hHeight;
            
            hHeight = (hArray[0].length*14)+(hArray[1].length*14)+(hArray[2].length*14)+help1.getHeight()+(hArray[3].length*14)+help2.getHeight();
            
            hScroll = new ScrollBar(mode != 3 ? width / 2 - board3.getWidth() / 2 + 10 : 0, mode != 3 ? height / 2 - board3.getHeight() / 2 + 10 : 20, mode != 3 ? board3.getWidth() - 18 : width-5, mode != 3 ? board3.getHeight() - 40 : height - 50, hHeight - (mode != 3 ? board3.getHeight() - 40 : height - 50), hHeight, true);
            hMode = mode;
        }
        if(mode != 3) {
            g.drawImage(board3, width / 2 - board3.getWidth() / 2, height / 2 - board3.getHeight() / 2, 20);
        }
        drawText.setColor(mode != 3 ? 0xe0e0e0 : 0xffffff);
        g.setClip(mode != 3 ?  width/2-board3.getWidth()/2+10 : 0, mode != 3 ? height/2-board3.getHeight()/2+10 : 20, mode != 3 ? board3.getWidth()-20 : width-5, mode != 3 ? board3.getHeight()-40 : height - 50);

        int Y = (mode != 3 ? height/2-board3.getHeight()/2+10 : 20)-hScroll.getValue();
        
        Y = drawText(g, hArray[0], Y);
        Y = drawText(g, hArray[1], Y);
        Y = drawText(g, hArray[2], Y);
        Y = drawImage(g, help1, Y);
        Y = drawText(g, hArray[3], Y);
        drawImage(g, help2, Y);

        g.setClip(0, 0, width, height);
        drawText.setColor(0xe0e0e0);
        if(mode != 3) {
            int x = width / 2 + board3.getWidth() / 2 - button[0].getWidth()-12, y = height/2+board3.getHeight()/2-button[0].getHeight()-8;
            h_back.paint(g, x, y, button);
            drawText.drawString(g, x+button[0].getWidth()/2-drawText.stringWidth(menu_text[1][4])/2+1, y+button[0].getHeight()/2-7, menu_text[1][4]);
        }
        hScroll.paint(g);
    }
    
}
