import game.S;
/**
 *
 * @author user
 */
public class Thorns {
    
    private int bH;
    private int[][][] sides;
    
    /*
     * Конструктор класса, получает стороны шипов, и высоту спрайта шипа
     */
    public Thorns(int[][][] sides, int bH) {
        this.sides = sides;
        this.bH = bH;
    }
    
    /*
     * Проверяет столкновение шарика с шипами, ball - спрайт мячика
     */
    public boolean check(S ball) {
        if(checkCollide(ball, 1)) return true;
        if(checkCollide(ball, 2)) return true;
        return false;
    }
    
    /*
     * Приватный метод, проверяет столкновение шарика с шипами в определенном направлении, d=1 - лево, d=2 - право
     */
    private boolean checkCollide(S ball, int d) {
        for(int j=0; j<sides[d-1].length; j++) {
            if(checkCollide(ball, sides[d-1][j], d)) return true;
        }
        return false;
    }
    
    /*
     * Приватный метод, проверяет столкновение мячика с одной стороны шипов в одном направлении, p=1 - лево, d=2 - право
     */
    private boolean checkCollide(S ball, int[] side, int p) {
        if(ball.getY() > (p == 1 ? side[0]-bH/2-ball.getHeight()/2 : side[0]-ball.getHeight()) && ball.getY() < (p == 1 ? side[0] : side[0]+bH/2-ball.getHeight()/2) && ball.getX() > side[1]-ball.getWidth()+5 && ball.getX() < side[2]-5) {
            return true;
        }
        return false;
    }
    
}
