/*
 * Decompiled with CFR 0.152.
 */
package jazzlib;

import jazzlib.Checksum;

public class Adler32
implements Checksum {
    private static final int BASE = 65521;
    private int checksum;

    public Adler32() {
        this.reset();
    }

    public void reset() {
        this.checksum = 1;
    }

    public void update(int n) {
        int n2 = this.checksum & 0xFFFF;
        int n3 = this.checksum >>> 16;
        n2 = (n2 + (n & 0xFF)) % 65521;
        n3 = (n2 + n3) % 65521;
        this.checksum = (n3 << 16) + n2;
    }

    public void update(byte[] byArray) {
        this.update(byArray, 0, byArray.length);
    }

    public void update(byte[] byArray, int n, int n2) {
        int n3 = this.checksum & 0xFFFF;
        int n4 = this.checksum >>> 16;
        while (n2 > 0) {
            int n5 = 3800;
            if (n5 > n2) {
                n5 = n2;
            }
            n2 -= n5;
            while (--n5 >= 0) {
                n4 += (n3 += byArray[n++] & 0xFF);
            }
            n3 %= 65521;
            n4 %= 65521;
        }
        this.checksum = n4 << 16 | n3;
    }

    public long getValue() {
        return (long)this.checksum & 0xFFFFFFFFL;
    }
}

