/*
 * Decompiled with CFR 0.152.
 */
package com.twistfuture.Game;

import com.twistfuture.Game.GameManager;
import com.twistfuture.Game.Insurance;
import com.twistfuture.Game.Loader;
import com.twistfuture.Game.ScoreCanvas;
import com.twistfuture.Game.TwistMidlet;
import com.twistfuture.app.GeneralFunction;
import com.twistfuture.utility.Button;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;

public class MainCanvas
extends Canvas
implements TwistMidlet.Callback,
Button.ButtonCallback {
    public static boolean headStartStatus;
    private boolean gamePause;
    private boolean gameStarted;
    private final GameManager manager;
    private final Button pause;
    private final Button headStart;
    private final Button doubler;
    private final Button insuranceBtn;
    private final Button back;
    private final int headStartPrice;
    private final int insurancePrice;
    private final int doublerPrice;
    private Button tapToPress;
    private boolean gameOver;
    private ScoreCanvas scoreCanvas;
    public static boolean threadStatus;
    private Loader loader;
    private boolean backPressed;
    private Insurance insurance;
    public static int noOflife;

    public MainCanvas() {
        this.headStartPrice = 1000;
        this.insurancePrice = 500;
        this.doublerPrice = 1000;
        this.setFullScreenMode(true);
        this.manager = new GameManager();
        this.tapToPress = new Button(GeneralFunction.createImage("maincanvas/tap.png"), 40, 350, 5, this);
        this.pause = new Button(GeneralFunction.createImage("maincanvas/pause.png"), 10, 10, 0, this);
        this.back = new Button(GeneralFunction.createImage("general/backun.png"), GeneralFunction.createImage("general/backp.png"), this.getWidth() - 40, this.getHeight() - 40, 1, this);
        this.headStart = new Button(GeneralFunction.createImage("maincanvas/headstart.png"), 4, 40, 2, this);
        this.doubler = new Button(GeneralFunction.createImage("maincanvas/doubler.png"), 84, 40, 3, this);
        this.insuranceBtn = new Button(GeneralFunction.createImage("maincanvas/insurance.png"), 164, 40, 4, this);
        threadStatus = true;
        this.startThread();
    }

    protected void showNotify() {
        this.gamePause = false;
        TwistMidlet.mMidlet.registerForUP(this);
        TwistMidlet.mMidlet.unregisterDown();
    }

    protected void hideNotify() {
        this.gamePause = true;
    }

    protected void paint(Graphics g) {
        this.manager.paint(g);
        if (!this.gameOver) {
            this.back.paint(g);
            this.pause.paint(g);
        }
        if (!this.gameStarted) {
            this.tapToPress.paint(g);
            if (!headStartStatus) {
                this.headStart.paint(g);
                this.doubler.paint(g);
                this.insuranceBtn.paint(g);
                g.drawString("1000", this.headStart.getX() + 30, this.headStart.getY() + this.headStart.getHeight() - 27, 0);
                g.drawString("500", this.insuranceBtn.getX() + 30, this.headStart.getY() + this.headStart.getHeight() - 27, 0);
                g.drawString("1000", this.doubler.getX() + 30, this.headStart.getY() + this.headStart.getHeight() - 27, 0);
            } else if (this.loader != null) {
                this.loader.piant(g);
            }
        }
        if (noOflife > -1 && this.insurance != null) {
            this.insurance.paint(g);
        }
        if (this.gameOver) {
            this.scoreCanvas.paint(g);
        }
    }

    protected void pointerPressed(int x, int y) {
        if (!this.gameOver) {
            if (!this.gameStarted) {
                int storyNO;
                this.tapToPress.pointerPressed(x, y);
                this.headStart.pointerPressed(x, y);
                this.doubler.pointerPressed(x, y);
                this.insuranceBtn.pointerPressed(x, y);
                if (this.loader != null && (storyNO = this.loader.tap(x, y)) >= 0) {
                    this.gameStarted = true;
                    this.manager.headStart(storyNO);
                    this.loader = null;
                }
            } else if (threadStatus) {
                if (y > 50 && y < 350) {
                    if (!this.gamePause) {
                        this.manager.pointerPressed(x, y);
                    }
                } else {
                    this.pause.pointerPressed(x, y);
                }
            }
            this.back.pointerPressed(x, y);
        } else {
            this.scoreCanvas.pointerPressed(x, y);
        }
        if (x > 55) {
            TwistMidlet.mMidlet.adClicked(x, y);
        }
    }

    public void callRepaint(int x, int y, int width, int height) {
    }

    public void buttonClicked(int buttonId) {
        switch (buttonId) {
            case 0: {
                if (!this.gamePause) {
                    this.pause.setImage(GeneralFunction.createImage("maincanvas/play.png"));
                } else {
                    this.pause.setImage(GeneralFunction.createImage("maincanvas/pause.png"));
                }
                this.gamePause = !this.gamePause;
                break;
            }
            case 1: {
                this.backPressed = true;
                threadStatus = false;
                break;
            }
            case 2: {
                this.headStarter();
                break;
            }
            case 3: {
                if (this.manager.getScore() <= 1000) break;
                this.manager.setScore(this.manager.getScore() - 1000);
                this.gameStarted = true;
                this.manager.coinDoubler();
                break;
            }
            case 4: {
                this.setInsurance();
                break;
            }
            case 5: {
                this.gameStarted = true;
            }
        }
    }

    private void startThread() {
        new Thread(new Runnable(){

            public void run() {
                while (threadStatus) {
                    if (!MainCanvas.this.gameStarted && MainCanvas.this.loader != null) {
                        MainCanvas.this.loader.movePointer();
                    }
                    MainCanvas.this.manager.update();
                    if (MainCanvas.this.insurance != null && noOflife > -1) {
                        MainCanvas.this.insurance.update();
                    }
                    MainCanvas.this.repaint();
                    GeneralFunction.sleepThread(30);
                }
                try {
                    if (!MainCanvas.this.backPressed) {
                        GameManager.manger.playSound("Tower_2");
                        while (MainCanvas.this.manager.fallen()) {
                            MainCanvas.this.repaint();
                            GeneralFunction.sleepThread(30);
                        }
                    }
                    MainCanvas.this.manager.saveScore();
                    MainCanvas.this.gameOver = true;
                    MainCanvas.this.scoreCanvas = new ScoreCanvas();
                    MainCanvas.this.repaint();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).start();
    }

    private void headStarter() {
        int score = this.manager.getScore();
        if (score > 1000) {
            this.manager.setScore(score - 1000);
            this.loader = new Loader();
            headStartStatus = true;
        }
    }

    private void setInsurance() {
        int score = this.manager.getScore();
        if (score > 500 && noOflife < 2) {
            this.manager.setScore(score - 500);
            if (this.insurance == null) {
                noOflife = -1;
                this.insurance = new Insurance();
            }
            this.insurance.setLife(++noOflife);
        }
    }

    static {
        noOflife = -1;
    }
}

