/*
 * Decompiled with CFR 0.152.
 */
package com.twistfuture.utill;

import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.PitchControl;
import javax.microedition.media.control.VolumeControl;

public class PlaySound
implements PlayerListener {
    public static final String FORMAT_TYPE_AMR = "audio/amr";
    public static final String FORMAT_TYPE_MP3 = "audio/mpeg";
    VolumeControl volume;
    long mDuration;
    PitchControl pitchControl = null;
    private int mAudio_File_Id;
    String mFile_Resource_Path;
    private CallBack mCallBack;
    Player mPlayer = null;

    public PlaySound(CallBack aCallback) {
        this.mCallBack = aCallback;
    }

    public void playerUpdate(Player player, String event, Object eventData) {
        if (event.equals("endOfMedia") && this.mCallBack != null) {
            this.mCallBack.fileReachedEndOfMedia(this.mAudio_File_Id);
        }
    }

    public void playSample(String filename, boolean aIsLoopingOn, int aPlayerNumber, String fileformat) {
        boolean execute = true;
        if (this.mFile_Resource_Path != null) {
            execute = this.mFile_Resource_Path.compareTo(filename) != 0;
        }
        if (execute) {
            this.stopAll();
            this.mFile_Resource_Path = filename;
            this.mAudio_File_Id = aPlayerNumber;
            InputStream stream = this.getClass().getResourceAsStream("/res/" + filename);
            try {
                this.mPlayer = Manager.createPlayer((InputStream)stream, (String)fileformat);
                if (aIsLoopingOn) {
                    this.mPlayer.setLoopCount(100);
                }
                this.mPlayer.realize();
                this.volume = (VolumeControl)this.mPlayer.getControl("VolumeControl");
                this.pitchControl = (PitchControl)this.mPlayer.getControl("PitchControl");
                this.mPlayer.prefetch();
                this.mPlayer.addPlayerListener((PlayerListener)this);
                this.mPlayer.start();
                this.mDuration = this.mPlayer.getDuration() / 1000000L;
            }
            catch (Exception e) {}
        } else {
            try {
                if (this.mPlayer != null) {
                    this.mPlayer.setMediaTime(0L);
                    this.mPlayer.start();
                }
            }
            catch (MediaException ex) {
                // empty catch block
            }
        }
    }

    public void setVolume(int level) {
        this.volume.setLevel(level);
    }

    public int getVolume() {
        return this.volume.getLevel();
    }

    public int getDuration() {
        return (int)this.mDuration;
    }

    public void stopPlayer(Player player) {
        PlaySound.stop(player);
    }

    private static synchronized void stop(Player player) {
        try {
            if (player.getState() == 400) {
                try {
                    player.stop();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            player.deallocate();
            player.close();
            player = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void stopAll() {
        if (this.mPlayer != null) {
            PlaySound.stop(this.mPlayer);
            this.mPlayer = null;
            this.mFile_Resource_Path = null;
        }
    }

    public static interface CallBack {
        public void fileReachedEndOfMedia(int var1);
    }
}

