/*
 * Decompiled with CFR 0.152.
 */
package com.manthanstudio.game;

import com.manthanstudio.game.Actor;
import com.manthanstudio.game.GameWorld;
import com.manthanstudio.resource.ResManager;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class TiledLayer {
    public static final int TILE_HEIGHT = 44;
    public static final int TILE_WIDTH = 44;
    public static final int TILE_HALF_HEIGHT = 22;
    public static final int TILE_HALF_WIDTH = 22;
    public static final int NO_TILE = 12;
    private GameWorld world;
    private int worldX;
    private int worldY;
    private int tilesWide;
    private int tilesHigh;
    public int viewWidth;
    public int viewHeight;
    public int viewY;
    public int viewX;
    private byte[][] tileMap;
    private Image tileImage;
    public static final int STATE_DAY = 0;
    public static final int STATE_TUNNEL_1 = 1;
    public static final int STATE_NIGHT = 2;
    public static final int STATE_TUNNEL_2 = 3;
    public int repeat = 0;
    public int state = 0;
    private boolean isShowStreatLight = true;
    private int startX;
    private int startY;
    private int endTileX;
    private int endTileY;
    private byte tileType;
    private int xpos;
    private int ypos;

    public TiledLayer(GameWorld world, int viewWidthArg, int viewHeightArg) {
        this.world = world;
        this.viewWidth = viewWidthArg;
        this.viewHeight = viewHeightArg;
        this.worldX = 0;
        this.worldY = 0;
    }

    public void initResources() {
        this.viewX = 0;
        this.viewY = 0;
        this.tilesWide = this.tileMap[0].length;
        this.tilesHigh = this.tileMap.length;
    }

    public final void setView(int viewXArg, int viewYArg) {
        this.viewX = viewXArg;
        this.viewY = viewYArg;
    }

    public void renderer(Graphics g) {
        this.startX = this.viewX / 44 - 1;
        this.startY = this.viewY / 44 - 1;
        this.endTileX = (Math.abs(this.viewX) + this.viewWidth) / 44 + 1;
        this.endTileY = (Math.abs(this.viewY) + this.viewHeight) / 44 + 1;
        if (this.endTileY > this.tilesHigh) {
            this.endTileY = this.tilesHigh;
        }
        this.tileType = 0;
        this.xpos = 0;
        this.ypos = 0;
        int tempX = 0;
        if (this.endTileX >= 0 && !this.world.isModeChange) {
            this.tileType = this.tileMap[this.endTileY - 1][this.endTileX % this.tileMap[0].length];
            if (this.tileType == 13) {
                this.world.changeBgMode(0);
                this.world.isModeChange = true;
            }
            if (this.tileType == 18) {
                this.world.changeBgMode(1);
                this.world.isModeChange = true;
            }
        }
        if (this.startX >= 0 && this.world.isModeChange) {
            this.tileType = this.tileMap[this.endTileY - 1][this.startX % this.tileMap[0].length];
            if (this.tileType == 15 || this.tileType == 10) {
                this.world.changeBgMode(2);
                this.world.isModeChange = false;
            }
        }
        for (int tileY = this.startY; tileY < this.endTileY; ++tileY) {
            for (int tileX = this.startX; tileX < this.endTileX; ++tileX) {
                byte tile;
                if (tileY < 0 || tileX < 0) continue;
                tempX = tileX % this.tileMap[0].length;
                this.tileType = this.tileMap[tileY][tempX];
                this.xpos = tileX * 44 - this.viewX + this.worldX;
                this.ypos = tileY * 44 - this.viewY + this.worldY;
                if (this.xpos > -44 && this.xpos < this.viewWidth && this.ypos > -44 && this.ypos < this.viewHeight && this.tileType != 12) {
                    this.drawClippedTile(g, this.xpos, this.ypos, this.tileType);
                }
                if (tileX % 4 != 0 || (tile = this.tileMap[0][tempX]) <= 3) continue;
                if (this.world.bgEnvirnmentIndex == 0) {
                    g.drawImage(ResManager.getImage(ResManager.IMAGE_DAY_STREET_LIGHT), this.xpos, 66, 0);
                    continue;
                }
                if (this.world.bgEnvirnmentIndex != 1) continue;
                g.drawImage(ResManager.getImage(ResManager.IMAGE_NIGHT_STREET_LIGHT), this.xpos, 66, 0);
            }
        }
    }

    public void cycle(long deltaMS) {
    }

    public void drawClippedTile(Graphics g, int targetX, int targetY, int tileNo) {
        int row = this.tileImage.getHeight() / 44;
        int col = this.tileImage.getWidth() / 44;
        g.setClip(targetX, targetY, 44, 44);
        g.drawImage(this.tileImage, targetX - tileNo % col * 44, targetY - tileNo / col % row * 44, 0);
        g.setClip(0, 0, 220, 176);
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public int getWorldX() {
        return this.worldX;
    }

    public void setWorldX(int worldX) {
        this.worldX = worldX;
    }

    public int getWorldY() {
        return this.worldY;
    }

    public void setWorldY(int worldY) {
        this.worldY = worldY;
    }

    public void setTileMapArray(byte[][] tile) {
        this.tileMap = tile;
    }

    public Image getTileImage() {
        return this.tileImage;
    }

    public void setTileImage(Image tileImage) {
        this.tileImage = tileImage;
    }

    public final int getTileAtX(int x) {
        return x / 44;
    }

    public final int getTileAtY(int y) {
        return y / 44;
    }

    public final int getTileCenterPosX(int x) {
        return this.getTileAtX(x) * 44 + 22;
    }

    public final int getTileCenterPosY(int y) {
        return this.getTileAtY(y) * 44 + 22;
    }

    public final byte getTile(int x, int y) {
        int tx = this.getTileAtX(x);
        int ty = this.getTileAtY(y);
        if (tx < 0 || tx >= this.tilesWide || ty < 0 || ty >= this.tilesHigh) {
            return -1;
        }
        return this.tileMap[y / 44][x / 44];
    }

    public boolean checkCollision(Actor hitter) {
        return false;
    }

    public void free() {
        this.tileImage = null;
        this.tileMap = null;
    }

    public void destroy() {
    }
}

